|=========
|Fonctions
|=========
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "GFATEM.h"
		
		.xdef     _memcpy
		.xdef     Func_memcpy 				|Fast copy
		.xdef     _memcpy_slow
		.xdef     Func_memcpy_slow 			|Slow copy
		.xdef     Func_GetnBits
		.xdef     Func_GetnDigits
		.xdef     Func_InputStr
		.xdef     Func_StrToBase
		.xdef     Func_StrToFloat
		.xdef     Func_kb_flush
		.xdef     Func_StrLower
		.xdef     Func_StrUpper
		.xdef     Func_IntToStr

|=========================================================================
|Func_memcpy
|-------------------------------------------------------------------------
|Fast copy
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre d'octets
|  dc.l %a0 = Source
|  dc.l %a1 = Destination
|
|output:  
|
|destroy: 
|=========================================================================		
_Func_memcpy_same_parity_address:
		tst.w      %d0					|Si paire?
		jbeq       _Func_memcpy_fast_copy		|Copie directe		
		move.b     (%a0)+,(%a1)+			|Aligne donnes
		subq.w     #1,%d1
_Func_memcpy_fast_copy:
		moveq.l    #0,%d0				|Efface %d1
		move.w     %d1,%d0				|%d0 dans %d1
		lsr.w      #2,%d0				|Divise %d1 par 4
		jbeq       _Func_memcpy_no_fast_copy		|Copie simple si gale  0
		subq.w     #1,%d0
_Func_memcpy_fast_copy_loop:
		move.l     (%a0)+,(%a1)+
		subq.w     #4,%d1
		dbf        %d0,_Func_memcpy_fast_copy_loop
		dbf        %d1,_Func_memcpy_simple_copy
		rts		
_memcpy:
Func_memcpy:			
		moveq.l    #0,%d1
		move.w     %d0,%d1
		jbeq       _Func_memcpy_exit			|Si taille 0   
		move.l     %a0,%d0				|%a0 dans %d1
		move.l     %a1,%d2				|%a1 dans %d2
		andi.w     #1,%d0				|Parit
		andi.w     #1,%d2				|Parit
		cmp.w      %d0,%d2				|Si galite
		jbeq       _Func_memcpy_same_parity_address	|Dtermine la parit		
_Func_memcpy_no_fast_copy:		
		subq.w     #1,%d1
_Func_memcpy_simple_copy:
		move.b     (%a0)+,(%a1)+
		dbf        %d1,_Func_memcpy_simple_copy
_Func_memcpy_exit:		
		rts
		
|Copie directe:
_memcpy_slow:
Func_memcpy_slow:
		moveq.l    #0,%d1
		move.w     %d0,%d1
		dbf        %d1,_Func_memcpy_simple_copy
		rts     
		
|=========================================================================
|Func_GetnBits
|-------------------------------------------------------------------------
|Renvoie le nombres de bits d'un nombre
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Nombre
|
|output:
|  dc.l %d0 = Nombre de bits  
|
|destroy: 
|=========================================================================		
_Func_GetnBits_return:
		addq.w    #1,%d1
		move.l    %d1,%d0
		rts

Func_GetnBits:
		moveq.l   #31,%d1
_Func_GetnBits_loop:
		add.l     %d0,%d0
		dbcs      %d1,_Func_GetnBits_loop
		jbcs      _Func_GetnBits_return
		moveq.l   #1,%d0
		rts
		

|=========================================================================
|Func_GetnDigits
|-------------------------------------------------------------------------
|Renvoie le nombres de digits d'un nombre dans une certaine base
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Nombre
|  dc.l %d1 = Base
|
|output:
|  dc.l %d0 = Nombre de digits  
|
|destroy:
|=========================================================================		
Func_GetnDigits:
		moveq.l    #1,%d2
		jbra       _Func_GetnDigits_loop
_Func_GetnDigits_add_digit:
		addq.w     #1,%d2
_Func_GetnDigits_loop:
		lsr.l      %d1,%d0
		jbne	   _Func_GetnDigits_add_digit
		move.l     %d2,%d0
		rts
		
 
|=========================================================================
|Func_InputStr
|-------------------------------------------------------------------------
|Fonction permettant d'entrer du texte
|-------------------------------------------------------------------------
|input:
|  dc.w %d1 = Nombre de caractres au maximum
|  dc.l %a2 = Buffer
|
|output:  
|  dc.w %d0 = Nombre de caractres entrs
|
|destroy: 
|=========================================================================  
_Func_InputStr_nokey:
		moveq.l   #0,%d4				|%d4 last_key=0
		moveq.l   #0,%d7				|%d7 RepeatKey = FALSE
		jbra      _Func_InputStr_loop2

Func_InputStr:
		movem.l   %d2-%d7,-(%SP)			|Sauvegarde registres
		lea.l     -18(%SP),%SP				|Zone sauvegarde SCR_STATE ss
		
		clr.b     (%a2)					|buffer [0] = 0
		
		move.l    %d1,-(%SP)
		lea.l     4(%SP),%a0
		pea.l     (%a0)					|SaveScrState (&ss)
		ROM_CALL  SaveScrState
		addq.l    #4,%SP
		move.l    (%SP)+,%d1
		
		jbsr      Func_kb_flush				|Vide clavier (aucune touche presse)
		moveq.l   #0,%d3				|key=0
		moveq.l   #0,%d4				|last_key=0
		moveq.l   #0,%d7				|RepeatKey=FALSE
		moveq.l   #0,%d2				|i=0
_Func_InputStr_loop:
		move.l    %d1,-(%SP)
		move.l    %d2,-(%SP)
		move.w    12+8(%SP),-(%SP)			|CurY
		move.w    10+2+8(%SP),-(%SP)			|CurX
		ROM_CALL  MoveTo
		
		move.l    string_buffer,-(%SP)
		pea.l     printf_inputstr1
		jbsr      printf
		lea.l     12(%SP),%SP
		move.l    (%SP)+,%d2
		move.l    (%SP)+,%d1
		
		move.w    %d3,%d4				|last_key=key
		moveq.l   #0,%d5				|%d5 repeat_delay = counter_time+PARAM_REPEAT_KEYDELAY 
		move.w    PARAM_REPEAT_KEYDELAY,%d5
		add.l     counter_time,%d5
		moveq.l   #0,%d6				|%d6 between_delay = counter_time+PARAM_BETWEEN_KEYDELAY
		move.w    PARAM_BETWEEN_KEYDELAY,%d6
		add.l     counter_time,%d6
|while (!(key = _kb_getkey ()) || key==last_key)
_Func_InputStr_loop2:		
		jbsr      _kb_getkey
		move.w    %d0,%d3
		jbeq      _Func_InputStr_loop2_next
		cmp.w     %d3,%d4
		jbeq      _Func_InputStr_loop2_next
		cmp.l     counter_time,%d6
		jbcs      _Func_InputStr_loop2_exit
_Func_InputStr_loop2_next:
		|if (!key)
		tst.w     %d3
		jbeq      _Func_InputStr_nokey
	
		|if (key && key==last_key && RepeatKey && counter_time>=between_delay)		
		cmp.w     %d3,%d4
		jbne      _Func_InputStr_loop2_next2
		tst.w     %d7
		jbeq      _Func_InputStr_loop2_next2
		cmp.l     counter_time,%d6
		jbcs      _Func_InputStr_loop2_exit
_Func_InputStr_loop2_next2:
		|if (key && key==last_key && !RepeatKey && counter_time>=repeat_delay)
		cmp.w     %d3,%d4
		jbne      _Func_InputStr_loop2
		tst.w     %d7
		jbne      _Func_InputStr_loop2
		cmp.l     counter_time,%d5
		jbcc      _Func_InputStr_loop2
		moveq.l   #1,%d7				|RepeatKey = TRUE
		jbra      _Func_InputStr_loop2
_Func_InputStr_loop2_exit:		
		|if (key>=32 && key<=0xFF && i<maxlen)
		cmpi.w    #32,%d3				|key>=32
		jbcs      _Func_InputStr_loop_next
		cmpi.w    #0xFF,%d3
		jbhi      _Func_InputStr_loop_next
		cmp.w     %d1,%d2
		jbcc      _Func_InputStr_loop_next
		lea.l     (%d2.w,%a2),%a0			|buffer [i++] = key
		move.b    %d3,(%a0)
		addq.w    #1,%d2
_Func_InputStr_loop_next:
		|if (key==KEY_BACKSPACE && i) 
		tst.w     %d2
		jbeq      _Func_InputStr_loop_next2
		cmpi.w    #KEY_BACKSPACE,%d3
		jbne      _Func_InputStr_loop_next2
		subq.w    #1,%d2				|i--
_Func_InputStr_loop_next2:
		lea.l     (%d2.w,%a2),%a0			|buffer [i] = 0
		clr.b     (%a0)

		|while (key!=KEY_ENTER)
		cmpi.w    #KEY_ENTER,%d3
		jbne      _Func_InputStr_loop
		
		move.w    %d2,%d3				|Sauvegarde i
		move.w    12(%SP),-(%SP)			|CurY
		move.w    10+2(%SP),-(%SP)			|CurX
		ROM_CALL  MoveTo
		
		move.l    string_buffer,-(%SP)
		pea.l     printf_inputstr2
		jbsr      printf
		lea.l     12+18(%SP),%SP
		
		move.w    %d3,%d0				|return i
		movem.l   (%SP)+,%d2-%d7			|Restaure registres
		rts


|=========================================================================
|Func_StrToBase
|-------------------------------------------------------------------------
|Conversion Binaire, Octal, Hexadcimal
|-------------------------------------------------------------------------
|input:
|  dc.w %d1 = Nombre de caractres
|  dc.l %a2 = Buffer
|
|output:  
|  dc.l %d0 = Nombre
|  dc.w %d7 = Opration russie?
|
|destroy: 
|=========================================================================  
Func_StrToBase:
		moveq.l   #-1,%d7				|Prpare comme opration russie?
		subq.w    #2,%d1				|Zone du nombre
		jble      _Func_StrToBase_error_exit
		cmpi.b    #'&',(%a2)+
		jbne      _Func_StrToBase_error_exit
		move.b    (%a2)+,%d0				|Caractre de dtermination de base
		
		cmpi.b    #'X',%d0
		jbeq      _Func_StrToBase_Binary
		cmpi.b    #'x',%d0
		jbeq      _Func_StrToBase_Binary
		
		cmpi.b    #'O',%d0
		jbeq      _Func_StrToBase_Octal
		cmpi.b    #'o',%d0
		jbeq      _Func_StrToBase_Octal
		
		cmpi.b    #'H',%d0
		jbeq      _Func_StrToBase_Hexa
		cmpi.b    #'h',%d0
		jbeq      _Func_StrToBase_Hexa
_Func_StrToBase_error_exit:
		moveq.l   #0,%d0
		moveq.l   #0,%d7		
		rts

|Conversion Binaire
_Func_StrToBase_Binary:
		cmpi.w    #32,%d1
		jbhi      _Func_StrToBase_error_exit
		
		moveq.l   #0,%d0
		dbf       %d1,_Func_StrToBase_Binary_loop
		jbra      _Func_StrToBase_error_exit
_Func_StrToBase_Binary_loop:
		moveq.l   #0,%d2
		move.b    (%a2)+,%d2
		cmpi.b    #'0',%d2
		jbeq      _Func_StrToBase_Binary_loop_next
		cmpi.b    #'1',%d2
		jbne      _Func_StrToBase_error_exit	
_Func_StrToBase_Binary_loop_next:
		subi.w    #'0',%d2
		moveq.l   #0,%d3
		move.w    %d1,%d3
		lsl.l     %d3,%d2
		add.l     %d2,%d0
		dbf       %d1,_Func_StrToBase_Binary_loop
		rts

|Conversion Octale		
_Func_StrToBase_Octal:
		cmpi.w    #11,%d1
		jbhi      _Func_StrToBase_error_exit
		
		moveq.l   #0,%d0
		dbf       %d1,_Func_StrToBase_Octal_loop
		jbra      _Func_StrToBase_error_exit
_Func_StrToBase_Octal_loop:
		moveq.l   #0,%d2
		move.b    (%a2)+,%d2
		cmpi.b    #'0',%d2
		jbcs      _Func_StrToBase_error_exit
		cmpi.b    #'7',%d2
		jbhi      _Func_StrToBase_error_exit
_Func_StrToBase_Octal_next:
		subi.w    #'0',%d2
		moveq.l   #0,%d3
		move.w    %d1,%d3		
		move.w    %d3,%d4				|%d3 multipli par 3
		add.w     %d3,%d3
		add.w     %d4,%d3
		lsl.l     %d3,%d2
		add.l     %d2,%d0
		dbf       %d1,_Func_StrToBase_Octal_loop
		rts

|Conversion Hexadcimale		
_Func_StrToBase_Hexa:
		cmpi.w    #8,%d1
		jbhi      _Func_StrToBase_error_exit
		moveq.l   #0,%d0
		dbf       %d1,_Func_StrToBase_Hexa_loop
		jbra      _Func_StrToBase_error_exit
_Func_StrToBase_Hexa_loop:
		moveq.l   #0,%d2
		move.b    (%a2)+,%d2
		
		|0  9
		cmpi.b    #'0',%d2
		jbcs      _Func_StrToBase_error_exit
		cmpi.b    #'9',%d2
		jbls      _Func_StrToBase_Hexa_digits_0_to_9
		
		|A  F
		cmpi.b    #'A',%d2
		jbcs      _Func_StrToBase_error_exit
		cmpi.b    #'F',%d2
		jbls      _Func_StrToBase_Hexa_digits_A_to_F   
		
		|a  f
		cmpi.b    #'a',%d2
		jbcs      _Func_StrToBase_error_exit
		cmpi.b    #'f',%d2
		jbhi      _Func_StrToBase_error_exit
		subi.w    #'a'-10,%d2
_Func_StrToBase_Hexa_loop_next:
		moveq.l   #0,%d3
		move.w    %d1,%d3
		lsl.w     #2,%d3
		lsl.l     %d3,%d2
		add.l     %d2,%d0
		dbf       %d1,_Func_StrToBase_Hexa_loop
		rts
		
_Func_StrToBase_Hexa_digits_0_to_9:
		subi.w    #'0',%d2
		jbra      _Func_StrToBase_Hexa_loop_next

_Func_StrToBase_Hexa_digits_A_to_F:
		subi.w    #'A'-10,%d2
		jbra      _Func_StrToBase_Hexa_loop_next		


|=========================================================================
|Func_StrToFloat
|-------------------------------------------------------------------------
|Conversion chane de caractre en flottant
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre de caractres
|  dc.l %a0 = Source
|  dc.l %a1 = Destination
|
|output:  
|  dc.l %d0 - dc.l %d1 - dc.w %d2 = Flottant
|  dc.w %d7 = Opration russie?
|
|destroy: 
|=========================================================================  
Func_StrToFloat:
		moveq.l   #-1,%d7					|Prpare comme opration russie?
		moveq.l   #0,%d3
		move.w    %d0,%d3					|Sauvegarde %d0
		movea.l   %a1,%a2					|Sauvegarde %a1
		cmpa.l    %a0,%a1
		jbeq      _Func_StrToFloat_next
		jbsr      _memcpy
		clr.b     (%a1)						|Caractre NULL
_Func_StrToFloat_next:
		movea.l   %a2,%a0					|%a0 = Destination
		dbf       %d3,_Func_StrToFloat_loop
		jbra      _Func_StrToFloat_error_exit
_Func_StrToFloat_loop:		
		move.b    (%a0),%d0
		cmpi.b    #'-',%d0
		jbeq      _Func_StrToFloat_char_negatif
		cmpi.b    #'E',%d0
		jbeq      _Func_StrToFloat_char_exposant
		cmpi.b    #'e',%d0
		jbeq      _Func_StrToFloat_char_exposant
		cmpi.b    #'+',%d0
		jbeq      _Func_StrToFloat_char_plus	
		addq.l    #1,%a0
_Func_StrToFloat_loop_next:
		dbf       %d3,_Func_StrToFloat_loop
_Func_StrToFloat_loop_end:		
		move.l    %a2,-(%SP)
		jbsr      atof
		addq.l    #4,%SP
		
		|Test de validit du nombre rentr
		move.w    %d2,-(%SP)
		move.l    %d1,-(%SP)
		move.l    %d0,-(%SP)
		move.w    %d0,-(%SP)
		move.l    %d1,-(%SP)
		move.l    %d0,-(%SP)
		ROM_CALL  is_nan
		tst.w     %d0
		jbne      _Func_StrToFloat_error_is_nan
		lea.l     10(%SP),%SP
		move.l    (%SP)+,%d0
		move.l    (%SP)+,%d1
		move.w    (%SP)+,%d2
		rts

_Func_StrToFloat_error_is_nan:
		lea.l     20(%SP),%SP		
_Func_StrToFloat_error_exit:
		moveq.l   #0,%d7
		rts
		
_Func_StrToFloat_char_negatif:
		move.b    #0xAD,(%a0)+
		dbf       %d3,_Func_StrToFloat_loop
		jbra      _Func_StrToFloat_loop_end
		
_Func_StrToFloat_char_exposant:
		move.b    #0x95,(%a0)+
		dbf       %d3,_Func_StrToFloat_loop
		jbra      _Func_StrToFloat_loop_end
		
_Func_StrToFloat_char_plus:
		movea.l   %a0,%a1
		addq.l    #1,%a0
		move.w    %d3,%d0
		move.l    %a0,-(%SP)
		jbsr      _memcpy_slow
		clr.b     (%a1)						|Caractre NULL
		move.l    (%SP)+,%a0
		dbf       %d3,_Func_StrToFloat_loop_next
		jbra      _Func_StrToFloat_loop_end


|=========================================================================
|Func_kb_flush
|-------------------------------------------------------------------------
|Vrification qu'aucune touche n'est presse
|-------------------------------------------------------------------------
|input:
|
|output:  
|
|destroy: %d0
|=========================================================================    
Func_kb_flush:
		jbsr      _kb_getkey
		tst.w     %d0
		jbne      Func_kb_flush
		rts


|=========================================================================
|Func_StrLower
|-------------------------------------------------------------------------
|Chane de caractres en minuscules
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre d'octets
|  dc.l %a0 = Chane de caractres
|
|output:  
|
|destroy: 
|=========================================================================
Func_StrLower:
		moveq.l   #0,%d1
		move.w    %d0,%d1
		subq.w    #1,%d1
		jbcs      _Func_StrLower_exit
		
_Func_StrLower_loop:		
		move.b    (%a0),%d0
		
		|A - Z
		cmpi.b    #'A',%d0
		jbcs      _Func_StrLower_end_loop
		cmpi.b    #'Z',%d0
		jbls      _Func_StrLower_lower
		
		|192 - 207
		cmpi.b    #192,%d0
		jbcs      _Func_StrLower_end_loop
		cmpi.b    #207,%d0
		jbls      _Func_StrLower_lower
		
		|209 - 214
		cmpi.b    #209,%d0
		jbcs      _Func_StrLower_end_loop
		cmpi.b    #214,%d0
		jbls      _Func_StrLower_lower
		
		|216 - 221
		cmpi.b    #216,%d0
		jbcs      _Func_StrLower_end_loop
		cmpi.b    #221,%d0
		jbls      _Func_StrLower_lower
		
_Func_StrLower_lower:
		addi.b    #'a'-'A',(%a0)
_Func_StrLower_end_loop:
		addq.l    #1,%a0
		dbf       %d1,_Func_StrLower_loop
_Func_StrLower_exit:
		rts


|=========================================================================
|Func_StrUpper
|-------------------------------------------------------------------------
|Chane de caractres en majuscules
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre d'octets
|  dc.l %a0 = Chane de caractres
|
|output:  
|
|destroy: 
|=========================================================================
Func_StrUpper:
		moveq.l   #0,%d1
		move.w    %d0,%d1
		subq.w    #1,%d1
		jbcs      _Func_StrUpper_exit
		
_Func_StrUpper_loop:		
		move.b    (%a0),%d0
		
		|a - z
		cmpi.b    #'a',%d0
		jbcs      _Func_StrUpper_end_loop
		cmpi.b    #'z',%d0
		jbls      _Func_StrUpper_upper
		
		|224 - 239
		cmpi.b    #224,%d0
		jbcs      _Func_StrUpper_end_loop
		cmpi.b    #239,%d0
		jbls      _Func_StrUpper_upper
		
		|241 - 246
		cmpi.b    #241,%d0
		jbcs      _Func_StrUpper_end_loop
		cmpi.b    #246,%d0
		jbls      _Func_StrUpper_upper
		
		|248 - 254
		cmpi.b    #248,%d0
		jbcs      _Func_StrUpper_end_loop
		cmpi.b    #254,%d0
		jbls      _Func_StrUpper_upper
		
_Func_StrUpper_upper:
		subi.b    #'a'-'A',(%a0)
_Func_StrUpper_end_loop:
		addq.l    #1,%a0
		dbf       %d1,_Func_StrUpper_loop
_Func_StrUpper_exit:
		rts
		
		
|=========================================================================
|Func_IntToStr
|-------------------------------------------------------------------------
|Convertie un entier en chane de caractres
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Entier.
|  dc.l %a3 = Chane de caractres de destination.
|
|output:
|  dc.w %d4 = Nombre de caractres.
|  dc.l %a3 = Chane de caractres.  
|
|destroy:
|=========================================================================
_Func_IntToStr_zero:
		move.b    #'0',-(%a3)
		addq.w    #1,%d4
		rts
		
Func_IntToStr:
		moveq.l   #0,%d4
		lea.l     12(%a3),%a3
		clr.b     -(%a3)
		moveq.l   #0,%d7				|Signe ngatif
		move.l    %d0,%d1
		jbeq      _Func_IntToStr_zero
		jbge      _Func_IntToStr_next
		moveq.l   #-1,%d7
		neg.l     %d1
_Func_IntToStr_next:
		move.l    %d1,%d3
_Func_IntToStr_loop:
		addq.w    #1,%d4
		moveq.l   #10,%d0
		ROM_CALL  _mu32u32
		addi.b    #'0',%d1
		move.b    %d1,-(%a3)
		move.l    %d3,%d1
		moveq.l   #10,%d0
		ROM_CALL  _du32u32
		move.l    %d1,%d3
		jbne      _Func_IntToStr_loop
_Func_IntToStr_end_loop:
		tst.w     %d7
		jbeq      _Func_IntToStr_exit
		move.b    #'-',-(%a3)
		addq.w    #1,%d4
_Func_IntToStr_exit:		
		rts


|*************************************************************************
|Table Hexadcimal de digits
|*************************************************************************		
  		.global     TableHexa
  		.text
  		.even
TableHexa:
		.byte       '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
		.even
		
		.end
		