|=====================
|Gestion interruptions
|=====================
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "GFATEM.h"
		
		.xdef     Interrupt1
		.xdef     Interrupt2
		.xdef     Interrupt6
		.xdef     _interrupt_exit_program
		
		.xdef     Except_Bus_Error
		.xdef     Except_Address_Error
		.xdef     Except_Illegal_Instruction
		.xdef     Except_Divide_By_Zero
		.xdef     Except_Privilege_Violation
		.xdef     Except_Memory_Violation
		
		.xdef     Current_Except
		
		
|=========================================================================
|Interrupt1
|-------------------------------------------------------------------------
|Interruption n1  200 Hz. Gestion TIMER
|=========================================================================
_Interrupt1_SetTimer_HW1:
		move.w    __COUNTER_HARDWARE,%d0
		addi.w    #__HARDWARE_FREQUENCY,%d0
		lea.l     __COUNTER_HARDWARE,%a0
		move.w    %d0,(%a0)
		jbpl	  _Interrupt1_SetTimer_HW1_next
		move.l    (%SP)+,%a0
		move.l    (%SP)+,%d0
		rte
		
_Interrupt1_SetTimer_HW1_next:			
		subi.w    #32768,%d0
		lea.l     __COUNTER_HARDWARE,%a0
		move.w    %d0,(%a0)
		
		|Execute SET_INT1
		jbsr      SET_INT1
		move.l    (%SP)+,%a0
		move.l    (%SP)+,%d0
		rte
		
Interrupt1:
		move.w    #0x2200,%SR
		move.l    %d0,-(%SP)
		move.l    %a0,-(%SP)
		
		cmpi.w    #1,HARDWARE_VERSION
		jbeq      _Interrupt1_SetTimer_HW1
		
		|Execute SET_INT1
		jbsr      SET_INT1
		move.l    (%SP)+,%a0   
		move.l    (%SP)+,%d0      
		rte
		
|=========================================================================
|SET_INT1
|-------------------------------------------------------------------------
|Interruption  200 Hz
|=========================================================================
_SET_INT1_next:
		subi.w    #32768,%d0
		lea.l     __COUNTER_TIMER,%a0
		move.w    %d0,(%a0)
		
		|Code execut  200 Hz
		lea.l     counter_time,%a0
		addq.l    #1,(%a0)
		rts
		
SET_INT1:
		move.w    __COUNTER_TIMER,%d0
		addi.w    #__TIMER_FREQUENCY,%d0
		lea.l     __COUNTER_TIMER,%a0
		move.w    %d0,(%a0)
		jbpl	  _SET_INT1_next
		rts
		

|=========================================================================
|Interrupt2
|-------------------------------------------------------------------------
|Interruption n2 dsactive 'clavier'
|=========================================================================
Interrupt2:
		move.w    #0x2700,%SR
		clr.b     0x60001B				|pokeIO (0x60001B,0);
		rte


|=========================================================================
|Interrupt6
|-------------------------------------------------------------------------
|Interruption n6 interception de la touche [ON]
|=========================================================================
Interrupt6:
		move.w    #0x2700,%SR
		move.w    #ERROR_BREAK,%d7	    		|Erreur BREAK
_interrupt_exit_program:		
		move.l    __SAVE_LINK__,%a6			|Restaure LINK %a6

		|move.l    %a0,-(%SP)		
		move.l    __SAVE_USP__,%a0			|Change pointeur pile %SP
		move      %a0,%USP
		|move.l    (%SP)+,%a0	

		move.l    #exit_program,2(%SP)			|Change adresse de retour dans PC
		move.w    __SAVE_SR__,(%SP)		
		rte


|=========================================================================
|Gestion des exceptions
|-------------------------------------------------------------------------
|Routines de gestion des exceptions
|=========================================================================
Except_Bus_Error:
		move.w    #0x00,-(%SP)
		jbra      Current_Except
		
Except_Address_Error:
		move.w    #0x01,-(%SP)
		jbra      Current_Except
		
Except_Illegal_Instruction:
		move.w    #0x02,-(%SP)
		jbra      Current_Except
		
Except_Divide_By_Zero:
		move.w    #0x03,-(%SP)
		jbra      Current_Except
		
Except_Privilege_Violation:
		move.w    #0x04,-(%SP)
		jbra      Current_Except
		
Except_Memory_Violation:
		move.w    #0x05,-(%SP)
		jbra      Current_Except	

Current_Except:	
		move.w    #0x2700,%SR
		
_Current_Except_SavRegisters:
		clr.w     VectState
		clr.l     VectBusAddress
		clr.w     VectIntRegister
		move.w    (%a7),VectExc					|Sauvegarde de SSP
		cmpi.w    #1,(%a7)+
		jbhi      _Current_Except_SavRegisters_next
		andi.w    #0x001F,(%a7)
		move.w    (%a7)+,VectState
		move.l    (%a7)+,VectBusAddress
		move.w    (%a7)+,VectIntRegister
_Current_Except_SavRegisters_next:
		move.w    (%a7),VectSR
		move.l    2(%a7),VectPC
		movem.l   %d0-%d7/%a0-%a7,SavRegisters			|des registres
		move      %USP,%a0					|et de USP
		move.l    %a0,SavRegisters+64|(4*(8+8))
		
		move.w    #F_4x6,-(%SP)					|petite fonte
		ROM_CALL  FontSetSys
		addq.l    #2,%SP

|===============================|
|AFFICHAGE PAGE 1 (INFOS DIVERS)|
|===============================|
_Current_Except_show_page1:		
		jbsr      clrscr		
		
		pea.l     printf_crash
		jbsr      printf
		addq.l    #4,%SP
		jbra      _Current_Except_endpage
		

|=============================|
|AFFICHAGE PAGE 2 (PROCESSEUR)|
|=============================|
_Current_Except_show_page2:		
		jbsr      clrscr					|Efface cran
		
		move.l    VectPC,-(%SP)
		move.l    (SavRegisters+64),-(%SP)
		move.w    VectSR,-(%SP)
		move.w    VectIntRegister,-(%SP)
		move.l    VectBusAddress,-(%SP)
		move.w    VectState,-(%SP)
		move.w    VectExc,-(%SP)
		
		move.w    VectExc,%d0					|Nom de l'exception
		lsl.w     #2,%d0
		lea.l     Exceptions_Table,%a0    
		adda.w    %d0,%a0 |lea.l     (%d0.w,%a0),%a0
		move.l    (%a0),-(%SP)
		pea.l     printf_page2_processor
		jbsr      printf
		lea.l     4+4+2+2+4+2+2+4+4(%SP),%SP
		
		|Affichage des registres		
		moveq.l   #7,%d7
_Current_Except_Show_Registers_loop:
		pea.l     printf_eofline
		jbsr      printf
		addq.l    #4,%SP

		|An
		moveq.l   #7,%d6
		sub.w     %d7,%d6
		move.w    %d6,%d0
		lsl.w     #2,%d0
		move.l    #SavRegisters,%a1
		lea.l     32(%d0.w,%a1),%a0
		move.l    (%a0),-(%SP)
		move.w    %d6,-(%SP)
		
		|Dn		
		lea.l     (%d0.w,%a1),%a0
		move.l    (%a0),-(%SP)
		move.w    %d6,-(%SP)
		
		pea.l     printf_page2_registers
		jbsr      printf
		lea.l     4+2+4+2+4(%SP),%SP
		dbf       %d7,_Current_Except_Show_Registers_loop
		jbra      _Current_Except_endpage
		
		
|===============================|
|AFFICHAGE PAGE 3 (INTERPRETEUR)|
|===============================|
_Current_Except_show_page3:		
		jbsr      clrscr
		
		move.l    ptrLocalVar,-(%SP)
		move.l    ptrStart_LocalVar,-(%SP)
		move.l    ptrFOR,-(%SP)
		move.l    ptrData_FOR,-(%SP)
		move.l    DTO,-(%SP)
		move.l    ptrData_DT,-(%SP)
		move.l    (SavRegisters+(8*4)+(5*4)),-(%SP)
		move.l    ptrStart_ES,-(%SP)
		move.l    ptrEnd_ES,-(%SP)
		move.l    TokensFile_DataPtr,-(%SP)
		move.l    TokensFile_DataMaxAdr,-(%SP)
		move.l    TokensFile_Data,-(%SP)
		move.w    HARDWARE_VERSION,-(%SP)
		move.w    CALCULATOR,%d0
		lsl.w     #2,%d0
		lea.l     Calculators_Table,%a0    
		adda.w    %d0,%a0 |lea.l     (%d0.w,%a0),%a0
		move.l    (%a0),-(%SP)
		pea.l     printf_page3_gfatem
		jbsr      printf
		lea.l     4+4+2+4+4+4+4+4+4+4+4+4+4+4+4(%SP),%SP
		
		jbra      _Current_Except_endpage
		
		
|===============================|
|AFFICHAGE PAGE 4 (INTERPRETEUR)|
|===============================|
_Current_Except_show_page4:		
		jbsr      clrscr
		
		ROM_CALL  HeapAvail
		move.l    %d0,-(%SP)
		move.l    TAB_STRING,-(%SP)
		move.l    TAB_BOOL,-(%SP)
		move.l    TAB_INTEGER,-(%SP)
		move.l    TAB_FLOAT,-(%SP)
		move.l    VAR_STRING,-(%SP)
		move.l    VAR_BOOL,-(%SP)
		move.l    VAR_INTEGER,-(%SP)
		move.l    VAR_FLOAT,-(%SP)
		move.l    sDATA_ptr,-(%SP)
		move.l    sDATA_start_ptr,-(%SP)
		move.l    sDATA_type_ptr,-(%SP)
		move.w    sDATA_number,-(%SP)
		move.w    sDATA_total_number,-(%SP)
		pea.l     printf_page4_gfatem
		jbsr      printf
		lea.l     4+2+2+4+4+4+4+4+4+4+4+4+4+4+4(%SP),%SP
		
_Current_Except_endpage:		
		jbsr      Func_kb_flush
_Current_Except_key_enter_loop:	
		jbsr      _kb_getkey
		
_Current_Except_key_enter_loop_next:
		cmpi.w    #KEY_ENTER,%d0
		jbeq      _Current_Except_exit
		cmpi.w    #KEY_ESC,%d0
		jbeq      _Current_Except_exit
		
		subi.w    #KEY_F1,%d0				|#KEY_F1
		jbeq      _Current_Except_show_page1
		subq.w    #1,%d0				|#KEY_F2
		jbeq      _Current_Except_show_page2
		subq.w    #1,%d0				|#KEY_F3
		jbeq      _Current_Except_show_page3
		subq.w    #1,%d0				|#KEY_F4
		jbeq      _Current_Except_show_page4
		subq.w    #1,%d0				|#KEY_F5
		jbne      _Current_Except_key_enter_loop
		trap      #TRAP_RESET	
_Current_Except_exit:		
		move.w    #ERROR_EXCEPTION,%d7		
		jbra      _interrupt_exit_program
		
		
|=========================================================================
|Constantes
|=========================================================================
|Page 1
  .text
printf_crash:
  .ascii   "An abnormal error was detected!!!\n\n"
  .ascii   "It is possible that this error results\n"
  .ascii   "from a bug in GFA-Basic.\n\n"
  .ascii   "For a report of bug, send your\n"
  .ascii   "program and this full report on the\n" 
  .ascii   "forum GFA-Basic:\n"
  .ascii   "http://forum.tigen.org\n\n"
  .ascii   "Press keys F1,F2,F3 and F4 for more\n"
  .ascii   "informations.\n"
  .ascii   "Press F5 key for RESET calculator.\n\n"
  .ascii   "Press ENTER or ESC key for exit GFA-Basic.\0"
  .even

|Page 2
  .data
  .even
Exceptions_Table:
  .long    _Exception_0x00
  .long    _Exception_0x01
  .long    _Exception_0x02
  .long    _Exception_0x03
  .long    _Exception_0x04
  .long    _Exception_0x05
  .even
  
  .text
_Exception_0x00:
  .ascii   "BUS ERROR\0"
_Exception_0x01:
  .ascii   "ADDRESS ERROR\0"
_Exception_0x02:
  .ascii   "ILLEGAL INSTRUCTION\0"
_Exception_0x03:
  .ascii   "DIVIDE BY ZERO\0"
_Exception_0x04:
  .ascii   "PRIVILEGE VIOLATION\0"
_Exception_0x05:
  .ascii   "PROTECT MEMORY VIOLATION\0"
  .even
  
printf_page2_processor:
  .ascii   "- %s (0x%02hX) -\n"
  .ascii   "State: 0x%02hX - Bus address: 0x%06lX\n"
  .ascii   "Instruction register = 0x%04hX\n"
  .ascii   "SR = 0x%04hX            USP = 0x%08lX\n"
  .ascii   "Crash address:         PC = 0x%06lX\n\n"
  .ascii   "Registers:\0"
printf_page2_registers:
  .ascii   "D%d = 0x%08lX  -  A%d = 0x%08lX\0"
  .even
  
|Page 3
  .data
  .even
Calculators_Table:
  .long    _Calculator_0x00
  .long    _Calculator_0x01
  .long    _Calculator_0x02
  .even

  .text
_Calculator_0x00:
  .ascii   "TI89/TI89 SE/TI89 Titanium\0"
_Calculator_0x01:
  .ascii   "TI92+\0"
_Calculator_0x02:
  .ascii   "TI Voyage 200\0"  
  .even
  
printf_page3_gfatem:
  .ascii   "Calculator: %s\n"
  .ascii   "Hardware version: %d.00\n\n"
  .ascii   "File start read pointer:       0x%08lX\n"
  .ascii   "File max read pointer:         0x%08lX\n"
  .ascii   "File next read pointer:        0x%08lX\n"
  .ascii   "ES stack start pointer:         0x%08lX\n"
  .ascii   "ES stack end pointer:           0x%08lX\n"
  .ascii   "ES stack pointer (A5):          0x%08lX\n"
  .ascii   "DT stack start pointer:         0x%08lX\n"
  .ascii   "DT stack current pointer:    0x%08lX\n"
  .ascii   "FOR stack start pointer:       0x%08lX\n"
  .ascii   "FOR stack current pointer:  0x%08lX\n"
  .ascii   "LV stack start pointer:         0x%08lX\n"
  .ascii   "LV stack current pointer:    0x%08lX\0"
  .even

|Page 4  
printf_page4_gfatem:
  .ascii   "Data total number:          %d\n"
  .ascii   "Data current number:     %d\n"
  .ascii   "Data start type pointer:  0x%08lX\n"
  .ascii   "Data start pointer:           0x%08lX\n"
  .ascii   "Data current pointer:      0x%08lX\n\n"
  .ascii   "VAR_FLOAT memory pointer:    0x%08lX\n"
  .ascii   "VAR_INT memory pointer:        0x%08lX\n"
  .ascii   "VAR_BOOL memory pointer:      0x%08lX\n"
  .ascii   "VAR_STRING memory pointer:  0x%08lX\n"
  .ascii   "TAB_FLOAT memory pointer:    0x%08lX\n"
  .ascii   "TAB_INT memory pointer:        0x%08lX\n"
  .ascii   "TAB_BOOL memory pointer:      0x%08lX\n"
  .ascii   "TAB_STRING memory pointer:  0x%08lX\n"
  .ascii   "Free RAM: %lu bytes\0"
  .even

|=========================================================================
|Variables
|=========================================================================  
  .bss
  .even
VectExc:	.space 	2
VectState:	.space	2
VectBusAddress:	.space	4
VectIntRegister:.space 	2
VectSR:		.space 	4			
VectPC:		.space	4
SavRegisters:	.space	4*(8+8)+4
  .even
						
		.end
			