|==========================
|Tokens d'Excution de base
|==========================
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "TokensExec.h"
		.include  "GFATEM.h"

		.xdef     _ExecToken_exit
		
                .xdef     ExecToken_None
                .xdef     ExecToken_Jump
                .xdef     ExecToken_If
                .xdef     ExecToken_IfJump
                .xdef     ExecToken_For_start
                .xdef     ExecToken_For_cmp
                .xdef     ExecToken_For_end
                .xdef     ExecToken_For_if
                .xdef     ExecToken_For_add
                .xdef     ExecToken_For_clear
                .xdef     ExecToken_EndTag
                .xdef     ExecToken_PointVirgule
                .xdef     ExecToken_Apost
                .xdef     ExecToken_Constant
                
                .xdef     ExecToken_LocalVar
                .xdef     ExecToken_Return
                .xdef     ExecToken_Gosub
                
                .xdef     ExecToken_Number_Float
                .xdef     ExecToken_Number_Int
                .xdef     ExecToken_String
                
                .xdef     ExecToken_Var_Float
		.xdef     ExecToken_Var_Int
		.xdef     ExecToken_Var_Bool
		.xdef     ExecToken_Var_String
		
		.xdef     ExecToken_Var_TFloat
		.xdef     ExecToken_Var_TInt
		.xdef     ExecToken_Var_TBool
		.xdef     ExecToken_Var_TString
			
		.xdef     ExecToken_Math_Add
		.xdef     ExecToken_Math_Sub
		.xdef     ExecToken_Math_Mul
		.xdef     ExecToken_Math_Div
		.xdef     ExecToken_Math_Puiss
		
		.xdef     ExecToken_Compare_Superior
		.xdef     ExecToken_Compare_Inferior
		.xdef     ExecToken_Egal
		.xdef     ExecToken_Supegal
		.xdef     ExecToken_Infegal
		.xdef     ExecToken_Diff
		
		.xdef     ExecToken_Affec
		
		.xdef     ExecToken_Logic_Not
		.xdef     ExecToken_Logic_And
		.xdef     ExecToken_Logic_Or
		.xdef     ExecToken_Logic_Xor
		.xdef     ExecToken_Logic_Imp
		.xdef     ExecToken_Logic_Eqv
		.xdef     ExecToken_Math_Mod
		.xdef     ExecToken_Math_Divint
		
		.xdef     ExecToken_Negatif
		
		.xdef     ExecBase_Restore
		
                                   
_ExecToken_exit:
		rts

|=================|
|Tokens de gestion|
|=================|                                 
ExecToken_None:
		rts
		
ExecToken_Jump:
		|Efface piles
		MACRO_ClearStacks			
		
		|Effectue saut
		lea.l     TokensFile_DataPtr,%a1		|Adresse de la donnes en cours
		movea.l   (%a1),%a0
		moveq.l   #0,%d0
		move.b    (%a0)+,-(%SP)				|Rcupre valeur de saut
		move.w    (%SP)+,%d0
		move.b    (%a0),%d0
		move.l    TokensFile_Data,%d1			|Adresse de dbut des donnes
		add.l     %d0,%d1				|Ce place  l'adresse du saut
		move.l    %d1,(%a1)		    		|Modifie pointeur
		rts

ExecToken_If:
		|Conversion en boolen
		MACRO_ConvertType 	#TYPE_BOOL, 0
		
		|Gestion du saut
		movea.l   4(%a2),%a2				|Boolen
		tst.b     (%a2)					|Si 0 jump sinon +2
		jbeq      ExecToken_Jump
		lea.l     TokensFile_DataPtr,%a0		|Ajoute 2 au pointeur de donnes
		addq.l    #2,(%a0)						
		
		|Efface piles
		MACRO_ClearStacks			
		rts
	
ExecToken_IfJump:
		|Conversion en boolen
		MACRO_ConvertType 	#TYPE_BOOL, 0
		
		|Gestion du saut
		movea.l   4(%a2),%a2				|Boolen
		tst.b     (%a2)					|Si -1 jump sinon +2
		jbne      ExecToken_Jump
		lea.l     TokensFile_DataPtr,%a0		|Ajoute 2 au pointeur de donnes
		addq.l    #2,(%a0)
		
		|Efface piles
		MACRO_ClearStacks					
		rts

ExecToken_For_start:
		lea.l     ptrFOR,%a1
		movea.l   (%a1),%a0				|Pile For
		move.b    -11(%a5),(%a0)+			|Type variable
		clr.b     (%a0)+				|Saute type de comparaison
		move.l    -8(%a5),(%a0)+			|Adresse de la variable
		move.l    %a0,(%a1)				|Donne suivante
		rts
			
ExecToken_For_cmp:
		lea.l     ptrFOR,%a3
		move.l    (%a3),%a2				|Pile FOR
		move.b    -6(%a2),%d0				|Rcupre type variable
		jbra      TokensExec_ConvertType_For

_ExecToken_For_end_nodata:
		cmpi.b    #FOR_DEC,%d1				|Dcrmentation?
		seq       -5(%a2)				|Change info type comparaison dans la pile FOR
		lea.l     10(%a2),%a2				|Place pointeur sur la donne (Add)
		subq.b    #TYPE_INTEGER,%d0
		jbeq      _ExecToken_For_end_nodata_integer
		|jbra      _ExecToken_For_end_nodata_float

_ExecToken_For_end_nodata_float:
		move.w    #0x4000,%d0				|1 en flottant
		subq.b    #FOR_INC,%d1				|Si incrmentation passe  la suite
		jbeq      _ExecToken_For_end_nodata_float_next
		move.w    #0xC000,%d0				|-1 en flottant
_ExecToken_For_end_nodata_float_next:
		move.w    %d0,(%a2)+
		move.w    #0x1000,(%a2)+
		clr.w     (%a2)+
		clr.l     (%a2)+
		move.l    %a2,(%a3)				|Prpare donne suivante pile FOR
		rts

_ExecToken_For_end_nodata_integer:
		subq.b    #FOR_DEC,%d1
		jbeq      _ExecToken_For_end_nodata_integer_next
		move.l    #1,(%a2)+				|Ajoute entier
		addq.l    #10-4,%a2				|Ce place au dbut de la donne d'addition
		move.l    %a2,(%a3)
		rts
_ExecToken_For_end_nodata_integer_next:
		move.l    #-1,(%a2)+				|Ajoute entier
		addq.l    #10-4,%a2				|Ce place au dbut de la donne d'addition
		move.l    %a2,(%a3)
		rts
		
ExecToken_For_end:
		lea.l     ptrFOR,%a3				|Pile FOR
		move.l    (%a3),%a2
		move.b    -6(%a2),%d0				|Rcupre type variable
		
		lea.l     TokensFile_DataPtr,%a1
		movea.l   (%a1),%a0				|Adresse de la donnes en cours
		addq.l    #1,(%a1)				|Avance pointeur de 1 octet				
		
		|tst.b     %d1					|Structure For type Inc 1 ou Dec 1
		move.b    (%a0),%d1				|Rcupre valeur de saut
		jbne      _ExecToken_For_end_nodata    		
		
		|Structure For complexe type Step
		lea.l     10(%a2),%a2				|Place pointeur au dbut de la donne Add
		jbsr      TokensExec_ConvertType_For
		
		move.l    %a2,(%a3)				|Prpare donne suivante pile FOR
		move.b    -10-10-6(%a2),%d0			|Rcupre type variable  
		subq.b    #TYPE_FLOAT,%d0			|Prpare type de comparaison	
		jbeq      _ExecToken_For_end_type_cmp_float
_ExecToken_For_end_type_cmp_integer:
		tst.l     -10(%a2)
		slt       -10-10-5(%a2)
		rts
_ExecToken_For_end_type_cmp_float:
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)	
		move.w    -10+8(%a2),-(%SP)			|Empile fin flottant
		move.l    -10+4(%a2),-(%SP)			|Empile milieu flottant
		move.l    -10(%a2),-(%SP)			|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0
		slt       -10-10-5(%a2)
		rts		

/*_ExecToken_For_if_exit:	
		lea.l     -26(%a2),%a2				|Efface donnes pile FOR
		lea.l     ptrFOR,%a0
		move.l    %a2,(%a0)
		jbra      ExecToken_Jump			|Quitte la boucle For*/
			
ExecToken_For_if:
		move.l    ptrFOR,%a2				|Zone de donnes		
		jbsr      TokensExec_For_if			|Comparaison
		tst.w     %d7
		jbne      ExecToken_Jump			|Quitte la boucle For
		lea.l     TokensFile_DataPtr,%a0		|Sinon continue excution boucle For
		addq.l    #2,(%a0)			
		
		|Efface piles
		MACRO_ClearStacks
		rts

_ExecToken_For_add_if:
		jbsr      TokensExec_For_if			|Comparaison
		tst.w     %d7
		jbeq      ExecToken_Jump
		|lea.l     -26(%a2),%a2				|Efface donnes pile FOR
		|lea.l     ptrFOR,%a0
		|move.l    %a2,(%a0)
		lea.l     TokensFile_DataPtr,%a0		|Sinon continue excution boucle For
		addq.l    #2,(%a0)
		
		|Efface piles
		MACRO_ClearStacks			
		rts

_ExecToken_For_add_integer:
		move.l    (%a0),%d0				|Dplace nombre d'addition dans %d0
		add.l     %d0,(%a3)				|Additionne variable avec nombre d'addition.
		jbra      _ExecToken_For_add_if

_ExecToken_For_add_float:
		|Empile number 1
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a3),-(%SP)				|Empile fin flottant
		move.l    4(%a3),-(%SP)				|Empile milieu flottant
		move.l    (%a3),-(%SP)				|Empile dbut flottant
		move.w    #fadd*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a3)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a3)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a3)				|Empile 2 octets fin flottant
		jbra      _ExecToken_For_add_if
		
ExecToken_For_add:
		move.l    ptrFOR,%a2				|Zone de donnes
		move.b    -26(%a2),%d0				|Type variable
		movea.l   -24(%a2),%a3				|Donne variable
		lea.l     -10(%a2),%a0				|Donne d'addition
		subq.b    #TYPE_INTEGER,%d0
		jbeq      _ExecToken_For_add_integer
		jbra      _ExecToken_For_add_float		

ExecToken_For_clear:
		lea.l     ptrFOR,%a0				|Pile FOR dans %a0
		subi.l    #26,(%a0)				|Avance de 26 octets le pointeur, vide de 1 item la pile
		rts
		
ExecToken_EndTag:
		lea.l     -4-4-2-1(%a5),%a5			|Saute adresses, 2 octets d'infos supplmentaires et type
		move.b    #OPRD_ENDTAG,-(%a5)			|Empile oprande
		rts
		
ExecToken_PointVirgule:
		lea.l     -4-4-2-1(%a5),%a5			|Saute adresses, 2 octets d'infos supplmentaires et type
		move.b    #OPRD_POINT_VIRGULE,-(%a5)		|Empile oprande
		rts
		
ExecToken_Apost:
		lea.l     -4-4-2-1(%a5),%a5			|Saute adresses, 2 octets d'infos supplmentaires et type
		move.b    #OPRD_APOST,-(%a5)			|Empile oprande
		rts
		
ExecToken_Constant:
		lea.l     TokensFile_DataPtr,%a0		|Pointeur de donnes
		move.l    (%a0),%a1
		moveq.l   #0,%d0				|Efface %d0
		move.b    (%a1),%d0				|Index de la constante
		lsl.w     #2,%d0				|Multiplie par 4
		addq.l    #1,(%a0)				|Avance de 1 le pointeur de donnes
		lea.l     Tbl_TokensConstant,%a0		|Charge la table des constantes dans %a1
		move.l    (%a0,%d0.w),%a0			|Pointe vers la bonne adresse
		jbra      (%a0)					|Saute  la constante


|=========================================|
|Tokens de gestion des variables locales  |
|=========================================|
|Charge une variable locale
_ExecToken_LocalVar_string:
		move.l    ptrLocalVarString,%a0			|Pointeur courant de variables locales
		adda.w    %d1,%a0				|Avance pointeur  la variable voulue
		
		move.l    %a0,-(%a5)				|Adresse descripteur...
		move.l    (%a0)+,%d0
		jbne      _ExecToken_LocalVar_string_not_NULL_string
		move.l    #EMPTY_STRING,%d0
_ExecToken_LocalVar_string_not_NULL_string:		
		move.l    %d0,-(%a5)				|Charge adresse dans la pile ES
		move.w    (%a0),-(%a5)				|Taille de la chane de caractres
		move.b    #TYPE_STRING,-(%a5)			|Empile type de donnes
		move.b    #OPRD_VAR,-(%a5)			|Empile oprande
		rts
		
ExecToken_LocalVar:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture offset
		move.l    (%a1),%a0

		moveq.l   #0,%d1				|Efface %d1
		move.b    (%a0)+,%d1				|Lecture type variable et dbut offset
		move.b    %d1,%d0				|Sauvegarde %d1
		lsr.b     #4,%d0				|Rcupre type
		andi.b    #0x0F,%d1				|Rcupre seulement dbut offset
		lsl.w     #8,%d1				|Partie 12 Bits, MSB
		move.b    (%a0),%d1				|Partie 8 Bits, LSB
		addq.l    #2,(%a1)				|Avance pointeur de lecture des tokens
		
		cmpi.b    #TYPE_STRING,%d0
		jbeq      _ExecToken_LocalVar_string
		
		move.l    ptrLocalVar,%a0			|Pointeur courant de variables locales
		adda.w    %d1,%a0				|Avance pointeur  la variable voulue
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    %a0,-(%a5)				|Charge adresse dans la pile ES
		subq.l    #2,%a5				|Saute les 2 octets d'infos supplmentaires
		move.b    %d0,-(%a5)				|Empile type de donnes
		move.b    #OPRD_VAR,-(%a5)			|Empile oprande
		rts
		

|=========================================|
|Tokens de gestion des procdures	  |
|=========================================|		
|Return
ExecToken_Return:
		|Rcupre offsets variables locales
		move.l    TokensFile_DataPtr,%a2
		move.b    (%a2)+,-(%SP)
		move.w    (%SP)+,%d0
		move.b    (%a2)+,%d0
		tst.w     %d0					|Optimisation en vitesse pour procdure
		jbeq      _ExecToken_Return_next1		|sans variables locales numriques
		
		|Restaure espace variables locales numriques
		lea.l     ptrLocalVar,%a1
		move.l    (%a1),%a0
		adda.w    %d0,%a0 |lea.l     (%d0.w,%a0),%a0
		move.l    %a0,(%a1)

_ExecToken_Return_next1:
		|Restaure espace variables locales chanes de caractres
		moveq.l   #0,%d6
		move.b    (%a2)+,-(%SP)
		move.w    (%SP)+,%d6
		move.b    (%a2),%d6
		move.w    %d6,%d3				|Offsets dans %d0
		jbeq      _ExecToken_Return_next2		|Optimisation en vitesse pour procdure
								|sans variables locales type chanes de caractres
		divu.w    #6,%d3				|Nombre de chanes de caractres
		lea.l     ptrLocalVarString,%a2
		move.l    (%a2),%a3
		jbsr      TokensExec_DeleteString
		add.l     %d6,(%a2)

_ExecToken_Return_next2:
		|Effectue saut
		lea.l     TokensFile_DataPtr,%a1
		move.w    8(%SP),%d0
		move.l    4(%SP),6(%SP)
		move.l    (%SP),2(%SP)
		addq.l    #2,%SP
		move.l    TokensFile_Data,%a0
		lea.l     (%d0.w,%a0),%a0
		move.l    %a0,(%a1)
		rts

|Gosub		
ExecToken_Gosub:
		|Zone dbut procdure
		lea.l     TokensFile_DataPtr,%a1
		move.l    (%a1),%a0
		moveq.l   #0,%d0
		move.b    (%a0)+,-(%SP)				|Rcupre valeur de saut
		move.w    (%SP)+,%d0
		move.b    (%a0),%d0
		move.l    TokensFile_Data,%d1			|Adresse de dbut des donnes
		
		|Offset de retour
		move.l    (%a1),%d2
		sub.l     %d1,%d2
		addq.w    #2,%d2
		
		|Sauvegarde offset dans pile %SP
		subq.l    #2,%SP
		move.l    2(%SP),(%SP)
		move.l    6(%SP),4(%SP) 
		move.w    %d2,8(%SP)    
		
		add.l     %d0,%d1				|Ce place  l'adresse du saut
		movea.l   %d1,%a3		    		|Modifie pointeur
		
		|Initialisation variables locales
		moveq.l   #0,%d0
		move.b    (%a3)+,-(%SP)				|Lecture offsets variables locales numriques	
		move.w    (%SP)+,%d0
		move.b    (%a3)+,%d0
		tst.w     %d0					|Optimisation en vitesse pour procdure
		jbeq      _ExecToken_InitLocalVars_startinit_string|sans variables locales numriques
		lea.l     ptrLocalVar,%a2
		move.l    (%a2),%a0
		suba.l    %d0,%a0
		move.l    %a0,(%a2)
		cmpa.l    ptrEnd_LocalVar,%a0    
		jbcs      _ERROR_local_vars_stack_overflow
		
		lsr.w     #1,%d0				|Divise par 2 l'offset (prparation effacement zone des variables)
		subq.w    #1,%d0
		jbcs      _ExecToken_InitLocalVars_endloop1
_ExecToken_InitLocalVars_loop1:		
		clr.w     (%a0)+
		dbf       %d0,_ExecToken_InitLocalVars_loop1
		
_ExecToken_InitLocalVars_endloop1:		
		moveq.l   #0,%d0
_ExecToken_InitLocalVars_startinit_string:		
		move.b    (%a3)+,-(%SP)				|Lecture offsets variables locales chanes de caractres
		move.w    (%SP)+,%d0
		move.b    (%a3)+,%d0
		tst.w     %d0					|Optimisations en vitesse pour procdure
		jbeq      _ExecToken_InitLocalVars_endloop2	|sans variables type chanes de caractres
		lea.l     ptrLocalVarString,%a2
		move.l    (%a2),%a0
		suba.l    %d0,%a0
		move.l    %a0,(%a2)
		cmpa.l    ptrStart_LocalVar,%a0
		jbcs      _ERROR_local_vars_stack_overflow
		
		lsr.w     #1,%d0				|Divise par 2 l'offset (prparation effacement zone des variables)
		subq.w    #1,%d0
		jbcs      _ExecToken_InitLocalVars_endloop2
_ExecToken_InitLocalVars_loop2:		
		clr.w     (%a0)+
		dbf       %d0,_ExecToken_InitLocalVars_loop2
		
_ExecToken_InitLocalVars_endloop2:
		|Passage des pointeurs pour variables locales dans la pile
		move.l    ptrLocalVar,-(%SP)
		move.l    ptrLocalVarString,-(%SP)
		
		|Vrification nombre d'arguments
		moveq.l   #0,%d5
		move.b    (%a3)+,%d5				|Nombre de variables
		jbsr      TokensExec_CNumArg
		cmp.w     %d5,%d6
		jbeq      _ExecToken_Gosub_next
		jbgt      _ERROR_too_parameter
		jbra      _ERROR_few_parameter	
		
		|Stockage des variables entres en paramtres
_ExecToken_Gosub_next:		
		moveq.l   #0,%d6
		subq.w    #1,%d5
		jbcs      _ExecToken_Gosub_endloop_start_procedure
		
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		
_ExecToken_Gosub_loop:
		tst.w     %d6
		jbeq      _ExecToken_Gosub_loop_MSB
_ExecToken_Gosub_loop_LSB:		
		moveq.l   #0,%d6
		move.b    (%a3)+,%d4
		andi.b    #0x0F,%d4
_ExecToken_Gosub_loop_next:
		|Tableau indfini		
		move.b    (%a5),%d0
		jbsr      TokensExec_CheckTableVar
		
		|Type number -> Type local var
		MACRO_ConvertType 	%d4, 0
		
		movea.l   4(%a5),%a0
		move.l    4(%SP),%a1				|Adresse dbut variables locales numriques
		cmpi.b    #TYPE_BOOL,%d4
		jbeq      _ExecToken_Gosub_affec_bool
		
		btst.b    #0,4(%SP)				|Donne adresse paire?
		jbeq      _ExecToken_Gosub_loop_pair
		addq.l    #1,4(%SP)
_ExecToken_Gosub_loop_pair:		
		subq.b    #TYPE_INTEGER,%d4			|#TYPE_INTEGER
		jbeq      _ExecToken_Gosub_affec_integer	
		jbcs      _ExecToken_Gosub_affec_float		|Float
		
		|Chane de caractres
		move.w    2(%a5),%d3
		move.l    (%SP),%a2
		jbsr      TokensExec_NewString_Gosub
		
		|Copie chane de caractres
		move.w    %d3,%d0
		movea.l   %a0,%a1 
		movea.l   4(%a5),%a0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		addq.l    #SIZE_DESCRIPTOR,(%SP)
		
_ExecToken_Gosub_loop_next2:
		lea.l     -12(%a5),%a5		
		dbf       %d5,_ExecToken_Gosub_loop
		
_ExecToken_Gosub_endloop:		
		tst.w     %d6
		jbeq      _ExecToken_Gosub_endloop_start_procedure
		addq.l    #1,%a3
_ExecToken_Gosub_endloop_start_procedure:		
		lea.l     TokensFile_DataPtr,%a0
		move.l    %a3,(%a0)
		
		|Restaure pile ES
		addq.l    #4+4,%SP				|Restaure pile SP
		jbra      TokensExec_EndTokenCmd2

_ExecToken_Gosub_loop_MSB:
		moveq.l   #-1,%d6
		move.b    (%a3),%d4
		lsr.b     #4,%d4
		jbra      _ExecToken_Gosub_loop_next

_ExecToken_Gosub_affec_integer:
		move.l    (%a0),(%a1)
		addq.l    #SIZE_INTEGER,4(%SP)
		jbra      _ExecToken_Gosub_loop_next2      
		
_ExecToken_Gosub_affec_float:
		move.l    (%a0)+,(%a1)+
		move.l    (%a0)+,(%a1)+
		move.w    (%a0),(%a1)
		addi.l    #SIZE_FLOAT,4(%SP)
		jbra      _ExecToken_Gosub_loop_next2
		
_ExecToken_Gosub_affec_bool:
		move.b    (%a0),(%a1)
		addq.l    #SIZE_BOOL,4(%SP)
		jbra      _ExecToken_Gosub_loop_next2
		

|=======================================|
|Tokens de gestion des donnes statiques|
|=======================================|
ExecToken_Number_Float:
		lea.l     TokensFile_DataPtr,%a0		|Adresse de la donnes en cours				
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    (%a0),-(%a5)				|Empile adresse dans ES
		subq.l    #2,%a5				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_FLOAT,-(%a5)			|Empile type de donnes
		move.b    #OPRD_NUMBER,-(%a5)			|Empile Oprande
		addi.l    #10,(%a0)				|Avance pointeur				
		rts
		
ExecToken_Number_Int:
		lea.l     TokensFile_DataPtr,%a0		|Adresse de la donnes en cours
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    (%a0),-(%a5)				|Empile adresse dans ES
		subq.l    #2,%a5				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_INTEGER,-(%a5)			|Empile type de donnes
		move.b    #OPRD_NUMBER,-(%a5)			|Empile oprande
		addq.l    #4,(%a0)				|Avance pointeur				
		rts
		
ExecToken_String:
		lea.l     TokensFile_DataPtr,%a1		|Pointeur de donnes dans %a1
		movea.l   (%a1),%a0				|Prpare lecture numro de la variable
		moveq.l   #0,%d0				|Efface %d0
		move.b    (%a0)+,%d0				|Taille de la chane de caractres
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    %a0,-(%a5)				|Empile adresse de la chane de caractres
		move.w    %d0,-(%a5)				|Empile taille de la chane de caractres
		move.b    #TYPE_STRING,-(%a5)			|Empile type de donnes
		move.b    #OPRD_STRING,-(%a5)			|Empile oprande
		addq.l    #1,%d0				|Saute caractre HULL
		adda.w    %d0,%a0 |lea	(%d0.w,%a0),%a0		|Ce place au token suivant
		move.l    %a0,(%a1)				|Avance pointeur de donnes
		rts


|===============================|
|Tokens de gestion des variables|
|===============================|		
ExecToken_Var_Float:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d0				|Efface %d0
		move.b    (%a0),%d0				|Lecture numro variable
		moveq.l   #0,%d1				|Efface d1	
		move.b    %d0,%d1				|Sauvegarde %d0 dans %d1
		lsl.w     #3,%d1				|Multiplie par 2^3=8 %d1
		add.w     %d0,%d0				|Multiplie par 2 %d0
		add.w     %d0,%d1				|Finale multiplication de 10
		move.l    VAR_FLOAT,%d0				|Adresse dbut variables flottants dans %d0
		add.l     %d1,%d0				|Zone de la variable n voulue
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    %d0,-(%a5)				|Charge adresse dans la pile ES
		subq.l    #2,%a5				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_FLOAT,-(%a5)			|Empile type de donnes
		move.b    #OPRD_VAR,-(%a5)			|Empile oprande
		addq.l    #1,(%a1)				|Token suivant
		rts
		
ExecToken_Var_Int:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d1				|Efface d1
		move.b    (%a0),%d1				|Lecture numro variable
		lsl.w     #2,%d1				|Multiplication de 2^2=4
		move.l    VAR_INTEGER,%d0			|Adresse de dbut variables de type entier
		add.l     %d1,%d0				|Zone de la variable n voulue
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    %d0,-(%a5)				|Charge adresse dans la pile ES
		subq.l    #2,%a5				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_INTEGER,-(%a5)			|Empile type de donnes
		move.b    #OPRD_VAR,-(%a5)			|Empile oprande
		addq.l    #1,(%a1)				|Token suivant
		rts
		
ExecToken_Var_Bool:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d1				|Efface d1
		move.b    (%a0),%d1				|Lecture numro variable
		move.l    VAR_BOOL,%d0				|Adresse de dbut variables de type entier
		add.l     %d1,%d0				|Zone de la variable n voulue
		subq.l    #4,%a5				|Saute adresse tableau...
		move.l    %d0,-(%a5)				|Charge adresse dans la pile ES
		subq.l    #2,%a5				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_BOOL,-(%a5)			|Empile type de donnes
		move.b    #OPRD_VAR,-(%a5)			|Empile oprande
		addq.l    #1,(%a1)				|Token suivant
		rts

ExecToken_Var_String:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d0				|Efface %d0
		move.b    (%a0),%d0				|Lecture numro variable
		moveq.l   #0,%d1				|Efface d1	
		move.b    %d0,%d1				|Sauvegarde %d0 dans %d1
		lsl.w     #2,%d1				|Multiplie par 2^2=4 %d1
		add.w     %d0,%d0				|Multiplie par 2 %d0
		add.w     %d0,%d1				|Finale multiplication de 6
		move.l    VAR_STRING,%a0			|Adresse dbut variables string dans %a0
		adda.w    %d1,%a0 |lea.l     (%d1.w,%a0),%a0	|Zone de la variable n voulue
		move.l    %a0,-(%a5)				|Adresse descripteur...
		move.l    (%a0)+,%d0
		jbne      _ExecToken_Var_String_not_NULL_string
		move.l    #EMPTY_STRING,%d0
_ExecToken_Var_String_not_NULL_string:		
		move.l    %d0,-(%a5)				|Charge adresse dans la pile ES
		move.w    (%a0),-(%a5)				|Taille de la chane de caractres
		move.b    #TYPE_STRING,-(%a5)			|Empile type de donnes
		move.b    #OPRD_VAR,-(%a5)			|Empile oprande
		addq.l    #1,(%a1)				|Token suivant
		rts
		
		
|==============================|
|Tokens de gestion des tableaux|
|==============================|
ExecToken_Var_TFloat:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d1				|Efface d1
		moveq.l   #0,%d2				|Efface d2
		move.b    (%a0),%d1				|Lecture numro variable
		move.b    %d1,%d2				|Copie %d1 dans %d2
		add.w     %d2,%d2				|%d2*2
		lsl.w     #2,%d1				|%d1*4
		add.w     %d2,%d1				|Permet de sauter les descripteur de 6 octets
		move.l    TAB_FLOAT,%d0				|Adresse de dbut tableaux type flottant
		add.l     %d1,%d0				|Zone du descripteur n voulu
		addq.l    #1,(%a1)				|Token suivant
		move.b    #TYPE_FLOAT,%d4
		move.w    #SIZE_FLOAT,%d5
		movea.l   %d0,%a4
		jbra      TokensExec_AddVarTable
		
ExecToken_Var_TInt:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d1				|Efface d1
		moveq.l   #0,%d2				|Efface d2
		move.b    (%a0),%d1				|Lecture numro variable
		move.b    %d1,%d2				|Copie %d1 dans %d2
		add.w     %d2,%d2				|%d2*2
		lsl.w     #2,%d1				|%d1*4
		add.w     %d2,%d1				|Permet de sauter les descripteur de 6 octets
		move.l    TAB_INTEGER,%d0			|Adresse de dbut tableaux type entier
		add.l     %d1,%d0				|Zone du descripteur n voulu
		addq.l    #1,(%a1)				|Token suivant
		move.b    #TYPE_INTEGER,%d4
		move.w    #SIZE_INTEGER,%d5
		movea.l   %d0,%a4
		jbra      TokensExec_AddVarTable
		
ExecToken_Var_TBool:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d1				|Efface d1
		moveq.l   #0,%d2				|Efface d2
		move.b    (%a0),%d1				|Lecture numro variable
		move.b    %d1,%d2				|Copie %d1 dans %d2
		add.w     %d2,%d2				|%d2*2
		lsl.w     #2,%d1				|%d1*4
		add.w     %d2,%d1				|Permet de sauter les descripteur de 6 octets
		move.l    TAB_BOOL,%d0				|Adresse de dbut tableaux type boolena
		add.l     %d1,%d0				|Zone du descripteur n voulu
		addq.l    #1,(%a1)				|Token suivant
		move.b    #TYPE_BOOL,%d4
		move.w    #SIZE_BOOL,%d5
		movea.l   %d0,%a4
		jbra      TokensExec_AddVarTable
	
ExecToken_Var_TString:
		lea.l     TokensFile_DataPtr,%a1		|Prpare lecture numro de la variable
		move.l    (%a1),%a0
		moveq.l   #0,%d1				|Efface d1
		moveq.l   #0,%d2				|Efface d2
		move.b    (%a0),%d1				|Lecture numro variable
		move.b    %d1,%d2				|Copie %d1 dans %d2
		add.w     %d2,%d2				|%d2*2
		lsl.w     #2,%d1				|%d1*4
		add.w     %d2,%d1				|Permet de sauter les descripteur de 6 octets
		move.l    TAB_STRING,%d0			|Adresse de dbut tableaux type string
		add.l     %d1,%d0				|Zone du descripteur n voulu
		addq.l    #1,(%a1)				|Token suivant
		move.b    #TYPE_STRING,%d4
		move.w    #SIZE_DESCRIPTOR,%d5
		movea.l   %d0,%a4
		jbra      TokensExec_AddVarTable

		
|=========================================|
|Tokens d'oprations mathmatiques simples|
|=========================================|
|********|
|ADDITION|
|********|
_ExecToken_Math_Add_integer:
		move.l    (%a1),%d0				|Number 1
		add.l     (%a0),%d0
		jbra	  TokensExec_AddResult2_Integer
		
_ExecToken_Math_Add_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fadd*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult2_Float
		
ExecToken_Math_Add:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Math_Add_integer			
		jbcs      _ExecToken_Math_Add_float		|Calcul entre flottants
		
		|Concantation de chanes de caractres			
		movea.l   %a0,%a4				|Sauvegarde chane 2
		move.w    14(%a5),%d0				|Taille chane 2
		move.w    %d0,%d7				|Sauvegarde taille de la chane 2
		add.w     2(%a5),%d0				|+ Taille chane 1
		jbsr      TokensExec_AddResult2_String
	
		lea.l     (%d7.w,%a0),%a3			|Futur copie chane 1
		move.w    %d7,%d0				|Taille chane 2
		movea.l   %a0,%a1				|Destination
		movea.l   %a4,%a0				|Source chane 2
		jbsr      _memcpy
		
		move.w    -10(%a5),%d0				|Taille chane 1
		movea.l   -8(%a5),%a0				|Source chane 1
		movea.l   %a3,%a1
		jbsr      _memcpy				|Caractre NULL
		clr.b     (%a1)
		rts


|************|
|SOUSTRACTION|
|************|
_ExecToken_Math_Sub_integer:
		move.l    (%a0),%d0				|Number 2
		sub.l     (%a1),%d0
		jbra	  TokensExec_AddResult2_Integer
		
ExecToken_Math_Sub:
		MACRO_MathType TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Math_Sub_integer			
_ExecToken_Math_Sub_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fsub*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult2_Float


|**************|
|MULTIPLICATION|
|**************|
_ExecToken_Math_Mul_integer:
		move.l    (%a1),-(%SP)				|Number 1
		move.l    (%a0),-(%SP)				|Number 2
		jbsr      __mulsi3
		addq.l    #4+4,%SP
		jbra	  TokensExec_AddResult2_Integer
		
ExecToken_Math_Mul:
		MACRO_MathType TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Math_Mul_integer			
_ExecToken_Math_Mul_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fmul*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult2_Float


|********|
|DIVISION|
|********|				
ExecToken_Math_Div:
		MACRO_ConvertType 	#TYPE_FLOAT, 12
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
_ExecToken_Math_Div_float:
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		move.w    8(%a1),%d0				|Division par zro? (Comparaison imparfaite!)
		move.l    4(%a1),%d1
		move.l    (%a1),%d2
		tst.w     %d0
		jbne      _ExecToken_Math_Div_float_next
		tst.l     %d1
		jbne      _ExecToken_Math_Div_float_next
		tst.w     %d2
		jbne      _ExecToken_Math_Div_float_next
		jbra	  _ERROR_divide_by_zero
		
_ExecToken_Math_Div_float_next:
		|Empile number 1
		move.w    %d0,-(%SP)				|Empile fin flottant
		move.l    %d1,-(%SP)				|Empile milieu flottant
		move.l    %d2,-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fdiv*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult2_Float

|*********|
|PUISSANCE|
|*********|
_ExecToken_Math_Puiss_integer_no_calcul:
		moveq.l   #0,%d0				|Rsultat gal  zro
		jbra      TokensExec_AddResult2_Integer
		
_ExecToken_Math_Puiss_integer:
		moveq.l   #1,%d0				|Rsultat
		move.l    (%a0),%d3				|Number 2
		move.l    (%a1),%d4				|Number 1 - Puissance (compteur)
		dbpl      %d4,_ExecToken_Math_Puiss_integer_no_calcul|Si <0
		
_ExecToken_Math_Puiss_integer_loop:
		move.l    %d3,-(%SP)				|Number 2
		move.l    %d0,-(%SP)				|Rsultat
		jbsr      __mulsi3
		addq.l    #4+4,%SP
		dbf       %d4,_ExecToken_Math_Puiss_integer_loop
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Math_Puiss:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Math_Puiss_integer		
_ExecToken_Math_Puiss_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #pow*4,-(%SP)				|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult2_Float
	
		
|======================|
|Tokens de comparaisons|
|======================|
|*********|
|SUPERIEUR|
|*********|
_ExecToken_Compare_Superior_integer:
		moveq.l   #0,%d0				|Rsultat FALSE
		move.l    (%a0),%d1
		cmp.l     (%a1),%d1				|Number 2 par rapport  number 1
		sgt	  %d0
		jbra      TokensExec_AddResult2_Bool
		
_ExecToken_Compare_Superior_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP		
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.l     %d1
		sgt       %d0
		jbra      TokensExec_AddResult2_Bool
		
ExecToken_Compare_Superior:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Compare_Superior_integer			
		jbcs      _ExecToken_Compare_Superior_float	|Calcul entre flottants
		
		|Comparaison de chanes de caractres
		pea.l     (%a1)
		pea.l     (%a0)
		ROM_CALL  strcmp
		addq.l    #4+4,%SP
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.w     %d1
		sgt       %d0
		jbra      TokensExec_AddResult2_Bool
		
		
|*********|
|INFERIEUR|
|*********|
_ExecToken_Compare_Inferior_integer:
		moveq.l   #0,%d0				|Rsultat FALSE
		move.l    (%a0),%d1
		cmp.l     (%a1),%d1				|Number 2 par rapport  number 1
		slt	  %d0
		jbra      TokensExec_AddResult2_Bool
		
_ExecToken_Compare_Inferior_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP		
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.l     %d1
		slt       %d0
		jbra      TokensExec_AddResult2_Bool
		
ExecToken_Compare_Inferior:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Compare_Inferior_integer			
		jbcs      _ExecToken_Compare_Inferior_float	|Calcul entre flottants
		
		|Comparaison de chanes de caractres
		pea.l     (%a1)
		pea.l     (%a0)
		ROM_CALL  strcmp
		addq.l    #4+4,%SP
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.w     %d1
		slt       %d0
		jbra      TokensExec_AddResult2_Bool
		
|****|
|EGAL|
|****|
_ExecToken_Egal_integer:
		moveq.l   #0,%d0				|Rsultat FALSE
		move.l    (%a0),%d1
		cmp.l     (%a1),%d1				|Number 2 par rapport  number 1
		seq	  %d0
		jbra      TokensExec_AddResult2_Bool
		
_ExecToken_Egal_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP		
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.l     %d1
		seq       %d0
		jbra      TokensExec_AddResult2_Bool
		
ExecToken_Egal:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Egal_integer			
		jbcs      _ExecToken_Egal_float			|Calcul entre flottants
		
		|Comparaison de chanes de caractres
		pea.l     (%a1)
		pea.l     (%a0)
		ROM_CALL  strcmp
		addq.l    #4+4,%SP
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.w     %d1
		seq       %d0
		jbra      TokensExec_AddResult2_Bool
		

|*****************|
|SUPERIEUR OU EGAL|
|*****************|		
_ExecToken_Supegal_integer:
		moveq.l   #0,%d0				|Rsultat FALSE
		move.l    (%a0),%d1
		cmp.l     (%a1),%d1				|Number 2 par rapport  number 1
		sge	  %d0
		jbra      TokensExec_AddResult2_Bool
		
_ExecToken_Supegal_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP		
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.l     %d1
		sge       %d0
		jbra      TokensExec_AddResult2_Bool
		
ExecToken_Supegal:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Supegal_integer			
		jbcs      _ExecToken_Supegal_float		|Calcul entre flottants
		
		|Comparaison de chanes de caractres
		pea.l     (%a1)
		pea.l     (%a0)
		ROM_CALL  strcmp
		addq.l    #4+4,%SP
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.w     %d1
		sge       %d0
		jbra      TokensExec_AddResult2_Bool
		
		
|*****************|
|INFERIEUR OU EGAL|
|*****************|		
_ExecToken_Infegal_integer:
		moveq.l   #0,%d0				|Rsultat FALSE
		move.l    (%a0),%d1
		cmp.l     (%a1),%d1				|Number 2 par rapport  number 1
		sle	  %d0
		jbra      TokensExec_AddResult2_Bool
		
_ExecToken_Infegal_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP		
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.l     %d1
		sle       %d0
		jbra      TokensExec_AddResult2_Bool
		
ExecToken_Infegal:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Infegal_integer			
		jbcs      _ExecToken_Infegal_float		|Calcul entre flottants
		
		|Comparaison de chanes de caractres
		pea.l     (%a1)
		pea.l     (%a0)
		ROM_CALL  strcmp
		addq.l    #4+4,%SP
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.w     %d1
		sle       %d0
		jbra      TokensExec_AddResult2_Bool
		
		
|*********|
|DIFFERENT|
|*********|
_ExecToken_Diff_integer:
		moveq.l   #0,%d0				|Rsultat FALSE
		move.l    (%a0),%d1
		cmp.l     (%a1),%d1				|Number 2 par rapport  number 1
		sne	  %d0
		jbra      TokensExec_AddResult2_Bool
		
_ExecToken_Diff_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP		
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.l     %d1
		sne       %d0
		jbra      TokensExec_AddResult2_Bool
		
ExecToken_Diff:
		MACRO_MathType TRUE, TRUE, FALSE, TRUE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Diff_integer			
		jbcs      _ExecToken_Diff_float			|Calcul entre flottants
		
		|Comparaison de chanes de caractres
		pea.l     (%a1)
		pea.l     (%a0)
		ROM_CALL  strcmp
		addq.l    #4+4,%SP
		move.l    %d0,%d1
		moveq.l   #0,%d0				|Rsultat FALSE
		tst.w     %d1
		sne       %d0
		jbra      TokensExec_AddResult2_Bool


|===================|
|Token d'affectation|
|===================|
_ExecToken_Affec_integer:
		move.l    (%a0),(%a1)				|Ecrit entier
		jbra      TokensExec_EndTokenCmd

_ExecToken_Affec_float:
		move.l    (%a0)+,(%a1)+				|Ecrit flottant
		move.l    (%a0)+,(%a1)+
		move.w    (%a0),(%a1)				|Dpile ES de 2 items
		jbra      TokensExec_EndTokenCmd
		
_ExecToken_Affec_bool:
		move.b    (%a0),(%a1)				|Ecrit boolen
		jbra      TokensExec_EndTokenCmd
		
_ExecToken_Affec_next:
		|Type number1 -> Type number2
		MACRO_ConvertType 	13(%a5), 0
		
		move.b    13(%a5),%d1				|Type number 2
		movea.l   4(%a5),%a0				|Number 1
		movea.l   16(%a5),%a1				|Number 2
		subq.b    #TYPE_INTEGER,%d1
		jbeq      _ExecToken_Affec_integer
		jbcs      _ExecToken_Affec_float 
		subq.b    #1,%d1
		jbeq      _ExecToken_Affec_bool
		
		|Affectation chane de caractres
		|Cration allocation
		move.w	  2(%a5),%d3				|Taille de la chane de caractres source
		lea.l     12(%a5),%a2				|Zone pile ES, chaine de caractres de destination
		jbsr      TokensExec_NewString
		
		|Copie chane de caractre
		move.w    %d3,%d0				|Taille de la chane de caractre  copier
		movea.l   %a0,%a1
		movea.l   4(%a5),%a0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		jbra      TokensExec_EndTokenCmd
		
ExecToken_Affec:
		move.b    12(%a5),%d0				|Oprande number 2
		jbsr      TokensExec_CheckTableVar
		subq.b    #OPRD_VAR,%d0
		jbeq      _ExecToken_Affec_next
		subq.b    #1,%d0				|OPRD_VARTABLE
		jbeq      _ExecToken_Affec_next
		jbra	  _ERROR_incorrect_arg


|============================|
|Tokens d'oprations logiques|
|============================|
|***********|
|NON LOGIQUE|
|***********|
_ExecToken_Logic_Not_integer:
		move.l    (%a0),%d0
		not.l     %d0
		jbra      TokensExec_AddResult_Integer
		
ExecToken_Logic_Not:
		MACRO_SimpleType FALSE, TRUE, TRUE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a0				|Number 1
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Logic_Not_integer
_ExecToken_Logic_Not_bool:
		move.b    (%a0),%d0
		not.b     %d0
		jbra      TokensExec_AddResult_Bool


|**********|
|ET LOGIQUE|
|**********|		
_ExecToken_Logic_And_integer:
		move.l    (%a0),%d0				|Number 2
		and.l     (%a1),%d0
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Logic_And:
		MACRO_MathType FALSE, TRUE, TRUE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Logic_And_integer
_ExecToken_Logic_And_bool:
		move.b    (%a0),%d0				|Number 2
		and.b     (%a1),%d0
		jbra      TokensExec_AddResult2_Bool
		
		
|***********|
|OU INCLUSIF|
|***********|		
_ExecToken_Logic_Or_integer:
		move.l    (%a0),%d0				|Number 2
		or.l      (%a1),%d0
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Logic_Or:
		MACRO_MathType FALSE, TRUE, TRUE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Logic_Or_integer
_ExecToken_Logic_Or_bool:
		move.b    (%a0),%d0				|Number 2
		or.b      (%a1),%d0
		jbra      TokensExec_AddResult2_Bool
		
				
|***********|
|OU EXCLUSIF|
|***********|		
_ExecToken_Logic_Xor_integer:
		move.l    (%a0),%d0				|Number 2
		move.l    (%a1),%d1				|Number 1
		eor.l     %d1,%d0
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Logic_Xor:
		MACRO_MathType FALSE, TRUE, TRUE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Logic_Xor_integer
_ExecToken_Logic_Xor_bool:
		move.b    (%a0),%d0				|Number 2
		move.b    (%a1),%d1				|Number 1
		eor.b     %d1,%d0
		jbra      TokensExec_AddResult2_Bool
		
		
|***********|
|IMPLICATION|
|***********|		
_ExecToken_Logic_Imp_integer:
		move.l    (%a0),%d0				|Number 2
		not.l     %d0
		or.l      (%a1),%d0
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Logic_Imp:
		MACRO_MathType FALSE, TRUE, TRUE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Logic_Imp_integer
_ExecToken_Logic_Imp_bool:
		move.b    (%a0),%d0				|Number 2
		not.b     %d0
		or.b      (%a1),%d0
		jbra      TokensExec_AddResult2_Bool
		
		
|***********|
|EQUIVALENCE|
|***********|		
_ExecToken_Logic_Eqv_integer:
		move.l    (%a0),%d0				|Number 2
		move.l    (%a1),%d1				|Number 1
		move.l    %d0,%d2
		move.l    %d1,%d3
		not.l     %d2
		not.l     %d3
		or.l      %d2,%d1
		or.l      %d3,%d0
		and.l     %d1,%d0
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Logic_Eqv:
		MACRO_MathType FALSE, TRUE, TRUE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Logic_Eqv_integer
_ExecToken_Logic_Eqv_bool:
		move.b    (%a0),%d0				|Number 2
		move.b    (%a1),%d1				|Number 1
		move.b    %d0,%d2
		move.b    %d1,%d3
		not.b     %d2
		not.b     %d3
		or.b      %d2,%d1
		or.b      %d3,%d0
		and.b     %d1,%d0
		jbra      TokensExec_AddResult2_Bool


|========================|
|Tokens de calculs divers|
|========================|
|******|
|MODULO|
|******|
_ExecToken_Math_Mod_integer:
		move.l    (%a1),-(%SP)				|Number 1
		move.l    (%a0),-(%SP)				|Number 2
		jbsr      __modsi3
		addq.l    #4+4,%SP
		jbra      TokensExec_AddResult2_Integer
		
ExecToken_Math_Mod:
		MACRO_MathType TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Math_Mod_integer
_ExecToken_Math_Mod_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fmod*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult2_Float


|****************|
|DIVISION ENTIERE|
|****************|
_ExecToken_Math_Divint_integer:
		move.l    (%a1),%d0				|Division par zro?
		jbeq      _ERROR_divide_by_zero
		move.l    %d0,-(%SP)				|Number 1
		move.l    (%a0),-(%SP)				|Number 2
		jbsr      __divsi3
		addq.l    #4+4,%SP
		jbra	  TokensExec_AddResult2_Integer
		
ExecToken_Math_Divint:
		MACRO_MathType TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a0				|Number 2
		
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Math_Divint_integer
_ExecToken_Math_Divint_float:
		move.w    8(%a1),%d0				|Division par zro? (Comparaison imparfaite!)
		move.l    4(%a1),%d1
		move.l    (%a1),%d2
		tst.w     %d0
		jbne      _ExecToken_Math_Divint_float_next
		tst.l     %d1
		jbne      _ExecToken_Math_Divint_float_next
		tst.w     %d2
		jbne      _ExecToken_Math_Divint_float_next
		jbra	  _ERROR_divide_by_zero
_ExecToken_Math_Divint_float_next:
		|Empile number 1
		move.w    %d0,-(%SP)				|Empile fin flottant
		move.l    %d1,-(%SP)				|Empile milieu flottant
		move.l    %d2,-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fdiv*4,-(%SP)			|Wrapper
		jbsr      __BC
		move.w    %d2,-(%SP)				|Empile fin flottant
		move.l    %d1,-(%SP)				|Empile milieu flottant
		move.l    %d0,-(%SP)				|Empile dbut flottant
		ROM_CALL  trunc
		lea.l     (4+4+2)+(2+4+4+2+4+4+2)(%SP),%SP
		jbra      TokensExec_AddResult2_Integer
		
		
|==============================|
|Token de ngation mathmatique|
|==============================|
_ExecToken_Negatif_integer:
		move.l    (%a0),%d0
		neg.l     %d0
		jbra      TokensExec_AddResult_Integer
		
ExecToken_Negatif:
		MACRO_SimpleType TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		
		move.b    1(%a5),%d0				|Type number 1
		movea.l   4(%a5),%a0				|Number 1
	
		subq.b    #TYPE_INTEGER,%d0			|Calcul entre entiers
		jbeq      _ExecToken_Negatif_integer
_ExecToken_Negatif_float:
		|Empile number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fneg*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Float
		
		
|=======|
|RESTORE|
|=======|	
ExecBase_Restore:
		lea.l     TokensFile_DataPtr,%a2		|Adresse de la donnes en cours
		move.l    (%a2),%a1
		lea.l     sDATA_number,%a0			|Donne en cours
		move.w    (%a1)+,(%a0)
		move.l    sDATA_start_ptr,%d0			|Adresse de dbut des donnes
		moveq.l   #0,%d1				|Efface %d1
		move.w    (%a1),%d1				
		add.l     %d0,%d1
		lea.l     sDATA_ptr,%a0				|Adresse de la donne
		move.l    %d1,(%a0)
		addq.l    #4,(%a2)
		rts
		
		.end
			