|====================
|Tokens de constantes
|====================
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "TokensExec.h"
		.include  "TokensConstant.h"
		.include  "GFATEM.h"

		.xdef     TokenConstant_KeyRead
		
		.xdef     TokenConstant_Calculator
		.xdef     TokenConstant_HW_Version
		.xdef     TokenConstant_LCD_Height
		.xdef     TokenConstant_LCD_Width
		.xdef     TokenConstant_LCD_Line_Bytes
		.xdef     TokenConstant_ROM_Base
		.xdef     TokenConstant_TI89
		.xdef     TokenConstant_TI89_Classic
		.xdef     TokenConstant_TI89_Titanium
		.xdef     TokenConstant_TI92Plus
		.xdef     TokenConstant_V200
		.xdef     TokenConstant_TIOS_Entries
		.xdef     TokenConstant_RR_0
		.xdef     TokenConstant_RR_1
		.xdef     TokenConstant_RR_2
		.xdef     TokenConstant_RR_3
		.xdef     TokenConstant_RR_4
		.xdef     TokenConstant_RR_5
		.xdef     TokenConstant_RR_6
		.xdef     TokenConstant_RR_7
		.xdef     TokenConstant_RR_8
		.xdef     TokenConstant_RR_9
		.xdef     TokenConstant_RR_2ND
		.xdef     TokenConstant_RR_A
		.xdef     TokenConstant_RR_Alpha
		.xdef     TokenConstant_RR_Apps
		.xdef     TokenConstant_RR_B
		.xdef     TokenConstant_RR_Backspace
		.xdef     TokenConstant_RR_C
		.xdef     TokenConstant_RR_Catalog
		.xdef     TokenConstant_RR_Clear
		.xdef     TokenConstant_RR_Comma
		.xdef     TokenConstant_RR_Cos
		.xdef     TokenConstant_RR_D
		.xdef     TokenConstant_RR_Diamond
		.xdef     TokenConstant_RR_Divide
		.xdef     TokenConstant_RR_Dot
		.xdef     TokenConstant_RR_Down
		.xdef     TokenConstant_RR_E
		.xdef     TokenConstant_RR_EE
		.xdef     TokenConstant_RR_Enter1
		.xdef     TokenConstant_RR_Enter2
		.xdef     TokenConstant_RR_Enter
		.xdef     TokenConstant_RR_Equals
		.xdef     TokenConstant_RR_Esc
		.xdef     TokenConstant_RR_F1
		.xdef     TokenConstant_RR_F2
		.xdef     TokenConstant_RR_F3
		.xdef     TokenConstant_RR_F4
		.xdef     TokenConstant_RR_F5
		.xdef     TokenConstant_RR_F6
		.xdef     TokenConstant_RR_F7
		.xdef     TokenConstant_RR_F8
		.xdef     TokenConstant_RR_F
		.xdef     TokenConstant_RR_G
		.xdef     TokenConstant_RR_H
		.xdef     TokenConstant_RR_Hand
		.xdef     TokenConstant_RR_Home
		.xdef     TokenConstant_RR_I
		.xdef     TokenConstant_RR_J
		.xdef     TokenConstant_RR_K
		.xdef     TokenConstant_RR_L
		.xdef     TokenConstant_RR_Left
		.xdef     TokenConstant_RR_Ln
		.xdef     TokenConstant_RR_M
		.xdef     TokenConstant_RR_Minus
		.xdef     TokenConstant_RR_Mode
		.xdef     TokenConstant_RR_Multiply
		.xdef     TokenConstant_RR_N
		.xdef     TokenConstant_RR_Negate
		.xdef     TokenConstant_RR_O
		.xdef     TokenConstant_RR_P
		.xdef     TokenConstant_RR_Paren_Close
		.xdef     TokenConstant_RR_Paren_Open
		.xdef     TokenConstant_RR_Plus
		.xdef     TokenConstant_RR_Power
		.xdef     TokenConstant_RR_Q
		.xdef     TokenConstant_RR_R
		.xdef     TokenConstant_RR_Right
		.xdef     TokenConstant_RR_S
		.xdef     TokenConstant_RR_Shift
		.xdef     TokenConstant_RR_Sin
		.xdef     TokenConstant_RR_Space
		.xdef     TokenConstant_RR_Store
		.xdef     TokenConstant_RR_T
		.xdef     TokenConstant_RR_Tan
		.xdef     TokenConstant_RR_Theta
		.xdef     TokenConstant_RR_U
		.xdef     TokenConstant_RR_Up
		.xdef     TokenConstant_RR_V
		.xdef     TokenConstant_RR_W
		.xdef     TokenConstant_RR_With
		.xdef     TokenConstant_RR_X
		.xdef     TokenConstant_RR_Y
		.xdef     TokenConstant_RR_Z
		
		.xdef     TokenConstant_AMS_1xx
		.xdef	  TokenConstant_AMS_2xx
		.xdef	  TokenConstant_AMS_3xx
		
|=========================================================================
|TokenConstant_KeyRead
|-------------------------------------------------------------------------
|Low level keyboard reading
|-------------------------------------------------------------------------
|input:
|  dc.w %d1 = Row TI89
|  dc.w %d2 = Row TI92
|  dc.b %d3 = Col TI89
|  dc.b %d4 = Col TI92
|
|output:
|  Add boolean in ES
|
|destroy:
|=========================================================================
TokenConstant_KeyRead:
		clr.b     %d0
		tst.w     CALCULATOR
		jbeq      _TokenConstant_KeyRead_TI89
_TokenConstant_KeyRead_TI92:
		move.w    %d2,%d1
		jbsr      _rowread2
		btst.b    %d4,%d1
		sne       %d0
		jbra      TokensExec_AddResult_NoDel_Bool      
		
_TokenConstant_KeyRead_TI89:
		jbsr      _rowread2
		btst.b    %d3,%d1
		sne       %d0
		jbra      TokensExec_AddResult_NoDel_Bool
		

|*************************************************************************
|Dbut constantes
|*************************************************************************		
TokenConstant_Calculator:
		moveq.l   #0,%d0
		move.w    CALCULATOR,%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_HW_Version:
		moveq.l   #0,%d0
		move.w    HARDWARE_VERSION,%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_LCD_Height:
		moveq.l   #0,%d0
		move.w    LCD_HEIGHT,%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_LCD_Width:
		moveq.l   #0,%d0
		move.w    LCD_WIDTH,%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_LCD_Line_Bytes:
		moveq.l   #0,%d0
		move.w    LCD_LINE_BYTES,%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_ROM_Base:
		move.l    ROM_BASE,%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_TI89:
		clr.b     %d0
		tst.w     CALCULATOR
		seq       %d0
		jbra      TokensExec_AddResult_NoDel_Bool
		
TokenConstant_TI89_Classic:
		clr.b     %d0
		tst.w     CALCULATOR
		jbne      _TokenConstant_TI89_Classic_end
		cmpi.w    #2,HARDWARE_VERSION
		jbhi      _TokenConstant_TI89_Classic_end
		moveq.l   #-1,%d0
_TokenConstant_TI89_Classic_end:
		jbra      TokensExec_AddResult_NoDel_Bool
		
TokenConstant_TI89_Titanium:
		clr.b     %d0
		tst.w     CALCULATOR
		jbne      _TokenConstant_TI89_Titanium_end
		cmpi.w    #3,HARDWARE_VERSION
		jbne      _TokenConstant_TI89_Titanium_end
		moveq.l   #-1,%d0
_TokenConstant_TI89_Titanium_end:
		jbra      TokensExec_AddResult_NoDel_Bool
		
TokenConstant_TI92Plus:
		clr.b     %d0
		cmpi.w    #1,CALCULATOR
		jbne      _TokenConstant_TI92Plus_end
		moveq.l   #-1,%d0
_TokenConstant_TI92Plus_end:
		jbra      TokensExec_AddResult_NoDel_Bool
		
TokenConstant_V200:
		clr.b     %d0
		cmpi.w    #2,CALCULATOR
		jbne      _TokenConstant_V200_end
		moveq.l   #-1,%d0
_TokenConstant_V200_end:
		jbra      TokensExec_AddResult_NoDel_Bool
		
TokenConstant_TIOS_Entries:
		move.l    200.w,%a0
		move.l    -4(%a0),%d0
		jbra      TokensExec_AddResult_NoDel_Integer
		
TokenConstant_RR_0:
		KEY_READ  4,9,0,5
		
TokenConstant_RR_1:
		KEY_READ  4,1,1,5
		
TokenConstant_RR_2:
		KEY_READ  3,1,1,6
		
TokenConstant_RR_3:
		KEY_READ  2,1,1,7
		
TokenConstant_RR_4:
		KEY_READ  4,2,2,5
		
TokenConstant_RR_5:
		KEY_READ  3,2,2,6
		
TokenConstant_RR_6:
		KEY_READ  2,2,2,7
		
TokenConstant_RR_7:
		KEY_READ  4,3,3,5
		
TokenConstant_RR_8:
		KEY_READ  3,3,3,6
		
TokenConstant_RR_9:
		KEY_READ  2,3,3,7
		
TokenConstant_RR_2ND:
		KEY_READ  0,0,4,0
		
TokenConstant_RR_A:
		KEY_READ  0xF,9,0xF,2
		
TokenConstant_RR_Alpha:
		KEY_READ  0,0xF,7,0xF
		
TokenConstant_RR_Apps:
		KEY_READ  5,7,0,6
		
TokenConstant_RR_B:
		KEY_READ  0xF,5,0xF,1
		
TokenConstant_RR_Backspace:
		KEY_READ  2,8,6,0
		
TokenConstant_RR_C:
		KEY_READ  0xF,3,0xF,1
		
TokenConstant_RR_Catalog:
		KEY_READ  3,0xF,6,0xF
		
TokenConstant_RR_Clear:
		KEY_READ  1,7,6,5
		
TokenConstant_RR_Comma:
		KEY_READ  2,4,4,7
		
TokenConstant_RR_Cos:
		KEY_READ  0xF,5,0xF,6
		
TokenConstant_RR_D:
		KEY_READ  0xF,2,0xF,2
		
TokenConstant_RR_Diamond:
		KEY_READ  0,0,6,1
		
TokenConstant_RR_Divide:
		KEY_READ  1,5,4,0
		
TokenConstant_RR_Dot:
		KEY_READ  3,9,0,6
		
TokenConstant_RR_Down:
		KEY_READ  0,0,2,7
		
TokenConstant_RR_E:
		KEY_READ  0xF,2,0xF,3
		
TokenConstant_RR_EE:
		KEY_READ  5,0xF,2,0xF
		
TokenConstant_RR_Enter1:
		KEY_READ  1,9,0,1
		
TokenConstant_RR_Enter2:
		KEY_READ  1,6,0,6
		
TokenConstant_RR_Enter:
		KEY_READ  1,9,0,1
		
TokenConstant_RR_Equals:
		KEY_READ  5,7,4,0
		
TokenConstant_RR_Esc:
		KEY_READ  6,8,0,6
		
TokenConstant_RR_F1:
		KEY_READ  5,6,7,4
		
TokenConstant_RR_F2:
		KEY_READ  4,4,7,4
		
TokenConstant_RR_F3:
		KEY_READ  3,2,7,4
		
TokenConstant_RR_F4:
		KEY_READ  2,9,7,4
		
TokenConstant_RR_F5:
		KEY_READ  1,7,7,4
		
TokenConstant_RR_F6:
		KEY_READ  0xF,5,0xF,4
		
TokenConstant_RR_F7:
		KEY_READ  0xF,3,0xF,4
		
TokenConstant_RR_F8:
		KEY_READ  0xF,1,0xF,4
		
TokenConstant_RR_F:
		KEY_READ  0xF,3,0xF,2
		
TokenConstant_RR_G:
		KEY_READ  0xF,4,0xF,2
		
TokenConstant_RR_H:
		KEY_READ  0xF,5,0xF,2
		
TokenConstant_RR_Hand:
		KEY_READ  0xF,0,0xF,3
		
TokenConstant_RR_Home:
		KEY_READ  5,0xF,6,0xF
		
TokenConstant_RR_I:
		KEY_READ  0xF,7,0xF,3
		
TokenConstant_RR_J:
		KEY_READ  0xF,6,0xF,2
		
TokenConstant_RR_K:
		KEY_READ  0xF,7,0xF,2
		
TokenConstant_RR_L:
		KEY_READ  0xF,8,0xF,2
		
TokenConstant_RR_Left:
		KEY_READ  0,0,1,4
		
TokenConstant_RR_Ln:
		KEY_READ  0xF,6,0xF,5
		
TokenConstant_RR_M:
		KEY_READ  0xF,7,0xF,1
		
TokenConstant_RR_Minus:
		KEY_READ  1,9,2,0
		
TokenConstant_RR_Mode:
		KEY_READ  4,8,6,5
		
TokenConstant_RR_Multiply:
		KEY_READ  1,7,3,7
		
TokenConstant_RR_N:
		KEY_READ  0xF,6,0xF,1
		
TokenConstant_RR_Negate:
		KEY_READ  2,9,0,7
		
TokenConstant_RR_O:
		KEY_READ  0xF,8,0xF,3
		
TokenConstant_RR_P:
		KEY_READ  0xF,6,0xF,7
		
TokenConstant_RR_Paren_Close:
		KEY_READ  3,4,4,6
		
TokenConstant_RR_Paren_Open:
		KEY_READ  4,4,4,5
		
TokenConstant_RR_Plus:
		KEY_READ  1,8,1,4
		
TokenConstant_RR_Power:
		KEY_READ  1,6,5,0
		
TokenConstant_RR_Q:
		KEY_READ  0xF,9,0xF,3
		
TokenConstant_RR_R:
		KEY_READ  0xF,3,0xF,3
		
TokenConstant_RR_Right:
		KEY_READ  0,0,3,6
		
TokenConstant_RR_S:
		KEY_READ  0xF,1,0xF,2
		
TokenConstant_RR_Shift:
		KEY_READ  0,0,5,2
		
TokenConstant_RR_Sin:
		KEY_READ  0xF,5,0xF,5
		
TokenConstant_RR_Space:
		KEY_READ  0xF,4,0xF,0
		
TokenConstant_RR_Store:
		KEY_READ  5,3,1,0
		
TokenConstant_RR_T:
		KEY_READ  2,4,5,3
		
TokenConstant_RR_Tan:
		KEY_READ  0xF,5,0xF,7
		
TokenConstant_RR_Theta:
		KEY_READ  0xF,8,0xF,1
		
TokenConstant_RR_U:
		KEY_READ  0xF,6,0xF,3
		
TokenConstant_RR_Up:
		KEY_READ  0,0,0,5
		
TokenConstant_RR_V:
		KEY_READ  0xF,4,0xF,1
		
TokenConstant_RR_W:
		KEY_READ  0xF,1,0xF,3
		
TokenConstant_RR_With:
		KEY_READ  5,0xF,3,0xF
		
TokenConstant_RR_X:
		KEY_READ  5,2,5,1
		
TokenConstant_RR_Y:
		KEY_READ  4,5,5,3
		
TokenConstant_RR_Z:
		KEY_READ  3,1,5,1
		
		
TokenConstant_AMS_1xx:
		move.b    AMS_1xx,%d0
		jbra      TokensExec_AddResult_NoDel_Bool

TokenConstant_AMS_2xx:
		clr.b     %d0
		move.l    200.w,%a0
		move.l    -4(%a0),%d0
		addi.l    #-1000,%d0
		cmpi.l    #543,%d0
		sls       %d0
		jbra      TokensExec_AddResult_NoDel_Bool
		
TokenConstant_AMS_3xx:
		clr.b     %d0
		move.l    200.w,%a0
		cmpi.l    #1543,-4(%a0)
		shi       %d0
		jbra      TokensExec_AddResult_NoDel_Bool
		
		.end
		