|=====================
|Fonctions d'execution
|=====================
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "TokensExec.h"
		.include  "GFATEM.h"
		
		|Erreurs
		.xdef     _ERROR_undef_vartable
		.xdef     _ERROR_empty_vartable
		.xdef     _ERROR_types_incompatible
		.xdef     _ERROR_incorrect_arg
		.xdef     _ERROR_divide_by_zero
		.xdef     _ERROR_square
		.xdef     _ERROR_few_arguments
		.xdef     _ERROR_too_arguments
		.xdef     _ERROR_tbl_incorrect_number_index
		.xdef     _ERROR_tbl_incorrect_index
		.xdef     _ERROR_defined_vartable
		.xdef     _ERROR_tbl_zerodim
		.xdef     _ERROR_no_enough_memory
		.xdef     _ERROR_log
		.xdef     _ERROR_out_of_data
		.xdef     _ERROR_sprite_length_wrong
		.xdef     _ERROR_syntax
		.xdef     _ERROR_local_vars_stack_overflow
		.xdef     _ERROR_few_parameter
		.xdef     _ERROR_too_parameter
		
		.xdef     _ERROR_end
		.xdef     _TokensExec_end
		
		|Fonctions
		.xdef     TokensExec_exit
		.xdef     TokensExec_Run
		
		.xdef     TokensExec_AddValue_Float
		.xdef     TokensExec_AddValue_Integer
		.xdef     TokensExec_AddValue_Bool
		.xdef     TokensExec_AddValue_String
		
		.xdef     TokensExec_Type_Float_To_Integer
		.xdef     TokensExec_Type_Float_To_Bool
		.xdef     TokensExec_Type_Integer_To_Float
		.xdef     TokensExec_Type_Integer_To_Bool
		.xdef     TokensExec_Type_Bool_To_Float
		.xdef     TokensExec_Type_Bool_To_Integer
		
		.xdef     TokensExec_ConvertType
		.xdef     TokensExec_ConvertOneType
		.xdef     TokensExec_ConvertTwoType
		|.xdef     TokensExec_PriorityType
		
		.xdef     TokensExec_AddResult2_Float
		.xdef     TokensExec_AddResult2_Integer
		.xdef     TokensExec_AddResult2_Bool
		.xdef     TokensExec_AddResult2_String
		
		.xdef     TokensExec_AddResult_Float
		.xdef     TokensExec_AddResult_Integer
		.xdef     TokensExec_AddResult_Bool
		.xdef     TokensExec_AddResult_String
		
		.xdef     TokensExec_AddResult_NoDel_Float
		.xdef     TokensExec_AddResult_NoDel_Integer
		.xdef     TokensExec_AddResult_NoDel_Bool
		.xdef     TokensExec_AddResult_NoDel_String
		
		.xdef     TokensExec_AddResult_Func_Float
		.xdef     TokensExec_AddResult_Func_Integer
		.xdef     TokensExec_AddResult_Func_Bool
		.xdef     TokensExec_AddResult_Func_String
		|.xdef     TokensExec_AddResult_Func_CurrentData
		
		.xdef     TokensExec_MathType_Next
		.xdef     TokensExec_MathType2_Next
		.xdef     TokensExec_EndFunc
		
		.xdef     TokensExec_CheckTableVar
		.xdef     TokensExec_CNumArg
		
		.xdef     TokensExec_NumArg
		.xdef     TokensExec_CheckArg
		
		.xdef     TokensExec_EndTokenCmd
		.xdef     TokensExec_EndTokenCmd2
		
		.xdef     TokensExec_ConvertType_For
		.xdef     TokensExec_For_if
		
		.xdef     TokensExec_AddVarTable
		.xdef     TokensExec_TotalDimVarTable
		
		.xdef     TokensExec_InitEmptyString
		|.xdef     TokensExec_CopyString
		.xdef     TokensExec_DeleteSimpleString
		.xdef     TokensExec_DeleteString
		.xdef     TokensExec_DeleteTabString
		.xdef     TokensExec_NewString
		.xdef     TokensExec_NewString_Gosub
		
		
|*************************************************************************
|Gestion des erreurs
|*************************************************************************
_ERROR_undef_vartable:
		move.w    #ERROR_UNDEF_VARTABLE,%d7
		jbra      _ERROR_end
		
_ERROR_empty_vartable:
		move.w    #ERROR_EMPTY_VARTABLE,%d7
		jbra      _ERROR_end
		
_ERROR_types_incompatible:
		move.w    #ERROR_TYPES_INCOMPATIBLE,%d7
		jbra      _ERROR_end

_ERROR_incorrect_arg:
		move.w    #ERROR_INCORRECT_ARG,%d7
		jbra      _ERROR_end
		
_ERROR_divide_by_zero:
		move.w    #ERROR_DIVIDE_BY_ZERO,%d7
		jbra      _ERROR_end
		
_ERROR_square:
		move.w    #ERROR_SQUARE,%d7
		jbra      _ERROR_end	
		
_ERROR_few_arguments:
		move.w    #ERROR_FEW_ARGUMENTS,%d7
		jbra      _ERROR_end
		
_ERROR_too_arguments:
		move.w    #ERROR_TOO_ARGUMENTS,%d7
		jbra      _ERROR_end
		
_ERROR_tbl_incorrect_number_index:
		move.w    #ERROR_TBL_INCORRECT_NUMBER_INDEX,%d7
		jbra      _ERROR_end
		
_ERROR_tbl_incorrect_index:
		move.w    #ERROR_TBL_INCORRECT_INDEX,%d7
		jbra      _ERROR_end

_ERROR_defined_vartable:
		move.w    #ERROR_DEFINED_VARTABLE,%d7
		jbra      _ERROR_end
		
_ERROR_tbl_zerodim:
		move.w    #ERROR_TBL_ZERODIM,%d7
		jbra      _ERROR_end
		
_ERROR_no_enough_memory:
		move.w    #ERROR_NO_ENOUGH_MEMORY,%d7
		jbra      _ERROR_end

_ERROR_log:
		move.w    #ERROR_LOG,%d7
		jbra      _ERROR_end
		
_ERROR_out_of_data:
		move.w    #ERROR_OUT_OF_DATA,%d7
		jbra      _ERROR_end

_ERROR_sprite_length_wrong:
		move.w    #ERROR_SPRITE_LENGTH_WRONG,%d7
		jbra      _ERROR_end
		
_ERROR_syntax:
		move.w    #ERROR_SYNTAX,%d7
		jbra      _ERROR_end
		
_ERROR_local_vars_stack_overflow:
		move.w    #ERROR_LOCAL_VARS_STACK_OVERFLOW,%d7
		jbra      _ERROR_end
		
_ERROR_few_parameter:
		move.w    #ERROR_FEW_PARAMETER,%d7
		jbra      _ERROR_end
		
_ERROR_too_parameter:
		move.w    #ERROR_TOO_PARAMETER,%d7
		jbra      _ERROR_end

_TokensExec_end:
		clr.w    %d7					|Efface %d7 (error_number)
_ERROR_end:
		movea.l   __SAVE_USP__,%SP			|Change pointeur pile %SP
		jbra      exit_program
		
TokensExec_exit:
		rts
						
|=========================================================================
|TokensExec_Run
|-------------------------------------------------------------------------
|Boucle d'excution des tokens
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: ...
|=========================================================================
TokensExec_Run:
 		moveq.l   #1,%d0
 		lea.l     error_line,%a0
 		move.w    %d0,(%a0)
 		movea.l   ptrEnd_ES,%a5					|%a5 = Pile ES
 		
_Run_loop:
 		lea.l     TokensFile_DataPtr,%a1			|Pointeur d'avancement de lecture des donnes
 		movea.l   (%a1),%a0
 		|cmpa.l    TokensFile_DataMaxAdr,%a0			|Dpassement donnes
 		|jbge      _Run_EndLoop
 		addq.l    #1,(%a1)					|Avance de 1 octet le pointeur de lecture des donnes
 		moveq.l   #0,%d0					|Vide registre
 		move.b    (%a0),%d0					|Lecture TOKEN
 		lsl.w     #2,%d0					|Multiplie par 4
 		lea.l     Tbl_Tokens,%a0				|Charge la table dans a0
 		move.l    (%a0,%d0.w),%a0
 		jbsr      (%a0) 					|Execute routine
		jbra	  _Run_loop
|_Run_EndLoop:		
|		rts


|=========================================================================
|TokensExec_AddValue_Float
|-------------------------------------------------------------------------
|Ajoute un flottant
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 - dc.l %d1 - dc.w %d2 = Flottant
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy: %a0
|=========================================================================
TokensExec_AddValue_Float:
		movea.l   %a2,%a0					|Permet de ne pas effacer %a2
		move.b    #OPRD_RESULT,(%a0)+				|Change oprande
		move.b    #TYPE_FLOAT,(%a0)+				|Change type
		addq.l    #2,%a0					|Saute les octets d'infos supplmentaires
		move.l    DTO,(%a0)					|Adresse du rsultat
		movea.l   DTO,%a0					|Ce place  la zone qui contiendra le rsultat
		move.l    %d0,(%a0)+					|Empile 4 octets dbut flottant
		move.l    %d1,(%a0)+					|Empile 4 octets suivant flottant
		move.w    %d2,(%a0)+					|Empile 2 octets fin flottant
		lea.l     DTO,%a1					|Modifie offset DTO
		move.l    %a0,(%a1)					
		rts


|=========================================================================
|TokensExec_AddValue_Integer
|-------------------------------------------------------------------------
|Ajoute un entier
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Entier
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy: %a0
|=========================================================================
TokensExec_AddValue_Integer:
		movea.l   %a2,%a0					|Permet de ne pas effacer %a2
		move.b    #OPRD_RESULT,(%a0)+				|Change oprande
		move.b    #TYPE_INTEGER,(%a0)+				|Change type
		addq.l    #2,%a0					|Saute les octets d'infos supplmentaires
		move.l    DTO,(%a0)					|Adresse du rsultat
		movea.l   DTO,%a0					|Ce place  la zone qui contiendra le rsultat
		move.l    %d0,(%a0)+					|Empile entier
		lea.l     DTO,%a1					|Modifie offset DTO
		move.l    %a0,(%a1)					|Modifie offset DTO
		rts


|=========================================================================
|TokensExec_AddValue_Bool
|-------------------------------------------------------------------------
|Ajoute un boolen
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Boolean
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy: %a2
|=========================================================================
TokensExec_AddValue_Bool:
		movea.l   %a2,%a0					|Permet de ne pas effacer %a2
		move.b    #OPRD_RESULT,(%a0)+				|Change oprande
		move.b    #TYPE_BOOL,(%a0)+				|Change type
		addq.l    #2,%a0					|Saute les octets d'infos supplmentaires
		move.l    DTO,(%a0)					|Adresse du rsultat
		movea.l   DTO,%a0					|Ce place  la zone qui contiendra le rsultat
		move.b    %d0,(%a0)+					|Empile entier
		addq.l    #1,%a0					|Ce place  une adresse paire
		lea.l     DTO,%a1					|Modifie offset DTO
		move.l    %a0,(%a1)
		rts


|=========================================================================
|TokensExec_AddValue_String
|-------------------------------------------------------------------------
|Ajoute une chane de caractres
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Taille de la chane de caractres
|  dc.l %a2 = Zone pile ES
|
|output:
|  dc.l %a0 = Zone chane de caractre
|
|destroy: %a2
|=========================================================================
TokensExec_AddValue_String:
		movea.l   %a2,%a0					|Permet de ne pas effacer %a2
		move.b    #OPRD_RESULT,(%a0)+				|Change oprande
		move.b    #TYPE_STRING,(%a0)+				|Change type
		move.w    %d0,(%a0)+					|Taille de la chane
		lea.l     DTO,%a3					|Pointeur DTO
		move.l    (%a3),%a1					|DTO dans %a1
		move.l    %a1,(%a0)					|Adresse du rsultat
		movea.l   %a1,%a0					|Pointeur dbut zone chane de caractres
/*pb si>32ko*/	adda.w    %d0,%a1 |lea.l     (%d0.w,%a1),%a1		|Avance de %d0 DTO
		clr.b     (%a1)+					|Caractre NULL
		btst.b    #0,%d0					|Parit de l'adresse					
		jbne      _TokensExec_AddValue_String_next		|Si paire
		clr.b     (%a1)+					|Caractre NULL, adresse paire
_TokensExec_AddValue_String_next:
		move.l    %a1,(%a3)					|Change pointeur DTO
		rts


|=========================================================================
|TokensExec_Type_Float_To_Integer
|-------------------------------------------------------------------------
|Convertie un flottant en entier
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 - dc.l %d1 - dc.w %d2 = Flottant
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy:
|=========================================================================
TokensExec_Type_Float_To_Integer:
		pea.l     (%a4)						|Sauvegarde %a4				
		movea.l   4(%a2),%a0					|Va  l'adresse o se trouve le flottant
		move.w    8(%a0),-(%SP)					|Empile fin flottant
		move.l    4(%a0),-(%SP)					|Empile milieu flottant
		move.l    (%a0),-(%SP)					|Empile dbut flottant
		ROM_CALL  trunc
		lea.l     4+4+2(%SP),%SP
		move.l    (%SP)+,%a4					|Restaure %a4
		jbra      TokensExec_AddValue_Integer			|Enregistre valeur
		
	
|=========================================================================
|TokensExec_Type_Float_To_Bool
|-------------------------------------------------------------------------
|Convertie un flottant en boolen
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 - dc.l %d1 - dc.w %d2 = Flottant
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy:
|=========================================================================
TokensExec_Type_Float_To_Bool:
		pea.l     (%a4)						|Sauvegarde %a4
		move.w    #0x4000,-(%SP)				|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)	
		movea.l   4(%a2),%a0					|Va  l'adresse o se trouve le flottant
		move.w    8(%a0),-(%SP)					|Empile fin flottant
		move.l    4(%a0),-(%SP)					|Empile milieu flottant
		move.l    (%a0),-(%SP)					|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		move.l    (%SP)+,%a4					|Restaure %a4
		tst.l     %d0						|Si %d0 diffrent de 0
		sne       %d0						|Remplie %d0 de 1 Flag Z
		jbra      TokensExec_AddValue_Bool			|Enregistre valeur
		

|=========================================================================
|TokensExec_Type_Integer_To_Float
|-------------------------------------------------------------------------
|Convertie un entier en flottant
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Entier
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy:
|=========================================================================
TokensExec_Type_Integer_To_Float:
		movea.l   4(%a2),%a0					|Va  l'adresse o se trouve l'entier
		move.l    (%a0),-(%SP)
		move.w    #flt*4,-(%SP)					|Wrapper
		jbsr      __BC
		addq.l    #2+4,%SP
		jbra      TokensExec_AddValue_Float			|Enregistre valeur
		
		
|=========================================================================
|TokensExec_Type_Integer_To_Bool
|-------------------------------------------------------------------------
|Convertie un entier en boolen
|-------------------------------------------------------------------------
|input:
|  dc.l %d0 = Entier
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy:
|=========================================================================
TokensExec_Type_Integer_To_Bool:
		movea.l   4(%a2),%a0					|Va  l'adresse o se trouve l'entier
		tst.l     (%a0)						|Si donnes -1 sinon 0
		sne       %d0
		jbra      TokensExec_AddValue_Bool			|Enregistre valeur
			
		
|=========================================================================
|TokensExec_Type_Bool_To_Float
|-------------------------------------------------------------------------
|Convertie un boolen en flottant
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Boolen
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy:
|=========================================================================
_TokensExec_Type_Bool_To_Float_zero:
		move.l    #0x40000000,%d0				|Flottant = 0.
		jbra      TokensExec_AddValue_Float			|Enregistre valeur

TokensExec_Type_Bool_To_Float:
		movea.l   4(%a2),%a0					|Va  l'adresse o se trouve le boolen
		moveq.l   #0,%d1
		moveq.l   #0,%d2
		tst.b     (%a0)						|Bool = 0?
		jbeq	  _TokensExec_Type_Bool_To_Float_zero 
		move.l    #0xC0001000,%d0				|Flottant = -1.		
		jbra      TokensExec_AddValue_Float			|Enregistre valeur
		
		
|=========================================================================
|TokensExec_Type_Bool_To_Integer
|-------------------------------------------------------------------------
|Convertie un boolen en entier
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Boolen
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy:
|=========================================================================
_TokensExec_Type_Bool_To_Integer_true:
		moveq.l   #-1,%d0
		jbra      TokensExec_AddValue_Integer			|Enregistre valeur

TokensExec_Type_Bool_To_Integer:
		movea.l   4(%a2),%a0					|Va  l'adresse o se trouve le boolen
		tst.b     (%a0)						|Bool = 0?	
		jbne      _TokensExec_Type_Bool_To_Integer_true
		moveq.l   #0,%d0
		jbra      TokensExec_AddValue_Integer			|Enregistre valeur


|=========================================================================
|TokensExec_ConvertType
|-------------------------------------------------------------------------
|Conversion de type (type src en type dest)
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Type source
|  dc.b %d1 = Type destination
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy: %a2 conserved
|=========================================================================
_TokensExec_ConvertType_Float_To:
		subq.b    #TYPE_INTEGER,%d1				|Integer
		jbeq      TokensExec_Type_Float_To_Integer
		jbra	  TokensExec_Type_Float_To_Bool

_TokensExec_ConvertType_Integer_To:
		subq.b    #TYPE_FLOAT,%d1				|Float
		jbeq      TokensExec_Type_Integer_To_Float
		jbra	  TokensExec_Type_Integer_To_Bool		
	
TokensExec_ConvertType:
		|Gestion des erreurs
		move.b    (%a2),%d2					|Oprande 
		
		subq.b    #OPRD_UNDEF_VARTABLE,%d2			
		jbeq      _ERROR_undef_vartable				|Tableau indfini
		subq.b    #1,%d2
		jbeq      _ERROR_empty_vartable				|Tableau sans indices
		
		|Type1=Type2?
		cmp.b     %d0,%d1
		jbeq      _TokensExec_ConvertType_exit
		
		|Types incompatibles?
		cmpi.b    #TYPE_STRING,%d0
		jbeq      _ERROR_types_incompatible
		cmpi.b    #TYPE_STRING,%d1
		jbeq      _ERROR_types_incompatible  
		
		|Conversion
		subq.b    #TYPE_INTEGER,%d0				|Integer
		jbeq      _TokensExec_ConvertType_Integer_To
		jbcs      _TokensExec_ConvertType_Float_To		|Float

_TokensExec_ConvertType_Bool_To:
		subq.b    #TYPE_FLOAT,%d1				|Float
		jbeq      TokensExec_Type_Bool_To_Float
		jbra	  TokensExec_Type_Bool_To_Integer
		
_TokensExec_ConvertType_exit:
		rts
		
		
|=========================================================================
|TokensExec_ConvertOneType
|-------------------------------------------------------------------------
|Conversion d'un type suivant des restrictions
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Flottant?
|  dc.b %d1 = Entier?
|  dc.b %d2 = Boolean?
|  dc.b %d3 = String?
|  dc.b %d4 = Type optimis
|  dc.l %a2 = Zone pile ES
|
|output:
|
|destroy: %a2 conserved
|=========================================================================
_TokensExec_ConvertOneType_convert:
		move.b    %d5,%d0					|Type
		move.b    %d4,%d1					|Type optimis
		jbra      TokensExec_ConvertType

TokensExec_ConvertOneType:
		|Chane de caractre avec autorisation?
		move.b    1(%a2),%d5					|Type
		move.b    %d5,%d6
		and.b     %d3,%d6					|Type & String
		subq.b    #TYPE_STRING,%d6				|Type==TYPE_STRING&&String==false				
		jbeq      _ERROR_types_incompatible
		
		|if ((type==TYPE_FLOAT && fnum==FALSE) || (type==TYPE_INT && integer==FALSE) || (type==TYPE_BOOL && boolean==FALSE))
		not.b     %d0
		and.b     %d5,%d0
		subq.b    #TYPE_FLOAT,%d0
		jbeq      _TokensExec_ConvertOneType_convert
		not.b     %d1
		and.b     %d5,%d1
		subq.b    #TYPE_INTEGER,%d1
		jbeq      _TokensExec_ConvertOneType_convert
		not.b     %d2
		and.b     %d5,%d2
		subq.b    #TYPE_BOOL,%d1
		jbeq      _TokensExec_ConvertOneType_convert
		
		|Gestion des erreurs
		move.b    (%a2),%d5					|Oprande
		subq.b    #OPRD_UNDEF_VARTABLE,%d5			|Tableau indfini
		jbeq      _ERROR_undef_vartable
		subq.b    #1,%d5					|Tableau sans indices
		jbeq	  _ERROR_empty_vartable
		rts
		

|=========================================================================
|TokensExec_ConvertTwoType
|-------------------------------------------------------------------------
|Conversion pour oprations mathmatiques, concordance des types
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Flottant?
|  dc.b %d1 = Entier?
|  dc.b %d2 = Boolean?
|  dc.b %d3 = String?
|  dc.b %d4 = Type optimis
|  dc.l %a2 = Zone pile ES number2
|  dc.l %a3 = Zone pile ES number1
|  dc.b %d7 = Change Ptr?
|
|output:
|
|destroy: %a3 conserved
|=========================================================================
_TokensExec_ConvertTwoType_type_string:
		tst.b     %d3						|Autorisation de chanes?
		jbeq      _ERROR_types_incompatible
		eor.b     %d5,%d6					|Si types diffrents
		jbne      _ERROR_types_incompatible
		rts							|Fin types chanes de caractres

_TokensExec_ConvertTwoType_convert1:
		|Type1=Type2
		move.b    %d5,%d3					|Sauvegarde type number2
		eor.b     %d6,%d3					|Mme type
		jbeq      _TokensExec_ConvertTwoType_exit

_TokensExec_ConvertTwoType_PriorityType:
		|if ((type1==TYPE_FLOAT) || (type1==TYPE_INT && type2==TYPE_BOOL)) return TRUE;
		|return FALSE;
		
		cmpi.b    #TYPE_FLOAT,%d6
		jbeq      _TokensExec_ConvertTwoType_PriorityType_true
		cmpi.b    #TYPE_INTEGER,%d6
		jbne      _TokensExec_ConvertTwoType_PriorityType_false
		cmpi.b    #TYPE_BOOL,%d5
		jbeq      _TokensExec_ConvertTwoType_PriorityType_true
		
_TokensExec_ConvertTwoType_PriorityType_false:
		moveq.l   #0,%d3
		jbra      _TokensExec_ConvertTwoType_PriorityType_end
		
_TokensExec_ConvertTwoType_PriorityType_true:
		moveq.l   #-1,%d3
		
_TokensExec_ConvertTwoType_PriorityType_end:
		|jbsr      TokensExec_PriorityType
		and.b     %d3,%d7
		jbne      _TokensExec_ConvertTwoType_next
		move.b    %d6,%d0					|Type number 1
		move.b    %d5,%d1					|Type number 2
		movea.l   %a3,%a2					|ptr 1
		jbra      TokensExec_ConvertType
			
_TokensExec_ConvertTwoType_convert2:
		move.b    %d5,%d0					|Type number 2
		move.b    %d6,%d1					|Type number 1
		jbra      TokensExec_ConvertType
		
TokensExec_ConvertTwoType:
		|Gestion des erreurs
		move.b    (%a2),%d5					|Oprande number2
		move.b    (%a3),%d6					|Oprande number1
		subq.b    #OPRD_UNDEF_VARTABLE,%d5
		jbeq      _ERROR_undef_vartable
		subq.b    #OPRD_UNDEF_VARTABLE,%d6
		jbeq      _ERROR_undef_vartable
		subq.b    #1,%d5
		jbeq      _ERROR_empty_vartable
		subq.b    #1,%d6
		jbeq      _ERROR_empty_vartable
		
		|Types incompatibles (chanes de caractres)
		move.b    1(%a2),%d5					|Type number2
		move.b    1(%a3),%d6					|Type number1
		cmpi.b    #TYPE_STRING,%d5
		jbeq      _TokensExec_ConvertTwoType_type_string
		cmpi.b    #TYPE_STRING,%d6
		jbeq      _TokensExec_ConvertTwoType_type_string
		
		|Nombre2 (Autoris) - Nombre1
		|if ((type2==TYPE_FLOAT && fnum) || (type2==TYPE_INT && integer) || (type2==TYPE_BOOL && boolean))
		|Flottant autoris?
		move.b    %d5,%d3
		and.b     %d0,%d3
		subq.b    #TYPE_FLOAT,%d3
		jbeq      _TokensExec_ConvertTwoType_convert1
		
		|Entier autoris?
		move.b    %d5,%d3
		and.b     %d1,%d3
		subq.b    #TYPE_INTEGER,%d3
		jbeq      _TokensExec_ConvertTwoType_convert1
		
		|Boolen autoris?
		move.b    %d5,%d3
		and.b     %d2,%d3
		subq.b    #TYPE_BOOL,%d3
		jbeq      _TokensExec_ConvertTwoType_convert1
		
_TokensExec_ConvertTwoType_next:		
		|Nombre2 (Non autoris) - Nombre1 (Autoris)
		|if ((type1==TYPE_FLOAT && fnum) || (type1==TYPE_INT && integer) || (type1==TYPE_BOOL && boolean))
		|Flottant autoris?
		move.b    %d6,%d3
		and.b     %d0,%d3
		subq.b    #TYPE_FLOAT,%d3
		jbeq      _TokensExec_ConvertTwoType_convert2
		
		|Entier autoris?
		move.b    %d6,%d3
		and.b     %d1,%d3
		subq.b    #TYPE_INTEGER,%d3
		jbeq      _TokensExec_ConvertTwoType_convert2
		
		|Boolen autoris?
		move.b    %d6,%d3
		and.b     %d2,%d3
		subq.b    #TYPE_BOOL,%d3
		jbeq      _TokensExec_ConvertTwoType_convert2
		
		move.b    %d5,%d0						|Type number 2
		move.b    %d4,%d1						|Type optimis
		jbsr	  TokensExec_ConvertType
		
		move.b    %d6,%d0						|Type number 1
		move.b    %d4,%d1						|Type optimis
		movea.l   %a3,%a2						|ptr 1
		jbra	  TokensExec_ConvertType
		
_TokensExec_ConvertTwoType_exit:
		rts


/*|=========================================================================
|TokensExec_PriorityType
|-------------------------------------------------------------------------
|Dominant:
|FALSE = Type2
|TRUE = Type1
|-------------------------------------------------------------------------
|input:
|  dc.b %d5 = Type number2
|  dc.b %d6 = Type number1
|
|output:
|  dc.l %d3 = Dominant?
|
|destroy:
|=========================================================================
TokensExec_PriorityType:
		|if ((type1==TYPE_FLOAT) || (type1==TYPE_INT && type2==TYPE_BOOL)) return TRUE;
		|return FALSE;
		
		cmpi.b    #TYPE_FLOAT,%d6
		jbeq      _TokensExec_PriorityType_true
		cmpi.b    #TYPE_INTEGER,%d6
		jbne      _TokensExec_PriorityType_false
		cmpi.b    #TYPE_BOOL,%d5
		jbeq      _TokensExec_PriorityType_true
		
_TokensExec_PriorityType_false:
		moveq.l   #0,%d3
		rts
		
_TokensExec_PriorityType_true:
		moveq.l   #-1,%d3
		rts*/


|=========================================================================
|TokensExec_AddResult2_xxx (Sans retour possible)
|-------------------------------------------------------------------------
|Ajoute un rsultat aprs un calcul entre 2 nombres
|-------------------------------------------------------------------------
|input:
|  Donnes
|=========================================================================
TokensExec_AddResult2_Float:
		lea.l     12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Float
		
TokensExec_AddResult2_Integer:
		lea.l     12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Integer
		
TokensExec_AddResult2_Bool:
		lea.l     12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Bool
		
TokensExec_AddResult2_String:
		lea.l     12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_String
		
		
|=========================================================================
|TokensExec_AddResult_xxx (Sans retour possible)
|-------------------------------------------------------------------------
|Ajoute un rsultat aprs un calcul avec 1 nombre
|-------------------------------------------------------------------------
|input:
|  Donnes
|=========================================================================
TokensExec_AddResult_Float:
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Float
		
TokensExec_AddResult_Integer:
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Integer
		
TokensExec_AddResult_Bool:
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Bool
		
TokensExec_AddResult_String:
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_String
		
|=========================================================================
|TokensExec_AddResult_NoDel_xxx (Sans retour possible)
|-------------------------------------------------------------------------
|Ajoute un rsultat
|-------------------------------------------------------------------------
|input:
|  Donnes
|=========================================================================
TokensExec_AddResult_NoDel_Float:
		lea.l     -12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Float
		
TokensExec_AddResult_NoDel_Integer:
		lea.l     -12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Integer
		
TokensExec_AddResult_NoDel_Bool:
		lea.l     -12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Bool
		
TokensExec_AddResult_NoDel_String:
		lea.l     -12(%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_String
		

|=========================================================================
|TokensExec_AddResult_Func_xxx (Sans retour possible)
|-------------------------------------------------------------------------
|Ajoute un rsultat aprs un fonction
|-------------------------------------------------------------------------
|input:
|  Donnes
|  dc.w %d6 = Nombre d'arguments
|=========================================================================
TokensExec_AddResult_Func_Float:
		|Dplace la pile de rands de 12 octets
		move.w    %d6,%d5
		lsl.w     #3,%d6
		lsl.w     #2,%d5
		add.w     %d5,%d6
   		adda.w    %d6,%a5 |lea.l     (%d6.w,%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Float
		
TokensExec_AddResult_Func_Integer:
   		|Dplace la pile de rands de 12 octets
		move.w    %d6,%d5
		lsl.w     #3,%d6
		lsl.w     #2,%d5
		add.w     %d5,%d6
   		adda.w    %d6,%a5 |lea.l     (%d6.w,%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Integer
		
TokensExec_AddResult_Func_Bool:
		|Dplace la pile de rands de 12 octets
		move.w    %d6,%d5
		lsl.w     #3,%d6
		lsl.w     #2,%d5
		add.w     %d5,%d6
   		adda.w    %d6,%a5 |lea.l     (%d6.w,%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_Bool
		
TokensExec_AddResult_Func_String:
		|Dplace la pile de rands de 12 octets
		move.w    %d6,%d5
		lsl.w     #3,%d6
		lsl.w     #2,%d5
		add.w     %d5,%d6
   		adda.w    %d6,%a5 |lea.l     (%d6.w,%a5),%a5
		movea.l   %a5,%a2
		jbra	  TokensExec_AddValue_String
		
/*TokensExec_AddResult_Func_CurrentData:
		move.l    (%a5)+,12-4(%a5)
		move.l    (%a5)+,12-4(%a5)
		move.l    (%a5)+,12-4(%a5)
		rts*/
		

|=========================================================================
|Gestion des macros
|-------------------------------------------------------------------------
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: 
|=========================================================================
TokensExec_MathType_Next:
   		moveq.l   #-1,%d7
   		lea.l     12(%a5),%a2
   		movea.l   %a5,%a3
   		jbra      TokensExec_ConvertTwoType
   		
TokensExec_MathType2_Next:
   		moveq.l   #0,%d7
   		lea.l     12(%a5),%a2
   		movea.l   %a5,%a3
   		jbra      TokensExec_ConvertTwoType
   
TokensExec_EndFunc:
   		addq.l    #1,%d6
   		move.w    %d6,%d5
   		lsl.w     #3,%d6
   		lsl.w     #2,%d5
   		add.w     %d5,%d6
   		adda.w    %d6,%a5 |lea.l     (%d6.w,%a5),%a5
		rts
		
		
|=========================================================================
|TokensExec_CheckTableVar
|-------------------------------------------------------------------------
|Gestion erreur pour les tableaux
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Operande
|
|output:
|
|destroy: 
|=========================================================================
TokensExec_CheckTableVar:
		cmpi.b    #OPRD_UNDEF_VARTABLE,%d0
		jbeq      _ERROR_undef_vartable
		cmpi.b    #OPRD_EMPTY_VARTABLE,%d0
		jbeq      _ERROR_empty_vartable
		rts
		
		
|=========================================================================
|TokensExec_CNumArg
|-------------------------------------------------------------------------
|Nombre d'argument tokens de commandes
|-------------------------------------------------------------------------
|input:
|  dc.b %a5 = Point sur le dernier argument
|
|output:
|  dc.l %d6 = Nombre d'argument
|
|destroy: 
|=========================================================================
TokensExec_CNumArg:
		move.l    ptrEnd_ES,%d6						|Adresse de fin pile ES dans %d0
		sub.l     %a5,%d6						|Adresse %a5 - %d0
		divu.w    #12,%d6						|Divise par 12 le rsultat
		rts
		
		
|=========================================================================
|TokensExec_NumArg
|-------------------------------------------------------------------------
|Nombre d'argument tokens de fonctions
|-------------------------------------------------------------------------
|input:
|  dc.b %a5 = Point sur le dernier argument
|
|output:
|  dc.l %d6 = Nombre d'argument
|
|destroy: 
|=========================================================================		
TokensExec_NumArg:
		moveq.l   #-1,%d6
		lea.l     -12(%a5),%a0
_TokensExec_NumArg_loop:
		lea.l     12(%a0),%a0
		addq.w    #1,%d6
		cmpi.b    #OPRD_ENDTAG,(%a0)
		jbne      _TokensExec_NumArg_loop		
		rts
		
		
|=========================================================================
|TokensExec_CheckArg
|-------------------------------------------------------------------------
|Nombre d'argument tokens de fonctions
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre d'arguments
|  dc.w %d6 = Nombre d'arguments pile
|
|output:
|
|destroy: 
|=========================================================================		
TokensExec_CheckArg:
		cmp.w     %d0,%d6
		jblt      _ERROR_few_arguments
		cmp.w     %d0,%d6
		jbgt      _ERROR_too_arguments
		rts


|=========================================================================
|TokensExec_EndTokenCmd
|-------------------------------------------------------------------------
|Fin d'un token de command
|-------------------------------------------------------------------------
|input:
|  
|output:
|
|destroy: 
|=========================================================================		
TokensExec_EndTokenCmd:		
		lea.l     TokensFile_DataPtr,%a2		|Adresse de la donnes en cours
		move.l    (%a2),%a0		
		lea.l     error_line,%a1			|Rcupre numro de ligne
		move.b    (%a0)+,(%a1)+				
		move.b    (%a0),(%a1)
		addq.l    #2,(%a2)				|Ajoute 2 pour token suivant
TokensExec_EndTokenCmd2:		
		MACRO_ClearStacks			
		rts

|=========================================================================
|TokensExec_ConvertType_For
|-------------------------------------------------------------------------
|Conversion de type pour la structure For
|-------------------------------------------------------------------------
|input:
|  dc.b %d0 = Type variable
|  dc.l %a2 = Zone d'criture
|  
|output:
|
|destroy:
|=========================================================================		
_TokensExec_ConvertType_For_convert:
		subq.b    #TYPE_INTEGER,%d1
		jbeq      _TokensExec_ConvertType_For_convert_integer_to_float
		jbra      _TokensExec_ConvertType_For_convert_float_to_integer

_TokensExec_ConvertType_For_convert_integer_to_float:
		move.l    (%a0),-(%SP)
		move.w    #flt*4,-(%SP)				|Wrapper
		jbsr      __BC
		addq.l    #2+4,%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)+				|Empile 2 octets fin flottant
		rts
		
_TokensExec_ConvertType_For_convert_float_to_integer:
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  trunc
		lea.l     4+4+2(%SP),%SP		
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		addq.l    #10-4,%a2		
		rts
		
_TokensExec_ConvertType_For_copy_integer:
		move.l    (%a0),(%a2)+
		addq.l    #10-4,%a2
		rts

TokensExec_ConvertType_For:
		|Vrification oprande
		move.b    (%a5),%d1				|Oprande number
		subq.b    #OPRD_UNDEF_VARTABLE,%d1		|Tableau indfini
		jbeq      _ERROR_undef_vartable
		subq.b    #1,%d1				|Tableau sans indices
		jbeq	  _ERROR_empty_vartable
		
		|Types incompatibles
		move.b    1(%a5),%d1				|Type number
		cmpi.b    #TYPE_BOOL,%d1
		jbeq      _ERROR_types_incompatible
		cmpi.b    #TYPE_STRING,%d1
		jbeq      _ERROR_types_incompatible
		
		movea.l   4(%a5),%a0				|Number dans %a0
		
		|Conversion si necessaire
		cmp.b     %d0,%d1
		jbne      _TokensExec_ConvertType_For_convert
		
		|Copie number
		subq.b    #TYPE_INTEGER,%d1
		jbeq      _TokensExec_ConvertType_For_copy_integer
_TokensExec_ConvertType_For_copy_float:
		move.l    (%a0)+,(%a2)+
		move.l    (%a0)+,(%a2)+
		move.w    (%a0),(%a2)+
		rts


|=========================================================================
|TokensExec_For_if
|-------------------------------------------------------------------------
|Condition If pour le FOR
|-------------------------------------------------------------------------
|input:
|  dc.l %a2 = Zone ptrFOR
|  
|output:
|  dc.w %d7: Rsultat condition 
|
|destroy: 
|=========================================================================
_TokensExec_For_if_exit:					|Condition respecte
		moveq.l   #-1,%d7
		rts

_TokensExec_For_if_integer:
		move.l    (%a1),%d0				|Donne comparaison dans %d0
		tst.b     %d3					|Infrieur ou gal
		jbeq      _TokensExec_For_if_integer_infegal
		cmp.l     (%a0),%d0				|Suprieur ou gal
		jbgt	  _TokensExec_For_if_exit
		rts
		
_TokensExec_For_if_integer_infegal:		
		cmp.l     (%a0),%d0				|Suprieur ou gal
		jblt	  _TokensExec_For_if_exit
		rts
		
_TokensExec_For_if_float_infegal:
		tst.l     %d0
		jblt	  _TokensExec_For_if_exit
		rts
				
TokensExec_For_if:
		moveq.l   #0,%d7
		move.b    -26(%a2),%d0				|Type variable
		move.b    -25(%a2),%d3				|Type comparaison
		movea.l   -24(%a2),%a0				|Donne variable
		lea.l     -20(%a2),%a1				|Donne de comparaison
		
		subq.b    #TYPE_INTEGER,%d0			|Comparaison entre entiers
		jbeq      _TokensExec_For_if_integer
		
		|Comparaison entre flottants
_TokensExec_For_if_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     20(%SP),%SP		
		tst.b     %d3					|Infrieur ou gal
		jbne      _TokensExec_For_if_float_infegal
		tst.l     %d0
		jbgt	  _TokensExec_For_if_exit
		rts
			
				
|=========================================================================
|TokensExec_AddVarTable
|-------------------------------------------------------------------------
|Ajoute une variable de type tableau
|-------------------------------------------------------------------------
|input:
|  dc.l %a4 = Pointeur descripteur
|  dc.b %d4 = Type
|  dc.w %d5 = Blocksize
|  
|output:
|
|destroy: 
|=========================================================================
|Pas d'arguments
_TokensExec_AddVarTable_noarg:
		tst.w     %d0					|N dim
		jbeq      _TokensExec_AddVarTable_nodim
|Tableau dfini sans arguments
_TokensExec_AddVarTable_noarg_dim:
		jbsr      TokensExec_EndFunc
		lea.l     -12(%a5),%a5				|Nouvelle donne
		move.b    #OPRD_EMPTY_VARTABLE,(%a5)		|Oprande
		move.b    %d4,1(%a5)				|Type
		move.w    4(%a4),%d0				|Nombre de dimensions
		add.w     %d0,%d0				|Multiplie par 2 %d0
		movea.l   (%a4),%a0
		adda.w    %d0,%a0
		move.l    %a0,4(%a5)				|Adresse dbut donnes tableau
	        move.l    %a4,8(%a5)				|Adr base (descripteur)
	        rts   

|Table non dfini				
_TokensExec_AddVarTable_nodim:
		move.l    DTO,%a3				|Pile temporaire de donnes DT
		move.w    %d6,%d3				|Nombre de rptition
		dbf       %d6,_TokensExec_AddVarTable_nodim_loop
		jbra      _TokensExec_AddVarTable_nodim_loop_end
_TokensExec_AddVarTable_nodim_loop:
		|Conversion number
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		|Copie arguments dans la pile DT
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d0
		addq.l    #1,%d0				|Dbute  l'index 0 - n-1
		move.w    %d0,(%a3)+				|Copie argument dans pile temporaire DT
		lea.l     12(%a5),%a5				|Donnes suivante
		dbf       %d6,_TokensExec_AddVarTable_nodim_loop

_TokensExec_AddVarTable_nodim_loop_end:
		|Complte infos pile %a5
		move.b    #OPRD_UNDEF_VARTABLE,(%a5)		|Operande
		move.b    %d4,1(%a5)				|Type
		move.w    %d3,2(%a5)				|N dim
		move.l    DTO,4(%a5)				|Adresse des arguments
		move.l    %a4,8(%a5)				|Adr base
		lea.l     DTO,%a0				|Avance pile DT
		move.l    %a3,(%a0)
		rts		

|Table dfini avec arguments
_TokensExec_AddVarTable_defined:
		cmp.w     %d6,%d0				|narg!=ndim
		jbne      _ERROR_tbl_incorrect_number_index
		
		move.w    #1,-(%SP)				|Total dim
		clr.w     -(%SP)				|Ptr
		
		move.l    (%a4),%a3				|Va  l'adresse pointe par le descripteur
		moveq.l   #0,%d3				|Prpare boucle FOR
		move.w    %d6,%d3				|Nombre de rptition
		dbf       %d3,_TokensExec_AddVarTable_defined_loop
		jbra      _TokensExec_AddVarTable_defined_loop_end
_TokensExec_AddVarTable_defined_loop:
		|Conversion number
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d0
		move.w    (%a3)+,%d1
		cmp.w     %d1,%d0				|number>=dim
		jbge      _ERROR_tbl_incorrect_index
		
		|Premier argument
		move.w    %d6,%d2
		subq.w    #1,%d2
		cmp.w     %d3,%d2
		jbeq      _TokensExec_AddVarTable_defined_nofirstarg
		
		|total_dim *= dimension prcdente
		move.w    -4(%a3),%d1				
		move.w    2(%SP),%d2
		mulu.w    %d1,%d2
		move.w    %d2,2(%SP)
_TokensExec_AddVarTable_defined_nofirstarg:
		move.w    2(%SP),%d2				|total_dim
		mulu.w    %d0,%d2				|total_dim*arg_value
		move.w    (%SP),%d0				|ptr
		add.w     %d0,%d2				|ptr+%d2
		move.w    %d2,(%SP)				|%d2->ptr
		lea.l     12(%a5),%a5				|Donnes suivante
		dbf       %d3,_TokensExec_AddVarTable_defined_loop
		
_TokensExec_AddVarTable_defined_loop_end:
		|Avance pointeur
		move.w    (%SP),%d2				|ptr->%d2
		mulu.w    %d2,%d5				|ptr*blocksize
		lea.l     (%d5.w,%a3),%a3			|Avance de ptr
		addq.l    #4,%SP				|Restaure pile %SP
		
		|Chane de caractres
		cmpi.b    #TYPE_STRING,%d4
		jbeq      _TokensExec_AddVarTable_defined_loop_string

		|Complte infos pile %a5
_TokensExec_AddVarTable_defined_loop_next:
		move.b    #OPRD_VARTABLE,(%a5)			|Operande
		move.b    %d4,1(%a5)				|Type
		move.w    4(%a4),2(%a5)				|N dim
		move.l    %a3,4(%a5)				|Adresse donne
		move.l    %a4,8(%a5)				|Adr base
		rts
		
_TokensExec_AddVarTable_defined_loop_string:
		movea.l   %a3,%a4				|Descripteur
		move.l    (%a3),%d0
		jbne      _TokensExec_AddVarTable_defined_loop_string_not_NULL
		move.l    #EMPTY_STRING,%d0
_TokensExec_AddVarTable_defined_loop_string_not_NULL:		
		movea.l   %d0,%a3				|Donnes chane de caractres
		jbra      _TokensExec_AddVarTable_defined_loop_next		

TokensExec_AddVarTable:
		jbsr      TokensExec_NumArg			|Nombre d'arguments
		move.w    4(%a4),%d0				|Nombre de dimensions (0 = Non dfini)
		
		tst.w     %d6					|N arguments
		jbeq      _TokensExec_AddVarTable_noarg
		tst.w     %d0					|N dim
		jbeq      _TokensExec_AddVarTable_nodim
		jbra      _TokensExec_AddVarTable_defined


|=========================================================================
|TokensExec_TotalDimVarTable
|-------------------------------------------------------------------------
|Calcul le nombre d'lments d'un tableau
|-------------------------------------------------------------------------
|input:
|  dc.l %a2 = Zone pile ES
|  
|output: 
|  dc.l %d0 = Nombre total d'lments
|
|destroy: %a0, %d1
|=========================================================================		
TokensExec_TotalDimVarTable:
		moveq.l    #0,%d0				|Prpare %d0
		moveq.l    #0,%d1				|Prpare %d1 pour boucle de dimensions
		movea.l    8(%a2),%a0				|%a0 = Pointeur descripteur
		move.w     4(%a0),%d1				|%d1 = Nombre de dimensions
		movea.l    (%a0),%a0				|Zone lments
		subq.w     #1,%d1
_TokensExec_TotalDimVarTable_next:
		moveq.l    #1,%d0
_TokensExec_TotalDimVarTable_loop:				
		mulu.w    (%a0)+,%d0
		dbf        %d1,_TokensExec_TotalDimVarTable_loop
		rts
		
		
|=========================================================================
|TokensExec_InitEmptyString
|-------------------------------------------------------------------------
|Espace avec des chanes de caractres vides
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre de chanes de caractres
|  dc.l %a0 = Zone mmoire
|  
|output: 
|
|destroy: 
|=========================================================================
TokensExec_InitEmptyString:
		moveq.l   #0,%d1
		move.w    %d0,%d1
		|lea.l     EMPTY_STRING,%a1
		dbf       %d1,_TokensExec_InitEmptyString_loop
		rts
_TokensExec_InitEmptyString_loop:
		|move.l    %a1,(%a0)+
		clr.l     (%a0)+
		clr.w     (%a0)+
		dbf       %d1,_TokensExec_InitEmptyString_loop
		rts
		
		
|=========================================================================
|TokensExec_CopyString
|-------------------------------------------------------------------------
|Copie une chane de caractres 16 bits par 16 bits
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre d'octets  copier
|  dc.l %a0 = Zone mmoire source
|  dc.l %a1 = Zone mmoire destination
|  
|output: 
|
|destroy: 
|=========================================================================		
/*TokensExec_CopyString:
		jbsr       _memcpy
		clr.b      (%a1)
		rts*/


|=========================================================================
|TokensExec_DeleteSimpleString
|-------------------------------------------------------------------------
|Efface une chane de caractres.
|-------------------------------------------------------------------------
|input:
|  dc.l %a2 = Zone mmoire
|  
|output: 
|
|destroy: 
|=========================================================================
TokensExec_DeleteSimpleString:
		move.l    (%a2),%d1
		jbeq      _TokensExec_DeleteSimpleString_exit
		move.l    %d1,-(%SP)
		ROM_CALL  free
		addq.l    #4,%SP
		clr.l     (%a2)+
		clr.w     (%a2)
_TokensExec_DeleteSimpleString_exit:
		rts
		
		
|=========================================================================
|TokensExec_DeleteString
|-------------------------------------------------------------------------
|Efface une zone de descripteurs de chanes de caractres.
|-------------------------------------------------------------------------
|input:
|  dc.w %d3 = Nombre de descripteurs
|  dc.l %a3 = Zone mmoire
|  
|output: 
|
|destroy: 
|=========================================================================
TokensExec_DeleteString:
		moveq.l   #0,%d5
		move.w    %d3,%d5
		dbf       %d5,_TokensExec_DeleteString_loop
		rts
_TokensExec_DeleteString_loop:
		move.l    (%a3),%d0
		jbeq      _TokensExec_DeleteString_next
		move.l    %d0,-(%SP)
		ROM_CALL  free
		addq.l    #4,%SP
		clr.l     (%a3)+
		clr.w     (%a3)+		
		dbf       %d5,_TokensExec_DeleteString_loop		
		rts
		
_TokensExec_DeleteString_next:
		addq.l    #6,%a3
		dbf       %d5,_TokensExec_DeleteString_loop		
		rts
		
		
|=========================================================================
|TokensExec_DeleteTabString
|-------------------------------------------------------------------------
|Efface une zone de descripteurs d'un tableau
|-------------------------------------------------------------------------
|input:
|  dc.w %d0 = Nombre de dimensions
|  dc.l %a3 = Zone mmoire, dbut du tableau
|  
|output: 
|
|destroy: 
|=========================================================================
TokensExec_DeleteTabString:
	        moveq.l   #0,%d1
	        move.w    %d0,%d1
	        moveq.l   #1,%d3
	        subq.w    #1,%d1
_TokensExec_DeleteTabString_loop_dim:
		mulu.w    (%a3)+,%d3
		dbf       %d1,_TokensExec_DeleteTabString_loop_dim
	        jbra      TokensExec_DeleteString	        
		rts
		
		
|=========================================================================
|TokensExec_NewString
|-------------------------------------------------------------------------
|Crer une chane de caractre
|-------------------------------------------------------------------------
|input:
|  dc.w %d3 = Taille de la chane
|  dc.l %a2 = Zone pile ES
|  
|output: 
|  dc.l %a0 = Adresse zone chane de caractres
|
|destroy: 
|=========================================================================
TokensExec_NewString:	
		moveq.l   #0,%d0
		move.w    %d3,%d0
		jbeq      _TokensExec_NewString_empty		|Chane vide
		addq.l    #1,%d0				|Caractre NULL
		
		move.l    8(%a2),%a1				|Adresse descripteur
		movea.l   (%a1),%a0				|Adresse relle de la chane de caractres
		jbne      _TokensExec_NewString_reallocate
_TokensExec_NewString_allocate:
		move.l    %d0,-(%SP)
		ROM_CALL  malloc
		addq.l    #4,%SP
		jbra      _TokensExec_NewString_end_allocate
		
_TokensExec_NewString_reallocate:
		move.w    2(%a2),%d1
		addq.w    #1,%d1
		cmp.w     %d0,%d1
		jbcc      _TokensExec_NewString_end_allocate	|Evite une rallocation dans le cas o l'espace mmoire est suffisant! 7x plus rapide!
		jbsr      realloc
		
_TokensExec_NewString_end_allocate:
		move.l    %a0,%d1
		jbeq      _ERROR_no_enough_memory
		move.l    8(%a2),%a1				|Adresse descripteur
		move.l    %a0,(%a1)+				|Change adresse de la chane dans le descripteur
		move.w    %d3,(%a1)				|Change taille de la chane dans le descripteur
		move.w    %d3,2(%a2)				|Change taille dans la pile ES
		move.l    %a0,4(%a2)				|Change adresse dans la pile ES
		rts
		
_TokensExec_NewString_empty:
		move.l    8(%a2),%a0
		clr.l     (%a0)+
		clr.w     (%a0)
		clr.w     2(%a2)
		clr.l     4(%a2)
		rts
				

|=========================================================================
|TokensExec_NewString_Gosub
|-------------------------------------------------------------------------
|Crer une chane de caractre
|-------------------------------------------------------------------------
|input:
|  dc.w %d3 = Taille de la chane
|  dc.l %a2 = Zone descripteur
|  
|output: 
|  dc.l %a0 = Adresse zone chane de caractres
|
|destroy: 
|=========================================================================
TokensExec_NewString_Gosub:
		moveq.l   #0,%d0
		move.w    %d3,%d0
		addq.w    #1,%d0
		move.l    %d0,-(%SP)
		ROM_CALL  malloc
		addq.l    #4,%SP
		move.l    %a0,%d1
		jbeq      _ERROR_no_enough_memory
		
		move.l    %a0,(%a2)+				|Change adresse de la chane dans le descripteur
		move.w    %d3,(%a2)				|Change taille de la chane dans le descripteur
		rts
		
		.end
	