|===============================
|Tokens d'Excution de fonctions
|===============================
		.include  "os.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "TokensExec.h"
		.include  "GFATEM.h"

                .xdef     ExecFnc_At
                .xdef     ExecCmd_Print
                .xdef     ExecCmd_Dim
                .xdef     ExecCmd_Cls
                .xdef     ExecFnc_Getkey
                .xdef     ExecFnc_Abs
                .xdef     ExecCmd_Add
                .xdef     ExecFnc_Atn
                .xdef     ExecCmd_Clr
                .xdef     ExecFnc_Cos
                .xdef     ExecCmd_Dec
                .xdef     ExecCmd_Div
                .xdef     ExecFnc_Even
                .xdef     ExecFnc_Exp
                .xdef     ExecFnc_Fix
                .xdef     ExecFnc_Frac
                .xdef     ExecCmd_Inc
                .xdef     ExecFnc_Log
                .xdef     ExecFnc_Log10
                .xdef     ExecCmd_Mul
                .xdef     ExecFnc_Odd
                .xdef     ExecFnc_Sgn
                .xdef     ExecFnc_Sin
                .xdef     ExecFnc_Sqr
                .xdef     ExecFnc_Tan
                .xdef     ExecFnc_Round
                .xdef     ExecCmd_Sub
                .xdef     ExecFnc_Asc
                .xdef     ExecFnc_Bin
                .xdef     ExecFnc_Hex
                .xdef     ExecFnc_Oct
                .xdef     ExecFnc_Chr
                .xdef     ExecFnc_Left
                .xdef     ExecFnc_Len
                .xdef     ExecFnc_Mid
                .xdef     ExecFnc_Right
                .xdef     ExecFnc_Space
                .xdef     ExecFnc_Str
                .xdef     ExecFnc_String
                .xdef     ExecFnc_Upper
                .xdef     ExecFnc_Val
                .xdef     ExecFnc_Arrayfill
                .xdef     ExecFnc_Ldim
                .xdef     ExecCmd_End
                .xdef     ExecFnc_Fre
                .xdef     ExecCmd_Pause
                .xdef     ExecCmd_Swap
                .xdef     ExecFnc_Mki
                .xdef     ExecFnc_Mkl
                .xdef     ExecFnc_Mkf
                .xdef     ExecFnc_Cvi
                .xdef     ExecFnc_Cvl
                .xdef     ExecFnc_Cvf
                .xdef     ExecCmd_Setfont
                .xdef     ExecFnc_Getfont
                .xdef     ExecFnc_Lower
                .xdef     ExecCmd_Run
                .xdef     ExecFnc_Ngetchx
                .xdef     ExecFnc_Rnd
                .xdef     ExecFnc_Timer
                .xdef     ExecCmd_System
                .xdef     ExecFnc_Crslin
                .xdef     ExecFnc_Crscol
                .xdef     ExecFnc_Random
                .xdef     ExecFnc_Type
                .xdef     ExecFnc_Lval
                .xdef     ExecFnc_Varptr
                .xdef     ExecFnc_Arrptr
                .xdef     ExecFnc_Dfree
                .xdef     ExecFnc_Peek
                .xdef     ExecFnc_Dpeek
                .xdef     ExecFnc_Lpeek
                .xdef     ExecCmd_Poke
                .xdef     ExecCmd_Dpoke
                .xdef     ExecCmd_Lpoke
                .xdef     ExecCmd_Box
                .xdef     ExecCmd_Input
                .xdef     ExecCmd_Text
                .xdef     ExecCmd_Plot
                .xdef     ExecCmd_Line
                .xdef     ExecCmd_Read
                .xdef     ExecCmd_Sprite
                .xdef     ExecCmd_Get
                .xdef     ExecCmd_Put
                .xdef     ExecFnc_Point

_Exec_exit:
		rts

|==|
|AT|
|==|                
ExecFnc_At:
		MACRO_Func_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		MACRO_ConvertType 	#TYPE_INTEGER, 12
		
		|PARAM_PRINT_ATx = INT_num2-1;
		movea.l   16(%a5),%a0				|Number 2
		move.w    2(%a0),%d0
		subq.w    #1,%d0
		lea.l     PARAM_PRINT_ATx,%a0
		move.w    %d0,(%a0)
		
		|PARAM_PRINT_ATy = INT_num1-1;
		movea.l   4(%a5),%a0				|Number 1
		move.w    2(%a0),%d0
		subq.w    #1,%d0
		lea.l     PARAM_PRINT_ATy,%a0
		move.w    %d0,(%a0)
		
		|PARAM_PRINT_AT = TRUE;
		lea.l     PARAM_PRINT_AT,%a0
		move.w    #TRUE,(%a0)			
		
		|PARAM_PRINT_REAL_ATx = PARAM_PRINT_ATx*PARAM_FONT_DIVx;
		clr.w     %d0
		move.w    PARAM_FONT_DIVx,%d0
		move.w    PARAM_PRINT_ATx,%d1
		muls.w    %d1,%d0
		lea.l     PARAM_PRINT_REAL_ATx,%a0
		move.w    %d0,(%a0)
		
		|PARAM_PRINT_REAL_ATy = PARAM_PRINT_ATy*PARAM_FONT_DIVy;
		clr.w     %d0
		move.w    PARAM_FONT_DIVy,%d0
		move.w    PARAM_PRINT_ATy,%d1
		muls.w    %d1,%d0
		lea.l     PARAM_PRINT_REAL_ATy,%a0
		move.w    %d0,(%a0)
		
		jbra      TokensExec_EndFunc

|=====|
|PRINT|
|=====|
_ExecCmd_Print_integer:
		move.l    (%a0),-(%SP)
		pea.l     printf_ld
		jbsr      printf
		addq.l    #4+4,%SP
		jbra      _ExecCmd_Print_next_continue
		
_ExecCmd_Print_float:
		move.w    8(%a0),-(%SP)
		move.l    4(%a0),-(%SP)
		move.l    (%a0),-(%SP)
		pea.l     printf_f
		jbsr      printf
		lea.l     4+4+4+2(%SP),%SP
		jbra      _ExecCmd_Print_next_continue
		
_ExecCmd_Print_bool:
		move.b    (%a0),%d0				|Force le flottant  tre sur 16 Bits signs
		ext.w     %d0
		move.w    %d0,-(%SP)
		pea.l     printf_d
		jbsr      printf
		addq.l    #4+2,%SP
		jbra      _ExecCmd_Print_next_continue
		
_ExecCmd_Print_apost:
		pea.l     printf_space
		jbsr      printf
		addq.l    #4,%SP
		jbra      _ExecCmd_Print_continue
		
_ExecCmd_Print_eofline:
		pea.l     printf_eofline
		jbsr      printf
		addq.l    #4,%SP
		jbra      _ExecCmd_Print_continue

_ExecCmd_Print_ParamAT:
		lea.l     PARAM_PRINT_AT,%a0		|Place curseur de texte aux coordonnes spcifies par AT
		clr.w     (%a0)			
		move.w    PARAM_PRINT_REAL_ATy,-(%SP)
		move.w    PARAM_PRINT_REAL_ATx,-(%SP)
		ROM_CALL  MoveTo
		addq.l    #2+2,%SP
		jbra      _ExecCmd_Print_continue_in_start

ExecCmd_Print:
		jbsr      TokensExec_CNumArg
		
		tst.w     PARAM_PRINT_AT		|Vrifie si la commande AT a t appelle soit PRINT AT...	
		jbne      _ExecCmd_Print_ParamAT
_ExecCmd_Print_continue_in_start:		
		movea.l   ptrEnd_ES,%a5			|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		dbf       %d6,_ExecCmd_Print_loop
_ExecCmd_Print_eofline2:		
		pea.l     printf_eofline
		jsr       printf
		addq.l    #4,%SP
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Print_loop:
		move.b    (%a5),%d0				|Oprande		
		move.b    1(%a5),%d1				|Type
		jbsr      TokensExec_CheckTableVar
		
		subq.b    #OPRD_POINT_VIRGULE,%d0		|Continue pour point virgule
		jbeq      _ExecCmd_Print_continue
		subq.b    #1,%d0				|OPRD_APOST
		jbeq      _ExecCmd_Print_apost
		
		|Affichage donnes
		movea.l   4(%a5),%a0				|Donnes
		
		subq.b    #TYPE_INTEGER,%d1
		jbeq      _ExecCmd_Print_integer
		jbcs      _ExecCmd_Print_float
		subq.b    #1,%d1				|TYPE_BOOL
		jbeq      _ExecCmd_Print_bool
_ExecCmd_Print_string:
		pea.l     (%a0)
		pea.l     printf_s
		jbsr      printf
		addq.l    #4+4,%SP
		jbra      _ExecCmd_Print_next_continue

_ExecCmd_Print_next_continue:
		|Saut de ligne
		tst.l     %d6
		jbeq      _ExecCmd_Print_eofline2
		move.b    -12(%a5),%d0				|Oprande suivante
		subq.b    #OPRD_POINT_VIRGULE,%d0
		jbeq      _ExecCmd_Print_continue
		subq.b    #1,%d0				|OPRD_APOST
		jbne      _ExecCmd_Print_eofline
		    
_ExecCmd_Print_continue:
		lea.l     -12(%a5),%a5				|Donnes suivante
		dbf       %d6,_ExecCmd_Print_loop	
		jbra      TokensExec_EndTokenCmd

|===|
|DIM|
|===|
_ExecCmd_Dim_block_integer:
		moveq.l   #SIZE_INTEGER,%d7
		jbra      _ExecCmd_Dim_loop_continue

_ExecCmd_Dim_block_float:
		moveq.l   #SIZE_FLOAT,%d7
		jbra      _ExecCmd_Dim_loop_continue
		
_ExecCmd_Dim_block_bool:
		moveq.l   #SIZE_BOOL,%d7
		jbra      _ExecCmd_Dim_loop_continue
		
ExecCmd_Dim:
		jbsr      TokensExec_CNumArg
		tst.w     %d6					|Pas d'arguments
		jbeq      _ERROR_few_arguments
		subq.w    #1,%d6
_ExecCmd_Dim_loop:
		move.b    (%a5)+,%d0				|Operande
		subq.b    #OPRD_VARTABLE,%d0
		jbeq      _ERROR_defined_vartable
		subq.b    #1,%d0				|OPRD_UNDEF_VARTABLE
		jbne      _ERROR_incorrect_arg
		
		move.b    (%a5)+,%d0				|Type
		subq.b    #TYPE_INTEGER,%d0
		jbeq      _ExecCmd_Dim_block_integer
		jbcs      _ExecCmd_Dim_block_float		|TYPE_FLOAT
		subq.b    #1,%d0				|TYPE_BOOL
		jbeq      _ExecCmd_Dim_block_bool
		
		moveq.l   #SIZE_DESCRIPTOR,%d7			|Tableau de chanes de caractres
_ExecCmd_Dim_loop_continue:
		moveq.l   #0,%d4				|Efface %d4
		move.w    (%a5)+,%d4				|ndim
		movea.l   (%a5)+,%a2				|Dimensions
		movea.l   %a2,%a3
		moveq.l   #1,%d3				|Total Dim
		moveq.l   #0,%d5
		move.w    %d4,%d5				|Boucle FOR 0  ndim
		subq.w    #1,%d5
_ExecCmd_Dim_loop_totaldim:
		mulu.w    (%a2)+,%d3				|total_dim *= dimension n
		dbf       %d5,_ExecCmd_Dim_loop_totaldim   
_ExecCmd_Dim_loop_totaldim_end:
		tst.w     %d3					|Pour tableau commence  index 0
		jbeq      _ERROR_tbl_zerodim
		moveq.l   #0,%d5
		mulu.w    %d7,%d3				|BlockSize*Total Dim
		move.w    %d3,%d5				|Nombre d'octets zone mmoire
		move.w    %d4,%d2
		add.w     %d2,%d2				|ndim*2
		add.w     %d2,%d3				|ndim+Total Dim
		move.l    %d3,-(%SP)
		ROM_CALL  malloc
		addq.l    #4,%SP
		move.l    %a0,%d0		
		jbeq      _ERROR_no_enough_memory		|No enough memory
		movea.l   (%a5)+,%a0				|Adresse descripteur
		move.l    %d0,(%a0)+				|Zone mmoire
		move.w    %d4,(%a0)				|Nombre de dimension
		movea.l   %d0,%a2				|Sauvegarde adresse
		
		|Copie les dimensions
		subq.w    #1,%d4
_ExecCmd_Dim_loop_copydim:		
		move.w    (%a3)+,(%a2)+
		dbf       %d4,_ExecCmd_Dim_loop_copydim

		|Si boolen effacer octets par octets
		subq.w    #SIZE_BOOL,%d7
		jbeq      _ExecCmd_Dim_loop_clear_memory_bool
		
		|Efface mots par mots
		lsr.w     #1,%d5
		subq.w    #1,%d5
_ExecCmd_Dim_loop_clear_memory:
		clr.w     (%a2)+
		dbf       %d5,_ExecCmd_Dim_loop_clear_memory
_ExecCmd_Dim_loop_copydim_end:
		dbf       %d6,_ExecCmd_Dim_loop
		jbra      TokensExec_EndTokenCmd
	
		|Efface octet par octet (boolens)
_ExecCmd_Dim_loop_clear_memory_bool:
		subq.w    #1,%d5
_ExecCmd_Dim_loop_clear_memory_numbers_bool:
		clr.b     (%a2)+
		dbf       %d5,_ExecCmd_Dim_loop_clear_memory_numbers_bool
		dbf       %d6,_ExecCmd_Dim_loop
		jbra      TokensExec_EndTokenCmd		


|===|
|CLS|
|===|		
ExecCmd_Cls:
		jbsr      clrscr
		jbra      TokensExec_EndTokenCmd

|======|
|GETKEY|
|======|		
ExecFnc_Getkey:
		jbsr      TokensExec_NumArg
		jbsr      _kb_getkey
		jbra      TokensExec_AddResult_Func_Integer

|===|
|ABS|
|===|
_ExecFnc_Abs_integer:
		move.l    (%a0),%d0
		jbge      TokensExec_AddResult_Func_Integer
		neg.l     %d0
		jbra      TokensExec_AddResult_Func_Integer
		
ExecFnc_Abs:
		MACRO_Func_CheckArg	#1
		move.w    %d6,%d7				|Sauvegarde nombre d'arguments
		
		MACRO_SimpleType 	TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		move.w    %d7,%d6				|Restaure nombre d'arguments
					
		movea.l   4(%a5),%a0				|Number
		cmpi.b    #TYPE_INTEGER,1(%a5)			|Type number
		jbeq      _ExecFnc_Abs_integer
_ExecFnc_Abs_float:
		|Empile number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #fabs*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float

|===|
|ADD|
|===|
_ExecCmd_Add_integer:
		move.l    (%a1),%d0				|Number 1
		add.l     %d0,(%a2)
		jbra      TokensExec_EndTokenCmd     
		
ExecCmd_Add:
		MACRO_Cmd_CheckArg	#2

		move.b    12(%a5),%d0				|Oprande number 2
		subq.b    #OPRD_VAR,%d0
		jbeq	  _ExecCmd_Add_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq	  _ExecCmd_Add_continue
		subq.b    #1,%d0
		jbeq      _ERROR_undef_vartable			|#OPRD_UNDEF_VARTABLE
		jbra      _ERROR_incorrect_arg
_ExecCmd_Add_continue:
		cmpi.b    #TYPE_BOOL,13(%a5)			|BOOL et STRING
		jbcc      _ERROR_incorrect_arg

		MACRO_MathType		TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER, TRUE
					
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a2				|Number 2
		
		cmpi.b    #TYPE_INTEGER,1(%a5)			|Type number 1
		jbeq      _ExecCmd_Add_integer
_ExecCmd_Add_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #fadd*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)				|Empile 2 octets fin flottant
		jbra      TokensExec_EndTokenCmd
		
|===|
|ATN|
|===|		
ExecFnc_Atn:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a0				|Number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #atan*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float

|===|
|ATN|
|===|
_ExecCmd_Clr_del_vartable_string:
		movea.l   8(%a5),%a3
		move.w    4(%a3),%d0				|Nombre de dimensions
		movea.l   (%a3),%a3				|Zone de decripteurs
		jbsr      TokensExec_DeleteTabString
		jbra      _ExecCmd_Clr_loop_delete_vartable
		

_ExecCmd_Clr_del_var_float:
		clr.l     (%a0)+
		clr.l     (%a0)+
		clr.w     (%a0)
		jbra      _ExecCmd_Clr_loop_next
		
_ExecCmd_Clr_del_var_integer:
		clr.l     (%a0)
		jbra      _ExecCmd_Clr_loop_next

_ExecCmd_Clr_del_var_bool:
		clr.b     (%a0)
		jbra      _ExecCmd_Clr_loop_next		

_ExecCmd_Clr_del_var:
		movea.l   4(%a5),%a0				|Donnes
		subq.b    #TYPE_INTEGER,%d1
		jbeq      _ExecCmd_Clr_del_var_integer
		jbcs      _ExecCmd_Clr_del_var_float		|#TYPE_FLOAT
		subq.b    #1,%d1				|#TYPE_BOOL
		jbeq      _ExecCmd_Clr_del_var_bool
_ExecCmd_Clr_del_var_string:
		movea.l   8(%a5),%a2
		jbsr      TokensExec_DeleteSimpleString
		jbra      _ExecCmd_Clr_loop_next
		
ExecCmd_Clr:
		jbsr      TokensExec_CNumArg
		tst.w     %d6
		jbeq      _ERROR_few_arguments
				
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		subq.w    #1,%d6
_ExecCmd_Clr_loop:
		move.b    (%a5),%d0
		subq.b    #OPRD_VAR,%d0
		jbeq      _ExecCmd_Clr_loop_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq      _ExecCmd_Clr_loop_continue
		subq.b    #1,%d0				|#OPRD_UNDEF_VARTABLE
		jbeq      _ERROR_undef_vartable
		subq.b    #1,%d0				|#OPRD_EMPTY_VARTABLE
		jbne      _ERROR_incorrect_arg
		
_ExecCmd_Clr_loop_continue:
		move.b    1(%a5),%d1				|Type
		
		cmpi.b    #OPRD_VARTABLE,(%a5)			|Variable ou donne d'un tableau
		jbls      _ExecCmd_Clr_del_var
		
		|Tableau (vide)
		subq.b    #TYPE_STRING,%d1
		jbeq      _ExecCmd_Clr_del_vartable_string
_ExecCmd_Clr_loop_delete_vartable:
		movea.l   8(%a5),%a3				|Descripteur
		move.l    (%a3),-(%SP)				|Zone mmoire donnes tableau
		ROM_CALL  free
		addq.l    #4,%SP
		clr.l     (%a3)+				|Zone mmoire NULL
		clr.w     (%a3)					|Nombre de dimensions = 0
_ExecCmd_Clr_loop_next:		
		lea.l     -12(%a5),%a5				|Donnes suivante
		dbf       %d6,_ExecCmd_Clr_loop
		jbra      TokensExec_EndTokenCmd

|===|
|COS|
|===|		
ExecFnc_Cos:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a0				|Number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #cos*4,-(%SP)				|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|===|
|DEC|
|===|
_ExecCmd_Dec_integer:
		subq.l    #1,(%a2)
		jbra      TokensExec_EndTokenCmd
		
ExecCmd_Dec:
		MACRO_Cmd_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande number 1
		move.b    1(%a5),%d1				|Type number 1
		subq.b    #OPRD_VAR,%d0
		jbeq	  _ExecCmd_Dec_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq	  _ExecCmd_Dec_continue
		subq.b    #1,%d0
		jbeq      _ERROR_undef_vartable			|#OPRD_UNDEF_VARTABLE
		jbra      _ERROR_incorrect_arg
_ExecCmd_Dec_continue:
		subq.b    #TYPE_BOOL,%d1			|BOOL et STRING
		jbcc      _ERROR_incorrect_arg
		
		movea.l   4(%a5),%a2				|Number 1
		
		addq.b    #1,%d1
		jbeq      _ExecCmd_Dec_integer
_ExecCmd_Dec_float:
		|Empile number 1
		clr.w     -(%SP)				|Empile fin flottant
		clr.l     -(%SP)				|Empile milieu flottant
		move.l    #0x40001000,-(%SP)			|Empile dbut flottant
		|Empile number 2
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #fsub*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)				|Empile 2 octets fin flottant
		jbra      TokensExec_EndTokenCmd
		
|===|
|DIV|
|===|
_ExecCmd_Div_integer:
		move.l    (%a1),%d0				|Number 1
		jbeq      _ERROR_divide_by_zero
		
		move.l    %d0,-(%SP)				|Number 1
		move.l    (%a2),-(%SP)				|Number 2
		jbsr      __divsi3
		addq.l    #4+4,%SP
		move.l    %d0,(%a2)
		jbra      TokensExec_EndTokenCmd     
		
ExecCmd_Div:
		MACRO_Cmd_CheckArg	#2 

		move.b    12(%a5),%d0				|Oprande number 2
		subq.b    #OPRD_VAR,%d0
		jbeq	  _ExecCmd_Div_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq	  _ExecCmd_Div_continue
		subq.b    #1,%d0
		jbeq      _ERROR_undef_vartable			|#OPRD_UNDEF_VARTABLE
		jbra      _ERROR_incorrect_arg
_ExecCmd_Div_continue:
		cmpi.b    #TYPE_BOOL,13(%a5)			|BOOL et STRING
		jbcc      _ERROR_incorrect_arg

		MACRO_MathType			TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER, TRUE
		
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a2				|Number 2
		
		cmpi.b    #TYPE_INTEGER,1(%a5)
		jbeq      _ExecCmd_Div_integer
_ExecCmd_Div_float:
		move.w    8(%a1),%d0				|Division par zro? (Comparaison imparfaite!)
		move.l    4(%a1),%d1
		move.l    (%a1),%d2
		tst.w     %d0
		jbne      _ExecCmd_Div_float_next
		tst.l     %d1
		jbne      _ExecCmd_Div_float_next
		tst.w     %d2
		jbne      _ExecCmd_Div_float_next
		jbra	  _ERROR_divide_by_zero
		
_ExecCmd_Div_float_next:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #fdiv*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)				|Empile 2 octets fin flottant
		jbra      TokensExec_EndTokenCmd

|====|
|EVEN|
|====|		
ExecFnc_Even:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d0
		andi.w    #1,%d0
		subq.w    #1,%d0
		jbra      TokensExec_AddResult_Func_Bool
		
|===|
|EXP|
|===|		
ExecFnc_Exp:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a0				|Number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #exp*4,-(%SP)				|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|===|
|FIX|
|===|
ExecFnc_Fix:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		move.l    (%a0),%d0
		jbra      TokensExec_AddResult_Func_Integer

|====|
|FRAC|
|====|		
ExecFnc_Frac:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a0		
		move.w    8(%a0),%d5				|Empile fin flottant
		move.l    4(%a0),%d4				|Empile milieu flottant
		move.l    (%a0),%d3				|Empile dbut flottant
		move.w    %d5,-(%SP)
		move.l    %d4,-(%SP)
		move.l    %d3,-(%SP)
		move.w    #floor*4,-(%SP)			|Wrapper
		jbsr      __BC		
		move.w    %d2,-(%SP)
		move.l    %d1,-(%SP)
		move.l    %d0,-(%SP)
		move.w    %d5,-(%SP)				|Empile fin flottant
		move.l    %d4,-(%SP)				|Empile milieu flottant
		move.l    %d3,-(%SP)				|Empile dbut flottant
		move.w    #fsub*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea       (2+4+4+2+4+4+2)+(2+4+4+2)(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|===|
|INC|
|===|
_ExecCmd_Inc_integer:
		addq.l    #1,(%a2)
		jbra      TokensExec_EndTokenCmd
		
ExecCmd_Inc:
		MACRO_Cmd_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande number 1
		move.b    1(%a5),%d1				|Type number 1
		subq.b    #OPRD_VAR,%d0
		jbeq	  _ExecCmd_Inc_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq	  _ExecCmd_Inc_continue
		subq.b    #1,%d0
		jbeq      _ERROR_undef_vartable			|#OPRD_UNDEF_VARTABLE
		jbra      _ERROR_incorrect_arg
_ExecCmd_Inc_continue:
		subq.b    #TYPE_BOOL,%d1			|BOOL et STRING
		jbcc      _ERROR_incorrect_arg
		
		movea.l   4(%a5),%a2				|Number 1
		
		addq.b    #1,%d1
		jbeq      _ExecCmd_Inc_integer
_ExecCmd_Inc_float:
		|Empile number 1
		clr.w     -(%SP)				|Empile fin flottant
		clr.l     -(%SP)				|Empile milieu flottant
		move.l    #0x40001000,-(%SP)			|Empile dbut flottant
		|Empile number 2
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #fadd*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)				|Empile 2 octets fin flottant
		jbra      TokensExec_EndTokenCmd
		
|===|
|LOG|
|===|								
ExecFnc_Log:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a2				|Number
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)	
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0
		jble      _ERROR_log
		
_ExecFnc_Log_float_next:	
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #log*4,-(%SP)				|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|=====|
|LOG10|
|=====|								
ExecFnc_Log10:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a2				|Number
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)	
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0
		jble      _ERROR_log
		
_ExecFnc_Log10_float_next:	
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #log10*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|===|
|MUL|
|===|
_ExecCmd_Mul_integer:
		move.l    (%a1),-(%SP)				|Number 1
		move.l    (%a2),-(%SP)				|Number 2
		jbsr      __mulsi3
		addq.l    #4+4,%SP
		move.l    %d0,(%a2)
		jbra      TokensExec_EndTokenCmd     
		
ExecCmd_Mul:
		MACRO_Cmd_CheckArg	#2 
		
		move.b    12(%a5),%d0				|Oprande number 2
		subq.b    #OPRD_VAR,%d0
		jbeq	  _ExecCmd_Mul_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq	  _ExecCmd_Mul_continue
		subq.b    #1,%d0
		jbeq      _ERROR_undef_vartable			|#OPRD_UNDEF_VARTABLE
		jbra      _ERROR_incorrect_arg
_ExecCmd_Mul_continue:
		cmpi.b    #TYPE_BOOL,13(%a5)			|BOOL et STRING
		jbcc      _ERROR_incorrect_arg

		MACRO_MathType 		TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER, TRUE
		
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a2				|Number 2
		
		cmpi.b    #TYPE_INTEGER,1(%a5)
		jbeq      _ExecCmd_Mul_integer
_ExecCmd_Mul_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #fmul*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)				|Empile 2 octets fin flottant
		jbra      TokensExec_EndTokenCmd
		
|===|
|ODD|
|===|		
ExecFnc_Odd:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d0
		andi.w    #1,%d0
		neg.w     %d0
		jbra      TokensExec_AddResult_Func_Bool

|===|
|SGN|
|===|						
_ExecFnc_Sgn_integer_zero:
		moveq.l   #0,%d0
		jbra      TokensExec_AddResult_Func_Integer
		
_ExecFnc_Sgn_minus:
		moveq.l   #-1,%d0
		jbra      TokensExec_AddResult_Func_Integer

_ExecFnc_Sgn_integer:
		tst.l     (%a0)
		jbeq      _ExecFnc_Sgn_integer_zero
		jbmi      _ExecFnc_Sgn_minus
		moveq.l   #1,%d0
		jbra      TokensExec_AddResult_Func_Integer
				
ExecFnc_Sgn:
		MACRO_Func_CheckArg	#1
		
		move.w    %d6,%a3				|Sauvegarde nombre d'arguments
		
		MACRO_SimpleType 	TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER

		move.w    %a3,%d6				|Restaure nombre d'arguments
		
		movea.l   4(%a5),%a0				|Number
		cmpi.b    #TYPE_INTEGER,1(%a5)			|Type number
		jbeq      _ExecFnc_Sgn_integer
_ExecFnc_Sgn_float:
		move.w    8(%a0),%d0				|Division par zro? (Comparaison imparfaite!)
		move.l    4(%a0),%d1
		move.l    (%a0),%d2
		tst.w     %d0
		jbne      _ExecFnc_Sgn_float_next
		tst.l     %d1
		jbne      _ExecFnc_Sgn_float_next
		tst.w     %d2
		jbne      _ExecFnc_Sgn_float_next
		moveq.l   #0,%d0
		jbra      TokensExec_AddResult_Func_Integer
		
_ExecFnc_Sgn_float_next:
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)	
		move.w    %d0,-(%SP)				|Empile fin flottant
		move.l    %d1,-(%SP)				|Empile milieu flottant
		move.l    %d2,-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0
		jbmi      _ExecFnc_Sgn_minus
		moveq.l   #1,%d0
		jbra      TokensExec_AddResult_Func_Integer

|===|
|SIN|
|===|
ExecFnc_Sin:		
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a0				|Number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #sin*4,-(%SP)				|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|===|
|SQR|
|===|								
ExecFnc_Sqr:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a2				|Number
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)	
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0
		jbmi      _ERROR_square
		
_ExecFnc_Sqr_float_next:	
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #sqrt*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float
		
|===|
|TAN|
|===|		
ExecFnc_Tan:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a0				|Number
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		move.w    #tan*4,-(%SP)				|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2(%SP),%SP
		jbra      TokensExec_AddResult_Func_Float

|=====|
|ROUND|
|=====|
_ExecFnc_Round_plus:
		clr.w     -(%SP)				|Flottant = 0.5
		clr.l     -(%SP)
		move.l    #0x3FFF5000,-(%SP)
		move.w    %d5,-(%SP)
		move.l    %d4,-(%SP)
		move.l    %d3,-(%SP)
		move.w    #fadd*4,-(%SP)			|Wrapper
		jbsr      __BC
		move.w    %d2,-(%SP)
		move.l    %d1,-(%SP)
		move.l    %d0,-(%SP)
		ROM_CALL  trunc
		lea.l     (4+4+2)+(2+4+4+2+4+4+2)(%SP),%SP
		jbra      TokensExec_AddResult_Func_Integer
		
ExecFnc_Round:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0

		movea.l   4(%a5),%a0
		move.w    8(%a0),%d5
		move.l    4(%a0),%d4
		move.l    (%a0),%d3
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)
		move.w    %d5,-(%SP)				|Empile fin flottant
		move.l    %d4,-(%SP)				|Empile milieu flottant
		move.l    %d3,-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0
		jbge      _ExecFnc_Round_plus
_ExecFnc_Round_minus:
		move.w    %d5,-(%SP)
		move.l    %d4,-(%SP)
		move.l    %d3,-(%SP)
		clr.w     -(%SP)				|Flottant = 0.5
		clr.l     -(%SP)
		move.l    #0x3FFF5000,-(%SP)
		move.w    #fsub*4,-(%SP)			|Wrapper
		jbsr      __BC
		move.w    %d2,-(%SP)
		move.l    %d1,-(%SP)
		move.l    %d0,-(%SP)
		ROM_CALL  trunc
		lea.l     (4+4+2)+(2+4+4+2+4+4+2)(%SP),%SP
		neg.l     %d0
		jbra      TokensExec_AddResult_Func_Integer
		
|===|
|SUB|
|===|
_ExecCmd_Sub_integer:
		move.l    (%a1),%d0				|Number 1
		sub.l     %d0,(%a2)
		jbra      TokensExec_EndTokenCmd     
				
ExecCmd_Sub:
		MACRO_Cmd_CheckArg	#2

		move.b    12(%a5),%d0				|Oprande number 2
		subq.b    #OPRD_VAR,%d0
		jbeq	  _ExecCmd_Sub_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq	  _ExecCmd_Sub_continue
		subq.b    #1,%d0
		jbeq      _ERROR_undef_vartable			|#OPRD_UNDEF_VARTABLE
		jbra      _ERROR_incorrect_arg
_ExecCmd_Sub_continue:
		cmpi.b    #TYPE_BOOL,13(%a5)			|BOOL et STRING
		jbcc      _ERROR_incorrect_arg

		MACRO_MathType		 TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER, TRUE
		
		movea.l   4(%a5),%a1				|Number 1
		movea.l   16(%a5),%a2				|Number 2
		
		cmpi.b    #TYPE_INTEGER,1(%a5)			|Type number 1
		jbeq      _ExecCmd_Sub_integer
_ExecCmd_Sub_float:
		|Empile number 1
		move.w    8(%a1),-(%SP)				|Empile fin flottant
		move.l    4(%a1),-(%SP)				|Empile milieu flottant
		move.l    (%a1),-(%SP)				|Empile dbut flottant
		|Empile number 2
		move.w    8(%a2),-(%SP)				|Empile fin flottant
		move.l    4(%a2),-(%SP)				|Empile milieu flottant
		move.l    (%a2),-(%SP)				|Empile dbut flottant
		move.w    #fsub*4,-(%SP)			|Wrapper
		jbsr      __BC
		lea.l     2+4+4+2+4+4+2(%SP),%SP
		move.l    %d0,(%a2)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a2)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a2)				|Empile 2 octets fin flottant
		jbra      TokensExec_EndTokenCmd

|===|
|ASC|
|===|		
ExecFnc_Asc:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a5)			|Type
		jbne      _ERROR_types_incompatible
		
		movea.l   4(%a5),%a0
		moveq.l   #0,%d0
		move.b    (%a0),%d0
		jbra      TokensExec_AddResult_Func_Integer

|===|
|BIN|
|===|
_ExecFnc_Bin_zero:
		move.b    #'0',(%a0)+
		dbf       %d1,_ExecFnc_Bin_loop	
		rts
		
ExecFnc_Bin:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d4
		move.l    %d4,%d0
		jbsr      Func_GetnBits
		move.l    %d0,%d1
		jbsr      TokensExec_AddResult_Func_String
		subq.l    #1,%d1
		
_ExecFnc_Bin_loop:
		moveq.l   #1,%d2
		lsl.l     %d1,%d2
		and.l     %d4,%d2
		jbeq      _ExecFnc_Bin_zero
		move.b    #'1',(%a0)+
		dbf       %d1,_ExecFnc_Bin_loop		
		rts

|===|
|HEX|
|===|		
ExecFnc_Hex:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d4
		move.l    %d4,%d0
		moveq.l   #4,%d1
		jbsr      Func_GetnDigits
		move.l    %d0,%d1
		jbsr      TokensExec_AddResult_Func_String
		subq.l    #1,%d1
		lea.l     TableHexa,%a2
		
_ExecFnc_Hex_loop:
		move.l    %d1,%d0
		lsl.l     #2,%d0
		move.l    %d4,%d2
		lsr.l     %d0,%d2
		andi.l    #15,%d2
		lea.l     (%d2.w,%a2),%a1
		move.b    (%a1),(%a0)+
		dbf       %d1,_ExecFnc_Hex_loop		
		rts

|===|
|OCT|
|===|		
ExecFnc_Oct:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d4
		move.l    %d4,%d0
		moveq.l   #3,%d1
		jbsr      Func_GetnDigits
		move.l    %d0,%d1
		jbsr      TokensExec_AddResult_Func_String
		subq.l    #1,%d1
		
_ExecFnc_Oct_loop:
		move.l    %d1,%d0
		mulu.w    #3,%d0
		move.l    %d4,%d2
		lsr.l     %d0,%d2
		andi.l    #7,%d2
		addi.b    #'0',%d2
		move.b    %d2,(%a0)+
		dbf       %d1,_ExecFnc_Oct_loop		
		rts

|===|
|CHR|
|===|		
ExecFnc_Chr:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a4				|Number
		moveq.l   #1,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.b    3(%a4),(%a0)
		rts

|====|
|LEFT|
|====|
_ExecFnc_Left_nchar:
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		move.w    2(%a0),%d4
		lea.l     12(%a5),%a2
		jbra      _ExecFnc_Left_continue
		
ExecFnc_Left:
		jbsr      TokensExec_NumArg
		cmpi.w    #2,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		cmpi.w    #1,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		
		movea.l   %a5,%a2
		moveq.l   #1,%d4
		cmpi.w    #2,%d6
		jbcc      _ExecFnc_Left_nchar
_ExecFnc_Left_continue:		
		move.b    (%a2),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a2)			|Type
		jbne      _ERROR_types_incompatible

		move.w    2(%a2),%d0
		cmp.w     %d0,%d4
		jbls      _ExecFnc_Left_continue2
		move.w    %d0,%d4
_ExecFnc_Left_continue2:
		movea.l   4(%a2),%a4
		move.w    %d4,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.w    %d4,%d0
		movea.l   %a0,%a1
		movea.l   %a4,%a0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		rts

|===|
|LEN|
|===|		
ExecFnc_Len:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a5)			|Type
		jbne      _ERROR_types_incompatible
		
		moveq.l   #0,%d0
		move.w    2(%a5),%d0
		jbra      TokensExec_AddResult_Func_Integer

|===|
|MID|
|===|
_ExecFnc_Mid_size:
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		move.w    2(%a0),%d4				|%d4 = Paramtre size
		lea.l     12(%a5),%a4				|Avance %a4 donne suivante
		jbra      _ExecFnc_Mid_continue
		
ExecFnc_Mid:
		jbsr      TokensExec_NumArg
		cmpi.w    #3,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		cmpi.w    #2,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		
		movea.l   %a5,%a4				|Pile dans %a4
		cmpi.w    #3,%d6				|Argument facultatif (size)
		jbeq      _ExecFnc_Mid_size
_ExecFnc_Mid_continue:
		MACRO_ConvertType 	#TYPE_INTEGER, 0, %a4	|Pos
		
		move.b    12(%a4),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,13(%a4)			|Type
		jbne      _ERROR_types_incompatible
		
		movea.l   4(%a4),%a0
		move.w    2(%a0),%d3				|%d3 = Paramtre pos
		jbeq      _ExecFnc_Mid_continue2
		subq.w    #1,%d3				|%d3 = pos-1
_ExecFnc_Mid_continue2:
		cmpi.w    #3,%d6
		jbeq      _ExecFnc_Mid_continue3
		move.w    14(%a4),%d4				|%d4 = string size
		sub.w     %d3,%d4				|%d4 = string size-pos
_ExecFnc_Mid_continue3:
		move.w    14(%a4),%d0
		cmp.w     %d0,%d3
		jbcc      _ExecFnc_Mid_clear_len
		move.w    %d3,%d1
		add.w     %d4,%d1
		cmp.w     %d0,%d1
		jbcs      _ExecFnc_Mid_continue4
		sub.w     %d3,%d0
		move.w    %d0,%d4
_ExecFnc_Mid_continue4:
		move.w    %d4,%d0
		jbsr      TokensExec_AddResult_Func_String
		movea.l   %a0,%a1
		movea.l   16(%a4),%a0
		adda.w    %d3,%a0 |lea.l     (%d3.w,%a0),%a0
		move.w    %d4,%d0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		rts
		
_ExecFnc_Mid_clear_len:
		clr.w     %d4
		jbra      _ExecFnc_Mid_continue4

|=====|
|RIGHT|
|=====|		
_ExecFnc_Right_nchar:
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		move.w    2(%a0),%d4
		lea.l     12(%a5),%a2
		jbra      _ExecFnc_Right_continue
		
ExecFnc_Right:
		jbsr      TokensExec_NumArg
		cmpi.w    #2,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		cmpi.w    #1,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		
		movea.l   %a5,%a2
		moveq.l   #1,%d4
		cmpi.w    #2,%d6
		jbcc      _ExecFnc_Right_nchar
_ExecFnc_Right_continue:		
		move.b    (%a2),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a2)			|Type
		jbne      _ERROR_types_incompatible

		move.w    2(%a2),%d3
		cmp.w     %d3,%d4
		jbls      _ExecFnc_Right_continue2
		move.w    %d3,%d4
_ExecFnc_Right_continue2:
		movea.l   4(%a2),%a4
		move.w    %d4,%d0
		jbsr      TokensExec_AddResult_Func_String
		sub.w     %d4,%d3
		adda.w    %d3,%a4
		move.w    %d4,%d0
		movea.l   %a0,%a1
		movea.l   %a4,%a0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		rts

|=====|
|SPACE|
|=====|	
ExecFnc_Space:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.w    2(%a0),%d4
		move.w    %d4,%d0
		jbsr      TokensExec_AddResult_Func_String
		moveq.l   #0,%d0
		move.w    %d4,%d0
		subq.w    #1,%d0
		jbcs      _ExecFnc_Space_exit
_ExecFnc_Space_loop:
		move.b    #32,(%a0)+
		dbf       %d0,_ExecFnc_Space_loop
_ExecFnc_Space_exit:		
		rts

|===|
|STR|
|===|
_ExecFnc_Str_integer:
		move.l    (%a0),%d0
		movea.l   string_buffer,%a3
		jbsr      Func_IntToStr
		move.w    %d4,%d0
		movea.l   %a3,%a4
		jbra      ExecFnc_Str_create_string
		
ExecFnc_Str:
		MACRO_Func_CheckArg	#1
		move.w    %d6,%d7				|Sauvegarde nombre d'arguments
		
		MACRO_SimpleType 	TRUE, TRUE, FALSE, FALSE, #TYPE_INTEGER
		move.w    %d7,%d6				|Restaure nombre d'arguments
					
		movea.l   4(%a5),%a0				|Number
		cmpi.b    #TYPE_INTEGER,1(%a5)			|Type number
		jbeq      _ExecFnc_Str_integer
_ExecFnc_Str_float:
		move.w    8(%a0),-(%SP)				|Empile fin flottant
		move.l    4(%a0),-(%SP)				|Empile milieu flottant
		move.l    (%a0),-(%SP)				|Empile dbut flottant
		pea.l     printf_f
		move.l    string_buffer,-(%SP)
		ROM_CALL  sprintf
		lea.l     4+4+4+4+2(%SP),%SP
		movea.l   string_buffer,%a4
ExecFnc_Str_create_string:
		move.w    %d0,%d4		
		jbsr      TokensExec_AddResult_Func_String
		move.w    %d4,%d0
		movea.l   %a0,%a1
		movea.l   %a4,%a0
		jbsr      _memcpy_slow
		clr.b     (%a1)
		rts

|======|
|STRING|
|======|
_ExecFnc_String_copy_string:
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		|Source
		move.l    4(%a5),%a4
		move.w    2(%a5),%d4
		
		|Destination
		move.w    2(%a5),%d0
		mulu.w    %d7,%d0
		jbsr      TokensExec_AddResult_Func_String
		tst.w     %d7
		jbeq      _ExecFnc_String_copy_string_exit
		movea.l   %a0,%a1
		
		subq.w    #1,%d7
_ExecFnc_String_copy_string_loop:
		move.w    %d4,%d0				|Taille
		movea.l   %a4,%a0				|Source
		jbsr      _memcpy_slow
		dbf       %d7,_ExecFnc_String_copy_string_loop
		clr.b     (%a1)
_ExecFnc_String_copy_string_exit:
		rts
		
ExecFnc_String:
		MACRO_Func_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 12	|Convert number 2
		
		moveq.l   #0,%d7
		move.l    16(%a5),%a0				|Number 1
		move.w    2(%a0),%d7				|Size
		
		cmpi.b    #TYPE_STRING,1(%a5)
		jbeq      _ExecFnc_String_copy_string
_ExecFnc_String_copy_char:
		MACRO_ConvertType 	#TYPE_INTEGER, 0	|Convert number 1
		
		movea.l   4(%a5),%a0
		move.b    3(%a0),%d4				|Caractre
		
		move.w    %d7,%d0
		jbsr      TokensExec_AddResult_Func_String
		tst.w     %d7
		jbeq      _ExecFnc_String_copy_char_exit

		subq.w    #1,%d7
_ExecFnc_String_copy_char_loop:
		move.b    %d4,(%a0)+
		dbf       %d7,_ExecFnc_String_copy_char_loop	
		clr.b     (%a0)
_ExecFnc_String_copy_char_exit:
		rts

|=====|
|UPPER|
|=====|		
ExecFnc_Upper:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a5)			|Type
		jbne      _ERROR_types_incompatible
		
		move.w    2(%a5),%d4				|Taille
		movea.l   4(%a5),%a4				|Adresse
		move.w    %d4,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.w    %d4,%d0
		movea.l   %a0,%a1
		movea.l   %a4,%a0
		movea.l   %a1,%a4
		jbsr      _memcpy
		clr.b     (%a1)
		move.w    %d4,%d0
		movea.l   %a4,%a0
		jbsr      Func_StrUpper
		rts

|---|
|VAL|
|---|			
ExecFnc_Val:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a5)			|Type
		jbne      _ERROR_types_incompatible
		
		moveq.l   #0,%d5
		move.w    2(%a5),%d5				|size
		movea.l   4(%a5),%a3				|string

		|Evite les espaces		
		subq.w    #1,%d5
		jbcs      _ExecFnc_Val_find_space_end
_ExecFnc_Val_find_space_loop:
		cmpi.b    #32,(%a3)
		jbne      _ExecFnc_Val_find_space_end
		addq.l    #1,%a3				|ptr++
		dbf       %d5,_ExecFnc_Val_find_space_loop
_ExecFnc_Val_find_space_end:
		
		|Conversion base
		move.w    %d5,%d1
		addq.w    #1,%d1
		movea.l   %a3,%a2
		jbsr      Func_StrToBase
		tst.w     %d7
		jbne      TokensExec_AddResult_Func_Integer
		
		|Dtermine la taille physique du nombre
		moveq.l    #0,%d0				|Taille du nombre en  octets
		movea.l   %a3,%a0
		tst.w     %d5
		jblt      TokensExec_AddResult_Func_Integer
_ExecFnc_Val_find_number_loop:
		move.b    (%a0)+,%d1
		
		cmpi.b    #'0',%d1
		jbcs      _ExecFnc_Val_find_number_end
		cmpi.b    #'9',%d1
		jbls      _ExecFnc_Val_find_number_loop_next
		
		cmpi.b    #'.',%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		cmpi.b    #0x95,%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		cmpi.b    #'e',%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		cmpi.b    #'E',%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		cmpi.b    #0xAD,%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		cmpi.b    #'+',%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		cmpi.b    #'-',%d1
		jbeq      _ExecFnc_Val_find_number_loop_next
		
		jbra      _ExecFnc_Val_find_number_end
		
_ExecFnc_Val_find_number_loop_next:		
		addq.w    #1,%d0
		dbf       %d5,_ExecFnc_Val_find_number_loop
_ExecFnc_Val_find_number_end:
		move.w    %d0,%d5
		jbeq      TokensExec_AddResult_Func_Integer
		
		|Entier?
		pea.l     (%a3)
		jbsr      atol
		move.l    %d0,(%SP)
		
		|Flottant?
		move.w    %d5,%d0
		movea.l   %a3,%a0
		movea.l   string_buffer,%a1
		jbsr      Func_StrToFloat
		move.w    %d2,-(%SP)
		move.l    %d1,-(%SP)
		move.l    %d0,-(%SP)
		ROM_CALL  is_nan
		tst.w     %d0
		jbne      _ExecFnc_Val_integer
		
		move.l    (%SP)+,%d0
		move.l    (%SP)+,%d1
		move.w    (%SP)+,%d2
		addq.l    #4,%SP
		jbra      TokensExec_AddResult_Func_Float

_ExecFnc_Val_integer:
		lea.l     4+4+2(%SP),%SP
		move.l    (%SP)+,%d0
		jbra      TokensExec_AddResult_Func_Integer

|=========|
|ARRAYFILL|
|=========|
_ExecFnc_Arrayfill_float:
		move.l     (%a0),(%a1)+
		move.l     4(%a0),(%a1)+
		move.w     8(%a0),(%a1)+
		dbf        %d0,_ExecFnc_Arrayfill_loop
		jbra      TokensExec_EndTokenCmd
		
_ExecFnc_Arrayfill_integer:
		move.l     (%a0),(%a1)+
		dbf        %d0,_ExecFnc_Arrayfill_loop
		jbra      TokensExec_EndTokenCmd
		
ExecFnc_Arrayfill:
		MACRO_Cmd_CheckArg	#2
		
		move.b     12(%a5),%d0				|Oprande
		subq.b     #OPRD_UNDEF_VARTABLE,%d0
		jbeq       _ERROR_undef_vartable
		subq.b     #1,%d0				|OPRD_EMPTY_VARTABLE
		jbne       _ERROR_incorrect_arg

		cmpi.b     #TYPE_STRING,13(%a5)			|Type
		jbeq       _ERROR_incorrect_arg
		MACRO_ConvertType 	13(%a5), 0
		
		lea.l      12(%a5),%a2				|Nombre d'items
		jbsr       TokensExec_TotalDimVarTable
		
		movea.l    4(%a5),%a0				|Number
		movea.l    16(%a5),%a1				|Zone donnes tableau
		move.b     13(%a5),%d1				|type
		
		subq.w     #1,%d0
_ExecFnc_Arrayfill_loop:
		cmpi.b     #TYPE_INTEGER,%d1
		jbeq       _ExecFnc_Arrayfill_integer
		cmpi.b     #TYPE_FLOAT,%d1
		jbeq       _ExecFnc_Arrayfill_float
		move.b     (%a0),(%a1)+
		dbf        %d0,_ExecFnc_Arrayfill_loop
		jbra      TokensExec_EndTokenCmd

|====|
|LDIM|
|====|		
ExecFnc_Ldim:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		subq.b    #OPRD_UNDEF_VARTABLE,%d0
		jbne      _ExecFnc_Ldim_next
		moveq.l   #0,%d0
		jbra       TokensExec_AddResult_Func_Integer      
_ExecFnc_Ldim_next:
		subq.b    #1,%d0				|#OPRD_EMPTY_VARTABLE
		jbne      _ERROR_incorrect_arg
		
		movea.l   %a5,%a2				|Zone pile ES
		jbsr      TokensExec_TotalDimVarTable
		jbra      TokensExec_AddResult_Func_Integer  

|===|
|END|
|===|
|Fin de l'excution de l'interprteur		
ExecCmd_End:
		jbra      _TokensExec_end

|===|
|FRE|
|===|		
ExecFnc_Fre:
		jbsr      TokensExec_NumArg
		
		ROM_CALL  HeapCompress
_ExecFnc_Fre_get_RAM:
		ROM_CALL  HeapAvail
		jbra      TokensExec_AddResult_Func_Integer

|=====|
|PAUSE|
|=====|		
ExecCmd_Pause:
		MACRO_Cmd_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d0
		move.l    counter_time,%d1			|%d1 = counter_time
		lsl.l     #2,%d0
		add.l     %d1,%d0
_ExecCmd_Pause_loop:
		cmp.l     counter_time,%d0
		jbcc      _ExecCmd_Pause_loop
		jbra      TokensExec_EndTokenCmd

|====|
|SWAP|
|====|
|Variable ou donnes d'un tableau
_ExecCmd_Swap_data_integer:
		move.l    (%a0),%d0				|number 2
		move.l    (%a1),(%a0)
		move.l    %d0,(%a1)
		jbra      TokensExec_EndTokenCmd

_ExecCmd_Swap_data_float:
		move.l    (%a0),%d0				|number 2
		move.l    4(%a0),%d1
		move.w    8(%a0),%d2
		move.l    (%a1),(%a0)+
		move.l    4(%a1),(%a0)+
		move.w    8(%a1),(%a0)
		move.l    %d0,(%a1)+
		move.l    %d1,(%a1)+
		move.w    %d2,(%a1)
		jbra      TokensExec_EndTokenCmd

_ExecCmd_Swap_data_bool:
		move.b    (%a0),%d0				|number 2
		move.b    (%a1),(%a0)
		move.b    %d0,(%a1)
		jbra      TokensExec_EndTokenCmd

_ExecCmd_Swap_data:
		movea.l   4(%a5),%a0				|adr number 2
		movea.l   16(%a5),%a1				|adr number 1
		
		|Type
		subq.b    #TYPE_INTEGER,%d2
		jbeq      _ExecCmd_Swap_data_integer
		jbcs      _ExecCmd_Swap_data_float
		subq.b    #1,%d2				|#TYPE_BOOL
		jbeq      _ExecCmd_Swap_data_bool
		jbra      _ExecCmd_Swap_descriptor
				
ExecCmd_Swap:
		MACRO_Cmd_CheckArg	#2
		
		move.b    (%a5),%d1				|Operand 2
		move.b    12(%a5),%d0				|operand 1
		
		|Tableau indfini
		cmpi.b    #OPRD_UNDEF_VARTABLE,%d0
		jbeq      _ERROR_undef_vartable
		cmpi.b    #OPRD_UNDEF_VARTABLE,%d1
		jbeq      _ERROR_undef_vartable
		
		|Arguments diffrent
		|if ((number2.operand!=number1.operand) || (number2.type!=number1.type) || (number2.operand!=OPRD_VAR && number2.operand!=OPRD_VARTABLE && number2.operand!=OPRD_EMPTY_VARTABLE)) 
		cmp.b     %d0,%d1
		jbne      _ERROR_incorrect_arg
		move.b    13(%a5),%d2				|Type number 1
		cmp.b     1(%a5),%d2
		jbne      _ERROR_incorrect_arg
		subq.b    #OPRD_VAR,%d0
		jbeq      _ExecCmd_Swap_continue
		subq.b    #1,%d0				|#OPRD_VARTABLE
		jbeq      _ExecCmd_Swap_continue
		subq.b    #2,%d0				|#OPRD_EMPTY_VARTABLE
		jbne      _ERROR_incorrect_arg
_ExecCmd_Swap_continue:			
		subq.b    #OPRD_VAR,%d1
		jbeq      _ExecCmd_Swap_data
		subq.b    #1,%d1				|#OPRD_VARTABLE
		jbeq      _ExecCmd_Swap_data
		
_ExecCmd_Swap_array:		
		|chanes de caractres
		|Gestion des tableaux
_ExecCmd_Swap_descriptor:
		movea.l   8(%a5),%a0				|adr descripteur number 2
		movea.l   20(%a5),%a1				|adr descripteur number 1
		move.l    (%a0),%d0
		move.w    4(%a0),%d1
		move.l    (%a1),(%a0)+
		move.w    4(%a1),(%a0)
		move.l    %d0,(%a1)+
		move.w    %d1,(%a1)
		jbra      TokensExec_EndTokenCmd

|===|
|MKI|
|===|		
ExecFnc_Mki:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a4				|Number
		moveq.l   #SIZE_INTEGER16,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.b    2(%a4),(%a0)+
		move.b    3(%a4),(%a0)
		rts

|===|
|MKL|
|===|		
ExecFnc_Mkl:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a4				|Number
		moveq.l   #SIZE_INTEGER,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4),(%a0)
		rts

|===|
|MKF|
|===|		
ExecFnc_Mkf:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_FLOAT, 0
		
		movea.l   4(%a5),%a4				|Number
		moveq.l   #SIZE_FLOAT,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4)+,(%a0)+
		move.b    (%a4),(%a0)
		rts

|===|
|CVI|
|===|		
ExecFnc_Cvi:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		move.b    1(%a5),%d0				|Type
		cmpi.b    #TYPE_STRING,%d0
		jbne      _ERROR_types_incompatible
		
		movea.l   4(%a5),%a0
		moveq.l   #0,%d0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d0
		move.b    (%a0),%d0
		jbra      TokensExec_AddResult_Func_Integer

|===|
|CVL|
|===|		
ExecFnc_Cvl:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		move.b    1(%a5),%d0				|Type
		cmpi.b    #TYPE_STRING,%d0
		jbne      _ERROR_types_incompatible
		
		movea.l   4(%a5),%a0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d0
		move.b    (%a0)+,%d0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d1
		move.b    (%a0),%d1
		swap      %d0
		move.w    %d1,%d0
		jbra      TokensExec_AddResult_Func_Integer

|===|
|CVF|
|===|		
ExecFnc_Cvf:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		move.b    1(%a5),%d0				|Type
		cmpi.b    #TYPE_STRING,%d0
		jbne      _ERROR_types_incompatible
		
		movea.l   4(%a5),%a0
		
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d0
		move.b    (%a0)+,%d0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d1
		move.b    (%a0)+,%d1
		swap      %d0
		move.w    %d1,%d0
		
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d1
		move.b    (%a0)+,%d1
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d2
		move.b    (%a0)+,%d2
		swap      %d1
		move.w    %d2,%d1
		
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d2
		move.b    (%a0),%d2
		jbra      TokensExec_AddResult_Func_Float

|=======|
|SETFONT|
|=======|		
ExecCmd_Setfont:
		MACRO_Cmd_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0				|Number
		move.l    (%a0),%d3
		cmpi.b    #3,%d3
		jbcs      _ExecCmd_Setfont_next
		moveq.l   #2,%d3
_ExecCmd_Setfont_next:
		move.w    %d3,-(%SP)
		ROM_CALL  FontSetSys
		addq.l    #2,%SP
		
		lea.l     PARAM_FONT,%a0
		move.w    %d3,(%a0)
		lea.l     PARAM_FONT_DIVx,%a0
		lea.l     PARAM_FONT_DIVy,%a1
		subq.w    #1,%d3
		jbcs      _ExecCmd_Setfont_F_4x6
		jbeq      _ExecCmd_Setfont_F_6x8
_ExecCmd_Setfont_F_8x10:		
		move.w    #8,(%a0)
		move.w    #10,(%a1)
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Setfont_F_4x6:
		move.w    #4,(%a0)
		move.w    #6,(%a1)
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Setfont_F_6x8:
		move.w    #6,(%a0)
		move.w    #8,(%a1)
		jbra      TokensExec_EndTokenCmd

|=======|
|GETFONT|
|=======|		
ExecFnc_Getfont:
		jbsr      TokensExec_NumArg
		moveq.l   #0,%d0
		move.w    PARAM_FONT,%d0
		jbra      TokensExec_AddResult_Func_Integer

|=====|
|LOWER|
|=====|		
ExecFnc_Lower:
		MACRO_Func_CheckArg	#1
		
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a5)			|Type
		jbne      _ERROR_types_incompatible
		
		move.w    2(%a5),%d4				|Taille
		movea.l   4(%a5),%a4				|Adresse
		move.w    %d4,%d0
		jbsr      TokensExec_AddResult_Func_String
		move.w    %d4,%d0
		movea.l   %a0,%a1
		movea.l   %a4,%a0
		movea.l   %a1,%a4
		jbsr      _memcpy
		clr.b     (%a1)
		move.w    %d4,%d0
		movea.l   %a4,%a0
		jbsr      Func_StrLower
		rts 
		
|===|
|RUN|
|===|		
ExecCmd_Run:
		|Efface pile boucles FOR
		lea.l     ptrFOR,%a0
		move.l    ptrData_FOR,(%a0)
		
		|Saute au dbut du programme
		lea.l     TokensFile_DataPtr,%a0
		move.l    TokensFile_Data,(%a0)
		
		|Efface piles
		jbra      TokensExec_EndTokenCmd2

|=======|
|NGETCHX|
|=======|		
ExecFnc_Ngetchx:
		jbsr      Func_kb_flush
		jbsr      TokensExec_NumArg
_ExecFnc_Ngetchx_loop:		
		jbsr      _kb_getkey
		tst.w     %d0
		jbeq      _ExecFnc_Ngetchx_loop
		andi.l    #0x0000FFFF,%d0
		jbra      TokensExec_AddResult_Func_Integer

|===|
|RND|
|===|		
ExecFnc_Rnd:
		jbsr      TokensExec_NumArg
		
		jbsr      rand
		move.w    %d0,-(%SP)
		clr.w     -(%SP)
		move.w    #flt*4,-(%SP)				|Wrapper
		jbsr      __BC
		clr.w     -(%SP)				|Divise par 32767
	        move.l    #0x70000000,-(%SP)
	        move.l    #0x40043276,-(%SP)
		move.w    %d2,-(%SP)
	        move.l    %d1,-(%SP)
	        move.l    %d0,-(%SP)
	        move.w    #fdiv*4,-(%SP)			|Wrapper
		jbsr      __BC
	        lea.l     2+4+4+2+4+4+2+2+2+2(%SP),%SP
	        jbra      TokensExec_AddResult_Func_Float 

|=====|
|TIMER|
|=====|		
ExecFnc_Timer:
		jbsr      TokensExec_NumArg
		move.l    counter_time,%d0
		jbra      TokensExec_AddResult_Func_Integer
		
ExecCmd_System:
		rts
		
ExecFnc_Crslin:
		rts
		
ExecFnc_Crscol:
		rts
		
|======|
|RANDOM|
|======|	
ExecFnc_Random:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		|Rcupre nombre
		movea.l   4(%a5),%a0
		move.l    (%a0),%d3
		jbsr      rand
		mulu.w    %d3,%d0
		jbpl      _ExecFnc_Random_next
		addi.l    #32767,%d0
_ExecFnc_Random_next:
		moveq.l   #15,%d2
		asr.l     %d2,%d0
		jbra      TokensExec_AddResult_Func_Integer
		
ExecFnc_Type:
		rts
		
ExecFnc_Lval:
		rts

|======|
|VARPTR|
|======|		
ExecFnc_Varptr:
		MACRO_Func_CheckArg	#1
		
		move.b     (%a5),%d0				|Operand
		cmpi.b     #OPRD_UNDEF_VARTABLE,%d0
		jbeq       _ERROR_undef_vartable
		subq.b     #OPRD_VAR,%d0
		jbeq       _ExecFnc_Varptr_next
		subq.b     #1,%d0				|#OPRD_VARTABLE
		jbne       _ERROR_incorrect_arg
		
_ExecFnc_Varptr_next:
		move.l     4(%a5),%d0				|Adresse
		jbra       TokensExec_AddResult_Func_Integer

|======|
|ARRPTR|
|======|
_ExecFnc_Arrptr_var_next:
		cmpi.b     #TYPE_STRING,1(%a5)
		jbne       _ERROR_incorrect_arg
		jbra       _ExecFnc_Arrptr_next
		
ExecFnc_Arrptr:
		MACRO_Func_CheckArg	#1
		
		move.b     (%a5),%d0				|Operand
		subq.b     #OPRD_VAR,%d0
		jbeq       _ExecFnc_Arrptr_var_next
		subq.b     #3,%d0				|#OPRD_EMPTY_VARTABLE
		jbne       _ERROR_incorrect_arg
		
_ExecFnc_Arrptr_next:
		move.l     8(%a5),%d0				|Adresse
		jbra       TokensExec_AddResult_Func_Integer

|=====|
|DFREE|
|=====|
ExecFnc_Dfree:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_BOOL, 0
		
		movea.l    4(%a5),%a0
		tst.b      (%a0)
		jbeq       _ExecFnc_Fre_get_RAM
_ExecFnc_Dfree_get_ROM:
		lea.l      -12(%SP),%SP
		pea.l      8(%SP)				|nodata
		pea.l      4+8(%SP)				|nodata
		pea.l      4+4+8(%SP)				|nodata
		pea.l      4+4+4+4(%SP)				|Free
		pea.l      4+4+4+4(%SP)				|FreeAftreGC
		pea.l      4+4+4+4+4+8(%SP)			|nodata
		ROM_CALL   EM_survey
		move.l     4+4+4+4+4+4(%SP),%d0			|FreeAfterGC
		add.l      4+4+4+4+4+4+4(%SP),%d0		|Free
		lea.l      4+4+4+4+4+4+12(%SP),%SP
		jbra       TokensExec_AddResult_Func_Integer

|====|
|PEEK|
|====|		
ExecFnc_Peek:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		movea.l   (%a0),%a0
		
		moveq.l   #0,%d0
		move.b    (%a0),%d0 
		jbra      TokensExec_AddResult_Func_Integer

|=====|
|DPEEK|
|=====|		
ExecFnc_Dpeek:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		movea.l   (%a0),%a0
		
		moveq.l   #0,%d0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d0
		move.b    (%a0),%d0
		jbra      TokensExec_AddResult_Func_Integer

|=====|
|LPEEK|
|=====|		
ExecFnc_Lpeek:
		MACRO_Func_CheckArg	#1
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		movea.l   4(%a5),%a0
		movea.l   (%a0),%a0
		
		moveq.l   #0,%d0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d0
		move.b    (%a0)+,%d0
		move.b    (%a0)+,-(%SP)
		move.w    (%SP)+,%d1
		move.b    (%a0),%d1
		swap      %d0
		move.w    %d1,%d0
		jbra      TokensExec_AddResult_Func_Integer

|====|
|POKE|
|====|			
ExecCmd_Poke:
		MACRO_Cmd_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 0	|Nombre
		MACRO_ConvertType 	#TYPE_INTEGER, 12	|Adresse
		
		movea.l   4(%a5),%a0				|Number
		movea.l   16(%a5),%a1				|Adresse
		movea.l   (%a1),%a1
		move.b    3(%a0),(%a1)
		jbra      TokensExec_EndTokenCmd

|=====|
|DPOKE|
|=====|			
ExecCmd_Dpoke:
		MACRO_Cmd_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 0	|Nombre
		MACRO_ConvertType 	#TYPE_INTEGER, 12	|Adresse
		
		movea.l   4(%a5),%a0				|Number
		movea.l   16(%a5),%a1				|Adresse
		movea.l   (%a1),%a1
		move.b    2(%a0),(%a1)+
		move.b    3(%a0),(%a1)
		jbra      TokensExec_EndTokenCmd

|=====|
|LPOKE|
|=====|		
ExecCmd_Lpoke:	
		MACRO_Cmd_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 0	|Nombre
		MACRO_ConvertType 	#TYPE_INTEGER, 12	|Adresse
		
		movea.l   4(%a5),%a0				|Number
		movea.l   16(%a5),%a1				|Adresse
		movea.l   (%a1),%a1
		move.b    (%a0)+,(%a1)+
		move.b    (%a0)+,(%a1)+
		move.b    (%a0)+,(%a1)+
		move.b    (%a0),(%a1)
		jbra      TokensExec_EndTokenCmd

|===|
|BOX|
|===|		
ExecCmd_Box:
		MACRO_Cmd_CheckArg	#4
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		MACRO_ConvertType 	#TYPE_INTEGER, 12
		MACRO_ConvertType 	#TYPE_INTEGER, 24
		MACRO_ConvertType 	#TYPE_INTEGER, 36
		
		movea.l   4(%a5),%a0				|Number 1
		movea.l   16(%a5),%a1				|Number 2
		movea.l   28(%a5),%a2				|Number 3
		movea.l   40(%a5),%a3				|Number 4
		move.w    2(%a0),-(%SP)				|Number x...
		move.w    2(%a1),-(%SP)
		move.w    2(%a2),-(%SP)
		move.w    2(%a3),-(%SP)
		move.w    #A_NORMAL,-(%SP)			|Attribut
		pea.l     SCR_RECT				|SRC_RECT *clip
		pea.l     6(%SP)
		ROM_CALL  DrawClipRect
		lea.l     4+4+2+2+2+2+2(%SP),%SP
		jbra      TokensExec_EndTokenCmd

|=====|
|INPUT|
|=====|
_ExecCmd_Input_eofline:
		pea.l     printf_eofline
		jbsr      printf
		addq.l    #4,%SP
		jbra      _ExecCmd_Input_loop_end2

_ExecCmd_Input_show_text:
		move.l    4(%a5),-(%SP)
		pea.l     printf_s
		jbsr      printf
		addq.l    #4+4,%SP
		jbra      _ExecCmd_Input_loop_end

_ExecCmd_Input_ParamAT:
		lea.l     PARAM_PRINT_AT,%a0			|Place curseur de texte aux coordonnes spcifies par AT
		clr.w     (%a0)			
		move.w    PARAM_PRINT_REAL_ATy,-(%SP)
		move.w    PARAM_PRINT_REAL_ATx,-(%SP)
		ROM_CALL  MoveTo
		addq.l    #2+2,%SP
		dbf       %d6,_ExecCmd_Input_loop
		jbra      TokensExec_EndTokenCmd
		
ExecCmd_Input:
		jbsr      TokensExec_CNumArg
		tst.w     %d6
		jbeq      _ERROR_few_arguments
				
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		
		tst.w     PARAM_PRINT_AT
		jbeq      _ExecCmd_Input_continue			
		cmpi.b    #OPRD_POINT_VIRGULE,(%a5)		|Oprande
		jbne      _ExecCmd_Input_continue
		subq.l    #1,%d6
		lea.l     -12(%a5),%a5				|Donnes suivante
_ExecCmd_Input_continue:
		movea.l   %a5,%a3
		moveq.l   #0,%d5
		move.w    %d6,%d5
		subq.l    #1,%d5
		tst.w     PARAM_PRINT_AT
		jbne      _ExecCmd_Input_ParamAT
		dbf       %d6,_ExecCmd_Input_loop
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Input_loop:
		move.b    (%a5),%d0				|Oprande
		tst.l     %d6
		jbne      _ExecCmd_Input_loop_next
		cmpi.b    #OPRD_STRING,%d0
		jbeq      _ERROR_syntax
		cmpi.b    #OPRD_POINT_VIRGULE,%d0
		jbeq      _ERROR_syntax
		
_ExecCmd_Input_loop_next:
		jbsr      TokensExec_CheckTableVar
		
		subq.b    #OPRD_STRING,%d0
		jbcs      _ERROR_incorrect_arg
		subq.b    #2,%d0
		jbls      _ExecCmd_Input_loop_next2		|#OPRD_VAR ou #OPRD_VARTABLE
		subq.b    #3,%d0				|#OPRD_POINT_VIRGULE
		jbeq      _ExecCmd_Input_loop_end2
		
		cmp.w     %d5,%d6
		jbne      _ERROR_incorrect_arg
_ExecCmd_Input_loop_next2:		
		|Affiche texte
		cmpi.b    #OPRD_STRING,(%a5)
		jbeq      _ExecCmd_Input_show_text
_ExecCmd_Input_loop_Incorrect_Input:
		move.w    %d5,%d0
		subq.w    #1,%d0
		cmp.w     %d0,%d6
		jbne      _ExecCmd_Input_show_interro
		cmpi.b    #OPRD_STRING,(%a3)
		jbne      _ExecCmd_Input_show_interro
		cmpi.b    #OPRD_POINT_VIRGULE,-12(%a3)
		jbne      _ExecCmd_Input_loop_next3     
_ExecCmd_Input_show_interro:		
		|Point d'interrogation
		pea.l     printf_i
		jbsr      printf
		addq.l    #4,%SP
_ExecCmd_Input_loop_next3:
		move.w    PARAM_INPUT_LENGTH,%d1
		move.l    string_buffer,%a2
		jbsr      Func_InputStr
		
		|Chane de caractre
		cmpi.b    #TYPE_STRING,1(%a5)
		jbeq      _ExecCmd_Input_write_string
		
		|Nombre avec base (&H, &X ou &O)
		moveq.l   #0,%d1
		move.w    %d0,%d1
		dbf       %d1,_ExecCmd_Input_loop_find_base
		jbra      _ExecCmd_Input_loop_next4
_ExecCmd_Input_loop_find_base:
		cmpi.b    #'&',(%a2)
		jbeq	  _ExecCmd_Input_write_base
		cmpi.b    #32,(%a2)+
		jbne      _ExecCmd_Input_loop_next4
		dbf       %d1,_ExecCmd_Input_loop_find_base
		jbra      _ExecCmd_Input_loop_Error_input
|Ecriture d'un simple nombre
_ExecCmd_Input_loop_next4:
		addq.w    #1,%d1
		move.w    %d1,%d0
		lea.l     -1(%a2),%a0
		movea.l   %a0,%a1
		jbsr      Func_StrToFloat
		tst.w     %d7
		jbeq      _ExecCmd_Input_loop_Error_input
		
|Vrification du nombre entr
		movea.l   4(%a5),%a3
		move.b    1(%a5),%d3				|Type
		subq.b    #TYPE_INTEGER,%d3
		jbeq      _ExecCmd_Input_write_number_integer
		subq.b    #1,%d3				|TYPE_BOOL
		jbeq      _ExecCmd_Input_write_number_bool
		move.l    %d0,(%a3)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a3)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a3)+				|Empile 2 octets fin flottant     
		
_ExecCmd_Input_loop_end:
		tst.w     %d6
		jbeq      _ExecCmd_Input_eofline
		cmpi.b    #OPRD_STRING,(%a5)
		jbne      _ExecCmd_Input_eofline
_ExecCmd_Input_loop_end2:		
		lea.l     -12(%a5),%a5				|Donnes suivante
		dbf       %d6,_ExecCmd_Input_loop
		jbsr      Func_kb_flush				|KeyFlush
		jbra      TokensExec_EndTokenCmd

|Erreur de donnes
_ExecCmd_Input_loop_Error_input:
		pea.l     printf_eofline
		jbsr      printf
		addq.l    #4,%SP
		|if (number (StartArg).operand==OPRD_STRING && (i==StartArg+1 || (i==StartArg+2 && number (StartArg+1).operand==OPRD_POINT_VIRGULE)))
		cmpi.b    #OPRD_STRING,(%a3)
		jbne      _ExecCmd_Input_loop_Incorrect_Input
		move.w    %d5,%d0
		subq.w    #1,%d0
		cmp.w     %d0,%d6
		jbeq      _ExecCmd_Input_loop_Error_input_next
		subq.w    #1,%d0
		cmp.w     %d0,%d6
		jbne      _ExecCmd_Input_loop_Incorrect_Input
		cmpi.b    #OPRD_POINT_VIRGULE,-12(%a3)
		jbne      _ExecCmd_Input_loop_Error_input_next
_ExecCmd_Input_loop_Error_input_next:
		move.l    4(%a3),-(%SP)
		pea.l     printf_s
		jbsr      printf
		addq.l    #4+4,%SP
		jbra      _ExecCmd_Input_loop_Incorrect_Input

|Ecriture des donnes
_ExecCmd_Input_write_string:
		|Allocation chane de caractre
		move.w    %d0,%d3
		movea.l   %a5,%a2
		jbsr      TokensExec_NewString
		
		|Ecriture des donnes
		move.w    %d3,%d0
		movea.l   %a0,%a1
		move.l    string_buffer,%a0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		jbra      _ExecCmd_Input_loop_end
		
|Ecriture d'un nombre dans une base!
_ExecCmd_Input_write_base:
		addq.w    #1,%d1
		jbsr      Func_StrToBase
		tst.w     %d7
		jbeq      _ExecCmd_Input_loop_Error_input
		movea.l   4(%a5),%a4				|Zone de donnes
		move.b    1(%a5),%d1				|Type
		subq.b    #TYPE_FLOAT,%d1
		jbeq      _ExecCmd_Input_write_base_float
		subq.b    #2,%d1				|#TYPE_BOOL
		jbeq      _ExecCmd_Input_write_base_bool
		move.l    %d0,(%a4)
		jbra      _ExecCmd_Input_loop_end
		
_ExecCmd_Input_write_base_float:
		move.l    %d0,-(%SP)
		move.w    #flt*4,-(%SP)				|Wrapper
		jbsr      __BC
		addq.l    #2+4,%SP
		movea.l   4(%a5),%a0
		move.l    %d0,(%a0)+				|Empile 4 octets dbut flottant
		move.l    %d1,(%a0)+				|Empile 4 octets suivant flottant
		move.w    %d2,(%a0)+				|Empile 2 octets fin flottant
		jbra      _ExecCmd_Input_loop_end
		
_ExecCmd_Input_write_base_bool:
		moveq.l   #0,%d1
		tst.l     %d0					|Si donnes -1 sinon 0
		sne       %d1
		move.b    %d1,(%a4)
		jbra      _ExecCmd_Input_loop_end

_ExecCmd_Input_write_number_integer:
		move.w    %d2,-(%SP)				|Empile fin flottant
		move.l    %d1,-(%SP)				|Empile milieu flottant
		move.l    %d0,-(%SP)				|Empile dbut flottant
		ROM_CALL  trunc
		lea.l     4+4+2(%SP),%SP
		move.l    %d0,(%a3)
		jbra      _ExecCmd_Input_loop_end
		
_ExecCmd_Input_write_number_bool:
		move.w    #0x4000,-(%SP)			|Place flottant = 0 dans SP
		clr.l     -(%SP)
		clr.l     -(%SP)				|Va  l'adresse o se trouve le flottant
		move.w    %d2,-(%SP)				|Empile fin flottant
		move.l    %d1,-(%SP)				|Empile milieu flottant
		move.l    %d0,-(%SP)				|Empile dbut flottant
		ROM_CALL  fcmp
		lea.l     4+4+2+4+4+2(%SP),%SP
		tst.l     %d0					|Si %d0 diffrent de 0
		sne       %d0					|Remplie %d0 de 1 Flag Z
		move.b    %d0,(%a3)
		jbra      _ExecCmd_Input_loop_end

|====|
|TEXT|
|====|
|l<0
_ExecCmd_Text_inf_l:
		neg.w     %d5
		movea.l   4(%a3),%a0				|%a0 = ptr
		moveq.l   #0,%d0
		move.w    2(%a3),%d0				|%d1 = size
		subq.w    #1,%d0
_ExecCmd_Text_inf_l_loop_string:
		cmpi.b    #32,(%a0)+
		jbne      _ExecCmd_Text_inf_l_loop_string_next
		addq.w    #1,%d7
_ExecCmd_Text_inf_l_loop_string_next:		
		dbf       %d0,_ExecCmd_Text_inf_l_loop_string
		jbra      _ExecCmd_Text_arg_l_next

|Argument l		
_ExecCmd_Text_arg_l:
		MACRO_ConvertType 	#TYPE_INTEGER, -36	|Argument l
		moveq.l   #0,%d7				|ncar
		movea.l   -32(%a5),%a0
		move.w    2(%a0),%d5
		jblt      _ExecCmd_Text_inf_l
|l>=0		
_ExecCmd_Text_sup_l:
		move.w    2(%a3),%d7				|ncar = size-1
		subq.w    #1,%d7
		moveq.l   #-1,%d4				|adjust_car = TRUE
		
_ExecCmd_Text_arg_l_next:
		tst.w     %d7					|!ncar
		jbeq      _ExecCmd_Text_next
		tst.w     %d5					|!l
		jbeq      _ExecCmd_Text_next
		
		moveq.l   #-1,%d3				|adjust_x = TRUE				
		move.w    PARAM_FONT,-(%SP)
		move.l    4(%a3),-(%SP)
		ROM_CALL  DrawStrWidth
		addq.l    #6,%SP
		sub.w     %d0,%d5				|l-DrawStrWidth
		divs.w    %d7,%d5				|%d5 = %d5/ncar
		jbra      _ExecCmd_Text_next	
		
ExecCmd_Text:
		jbsr      TokensExec_CNumArg
		cmpi.w    #3,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		cmpi.b    #TYPE_STRING,1(%a5)			|Si pas string dernier argument
		jbne      _ERROR_incorrect_arg
		cmpi.w    #4,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		
		movea.l   %a5,%a3				|Sauvegarde zone chane de caractres
		tst.w     2(%a5)				|size = 0
		jbeq      _ExecCmd_Text_end
		
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes		
		MACRO_ConvertType 	#TYPE_INTEGER, -12	|X
		MACRO_ConvertType 	#TYPE_INTEGER, -24	|Y
		
		moveq.l   #0,%d5				|Ajustement l
		moveq.l   #0,%d3				|adjust_x
		moveq.l   #0,%d4				|adjust_car
		
		cmpi.b    #4,%d6
		jbeq      _ExecCmd_Text_arg_l
		
_ExecCmd_Text_next:		
		movea.l   -8(%a5),%a0
		move.w    2(%a0),%d6				|X
		movea.l   -20(%a5),%a0
		move.w    2(%a0),%d7				|Y
		
		moveq.l   #0,%d2
		move.w    2(%a3),%d2
		subq.w    #1,%d2
		movea.l   4(%a3),%a3				|ptr
_ExecCmd_Text_loop_draw_char:
		move.l    %d2,-(%SP)
		
		|DrawClipChar (x, y, ptr [i], &(SCR_RECT){{0, 0, LCD_WIDTH-1, LCD_HEIGHT-1}}, A_NORMAL);
		move.w    #A_NORMAL,-(%SP)
		pea.l     SCR_RECT
		clr.w     %d0
		move.b    (%a3),%d0
		move.w    %d0,-(%SP)				|car
		move.w    %d7,-(%SP)				|Y
		move.w    %d6,-(%SP)				|X
		ROM_CALL  DrawClipChar
		
		|x += FontCharWidth (ptr [i]); //PARAM_FONT_DIVX;
		clr.w     %d0
		move.b    (%a3)+,%d0
		move.w    %d0,-(%SP)
		ROM_CALL  FontCharWidth
		lea.l     14(%SP),%SP
		add.w     %d0,%d6				|x += %d0
		
		move.l    (%SP)+,%d2
		
		|if (i+1<size && adjust_x && ((!adjust_car && ptr [i+1]==32) || adjust_car))
		|  x += l;
		tst.w     %d3
		jbeq      _ExecCmd_Text_end_loop
		tst.w     %d2
		jbeq      _ExecCmd_Text_end_loop
		tst.w     %d4
		jbne      _ExecCmd_Text_adjust_x
		cmpi.b    #32,(%a3)
		jbne      _ExecCmd_Text_end_loop
_ExecCmd_Text_adjust_x:
		add.w     %d5,%d6				|x += l
_ExecCmd_Text_end_loop:				|ptr += 1
		dbf       %d2,_ExecCmd_Text_loop_draw_char		
_ExecCmd_Text_end:
		jbra      TokensExec_EndTokenCmd

|====|
|PLOT|
|====|		
ExecCmd_Plot:
		MACRO_Cmd_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		MACRO_ConvertType 	#TYPE_INTEGER, 12
		
		movea.l   4(%a5),%a0
		move.w    2(%a0),%d1				|Y
		movea.l   16(%a5),%a0
		move.w    2(%a0),%d0				|X
		movea.l   #LCD_MEM,%a0
		
		|Clippage
		cmpi.w    #MAX_LCD_WIDTH,%d0
		jbhi      TokensExec_EndTokenCmd
		cmpi.w    #MAX_LCD_HEIGHT,%d1
		jbhi      TokensExec_EndTokenCmd
		
		add.w     %d1,%d1				|Y *= 2
		move.w    %d1,%d2				|Y->%d2
		lsl.w     #4,%d2				|%d2 *= 16
		sub.w     %d1,%d2				|%d2 = Y*30
		
		move.w    %d0,%d1				|%d0->%d1
		lsr.w     #3,%d1				|%d1 /= 8
		add.w     %d1,%d2				|%d2 += %d1
		adda.w    %d2,%a0				|%a0 += %d2 soit %a0 += y*30+x/8
		
		andi.b    #7,%d0				|x0 &= 7
		moveq.l   #7,%d1
		sub.b     %d0,%d1
		bset.b    %d1,(%a0)
		jbra      TokensExec_EndTokenCmd

|====|
|LINE|
|====|		
ExecCmd_Line:
		MACRO_Cmd_CheckArg	#4
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		MACRO_ConvertType 	#TYPE_INTEGER, 12
		MACRO_ConvertType 	#TYPE_INTEGER, 24
		MACRO_ConvertType 	#TYPE_INTEGER, 36
		
		movea.l   4(%a5),%a0				|Number 1
		movea.l   16(%a5),%a1				|Number 2
		movea.l   28(%a5),%a2				|Number 3
		movea.l   40(%a5),%a3				|Number 4
		move.w    2(%a0),-(%SP)				|Number x...
		move.w    2(%a1),-(%SP)
		move.w    2(%a2),-(%SP)
		move.w    2(%a3),-(%SP)
		move.w    #A_NORMAL,-(%SP)			|Attribut
		pea.l     SCR_RECT				|SRC_RECT *clip
		pea.l     6(%SP)
		ROM_CALL  DrawClipLine
		lea.l     4+4+2+2+2+2+2(%SP),%SP
		jbra      TokensExec_EndTokenCmd
		
|====|
|READ|
|====|
_ExecCmd_Read_type_MSB:
		lsr.b     #4,%d0				|MSB
		jbra      _ExecCmd_Read_loop_continue
		
_ExecCmd_Read_float:
		subq.l    #4,%a2				|Saute adresse tableau...
		move.l    (%a0),-(%a2)				|Empile adresse dans ES
		subq.l    #2,%a2				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_FLOAT,-(%a2)			|Empile type de donnes
		move.b    #OPRD_NUMBER,-(%a2)			|Empile Oprande
		add.l     #SIZE_FLOAT,(%a0)			|Avance pointeur de donnes
		move.b    #TYPE_FLOAT,%d0			|Type pour data
		jbra      _ExecCmd_Read_loop_continue2

_ExecCmd_Read_integer16:
		movea.l   (%a0),%a1				|Zone de donne
		clr.w     -16(%a2)				|Efface MSB du nombre temporaire
		move.w    (%a1),-14(%a2)			|Nombre sur 16 Bits
		lea.l     -16(%a2),%a1				|%a1 = Adresse de la donne temporaire
		subq.l    #4,%a2				|Saute adresse tableau...
		move.l    %a1,-(%a2)				|Empile adresse dans ES
		subq.l    #2,%a2				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_INTEGER,-(%a2)			|Empile type de donnes
		move.b    #OPRD_NUMBER,-(%a2)			|Empile Oprande
		addq.l    #SIZE_INTEGER16,(%a0)			|Avance pointeur de donnes
		move.b    #TYPE_INTEGER,%d0			|Type pour data
		jbra      _ExecCmd_Read_loop_continue2
		
_ExecCmd_Read_integer32:
		subq.l    #4,%a2				|Saute adresse tableau...
		move.l    (%a0),-(%a2)				|Empile adresse dans ES
		subq.l    #2,%a2				|Saute les 2 octets d'infos supplmentaires
		move.b    #TYPE_INTEGER,-(%a2)			|Empile type de donnes
		move.b    #OPRD_NUMBER,-(%a2)			|Empile Oprande
		addq.l    #SIZE_INTEGER,(%a0)			|Avance pointeur de donnes
		move.b    #TYPE_INTEGER,%d0			|Type pour data
		jbra      _ExecCmd_Read_loop_continue2

_ExecCmd_Read_string_add_NULL:
		addq.l    #1,(%a0)
		jbra      _ExecCmd_Read_loop_continue2

_ExecCmd_Read_write_float:
		move.l    (%a1)+,(%a0)+				|Ecrit flottant
		move.l    (%a1)+,(%a0)+
		move.w    (%a1),(%a0)
		jbra      _ExecCmd_Read_loop_continue3
		
_ExecCmd_Read_write_integer:
		move.l    (%a1),(%a0)
		jbra      _ExecCmd_Read_loop_continue3
		
		
ExecCmd_Read:
		jbsr      TokensExec_CNumArg
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		lea.l     -16(%SP),%SP				|Dfinie zone temporaire ES+Nombre temporaire
		subq.w    #1,%d6
_ExecCmd_Read_loop:
		|Out of data?
		lea.l     sDATA_number,%a0			|Donne en cours
		move.w    (%a0),%d1				|%d1 = sDATA_number
		cmp.w     sDATA_total_number,%d1		|Dpassement des donnes
		jbcc      _ERROR_out_of_data	
		addi.w    #1,(%a0)				|Donne suivante
				
		|Lecture type de la donne
		movea.l   sDATA_type_ptr,%a0			|Zone de typage dans %a0
		move.w    %d1,%d0				|%d0 = sDATA_number
		lsr.w     #1,%d0				|Prpare lecture de l'octet de typage
		adda.w    %d0,%a0 |lea.l     (%d0.w,%a0),%a0	|Ce place sur l'octet de typage
		move.b    (%a0),%d0				
		btst.b    #0,%d1				|Rcupre MSB ou LSB
		jbeq      _ExecCmd_Read_type_MSB		|MSB
		andi.b    #0x0F,%d0				|LSB
_ExecCmd_Read_loop_continue:
		|Avance pointeur de donne et ecriture d'une pile ES
		lea.l     sDATA_ptr,%a0				|Pointeur de donnes
		lea.l     16(%SP),%a2				|Zone ES temporaire!
		
		|Ecriture dans la pile temporaire ES
		subq.b    #DATA_INTEGER16,%d0
		jbeq      _ExecCmd_Read_integer16
		jbcs      _ExecCmd_Read_float			|#DATA_FLOAT
		subq.b    #1,%d0				|#DATA_INTEGER16
		jbeq      _ExecCmd_Read_integer32
_ExecCmd_Read_string:
		movea.l   (%a0),%a1				|Zone de donne
		moveq.l   #0,%d1				|Efface %d1
		move.w    (%a1),%d1				|Taille de la chane
		addq.l    #2,(%a0)				|Saute octet NULL+taille
		subq.l    #4,%a2				|Saute adresse tableau...
		move.l    (%a0),-(%a2)				|Empile adresse de la chane de caractres
		move.w    %d1,-(%a2)				|Empile taille de la chane de caractres
		move.b    #TYPE_STRING,-(%a2)			|Empile type de donnes
		move.b    #OPRD_STRING,-(%a2)			|Empile oprande
		addq.w    #1,%d1				|Caractre NULL
		add.l     %d1,(%a0)				|Avance de la taille de la chane
		move.b    #TYPE_STRING,%d0			|Type pour data
		btst.b    #0,%d1				|Si taille paire			
		jbne      _ExecCmd_Read_string_add_NULL
		
_ExecCmd_Read_loop_continue2:	
		|Conversion de type number -> var
		move.b    1(%a5),%d1
		jbsr      TokensExec_ConvertType	
		
		|Affectation
		move.b    1(%a5),%d0
		movea.l   4(%a2),%a1				|Number
		movea.l   4(%a5),%a0				|Variable
		subq.b    #TYPE_INTEGER,%d0
		jbeq      _ExecCmd_Read_write_integer
		jbcs      _ExecCmd_Read_write_float		|#TYPE_FLOAT
_ExecCmd_Read_write_string:
		|Cration allocation
		move.w	  2(%a2),%d3				|Taille de la chane de caractres source
		movea.l   4(%a2),%a3				|Zone chane de caractre source
		movea.l   %a5,%a2				|Zone pile ES, chaine de caractres de destination
		jbsr      TokensExec_NewString
		
		|Copie chane de caractre
		move.w    %d3,%d0				|Taille de la chane de caractre  copier
		movea.l   %a0,%a1
		movea.l   %a3,%a0
		jbsr      _memcpy
		clr.b     (%a1)					|Caractre NULL
		
_ExecCmd_Read_loop_continue3:		
		lea.l     -12(%a5),%a5				|Donnes suivante
		dbf       %d6,_ExecCmd_Read_loop
		lea.l     16(%SP),%SP				|Efface zone temporaire ES
		jbra      TokensExec_EndTokenCmd

|======|
|SPRITE|
|======|
/*SIMPLE SPRITE (NO MASKED)*/
/*ClipSprite16_OR_R Source ExtGraph v2.0 bta 4.0*/
_ExecCmd_Sprite_ClipSprite_NOMASK_MODE_or:
		or.l      %d1,(%a3)
		rts

_ExecCmd_Sprite_ClipSprite_NOMASK_MODE_xor:
		eor.l     %d1,(%a3)
		rts

_ExecCmd_Sprite_ClipSprite_NOMASK_MODE:
		cmpi.b    #SPRT_XOR,%d2
		jbeq      _ExecCmd_Sprite_ClipSprite_NOMASK_MODE_xor
		jbra      _ExecCmd_Sprite_ClipSprite_NOMASK_MODE_or

_ExecCmd_Sprite_ClipSprite_NOMASK:
    		cmpi.b    #SPRT_AND,%d2
    		jbeq      _ExecCmd_Sprite_ClipSprite_NOMASK_AND
    		
    		move.w    %d1,%d3				|%d3 = y
    		jbpl      _ExecCmd_Sprite_ClipSprite_NOMASK_9	|h > 0 ?

    		add.w     %d1,%d5				|%d5 = h + y
   		jbmi      _ExecCmd_Sprite_ClipSprite_NOMASK_0	|y + h < 0 ?

    		add.w     %d1,%d1				|%d1 = 2y
    		suba.w    %d1,%a4				|sprt -= 2y
    		moveq.l   #0,%d1				|offsety = 0
    		jbra      _ExecCmd_Sprite_ClipSprite_NOMASK_10

_ExecCmd_Sprite_ClipSprite_NOMASK_9:
    		add.w     %d5,%d3				|%d3 = h + y
    		subi.w    #MAX_LCD_HEIGHT,%d3			|%d3 = h + y - 127
    		jble      _ExecCmd_Sprite_ClipSprite_NOMASK_6	|h + y - 127 <= 0 ?
    		sub.w     %d3,%d5				|h -= h + y - 127 (h = 127-y)
    		jbmi      _ExecCmd_Sprite_ClipSprite_NOMASK_0

_ExecCmd_Sprite_ClipSprite_NOMASK_6:
    		move.w    %d1,%d3
    		lsl.w     #4,%d1
    		sub.w     %d3,%d1				|%d1 = y*15

_ExecCmd_Sprite_ClipSprite_NOMASK_10:
    		move.w    %d0,%d3				|%d3 = x
    		jble      _ExecCmd_Sprite_ClipSprite_NOMASK_8	|x < 0 ?
    		cmpi.w    #MAX_LCD_WIDTH-16,%d0
    		jbhi      _ExecCmd_Sprite_ClipSprite_NOMASK_7	|x > 239-15

    		lsr.w     #4,%d3				|%d3 = x/16
    		add.w     %d3,%d1				|%d3 = x/16 + y*15
    		add.w     %d1,%d1				|%d3 = x/8 + y*30
    		adda.w    %d1,%a3				|dest += offset

    		andi.w    #15,%d0
    		cmpi.w    #8,%d0
    		jbge      _ExecCmd_Sprite_ClipSprite_NOMASK_3
    
_ExecCmd_Sprite_ClipSprite_NOMASK_1:
    		moveq.l   #0,%d1
    		move.w    (%a4)+,%d1
    		swap      %d1
    		lsr.l     %d0,%d1
    		jbsr	  _ExecCmd_Sprite_ClipSprite_NOMASK_MODE
    		lea       30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_1
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_NOMASK_3:
    		moveq.l   #16,%d1
    		sub.w     %d0,%d1
    		
    		/*moveq.l   #16,%d6
    		sub.w     %d1,%d6
    		move.w    %d6,%d0*/
    		move.w    %d1,%d0
_ExecCmd_Sprite_ClipSprite_NOMASK_2:
    		moveq.l   #0,%d1
    		move.w    (%a4)+,%d1
    		/*swap      %d1
    		lsr.l     %d0,%d1*/
    		lsl.l     %d0,%d1
    		jbsr	  _ExecCmd_Sprite_ClipSprite_NOMASK_MODE
    		lea       30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_2

_ExecCmd_Sprite_ClipSprite_NOMASK_0:
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_NOMASK_8:
    		cmpi.w    #MIN_LCD_WIDTH-16,%d0
    		jble      _ExecCmd_Sprite_ClipSprite_NOMASK_0	|x <= -16 ?
    		neg.w     %d0					|shift = -x
    		add.w     %d1,%d1				|%d1 = y*30
    		adda.w    %d1,%a3				|dest += offset
    		
_ExecCmd_Sprite_ClipSprite_NOMASK_4:
    		moveq.l   #0,%d1
    		move.w    (%a4)+,%d1
    		swap      %d1
    		lsl.l     %d0,%d1				|shifting
    		jbsr	  _ExecCmd_Sprite_ClipSprite_NOMASK_MODE
    		lea.l     30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_4
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_NOMASK_7:
    		cmpi.w    #MAX_LCD_WIDTH,%d0
    		jbhi      _ExecCmd_Sprite_ClipSprite_NOMASK_0	|x > 239
    		andi.w    #15,%d0				|shiftx = x & 15
    		add.w     %d1,%d1				|%d1 = y*30
    		lea.l     28(%a3,%d1.w),%a3
    		
_ExecCmd_Sprite_ClipSprite_NOMASK_5:
    		moveq.l   #0,%d1
    		move.w    (%a4)+,%d1
    		lsr.l     %d0,%d1
    		swap      %d1
    		jbsr	  _ExecCmd_Sprite_ClipSprite_NOMASK_MODE
    		lea.l     30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_5
    		jbra      TokensExec_EndTokenCmd
    		
|Sprite NoMasked en mode AND
_ExecCmd_Sprite_ClipSprite_NOMASK_AND:
		move.w    %d1,%d3				|%d3 = y
    		jbpl      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_9	|h > 0 ?

    		add.w     %d1,%d5				|%d5 = h + y
   		jbmi      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_0	|y + h < 0 ?

    		add.w     %d1,%d1				|%d1 = 2y
    		suba.w    %d1,%a4				|sprt -= 2y
    		moveq.l   #0,%d1				|offsety = 0
    		jbra      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_10

_ExecCmd_Sprite_ClipSprite_NOMASK_AND_9:
    		add.w     %d5,%d3				|%d3 = h + y
    		subi.w    #MAX_LCD_HEIGHT,%d3			|%d3 = h + y - 127
    		jble      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_6	|h + y - 127 <= 0 ?
    		sub.w     %d3,%d5				|h -= h + y - 127 (h = 127-y)
    		jbmi      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_0

_ExecCmd_Sprite_ClipSprite_NOMASK_AND_6:
    		move.w    %d1,%d3
    		lsl.w     #4,%d1
    		sub.w     %d3,%d1				|%d1 = y*15

_ExecCmd_Sprite_ClipSprite_NOMASK_AND_10:
    		move.w    %d0,%d3				|%d3 = x
    		jble      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_8	|x < 0 ?
    		cmpi.w    #MAX_LCD_WIDTH-16,%d0
    		jbhi      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_7	|x > 239-15

    		lsr.w     #4,%d3				|%d3 = x/16
    		add.w     %d3,%d1				|%d3 = x/16 + y*15
    		add.w     %d1,%d1				|%d3 = x/8 + y*30
    		adda.w    %d1,%a3				|dest += offset
		moveq.l   #16,%d1
    		andi.w    #15,%d0
    		sub.w     %d0,%d1				| %d1 = 16 - (x & 15)
_ExecCmd_Sprite_ClipSprite_NOMASK_AND_1:
    		moveq.l   #-1,%d0
    		move.w    (%a4)+,%d0
    		rol.l     %d1,%d0
    		and.l     %d0,(%a3)
    		lea.l     30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_AND_1
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_NOMASK_AND_8:
    		cmpi.w    #MIN_LCD_WIDTH-16,%d0
    		jble      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_0	| x <= -16 ?
    		neg.w     %d0					| shift = -x
    		add.w     %d1,%d1				| %d1 = y*30
    		adda.w    %d1,%a3				| dest += offset
_ExecCmd_Sprite_ClipSprite_NOMASK_AND_4:
    		moveq.l   #-1,%d1
    		move.w    (%a4)+,%d1
    		rol.l     %d0,%d1				| shifting
    		and.w     %d1,(%a3)
    		lea.l     30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_AND_4
_ExecCmd_Sprite_ClipSprite_NOMASK_AND_0:
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_NOMASK_AND_7:
    		cmpi.w    #MAX_LCD_WIDTH,%d0
    		jbhi      _ExecCmd_Sprite_ClipSprite_NOMASK_AND_0	| x > 239
    		andi.w    #15,%d0				| shiftx = x & 15
    		add.w     %d1,%d1				| %d1 = y*30
    		lea.l     28(%a3,%d1.w),%a3
_ExecCmd_Sprite_ClipSprite_NOMASK_AND_5:
    		moveq.l   #-1,%d1
    		move.w    (%a4)+,%d1
    		lsr.l     %d0,%d1
    		and.w     %d1,(%a3)
    		lea.l     30(%a3),%a3
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_NOMASK_AND_5
    		jbra      TokensExec_EndTokenCmd
    				
		
/*MASKED SPRITE*/
/*ClipSprite16_MASK_R Source ExtGraph v2.0 bta 4.0*/
_ExecCmd_Sprite_ClipSprite_MASK_nointerlaced:
		lea.l     2(%a4),%a2
		moveq.l   #2,%d2				|Gestion mode non entrelac
		jbra      _ExecCmd_Sprite_ClipSprite_MASK_continue
		
_ExecCmd_Sprite_ClipSprite_MASK:    		
    		cmpi.b    #1,%d4
    		jbne      _ExecCmd_Sprite_ClipSprite_MASK_nointerlaced
    		move.w    %d5,%d3				|Zone de masque
    		addq.w    #1,%d3
    		add.w     %d3,%d3
    		lea.l     (%d3.w,%a4),%a2
    		moveq.l   #0,%d2				|Gestion mode entrelac
    		
_ExecCmd_Sprite_ClipSprite_MASK_continue:
    		move.w    %d1,%d3				|%d3 = y
    		jbpl      _ExecCmd_Sprite_ClipSprite_MASK_9	|h > 0 ?
 
    		add.w     %d1,%d5				|%d5 = y + h
    		jbmi      _ExecCmd_Sprite_ClipSprite_MASK_0	|y + h < 0 ?
    		add.w     %d1,%d1				|%d1 = 2y
    		move.w    %d2,%d6				|Gestion sprite masqu
    		lsr.w     #1,%d6
    		lsl.w     %d6,%d1
    		suba.w    %d1,%a4				|sprt -= 2y
    		suba.w    %d1,%a2				|mask -= 2y
    		moveq.l   #0,%d1				|offsety = 0
    		jbra      _ExecCmd_Sprite_ClipSprite_MASK_10
    		
_ExecCmd_Sprite_ClipSprite_MASK_9:
    		add.w     %d5,%d3				|%d3 = h + y
    		subi.w    #MAX_LCD_HEIGHT,%d3			|%d3 = h + y - 127
    		jble      _ExecCmd_Sprite_ClipSprite_MASK_6	|h + y - 127 <= 0 ?		
    		sub.w     %d3,%d5				|h -= h + y - 127 (h = 127-y)
    		jbmi      _ExecCmd_Sprite_ClipSprite_MASK_0

_ExecCmd_Sprite_ClipSprite_MASK_6:
    		move.w    %d1,%d3
    		lsl.w     #4,%d1
    		sub.w     %d3,%d1				|%d1 = y*15
    		
_ExecCmd_Sprite_ClipSprite_MASK_10:
    		move.w    %d0,%d3				|%d3 = x
    		jble      _ExecCmd_Sprite_ClipSprite_MASK_8	|x < 0 ?
    		cmpi.w    #MAX_LCD_WIDTH-16,%d0
    		jbhi      _ExecCmd_Sprite_ClipSprite_MASK_7	|x > 239-15

    		lsr.w     #4,%d3				|%d3 = x/16
    		add.w     %d3,%d1				|%d3 = x/16 + y*15
    		add.w     %d1,%d1				|%d3 = x/8 + y*30
    		adda.w    %d1,%a3				|dest += offset
    		moveq.l   #16,%d1
    		andi.w    #15,%d0
    		sub.w     %d0,%d1				|%d1 = 16 - (x & 15)

_ExecCmd_Sprite_ClipSprite_MASK_1:
    		move.l    (%a3),%d3

    		moveq.l   #-1,%d0
    		move.w    (%a2)+,%d0
    		rol.l     %d1,%d0
    		and.l     %d0,%d3

    		moveq.l   #0,%d0
    		move.w    (%a4)+,%d0
    		lsl.l     %d1,%d0
    		or.l      %d0,%d3

    		move.l    %d3,(%a3)
    		lea.l     30(%a3),%a3
    		adda.w    %d2,%a4				|Gestion du sprite
    		adda.w    %d2,%a2				|Gestion du masque
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_MASK_1
    		
_ExecCmd_Sprite_ClipSprite_MASK_0:
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_MASK_8:
    		cmpi.w    #MIN_LCD_WIDTH-16,%d0
    		jble      _ExecCmd_Sprite_ClipSprite_MASK_0     |x <= -16 ?
    		neg.w     %d0					|shift = -x
    		add.w     %d1,%d1				|%d1 = y*30
    		adda.w    %d1,%a3				|dest += offset
    		
_ExecCmd_Sprite_ClipSprite_MASK_4:
    		move.w    (%a3),%d3

    		moveq.l   #-1,%d1
    		move.w    (%a2)+,%d1
    		rol.l     %d0,%d1
    		and.w     %d1,%d3

    		move.w    (%a4)+,%d1
    		lsl.w     %d0,%d1				|shifting
    		or.w      %d1,%d3

    		move.w    %d3,(%a3)
    		lea.l     30(%a3),%a3
    		adda.w    %d2,%a4				|Gestion du sprite
    		adda.w    %d2,%a2				|Gestion du masque
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_MASK_4
    		jbra      TokensExec_EndTokenCmd

_ExecCmd_Sprite_ClipSprite_MASK_7:  
    		cmpi.w    #MAX_LCD_WIDTH,%d0
    		jbhi      _ExecCmd_Sprite_ClipSprite_MASK_0	|x > 239
    		andi.w    #15,%d0				|shiftx = x & 15
    		add.w     %d1,%d1				|%d1 = y*30
    		lea.l     28(%a3,%d1.w),%a3
    		
_ExecCmd_Sprite_ClipSprite_MASK_5:
    		move.w    (%a3),%d3

    		moveq.l   #-1,%d1
    		move.w    (%a2)+,%d1
    		asr.l     %d0,%d1
    		and.w     %d1,%d3

    		move.w    (%a4)+,%d1
    		lsr.w     %d0,%d1
    		or.w      %d1,%d3

    		move.w    %d3,(%a3)
    		lea.l     30(%a3),%a3
    		adda.w    %d2,%a4				|Gestion du sprite
    		adda.w    %d2,%a2				|Gestion du masque
    		dbf       %d5,_ExecCmd_Sprite_ClipSprite_MASK_5
		jbra      TokensExec_EndTokenCmd		

_ExecCmd_Sprite_mode:
		MACRO_ConvertType 	#TYPE_INTEGER, -36
		
		movea.l   -32(%a5),%a0
		move.w    2(%a0),%d2
		jbra      _ExecCmd_Sprite_continue
		
_ExecCmd_Sprite_lcd_mem:
		MACRO_ConvertType 	#TYPE_INTEGER, -48		
		
		movea.l   -44(%a5),%a3
		movea.l   (%a3),%a3
		jbra      _ExecCmd_Sprite_continue2

_ExecCmd_Sprite_lenght_nomasked:
		addq.w    #6,%d1				|Ajoute taille header du sprite
		cmp.w     %d1,%d0
		jbcs      _ERROR_sprite_length_wrong
		jbra      _ExecCmd_Sprite_continue3
		
ExecCmd_Sprite:
		jbsr      TokensExec_CNumArg
		cmpi.w    #5,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		cmpi.w    #3,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		
		|Sprite
		move.b    (%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		cmpi.b    #TYPE_STRING,1(%a5)			|Type
		jbne      _ERROR_types_incompatible
		
		movea.l   4(%a5),%a4				|Pointeur donnes sprite
		addq.l    #4,%a4				|Saute coordonnes x,y
		move.b    (%a4)+,%d4				|Masked?
		moveq.l   #0,%d5				|Efface %d5
		move.b    (%a4)+,%d5  				|Hauteur en bits
		
		|Taille du sprite incorrecte?
		move.w    2(%a5),%d0				|Taille du sprite
		moveq.l   #0,%d1				|Efface %d1
		move.b    %d5,%d1				|%d1 = Hauteur
		add.w     %d1,%d1				|%d1 = Taille d'un sprite non masqu
		
		tst.b     %d4
		jbeq      _ExecCmd_Sprite_lenght_nomasked
		|Sprite mask
		add.w     %d1,%d1				|%d1 = Taille d'un sprite masqu
		addq.w    #6,%d1				|Ajoute taille header du sprite
		cmp.w     %d1,%d0
		jbcs      _ERROR_sprite_length_wrong
_ExecCmd_Sprite_continue3:
		|Coordonne X
		MACRO_ConvertType 	#TYPE_INTEGER, -12
		
		|Coordonne Y
		MACRO_ConvertType 	#TYPE_INTEGER, -24
				
		|Zone mmoire
		cmpi.w    #5,%d6
		movea.l   #LCD_MEM,%a3				|Zone mmoire par dfaut
		jbeq      _ExecCmd_Sprite_lcd_mem
_ExecCmd_Sprite_continue2:
		|Mode d'affichage
		move.w    #SPRT_OR,%d2
		cmpi.w    #4,%d6
		jbcc      _ExecCmd_Sprite_mode
_ExecCmd_Sprite_continue:
		|Coordonnes
		movea.l   -8(%a5),%a0				|X
		move.w    2(%a0),%d0
		movea.l   -20(%a5),%a0				|Y
		move.w    2(%a0),%d1
		dbf       %d5,_ExecCmd_Sprite_continue4
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Sprite_continue4:		
		|Affichage du sprite
		tst.b     %d4
		jbne      _ExecCmd_Sprite_ClipSprite_MASK
		jbra      _ExecCmd_Sprite_ClipSprite_NOMASK
		
|===|
|GET|
|===|
_ExecCmd_Get_Copy:
		subq.w    #1,%d6				|Hauteur -= 1
		
		add.w     %d1,%d1				|Y *= 2
		move.w    %d1,%d2				|Y->%d2
		lsl.w     #4,%d2				|%d2 *= 16
		sub.w     %d1,%d2				|%d2 = Y*30
		
		move.w    %d0,%d1				|%d0->%d1
		lsr.w     #3,%d1				|%d1 /= 8
		add.w     %d1,%d2				|%d2 += %d1
		adda.w    %d2,%a3				|%a3 += %d2 soit %a3 += y*30+x/8

		moveq.l   #30,%d1				|Nombre d'octets  sauter ligne suivante
		sub.w     %d5,%d1				|%d1 -= Bytewidth
		subq.w    #2,%d5				|Byetewidth -= 2
		
		|Masque dernier octet
		move.w    %d4,%d2				|%d2 = Largeur
		moveq.l   #-1,%d4				|Mask
		andi.w    #7,%d2				|%d2 &= 7
		jbeq      _ExecCmd_Get_mask_end
		lsr.b     %d2,%d4
		not.b     %d4
_ExecCmd_Get_mask_end:		
		andi.w    #7,%d0				|Sprite  adresse absolue
		jbeq      _ExecCmd_Get_absolute
		
		moveq.l   #8,%d2				|8-shift
		sub.w	  %d0,%d2				|Dcalage->%d2
		
		tst.w     %d5					|Bytewidth = 1
		jblt      _ExecCmd_Get_single_bytewidth
		
_ExecCmd_Get_columns:
		moveq.l   #0,%d7
		move.w    %d5,%d7				|%d7 = Bytewidth
_ExecCmd_Get_line:
		move.b	  (%a3)+,%d3
		lsl.b	  %d0,%d3
		move.b	  %d3,(%a0)
		
		move.b	  (%a3),%d3
		lsr.b	  %d2,%d3
		or.b	  %d3,(%a0)+
		dbf       %d7,_ExecCmd_Get_line
		
		|Dernier octet
		move.b	  (%a3)+,%d3
		lsl.b	  %d0,%d3
		move.b	  %d3,(%a0)
		
		move.b	  (%a3),%d3
		lsr.b	  %d2,%d3
		or.b	  %d3,(%a0)
		and.b     %d4,(%a0)+
		
		adda.w    %d1,%a3
		dbf       %d6,_ExecCmd_Get_columns		
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Get_single_bytewidth:
		move.b	  (%a3)+,%d3
		lsl.b	  %d0,%d3
		move.b	  %d3,(%a0)
		
		move.b	  (%a3),%d3
		lsr.b	  %d2,%d3
		or.b	  %d3,(%a0)
		and.b     %d4,(%a0)+
		
		adda.w    %d1,%a3
		dbf       %d6,_ExecCmd_Get_single_bytewidth
		jbra      TokensExec_EndTokenCmd
		

_ExecCmd_Get_absolute:
		tst.w     %d5					|Bytewidth = 1
		jblt      _ExecCmd_Get_absolute_single_bytewidth
		
		|Bytewidth > 0
_ExecCmd_Get_absolute_columns:
		moveq.l   #0,%d0		
		move.w    %d5,%d0				|%d0 = Byewidth
_ExecCmd_Get_absolute_line:
		move.b    (%a3)+,(%a0)+
		dbf       %d0,_ExecCmd_Get_absolute_line
		
		|Dernier octet
		move.b    (%a3)+,%d2
		and.b     %d4,%d2
		move.b    %d2,(%a0)+
		
		adda.w    %d1,%a3
		dbf       %d6,_ExecCmd_Get_absolute_columns
		jbra      TokensExec_EndTokenCmd		

_ExecCmd_Get_absolute_single_bytewidth:
		addq.w    #1,%d1				|Octets entre chaque lignes
_ExecCmd_Get_absolute_single_bytewidth_columns:		
		move.b    (%a3),%d2
		and.b     %d4,%d2
		move.b    %d2,(%a0)+
		adda.w    %d1,%a3
		dbf       %d6,_ExecCmd_Get_absolute_single_bytewidth_columns
		jbra      TokensExec_EndTokenCmd

		
_ExecCmd_Get_lcd_mem:
		MACRO_ConvertType 	#TYPE_INTEGER, -60		
		
		movea.l   -56(%a5),%a3
		movea.l   (%a3),%a3
		jbra      _ExecCmd_Get_continue
		
ExecCmd_Get:
		jbsr      TokensExec_CNumArg
		cmpi.w    #6,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		cmpi.w    #5,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		
		MACRO_ConvertType 	#TYPE_INTEGER, 0	|Coordonne X0
		MACRO_ConvertType 	#TYPE_INTEGER, -12	|Coordonne Y0
		MACRO_ConvertType 	#TYPE_INTEGER, -24	|Coordonne X1
		MACRO_ConvertType 	#TYPE_INTEGER, -36	|Coordonne Y1
		
		|Chane de caractres
		move.b    -48(%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		move.b    -47(%a5),%d0				|Type
		cmpi.b    #TYPE_STRING,%d0
		jbne      _ERROR_types_incompatible
				
		|Zone mmoire
		cmpi.w    #6,%d6
		movea.l   #LCD_MEM,%a3				|Zone mmoire par dfaut
		jbeq      _ExecCmd_Get_lcd_mem
		
_ExecCmd_Get_continue:
		movea.l   4(%a5),%a0				|X0
		move.w    2(%a0),%d0
		movea.l   -8(%a5),%a0				|Y0
		move.w    2(%a0),%d1
		movea.l   -20(%a5),%a0				|X1
		move.w    2(%a0),%d2
		movea.l   -32(%a5),%a0				|Y1
		move.w    2(%a0),%d3
		
		|Taille des donnes en cctets
		move.w    %d2,%d4				|Taille du sprite en largeur = X1-X0
		sub.w     %d0,%d4
		addq.w    #1,%d4
		move.w    %d3,%d6
		sub.w     %d1,%d6				|Taille du sprite en hauteur = Y1-Y0
		addq.w    #1,%d6
		
		|Calcul de bytewidth
		move.w    %d4,%d3
		addq.w    #7,%d3
		asr.w     #3,%d3
		move.w    %d3,%d5
		muls.w    %d6,%d3
		jble      _ERROR_incorrect_arg
		
		|Sauvegarde X0 et Y0
		move.w    %d1,-(%SP)
		move.w    %d0,-(%SP)
		
		|Cration de la chane de caractres
		addq.w    #4,%d3				|Taille header sprite
		lea.l     -48(%a5),%a2
		jbsr      TokensExec_NewString
		
		|Restaure coordonnes
		move.w    (%SP)+,%d0				|X0
		move.w    (%SP)+,%d1				|Y0
				
		|Header sprite
		move.w    %d4,(%a0)+				|Largeur
		move.w    %d6,(%a0)+      			|Hauteur
		jbra      _ExecCmd_Get_Copy
		
|===|
|PUT|
|===|
_ExecCmd_Put_Draw:
		|Zone de non affichage
		move.w    %d2,%d5				|%d5 = Bytewidth
		neg.w     %d5					|%d5 = -Bytewidth
		lsl.w     #3,%d5				|-Bytewidth*8
		cmp.w     %d5,%d0				|x<=%d5
		jble      TokensExec_EndTokenCmd
		cmpi.w    #MAX_LCD_WIDTH+1,%d0
		jbge      TokensExec_EndTokenCmd
		move.w    %d3,%d5				|%d5 = h
		neg.w     %d5					|%d5 = -h
		cmp.w     %d5,%d1
		jblt      TokensExec_EndTokenCmd
		cmpi.w    #MAX_LCD_HEIGHT+1,%d1
		jbge      TokensExec_EndTokenCmd
		
		|y<0
		tst.w     %d1
		jbge      _ExecCmd_Put_Draw_continue
		add.w     %d1,%d3				|h += y
		move.w    %d1,%d5				|%d5 = y
		muls.w    %d2,%d5				|y*Bytewidth
		suba.w    %d5,%a0				|sprite -= y*Bytewidth
		moveq.l   #0,%d1
_ExecCmd_Put_Draw_continue:
		|y+1>=MAX_LCD_HEIGHT
		move.w    %d1,%d5				|%d5 = y
		add.w     %d3,%d5				|%d5 = y+h
		cmpi.w    #MAX_LCD_HEIGHT+1,%d5
		jblt      _ExecCmd_Put_Draw_continue2
		move.w    #MAX_LCD_HEIGHT+1,%d3			|h = MAX_LCD_HEIGHT
		sub.w     %d1,%d3				|h = MAX_LCD_HEIGHT-y
_ExecCmd_Put_Draw_continue2:
		move.w    %d1,%d5				|%d5 = y
		add.w     %d5,%d5				|y*2
		asl.w     #5,%d1				|%d1 = y<<5
		sub.w     %d5,%d1				|(y<<5)-(y<<1)
		move.w    %d0,%d5				|%d5 = x
		asr.w     #3,%d5				|%d5 = x>>8
		add.w     %d5,%d1
		adda.w    %d1,%a3				|offset
		
		move.w    %d0,%d1				|%d1 = x
		andi.w    #7,%d1				|%d1 = x&7
		
		moveq.l   #8,%d4
		sub.w     %d1,%d4				|8-%d1
		
		move.w    #30,%d5
		sub.w     %d2,%d5
		
		|x<0
		tst.w     %d0
		jblt      _ExecCmd_Put_Draw_left
		move.w    %d2,%d6				|%d6 = Bytewidth
		lsl.w     #3,%d6				|%d6 = Bytewidth<<3
		add.w     %d0,%d6				|%d6 = (Bytewidth<<3)+x
		cmpi.w    #MAX_LCD_WIDTH+1,%d6
		jbge      _ExecCmd_Put_Draw_right
_ExecCmd_Put_Draw_normal:
		moveq.l   #0,%d0
		move.w    %d3,%d0
		dbf       %d0,_ExecCmd_Put_Draw_normal_loop
		jbra      TokensExec_EndTokenCmd
_ExecCmd_Put_Draw_normal_loop:
		moveq.l   #0,%d3
		move.b    (%a0),%d3
		lsr.w     %d1,%d3
		or.b      %d3,(%a3)+
		
		moveq.l   #0,%d7
		move.w    %d2,%d7
		subq.w    #1,%d7
		dbf       %d7,_ExecCmd_Put_Draw_normal_loop2
		jbra      _ExecCmd_Put_Draw_normal_loop2_continue
_ExecCmd_Put_Draw_normal_loop2:
		moveq.l   #0,%d3
		move.b    (%a0)+,%d3
		lsl.w     %d4,%d3
		or.b      %d3,(%a3)
		moveq.l   #0,%d3
		move.b    (%a0),%d3
		lsr.w     %d1,%d3
		or.b      %d3,(%a3)+
		dbf       %d7,_ExecCmd_Put_Draw_normal_loop2
_ExecCmd_Put_Draw_normal_loop2_continue:
		moveq.l   #0,%d3
		move.b    (%a0)+,%d3
		lsl.w     %d4,%d3
		or.b      %d3,(%a3)
		adda.w    %d5,%a3 |lea.l     (%d5.w,%a3),%a3
		dbf       %d0,_ExecCmd_Put_Draw_normal_loop				
		jbra      TokensExec_EndTokenCmd

_ExecCmd_Put_Draw_left:
		neg.w     %d0					|x = -x
		move.w    %d0,%d6
		lsr.w     #3,%d6
		
		move.w    %d6,%d7
		lsl.w     #3,%d7
		cmp.w     %d7,%d0
		jbeq      _ExecCmd_Put_Draw_left_continue
		addq.w    #1,%d6		
_ExecCmd_Put_Draw_left_continue:
		moveq.l   #0,%d0
		move.w    %d3,%d0
		dbf       %d0,_ExecCmd_Put_Draw_left_loop
		jbra      TokensExec_EndTokenCmd
_ExecCmd_Put_Draw_left_loop:
		subq.l    #1,%a0		
		adda.w    %d6,%a0 |lea.l     (%d6.w,%a0),%a0
		adda.w    %d6,%a3 |lea.l     (%d6.w,%a3),%a3
		
		moveq.l   #0,%d7
		move.w    %d2,%d7
		sub.w     %d6,%d7
		dbf       %d7,_ExecCmd_Put_Draw_left_loop2
		jbra      _ExecCmd_Put_Draw_left_loop2_continue
_ExecCmd_Put_Draw_left_loop2:
		moveq.l   #0,%d3
		move.b    (%a0)+,%d3
		lsl.w     %d4,%d3
		or.b      %d3,(%a3)
		moveq.l   #0,%d3
		move.b    (%a0),%d3
		lsr.w     %d1,%d3
		or.b      %d3,(%a3)+
		dbf       %d7,_ExecCmd_Put_Draw_left_loop2
_ExecCmd_Put_Draw_left_loop2_continue:
		moveq.l   #0,%d3
		move.b    (%a0)+,%d3
		lsl.w     %d4,%d3
		or.b      %d3,(%a3)
		adda.w    %d5,%a3 |lea.l     (%d5.w,%a3),%a3
		dbf       %d0,_ExecCmd_Put_Draw_left_loop		
		jbra      TokensExec_EndTokenCmd
		
_ExecCmd_Put_Draw_right:
		subi.w    #MAX_LCD_WIDTH+1,%d6
		asr.w     #3,%d6
		moveq.l   #0,%d0
		move.w    %d3,%d0
		dbf       %d0,_ExecCmd_Put_Draw_right_loop
		jbra      TokensExec_EndTokenCmd
_ExecCmd_Put_Draw_right_loop:
		moveq.l   #0,%d3
		move.b    (%a0),%d3
		lsr.w     %d1,%d3
		or.b      %d3,(%a3)+
		
		moveq.l   #0,%d7
		move.w    %d2,%d7
		sub.w     %d6,%d7
		subq.w    #1,%d7
		dbf       %d7,_ExecCmd_Put_Draw_right_loop2
		jbra      _ExecCmd_Put_Draw_right_loop2_continue
_ExecCmd_Put_Draw_right_loop2:
		moveq.l   #0,%d3
		move.b    (%a0)+,%d3
		lsl.w     %d4,%d3
		or.b      %d3,(%a3)
		moveq.l   #0,%d3
		move.b    (%a0),%d3
		lsr.w     %d1,%d3
		or.b      %d3,(%a3)+
		dbf       %d7,_ExecCmd_Put_Draw_right_loop2
_ExecCmd_Put_Draw_right_loop2_continue:		
		addq.l    #1,%a0
		adda.w    %d6,%a0 |lea.l     (%d6.w,%a0),%a0
		adda.w    %d6,%a3 |lea.l     (%d6.w,%a3),%a3
		adda.w    %d5,%a3 |lea.l     (%d5.w,%a3),%a3
		dbf       %d0,_ExecCmd_Put_Draw_right_loop		
		jbra      TokensExec_EndTokenCmd

_ExecCmd_Put_mode:
		MACRO_ConvertType 	#TYPE_INTEGER, -36
		
		movea.l   -32(%a5),%a0
		move.w    2(%a0),%d4
		jbra      _ExecCmd_Put_continue
		
_ExecCmd_Put_lcd_mem:
		MACRO_ConvertType 	#TYPE_INTEGER, -48	
		
		movea.l   -44(%a5),%a3
		movea.l   (%a3),%a3
		jbra      _ExecCmd_Put_continue2
		
ExecCmd_Put:
		jbsr      TokensExec_CNumArg
		cmpi.w    #5,%d6				|Trop d'arguments
		jbhi      _ERROR_too_arguments
		cmpi.w    #3,%d6				|Pas assez d'arguments
		jbcs      _ERROR_few_arguments
		
		movea.l   ptrEnd_ES,%a5				|Place la pile au dbut de la premire donnes
		lea.l     -12(%a5),%a5
		
		|Coordonne X
		MACRO_ConvertType 	#TYPE_INTEGER, 0
		
		|Coordonne Y
		MACRO_ConvertType 	#TYPE_INTEGER, -12
		
		|Chane de caractres
		move.b    -24(%a5),%d0				|Oprande
		jbsr      TokensExec_CheckTableVar
		
		move.b    -23(%a5),%d0				|Type
		cmpi.b    #TYPE_STRING,%d0
		jbne      _ERROR_types_incompatible
		
		|Mode d'affichage
		move.w    #MODE_OR,%d4
		cmpi.w    #4,%d6
		jbcc      _ExecCmd_Put_mode
_ExecCmd_Put_continue:
		|Zone mmoire
		cmpi.w    #5,%d6
		movea.l   #LCD_MEM,%a3				|Zone mmoire par dfaut
		jbeq      _ExecCmd_Put_lcd_mem
		
_ExecCmd_Put_continue2:
		movea.l   4(%a5),%a0				|X
		move.w    2(%a0),%d0
		movea.l   -8(%a5),%a0				|Y
		move.w    2(%a0),%d1
		
		|Header chane de caractres
		movea.l   -20(%a5),%a0				|Zone chane de caractres
		move.w    (%a0)+,%d2				|Largeur
		move.w    (%a0)+,%d3				|Hauteur
		
		|Bytewidth
		addq.w    #7,%d2
		asr.w     #3,%d2
		jbra      _ExecCmd_Put_Draw
		
|=====|
|POINT|
|=====|		
ExecFnc_Point:
		MACRO_Func_CheckArg	#2
		MACRO_ConvertType 	#TYPE_INTEGER, 0	|Y
		MACRO_ConvertType 	#TYPE_INTEGER, 12	|X
		
		movea.l   4(%a5),%a0
		move.w    2(%a0),%d2				|Y
		movea.l   16(%a5),%a0
		move.w    2(%a0),%d1				|X
		movea.l   #LCD_MEM,%a0
		
		add.w     %d2,%d2				|Y *= 2
		move.w    %d2,%d3				|Y->%d3
		lsl.w     #4,%d3				|%d3 *= 16
		sub.w     %d2,%d3				|%d3 = Y*30
		
		move.w    %d1,%d2				|%d1->%d2
		lsr.w     #3,%d2				|%d2 /= 8
		add.w     %d2,%d3				|%d3 += %d2
		adda.w    %d3,%a0				|%a0 += %d3 soit %a0 += y*30+x/8
		
		moveq.l   #0,%d0
		andi.b    #7,%d1				|x0 &= 7
		moveq.l   #7,%d2
		sub.b     %d1,%d2
		btst.b    %d2,(%a0)
		sne       %d0
		jbra      TokensExec_AddResult_Func_Bool		

		.end
		