|=============================================================================================
|Constantes
|=============================================================================================  
  .global _comment
  .global GTK_Signature
  .global GTK_Version
  .global GTK_Tokens_Section
  .global FontLib_FileName
  
  .global printf_f
  .global printf_ld
  .global printf_d
  .global printf_s
  .global printf_i
  .global printf_space
  .global printf_eofline
  .global printf_inputstr1
  .global printf_inputstr2
  
  .global EMPTY_STRING
  
  .text
comment:
  .string "GFA_TEM V1.0"
  .even
  
GTK_Signature:
  .ascii  "GFA_GTK"		  |7 octets
  .even
  
GTK_Version:
  .byte	  1
  .even
  
GTK_Tokens_Section:
  .ascii   "TK"			  |2 octets
  .even
  
FontLib_FileName:
  .ascii   "gfa_font\0"
  .even

printf_f:
  .ascii   "%f\0"
printf_ld:
  .ascii   "%ld\0"
printf_d:
  .ascii   "%d\0"
printf_s:
  .ascii   "%s\0"
printf_i:
  .ascii   "? \0"
printf_space:
  .ascii   " \0"
printf_eofline:
  .ascii   "\12\0"
printf_inputstr1:
  .ascii   "%s_   \0"
printf_inputstr2:
  .ascii   "%s   \0"
  .even
EMPTY_STRING:
  .word    0
  .even


|=============================================================================================
|Variables
|=============================================================================================
  .global Start_Variables
  
  |Divers
  .global SaveScreen
  .global string_buffer
  
  |Gestion erreur
  |.global error_number
  .global error_line
  
  |Gestion fichier
  .global TokensFile_Name
  .global TokensFile_NameSize
  .global TokensFile_SymEntry
  .global TokensFile_Handle
  .global TokensFile_Data
  .global TokensFile_DataPtr
  .global TokensFile_DataMaxAdr
  .global TokensFile_Size
  .global Buffer_FindFile
  
  |Structure DATA
  .global sDATA_start_ptr
  .global sDATA_total_number
  .global sDATA_type_ptr
  .global sDATA_ptr
  .global sDATA_number
  
  |Nombre de variables
  .global nVar_Float
  .global nVar_Int
  .global nVar_Bool
  .global nVar_String
  
  .global nVar_TFloat
  .global nVar_TInt
  .global nVar_TBool
  .global nVar_TString
  
  |Pointeurs allocations
  .global MEM_VARS
  .global MEM_TABS
  
  .global VAR_FLOAT
  .global VAR_INTEGER
  .global VAR_BOOL
  .global VAR_STRING
  
  .global TAB_FLOAT
  .global TAB_INTEGER
  .global TAB_BOOL
  .global TAB_STRING
  
  |Zone mmoire piles
  .global ptrStart_ES	    	    |Pointeur de donnes de la pile ES (Execution Stack), dbut de la pile
  .global ptrEnd_ES		    |Pointeur de donnes de la pile ES (Execution Stack), fin de la pile	
  .global ptrData_DT		    |Pointeur de donnes de la pile DT (Data Tampon)
  .global DTO			    |Adresse d'criture pour DT
  .global ptrData_FOR		    |Pointeur de variables pour les boucles FORs, dbut de la pile
  .global ptrFOR		    |Pointeur actuelle de variables pour les boucles FORs
  .global ptrStart_LocalVar	    |Pointeur de vrification dpassement pile!
  .global ptrLocalVar		    |Pointeur de donnes en cours
  .global ptrEnd_LocalVar           |Pointeur de fin variable locale marque fin chanes de caractres
  .global ptrStart_LocalVarString   |Pointeur absolue de dbut chanes de caractres
  .global ptrLocalVarString         |Pointeur de dbut de lecture des chanes de caractres
  
  |Interruptions
  .global SetInts
  .global OldExcept0
  .global OldExcept1
  .global OldExcept2
  .global OldExcept3
  .global OldExcept4
  .global OldExcept5
  .global OldInt1
  .global OldInt2
  .global OldInt5
  .global OldInt6
  .global __SAVE_LINK__
  .global __SAVE_USP__
  .global __SAVE_SR__
  .global counter_time
  .global __COUNTER_HARDWARE
  .global __COUNTER_TIMER
  .global HARDWARE_VERSION
  .global CALCULATOR
  .global AMS_1xx
  .global LCD_WIDTH
  .global LCD_HEIGHT
  .global LCD_LINE_BYTES
  .global SCR_RECT
  .global ROM_BASE
  
  |Parameters
  .global PARAM_PRINT_AT
  .global PARAM_PRINT_ATx
  .global PARAM_PRINT_ATy
  .global PARAM_PRINT_REAL_ATx
  .global PARAM_PRINT_REAL_ATy
  .global PARAM_SHOW_ENDTEXT
  .global PARAM_REPEAT_KEYDELAY
  .global PARAM_BETWEEN_KEYDELAY
  .global PARAM_PRINT_DIGITS
  .global PARAM_FONTLIB
  .global PARAM_FONTLIB_MODE
  .global PARAM_FONTLIB_GRAPHMODE
  .global PARAM_FONT 
  .global PARAM_FONT_DIVx
  .global PARAM_FONT_DIVy
  .global PARAM_CURATTR
  .global PARAM_SPRITE_LCD_MEM
  .global PARAM_INPUT_LENGTH

  .global End_Variables
  

|-----------------------
|Dbut section variables
|-----------------------  
  .bss
  .even
Start_Variables:  

SaveScreen:	       .space 4
string_buffer:         .space 4
  
|error_number:          .space 2
error_line:	       .space 2
 
TokensFile_Name:       .space 18
TokensFile_NameSize:   .space 2

TokensFile_SymEntry:   .space 4
TokensFile_Handle:     .space 2
TokensFile_Data:       .space 4
TokensFile_DataPtr:    .space 4
TokensFile_DataMaxAdr: .space 4
TokensFile_Size:       .space 2
Buffer_FindFile:       .space 18
    
sDATA_start_ptr:       .space 4
sDATA_total_number:    .space 2
sDATA_type_ptr:	       .space 4
sDATA_ptr:             .space 4
sDATA_number:	       .space 2
 
nVar_Float:	       .space 1
nVar_Int:	       .space 1
nVar_Bool:	       .space 1
nVar_String:	       .space 1

nVar_TFloat:	       .space 1
nVar_TInt:	       .space 1
nVar_TBool:	       .space 1
nVar_TString:	       .space 1

MEM_VARS:	       .space 4
MEM_TABS:	       .space 4

VAR_FLOAT:	       .space 4
VAR_INTEGER:	       .space 4
VAR_BOOL:	       .space 4
VAR_STRING:	       .space 4

TAB_FLOAT:	       .space 4
TAB_INTEGER:	       .space 4
TAB_BOOL:	       .space 4
TAB_STRING:	       .space 4 
 
ptrStart_ES:	       .space 4
ptrEnd_ES:	       .space 4
ptrData_DT:            .space 4
DTO:		       .space 4
ptrData_FOR:	       .space 4
ptrFOR:		       .space 4
ptrStart_LocalVar:     .space 4
ptrLocalVar:           .space 4
ptrEnd_LocalVar:       .space 4
ptrStart_LocalVarString:.space 4
ptrLocalVarString:     .space 4
  
SetInts:	       .space 2  
OldExcept0:            .space 4
OldExcept1:            .space 4
OldExcept2:            .space 4
OldExcept3:            .space 4
OldExcept4:            .space 4
OldExcept5:            .space 4
OldInt1:	       .space 4
OldInt2:	       .space 4
OldInt5:	       .space 4
OldInt6:	       .space 4
__SAVE_LINK__:	       .space 4
__SAVE_USP__:	       .space 4
__SAVE_SR__:           .space 2
counter_time:	       .space 4
__COUNTER_HARDWARE:    .space 2
__COUNTER_TIMER:       .space 2
HARDWARE_VERSION:      .space 2
CALCULATOR:	       .space 2
AMS_1xx:               .space 2
LCD_WIDTH:	       .space 2
LCD_HEIGHT:	       .space 2
LCD_LINE_BYTES:	       .space 2
SCR_RECT:	       .space 4
ROM_BASE:	       .space 4
   
PARAM_PRINT_AT:	       .space 2
PARAM_PRINT_ATx:       .space 2
PARAM_PRINT_ATy:       .space 2
PARAM_PRINT_REAL_ATx:  .space 2
PARAM_PRINT_REAL_ATy:  .space 2
PARAM_SHOW_ENDTEXT:    .space 2
PARAM_REPEAT_KEYDELAY: .space 2
PARAM_BETWEEN_KEYDELAY:.space 2
PARAM_PRINT_DIGITS:    .space 2
PARAM_FONTLIB:	       .space 2   |Utilisation de la librairie = -1
PARAM_FONTLIB_MODE:    .space 2
PARAM_FONTLIB_GRAPHMODE: .space 2
PARAM_FONT:            .space 2 
PARAM_FONT_DIVx:       .space 2
PARAM_FONT_DIVy:       .space 2
PARAM_CURATTR:	       .space 2
PARAM_SPRITE_LCD_MEM:  .space 4
PARAM_INPUT_LENGTH:    .space 2
  .even

End_Variables:
  .end
  
    