// C Source File
// Created 29/09/2006; 21:28:12

#include "tbl_tags.h"
#include "tbl_structs.h"
#include "tigcclib.h"
#include "error.h"
#include "memory.h"
#include "expr_find.h"
#include "tags.h"
#include "ETokenisor.h"

bool isInProcedure;
bool FirstProcedure;
unsigned short ProcedureOffset;
unsigned short *TblProcedureJump;
s_GotoJump *TblGosubJump;
unsigned short nTblGosubJump;

s_LabelJump *TblLabelJump;
s_GotoJump *TblGotoJump;
unsigned short nTblGotoJump;

s_GotoJump *TblRestoreJump;
unsigned short nTblRestoreJump;

unsigned char *TblStruct;
unsigned short nTblStruct;
unsigned short nTblStructExitIf;
unsigned char *nTblExitIf;
unsigned short *TblExitIf;
unsigned short TotalExitIf;

unsigned short nTblStructContinue;
unsigned char *nTblContinue;
unsigned short *TblContinue;
unsigned short TotalContinue;
unsigned short *TblStructContinue_address;

s_IFJump *Tbl_IF_Jump;
unsigned short n_IF_Jump;
unsigned short *Tbl_ElseIf_Address;
unsigned short TotalElseIf;
unsigned short *Tbl_Do_Address;
unsigned short TotalDo;
unsigned short *Tbl_Repeat_Address;
unsigned short TotalRepeat;
unsigned short *Tbl_While_Address_If;
unsigned short *Tbl_While_Address_Jump;
unsigned short TotalWhile;
s_FORJump *Tbl_FOR_Jump;
unsigned short TotalFor;

const char GFA_ETOKENISOR_HEADER_SIGNATURE[7] = "GFA_GTK";
const unsigned char GFA_ETOKENISOR_HEADER_VERSION[1] = {1};

static GFA_ERROR_NUMBER ExprTokens_MakeGotoJump (GFA_ETokensBuffer *buffer);
static void ExprTokens_MakeRestoreJump (GFA_ETokensBuffer *buffer);
static void ExprTokens_MakeGosubJump (GFA_ETokensBuffer *buffer);
static GFA_ERROR_NUMBER ExprTokens_CheckStruct (void);
static GFA_ERROR_NUMBER ExprTokens_NewStruct (unsigned char x);
static void ExprTokens_DelStruct (GFA_ETokensBuffer *buffer, unsigned short address);
static bool ExprTokens_FindStruct (unsigned char fstruct);
static void ExprTokens_MakeAddress(GFA_ETokensBuffer *buffer, unsigned short pos, unsigned short offset);

GFA_ETokensBuffer GFA_ETokenisor_CreateBuffer() {
	isInProcedure = FALSE;
	FirstProcedure = FALSE;
	
  TblProcedureJump = NULL;
	TblGosubJump = NULL;
	
	TblLabelJump = NULL;
	TblGotoJump = NULL;
	TblRestoreJump = NULL;
	Tbl_IF_Jump = NULL;
	Tbl_ElseIf_Address = NULL;
	Tbl_Do_Address = NULL;
	Tbl_Repeat_Address = NULL;
	Tbl_While_Address_If = NULL;
	Tbl_While_Address_Jump = NULL;
	Tbl_FOR_Jump = NULL;
	
	TblStruct = NULL;
	nTblExitIf = NULL;
	TblExitIf = NULL;
	nTblContinue = NULL;
	TblContinue = NULL;
	TblStructContinue_address = NULL;
	
	//Procdures
	TblProcedureJump = GFA_Memory_Alloc(MAX_PROCEDURE * sizeof (unsigned short));
	memset (TblProcedureJump, 0x00, MAX_PROCEDURE*sizeof (unsigned short));
	
	//Gosubs
	TblGosubJump = GFA_Memory_Alloc(MAX_GOSUB * sizeof (s_GotoJump));
	
	//Labels
	TblLabelJump = GFA_Memory_Alloc(MAX_LABEL * sizeof (s_LabelJump));
	memset (TblLabelJump, 0x00, MAX_LABEL*sizeof (s_LabelJump));
	
	//Gotos
	TblGotoJump = GFA_Memory_Alloc(MAX_GOTO * sizeof (s_GotoJump));
		
	//Restore
	TblRestoreJump = GFA_Memory_Alloc(MAX_RESTORE * sizeof (s_GotoJump));
		
	//Liste des structures
	TblStruct = GFA_Memory_Alloc(MAX_STRUCT * sizeof (unsigned char));
	
	nTblExitIf = GFA_Memory_Alloc(MAX_EXITIF * sizeof (unsigned char));
	TblExitIf = GFA_Memory_Alloc(MAX_EXITIF * sizeof (unsigned short));
	
	nTblContinue = GFA_Memory_Alloc(MAX_CONTINUE * sizeof (unsigned char));
	TblContinue = GFA_Memory_Alloc(MAX_CONTINUE * sizeof (unsigned short));
	TblStructContinue_address = GFA_Memory_Alloc(MAX_CONTINUE * sizeof (unsigned short));
		
	//IFs
	Tbl_IF_Jump = GFA_Memory_Alloc(MAX_IF * sizeof (s_IFJump));
	
	//ElseIf
	Tbl_ElseIf_Address = GFA_Memory_Alloc(MAX_ELSEIF * sizeof (unsigned short));
	
	//Do...Loop
	Tbl_Do_Address = GFA_Memory_Alloc(MAX_DO * sizeof (unsigned short));
	
	//Repeat...Until
	Tbl_Repeat_Address = GFA_Memory_Alloc(MAX_REPEAT * sizeof (unsigned short));
	
	//While...Wend
	Tbl_While_Address_If = GFA_Memory_Alloc(MAX_WHILE * sizeof (unsigned short));
	Tbl_While_Address_Jump = GFA_Memory_Alloc(MAX_WHILE * sizeof (unsigned short));
	
	//For.To. ...Next.
	Tbl_FOR_Jump = GFA_Memory_Alloc(MAX_FOR * sizeof (s_FORJump));
	
	GFA_ETokensBuffer buffer = GFA_MemoryBuffer_Create();
	GFA_MemoryBuffer_SetCurrentAddress(&buffer, sizeof(GFA_ETokenisor_Header), GFA_SEEK_SET);
	return buffer;
}


inline void GFA_ETokenisor_DeleteBuffer(GFA_ETokensBuffer *buffer) {
  Assert(buffer);
  
  if (TblProcedureJump) GFA_Memory_Free (TblProcedureJump);
	if (TblGosubJump) GFA_Memory_Free (TblGosubJump);
	
	if (TblLabelJump) GFA_Memory_Free (TblLabelJump);
	if (TblGotoJump) GFA_Memory_Free (TblGotoJump);
	if (TblRestoreJump) GFA_Memory_Free (TblRestoreJump);
	if (TblStruct) GFA_Memory_Free (TblStruct);
	
	if (nTblExitIf) GFA_Memory_Free (nTblExitIf);
	if (TblExitIf) GFA_Memory_Free (TblExitIf);
	
	if (nTblContinue) GFA_Memory_Free (nTblContinue);
	if (TblContinue) GFA_Memory_Free (TblContinue);
	if (TblStructContinue_address) GFA_Memory_Free (TblStructContinue_address);
	
	if (Tbl_IF_Jump) GFA_Memory_Free (Tbl_IF_Jump);
	if (Tbl_ElseIf_Address) GFA_Memory_Free (Tbl_ElseIf_Address);
	
	if (Tbl_Do_Address) GFA_Memory_Free (Tbl_Do_Address);
	if (Tbl_Repeat_Address) GFA_Memory_Free (Tbl_Repeat_Address);
	if (Tbl_While_Address_If) GFA_Memory_Free (Tbl_While_Address_If);
	if (Tbl_While_Address_Jump) GFA_Memory_Free (Tbl_While_Address_Jump);
	
	if (Tbl_FOR_Jump) GFA_Memory_Free (Tbl_FOR_Jump);
	
	GFA_MemoryBuffer_Delete(buffer);
}


GFA_ERROR_NUMBER GFA_ETokenisor_WriteStackTag(GFA_ETokensBuffer *buffer, const GFA_StackTag *stack_tag) {
	Assert(buffer);
	
	// Nous sommes dans la zone des commandes du parseur, ne pas tokeniser
  if (!GFA_Tag_GetParserAreaDefined(stack_tag))
    return GFA_ERR_OK; 
	
	bool write_line = false;
	
	for (unsigned short i = 0; i < GFA_Tag_GetStackSize(stack_tag); ++i) {
		const GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
			
		if (tag->symbol==GFA_SYMBOL_ENDTAG) {
			GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_ENDTAG);
		}
		else if (tag->tag==GFA_TAG_VALUE) {
			if (!((unsigned long)GFA_MemoryBuffer_GetCurrentAddress(buffer) & 1)) GFA_MemoryBuffer_WriteByte(buffer, 0x00);
			
			if (tag->subtag==GFA_SUBTAG_INT_S32) {
				GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_NUMBER_INT);
				GFA_MemoryBuffer_WriteLong(buffer, tag->info.number.value_S32);
			}
			else if (tag->subtag==GFA_SUBTAG_FLOAT) {
				GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_NUMBER_FLOAT);
				GFA_MemoryBuffer_WriteData(buffer, &tag->info.number.value_float, sizeof(float));
			}
			else if (tag->subtag==GFA_SUBTAG_STRING) {
				GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_STRING);
				GFA_MemoryBuffer_WriteByte(buffer, GFA_String_GetSize(&tag->expr));
				GFA_MemoryBuffer_WriteData(buffer, GFA_String_GetStr(&tag->expr), GFA_String_GetSize(&tag->expr));
				GFA_MemoryBuffer_WriteByte(buffer, 0x00);
			}
		}
		else if ((tag->tag==GFA_TAG_VAR) || (tag->tag==GFA_TAG_VARTABLE)) {
			unsigned short mark = (tag->tag==GFA_TAG_VAR)?ETOKEN_VAR_FLOAT:ETOKEN_VAR_TFLOAT;
			if (tag->subtag==GFA_SUBTAG_INT_S32) ++mark;
			else if (tag->subtag==GFA_SUBTAG_BOOL) mark += 2;
			else if (tag->subtag==GFA_SUBTAG_STRING) mark += 3;
			
			GFA_MemoryBuffer_WriteByte(buffer, mark);
			GFA_MemoryBuffer_WriteByte(buffer, tag->info.index);
		}
		else if (tag->tag==GFA_TAG_MATH) {
			if (tag->subtag==GFA_SUBTAG_AFFEC_LEFT)    {GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_AFFEC); write_line = true;}
			else if (tag->subtag==GFA_SUBTAG_ADD)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_ADD);
			else if (tag->subtag==GFA_SUBTAG_SUB)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_SUB);
			else if (tag->subtag==GFA_SUBTAG_MUL)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_MUL);
			else if (tag->subtag==GFA_SUBTAG_DIV)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_DIV);
			else if (tag->subtag==GFA_SUBTAG_EXP)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_PUISS);
			else if (tag->subtag==GFA_SUBTAG_DIV_INT) GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_DIVINT);
			else if (tag->subtag==GFA_SUBTAG_MOD)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_MATH_MOD);
			else if (tag->subtag==GFA_SUBTAG_NEGATIF) GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_NEGATIF);
		}
		else if (tag->tag==GFA_TAG_LOGIC) {
			GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_LOGIC_NOT + (tag->subtag - 1));
		}
		else if (tag->tag==GFA_TAG_COMPARE) {
			if (tag->subtag==GFA_SUBTAG_EGAL)          GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_COMPARE_EGAL);
			else if (tag->subtag==GFA_SUBTAG_INFERIOR) GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_COMPARE_INFERIOR);
			else if (tag->subtag==GFA_SUBTAG_SUPERIOR) GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_COMPARE_SUPERIOR);
			else if (tag->subtag==GFA_SUBTAG_INFEGAL)  GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_COMPARE_INFEGAL);
			else if (tag->subtag==GFA_SUBTAG_SUPEGAL)  GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_COMPARE_SUPEGAL);
			else if (tag->subtag==GFA_SUBTAG_DIFF)     GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_COMPARE_DIFF);
		}
		else if (tag->tag==GFA_TAG_SIGN) {
			if (tag->subtag==GFA_SUBTAG_POINT_COMMA) GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_POINT_VIRGULE);
			else if (tag->subtag==GFA_SUBTAG_APOST)  GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_APOST);
		}
		else if (tag->symbol==GFA_SYMBOL_FUNCTION) {
			unsigned short token = ETOKEN_FUNC_DIM + GFA_Lib_Object_GetTokenIndex(&tag->info.library.object);
			GFA_MemoryBuffer_WriteByte(buffer, token);
			if ((token==ETOKEN_FUNC_END) || (token==ETOKEN_FUNC_RUN)) write_line = true;
			else write_line = (GFA_Tag_GetFromStack(stack_tag, i + 1)->symbol==GFA_SYMBOL_EOFLINE);
		}
		
		//Label
		else if (tag->symbol==GFA_SYMBOL_LABEL)
		{
		  TblLabelJump [tag->info.index].address = GFA_MemoryBuffer_GetSize(buffer);	//Adresse du label
		  TblLabelJump [tag->info.index].data_number = 0; //iData_Number;	//Dernire donne
		  TblLabelJump [tag->info.index].data_ptr = 0; //Data_TokensFile_size; //Pointe sur la dernire donne
		  TblLabelJump [tag->info.index].isInLoop = (ExprTokens_FindStruct (GFA_STRUCT_FOR));
		  TblLabelJump [tag->info.index].ProcedureOffset = isInProcedure?ProcedureOffset:0;
		  break;
		}
		
		else if (tag->tag==GFA_TAG_STRUCT) {
			switch (tag->struct_idx) {
				case GFA_STRUCT_PRINT:
				{
					GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_FUNC_PRINT);
					write_line = true;
					break;
				}
				
				case GFA_STRUCT_AT:
				{
					GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_FUNC_AT);
					break;
				}
		    
		    //Goto
		    case GFA_STRUCT_GOTO:
		    {		
			    //Goto dans Loop?
			    if (ExprTokens_FindStruct (GFA_STRUCT_FOR))
			      return ERROR_INCORRECT_GOTO;
			
			    //Token
			    GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_JUMP);
			
			    //Adresse connue
			    if (TblLabelJump [tag->info.index].address) 
			    {
			      //Label dans Loop ou hors procdure?
			      if ((TblLabelJump [tag->info.index].isInLoop) 
			       || (TblLabelJump [tag->info.index].ProcedureOffset!=(isInProcedure?ProcedureOffset:0))) {
			  	    return ERROR_INCORRECT_GOTO;}
			      
			      ExprTokens_MakeAddress(buffer, TblLabelJump [tag->info.index].address, 0);
			    }
			    else
			    {
				    //Evite Goto hors procdure
				    TblGotoJump [nTblGotoJump].ProcedureOffset = isInProcedure?ProcedureOffset:0;
				
				    //Prparation du saut
				    TblGotoJump [nTblGotoJump].lbl_index = tag->info.index;
				    TblGotoJump [nTblGotoJump++].token_address = GFA_MemoryBuffer_GetSize(buffer);
				
				    //Adresse
				    GFA_MemoryBuffer_WriteShort(buffer, 0);
			    }
			    
			    break;
	    	}
				
				default:;
			}
		}
		
		if ((tag->symbol==GFA_SYMBOL_EOFLINE) || write_line) {
			GFA_MemoryBuffer_WriteShort(buffer, 0);
			while (++i < GFA_Tag_GetStackSize(stack_tag)) {
				tag = GFA_Tag_GetFromStack(stack_tag, i);
				if (tag->symbol!=GFA_SYMBOL_EOFLINE) {
					--i;
					break;
				}
		  }
				
			continue;
		}
	}
	
	return GFA_ERR_OK;
}


GFA_ERROR_NUMBER GFA_ETokenisor_CreateFile(GFA_ETokensBuffer *buffer, const char *file, const GFA_StackExprFind *stack_expr_find) {
	Assert(buffer && file && stack_expr_find);
	
	GFA_MemoryBuffer_WriteByte(buffer, ETOKEN_FUNC_END);
	
	GFA_ETokenisor_Header header;
	memcpy (header.file_id, "GFA_GTK", 7);
	header.version = 1;
	header.tokens_size = GFA_MemoryBuffer_GetSize(buffer) - sizeof(header);
	header.number_data = 0;
	header.offset_data = header.tokens_size;
	header.nfloat = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_FLOAT);
	header.ninteger = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_S32);
	header.nbool = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_BOOL);
	header.nstring = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_STRING);
	header.ntblfloat = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_TAB_FLOAT);
	header.ntblinteger = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_TAB_S32);
	header.ntblbool = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_TAB_BOOL);
	header.ntblstring = GFA_ExprFind_GetStackSize(stack_expr_find, GFA_EXPR_TAB_STRING);
	memcpy (header.section_tk, "TK", 2);
	
	memcpy(GFA_MemoryBuffer_GetBeginAddress(buffer), &header, sizeof(header));
	return GFA_File_GenerateFileFromMemoryBuffer(buffer, file, "GTK");
}


//***************************************
//Attribution des adresses pour les GOTOS
//***************************************
GFA_ERROR_NUMBER ExprTokens_MakeGotoJump (GFA_ETokensBuffer *buffer)
{
	unsigned short address, token_address;
	
	//Parcours sauts  effectuer
	for (unsigned short i=0; i<nTblGotoJump; i++)
	{
		//Label dans Loop ou Goto hors procedure?
		if ((TblLabelJump [TblGotoJump [i].lbl_index].isInLoop) 
		 || (TblLabelJump [TblGotoJump [i].lbl_index].ProcedureOffset!=TblGotoJump [i].ProcedureOffset))
		{
		  return ERROR_INCORRECT_GOTO;
		}
		
		token_address = TblGotoJump [i].token_address;
		address = TblLabelJump [TblGotoJump [i].lbl_index].address;
		
		
		
		ExprTokens_MakeAddress (buffer, token_address, address);
	}
	
	return GFA_ERR_OK;
}


//******************************************
//Attribution des adresses pour les RESTOREs
//******************************************
void ExprTokens_MakeRestoreJump (GFA_ETokensBuffer *buffer)
{
  unsigned short data_number, data_ptr, token_address;
	
	//Parcours sauts  effectuer
	for (unsigned short i=0; i<nTblRestoreJump; i++)
	{
		token_address = TblRestoreJump [i].token_address;
		data_number = TblLabelJump [TblRestoreJump [i].lbl_index].data_number;
		data_ptr = TblLabelJump [TblRestoreJump [i].lbl_index].data_ptr;
		
		ExprTokens_MakeAddress (buffer, token_address, data_number);
		ExprTokens_MakeAddress (buffer, token_address+sizeof (unsigned short), data_ptr);
	}
}


//******************************************
//Attribution des adresses pour les GOSUBs
//******************************************
void ExprTokens_MakeGosubJump (GFA_ETokensBuffer *buffer)
{
  unsigned short address, token_address;
	
	//Parcours sauts  effectuer
	for (unsigned short i=0; i<nTblGosubJump; i++)
	{
		token_address = TblGosubJump [i].token_address;
		address = TblProcedureJump [TblGosubJump [i].lbl_index];
		
		ExprTokens_MakeAddress (buffer, token_address, address);
	}
}

//********************************************
//Vrifie si il ne manque pas un Endif...
//********************************************
GFA_ERROR_NUMBER ExprTokens_CheckStruct (void)
{
	if (n_IF_Jump) return ERROR_IF;
	if (TotalDo) return ERROR_DO;
	if (TotalRepeat) return ERROR_REPEAT;
	if (TotalWhile) return ERROR_WHILE;
	if (TotalFor) return ERROR_FOR;
	
	if (isInProcedure) return ERROR_PROCEDURE;
	return GFA_ERR_OK;
}

//**********************************************************
//Ajoute une structure
//**********************************************************
GFA_ERROR_NUMBER ExprTokens_NewStruct (unsigned char x)
{
	if (nTblStruct>=MAX_STRUCT) return ERROR_STRUCT_OVERFLOW;
	
	TblStruct [nTblStruct++] = x; 
	if (x!=STRUCT_IF) 
	{
		if (nTblStructExitIf>=MAX_EXITIF) return ERROR_EXITIF_OVERFLOW;
		nTblExitIf [nTblStructExitIf++] = 0;
		
		if (nTblStructContinue>=MAX_CONTINUE) return ERROR_CONTINUE_OVERFLOW;
		nTblContinue [nTblStructContinue++] = 0;
	}
		
	return GFA_ERR_OK;
}

//**********************************************************
//Efface structure
//**********************************************************
void ExprTokens_DelStruct (GFA_ETokensBuffer *buffer, unsigned short address)
{
	if (TblStruct [--nTblStruct]==STRUCT_IF) return;
	unsigned char nExitIf = nTblExitIf [nTblStructExitIf-1];
	unsigned char nContinue = nTblContinue [nTblStructContinue-1];
	
	//Exit	
	for (int i=1; i<=nExitIf; i++) {
		ExprTokens_MakeAddress (buffer, TblExitIf [TotalExitIf-i], address);}
	
	TotalExitIf -= nTblExitIf [--nTblStructExitIf];
	
	//Continue
	unsigned short continue_address = TblStructContinue_address [nTblStructContinue-1];
	for (int i=1; i<=nContinue; i++) {
		ExprTokens_MakeAddress (buffer, TblContinue [TotalContinue-i], continue_address);}
	
	TotalContinue -= nTblContinue [--nTblStructContinue];
}


//**********************************************************
//Recherche structure
//**********************************************************
bool ExprTokens_FindStruct (unsigned char fstruct)
{
	//Recherche Goto dans boucle For
	for (int i=nTblStruct-1; i>=0; i--) {
		if (TblStruct [i]==fstruct)
		  return true;}
		  
	return false;
}


void ExprTokens_MakeAddress(GFA_ETokensBuffer *buffer, unsigned short pos, unsigned short offset) {
	unsigned char *ptr = (unsigned char*)(GFA_MemoryBuffer_GetBeginAddress(buffer)) + pos;
	*(ptr++) = offset>>8;
	*ptr = offset & 0xFF;
}

