// Header File
// Created 29/09/2006; 21:27:32

#ifndef _GFA_ETOKENISOR_H_
#define _GFA_ETOKENISOR_H_

#include "errors.h"
#include "memory.h"
#include "tags.h"

#define MAX_SYMBOL					0xFF
#define MAX_LOCAL_VAR				MAX_SYMBOL
#define MAX_PROCEDURE				MAX_SYMBOL
#define MAX_GOSUB						MAX_SYMBOL

#define MAX_LABEL						MAX_SYMBOL
#define MAX_GOTO						MAX_SYMBOL
#define MAX_RESTORE					MAX_SYMBOL
#define MAX_IF							MAX_SYMBOL
#define MAX_ELSEIF					MAX_SYMBOL
#define MAX_DO							MAX_SYMBOL
#define MAX_REPEAT					MAX_SYMBOL
#define MAX_WHILE						MAX_SYMBOL
#define MAX_FOR							MAX_SYMBOL

#define MAX_STRUCT					MAX_SYMBOL
#define MAX_EXITIF					MAX_SYMBOL
#define MAX_CONTINUE				MAX_SYMBOL

#define STRUCT_IF						1
#define STRUCT_DO						2
#define STRUCT_REPEAT				3
#define STRUCT_WHILE				4
#define STRUCT_FOR					5

#define FOR_TYPE_TO					0
#define FOR_TYPE_DOWNTO			1
#define FOR_TYPE_STEP				2

#define ExprTokens_MakeContinueAddress(address) TblStructContinue_address [nTblStructContinue-1] = address;

//Structure des labels
typedef struct {
	unsigned short address;
	unsigned short data_number;
	unsigned short data_ptr;
	BOOL isInLoop;						//Ce trouve dans une boucle FOR!
	unsigned short ProcedureOffset;
} s_LabelJump;


//Structure d'adressage des GOTOs
typedef struct {
	unsigned char lbl_index;
	unsigned short token_address;
	unsigned short ProcedureOffset;
} s_GotoJump;


//Structure de saut pour les conditons IF
typedef struct {
	unsigned short nElseIf;
	BOOL branch_else;
	unsigned short token_address;
} s_IFJump;


//Structure de gestion des boucles FOR
typedef struct {
  unsigned char var_subtag;
  unsigned char var_number;
  unsigned short token_address_data;
  unsigned short token_address_if;
} s_FORJump;


//Structure de gestion des variables locales
typedef struct {
	BOOL local;
	unsigned short offset;
} s_LocalVar;

extern bool isInProcedure;
extern bool FirstProcedure;
extern unsigned short ProcedureOffset;
extern unsigned short *TblProcedureJump;
extern s_GotoJump *TblGosubJump;
extern unsigned short nTblGosubJump;

extern s_LabelJump *TblLabelJump;
extern s_GotoJump *TblGotoJump;
extern unsigned short nTblGotoJump;

extern s_GotoJump *TblRestoreJump;
extern unsigned short nTblRestoreJump;

extern unsigned char *TblStruct;
extern unsigned short nTblStruct;
extern unsigned short nTblStructExitIf;
extern unsigned char *nTblExitIf;
extern unsigned short *TblExitIf;
extern unsigned short TotalExitIf;

extern unsigned short nTblStructContinue;
extern unsigned char *nTblContinue;
extern unsigned short *TblContinue;
extern unsigned short TotalContinue;
extern unsigned short *TblStructContinue_address;

extern s_IFJump *Tbl_IF_Jump;
extern unsigned short n_IF_Jump;
extern unsigned short *Tbl_ElseIf_Address;
extern unsigned short TotalElseIf;
extern unsigned short *Tbl_Do_Address;
extern unsigned short TotalDo;
extern unsigned short *Tbl_Repeat_Address;
extern unsigned short TotalRepeat;
extern unsigned short *Tbl_While_Address_If;
extern unsigned short *Tbl_While_Address_Jump;
extern unsigned short TotalWhile;
extern s_FORJump *Tbl_FOR_Jump;
extern unsigned short TotalFor;


//****************
//Liste des tokens
//****************
#define ETOKEN_END											ETOKEN_FUNC_END

#define ETOKEN_NONE											0x00				//Pas d'opration, alignement adresse paire
#define ETOKEN_JUMP											0x01				//Ajoute adresse dans la pile soit 4 octets suivants
#define ETOKEN_IF												0x02
#define ETOKEN_IFJUMP										0x03
#define ETOKEN_FORs											0x04				//Sauvegarde variable
#define ETOKEN_FORc											0x05				//Comparaison
#define ETOKEN_FORe											0x06
  #define ETOKEN_FORe_addi 								0x00			//Ajoute avec Step
  #define ETOKEN_FORe_add1								0x01			//Ajoute 1 To seule
  #define ETOKEN_FORe_sub1								0x02			//Soustrait de 1 Downto
#define ETOKEN_FOR_if										0x07
#define ETOKEN_FOR_add									0x08
#define ETOKEN_FOR_clear								0x09
#define ETOKEN_ENDTAG										0x0A				//Fin des arguments pour une fonctions
#define ETOKEN_POINT_VIRGULE						0x0B				//Point virgule, seulement pour PRINT
#define ETOKEN_APOST										0x0C				//Apostrophe, seulement pour PRINT
#define ETOKEN_CONSTANT									0x0D

#define ETOKEN_LOCAL_VAR								0x0E
#define ETOKEN_RETURN										0x0F
#define ETOKEN_GOSUB										0x10

#define ETOKEN_NUMBER_FLOAT							0x11
#define ETOKEN_NUMBER_INT								0x12
#define ETOKEN_STRING										0x13				//Suivie de 2 octets pour info taille

#define ETOKEN_VAR_FLOAT								0x14				//Variable type float
#define ETOKEN_VAR_INT									0x15				//Variable type integer
#define ETOKEN_VAR_BOOL									0x16				//Variable type boolens
#define ETOKEN_VAR_STRING								0x17				//Variable type chane de caractres

#define ETOKEN_VAR_TFLOAT								0x18				//Tableau type float
#define ETOKEN_VAR_TINT									0x19				//Tableau type integer
#define ETOKEN_VAR_TBOOL								0x1A				//Tableau type boolens
#define ETOKEN_VAR_TSTRING							0x1B				//Tableau type chane de caractres


//Maths
//-----
#define ETOKEN_MATH_ADD									0x1C
#define ETOKEN_MATH_SUB									0x1D
#define ETOKEN_MATH_MUL									0x1E
#define ETOKEN_MATH_DIV									0x1F
#define ETOKEN_MATH_PUISS								0x20

//Comparaison
//-----------
#define ETOKEN_COMPARE_SUPERIOR					0x21
#define ETOKEN_COMPARE_INFERIOR					0x22
#define ETOKEN_COMPARE_EGAL							0x23
#define ETOKEN_COMPARE_SUPEGAL					0x24
#define ETOKEN_COMPARE_INFEGAL					0x25
#define ETOKEN_COMPARE_DIFF							0x26

//Affectation
//-----------
#define ETOKEN_AFFEC										0x27

//Logique
//-------
#define ETOKEN_LOGIC_NOT								0x28
#define ETOKEN_LOGIC_AND								0x29
#define ETOKEN_LOGIC_OR									0x2A
#define ETOKEN_LOGIC_XOR								0x2B
#define ETOKEN_LOGIC_IMP								0x2C
#define ETOKEN_LOGIC_EQV								0x2D
#define ETOKEN_MATH_MOD									0x2E
#define ETOKEN_MATH_DIVINT							0x2F
	
//Ngatif
//-------
#define ETOKEN_NEGATIF									0x30

//Fonctions
//---------
#define ETOKEN_FUNC_AT									0x31
#define ETOKEN_FUNC_PRINT								0x32
#define ETOKEN_FUNC_DIM									0x33
#define ETOKEN_FUNC_CLS									0x34
#define ETOKEN_FUNC_GETKEY							0x35
#define ETOKEN_FUNC_ABS									0x36
#define ETOKEN_FUNC_ADD									0x37
#define ETOKEN_FUNC_ATN									0x38
#define ETOKEN_FUNC_CLR									0x39
#define ETOKEN_FUNC_COS									0x3A
#define ETOKEN_FUNC_DEC									0x3B
#define ETOKEN_FUNC_DIV									0x3C
#define ETOKEN_FUNC_EVEN								0x3D
#define ETOKEN_FUNC_EXP									0x3E
#define ETOKEN_FUNC_FIX									0x3F
#define ETOKEN_FUNC_FRAC								0x40
#define ETOKEN_FUNC_INC									0x41
#define ETOKEN_FUNC_LOG									0x42
#define ETOKEN_FUNC_LOG10								0x43
#define ETOKEN_FUNC_MUL									0x44
#define ETOKEN_FUNC_ODD									0x45
#define ETOKEN_FUNC_SGN									0x46
#define ETOKEN_FUNC_SIN									0x47
#define ETOKEN_FUNC_SQR									0x48
#define ETOKEN_FUNC_TAN									0x49
#define ETOKEN_FUNC_ROUND								0x4A
#define ETOKEN_FUNC_SUB									0x4B
#define ETOKEN_FUNC_ASC									0x4C
#define ETOKEN_FUNC_BIN									0x4D
#define ETOKEN_FUNC_HEX									0x4E
#define ETOKEN_FUNC_OCT									0x4F
#define ETOKEN_FUNC_CHR									0x50
#define ETOKEN_FUNC_LEFT								0x51
#define ETOKEN_FUNC_LEN									0x52
#define ETOKEN_FUNC_MID									0x53
#define ETOKEN_FUNC_RIGHT								0x54
#define ETOKEN_FUNC_SPACE								0x55
#define ETOKEN_FUNC_STR									0x56
#define ETOKEN_FUNC_STRING							0x57
#define ETOKEN_FUNC_UPPER								0x58
#define ETOKEN_FUNC_VAL									0x59
#define ETOKEN_FUNC_ARRAYFILL						0x5A
#define ETOKEN_FUNC_LDIM								0x5B
#define ETOKEN_FUNC_END									0x5C
#define ETOKEN_FUNC_FRE									0x5D
#define ETOKEN_FUNC_PAUSE								0x5E
#define ETOKEN_FUNC_SWAP								0x5F
#define ETOKEN_FUNC_MKI									0x60
#define ETOKEN_FUNC_MKL									0x61
#define ETOKEN_FUNC_MKF									0x62
#define ETOKEN_FUNC_CVI									0x63
#define ETOKEN_FUNC_CVL									0x64
#define ETOKEN_FUNC_CVF									0x65
#define ETOKEN_FUNC_SETFONT							0x66
#define ETOKEN_FUNC_GETFONT							0x67
#define ETOKEN_FUNC_LOWER								0x68
#define ETOKEN_FUNC_RUN									0x69
#define ETOKEN_FUNC_NGETCHX							0x6A
#define ETOKEN_FUNC_RND									0x6B
#define ETOKEN_FUNC_TIMER								0x6C
#define ETOKEN_FUNC_SYSTEM							0x6D
#define ETOKEN_FUNC_CRSLIN							0x6E
#define ETOKEN_FUNC_CRSCOL							0x6F
#define ETOKEN_FUNC_RANDOM							0x70
#define ETOKEN_FUNC_TYPE								0x71
#define ETOKEN_FUNC_LVAL								0x72
#define ETOKEN_FUNC_VARPTR							0x73
#define ETOKEN_FUNC_ARRPTR							0x74
#define ETOKEN_FUNC_DFREE								0x75
#define ETOKEN_FUNC_PEEK								0x76
#define ETOKEN_FUNC_DPEEK								0x77
#define ETOKEN_FUNC_LPEEK								0x78
#define ETOKEN_FUNC_POKE								0x79
#define ETOKEN_FUNC_DPOKE								0x7A
#define ETOKEN_FUNC_LPOKE								0x7B
#define ETOKEN_FUNC_BOX									0x7C
#define ETOKEN_FUNC_INPUT								0x7D
#define ETOKEN_FUNC_TEXT								0x7E
#define ETOKEN_FUNC_PLOT								0x7F
#define ETOKEN_FUNC_LINE								0x80
#define ETOKEN_FUNC_READ								0x81
#define ETOKEN_FUNC_RESTORE							0x82
#define ETOKEN_FUNC_SPRITE							0x83
#define ETOKEN_FUNC_GET									0x84
#define ETOKEN_FUNC_PUT									0x85
#define ETOKEN_FUNC_POINT								0x86

//Structure d'un fichier contenant des tokens d'execution GTK		24 octets
typedef struct {
	unsigned char file_id [7];			// "GFA_GTK"
	unsigned char version;					//1
	unsigned short tokens_size;			//Taille de la section des tokens
	unsigned short number_data;			//Nombre de donnes DATA
	unsigned short offset_data;			//Offset dbut donnes DATA
	unsigned char nfloat;
	unsigned char ninteger;
	unsigned char nbool;
	unsigned char nstring;
	unsigned char ntblfloat;
	unsigned char ntblinteger;
	unsigned char ntblbool;
	unsigned char ntblstring;
	unsigned char section_tk [2];		// "TK"
} GFA_ETokenisor_Header;

typedef GFA_MemoryBuffer GFA_ETokensBuffer;

extern GFA_ETokensBuffer GFA_ETokenisor_CreateBuffer();
extern inline void GFA_ETokenisor_DeleteBuffer(GFA_ETokensBuffer *buffer);

extern GFA_ERROR_NUMBER GFA_ETokenisor_WriteStackTag(GFA_ETokensBuffer *buffer, const GFA_StackTag *stack_tag);
extern GFA_ERROR_NUMBER GFA_ETokenisor_CreateFile(GFA_ETokensBuffer *buffer, const char *file, const GFA_StackExprFind *stack_expr_find);

#endif
