// C Source File
// Created 24/06/2006; 16:35:25

#include "tigcclib.h"
#include "charset.h"

inline bool GFA_Charset_EofLine(char c) {
  return ((c==CHAR_NULL) || (c==CHAR_ENDLINE));
}


inline bool GFA_Charset_Number(char c) {
  return (c>='0' && c<='9');
}


inline bool GFA_Charset_Exponential(char c) {
  switch (c) {
    case (char)CHAR_E:
    case 'E':
    case 'e':
      return true;
    
    default:
      return false;
  }
}


inline bool GFA_Charset_Operator(char c) {
  switch (c) {
    case '+':
    case '-':
    case (char)CHAR_NEGATIF:
      return true;
      
    default:
      return false;
  }
}


inline bool GFA_Charset_Letter(char c) {
  return ((GFA_Charset_LetterUpper(c)!=c) || (GFA_Charset_LetterLower(c)!=c));
}


char GFA_Charset_LetterUpper(char c) {
  if ((c>='a' && c<='z') || 
      (c>=(char)CHAR_aGRAVE && c<=(char)CHAR_iUML) ||
      (c>=(char)CHAR_nTILDE && c<=(char)CHAR_oUML) ||
      (c>=(char)CHAR_oSlash && c<=(char)CHAR_thorn))
    return (c - ('a' - 'A'));
  return c;
}


char GFA_Charset_LetterLower(char c) {
  if ((c>='A' && c<='Z') ||
      (c>=(char)CHAR_AGRAVE && c<=(char)CHAR_IUML) ||
      (c>=(char)CHAR_NTILDE && c<=(char)CHAR_OUML) ||
      (c>=(char)CHAR_OSlash && c<=(char)CHAR_THORN))
    return (c + ('a' - 'A'));
  return c;
}
