// Header File
// Created 24/06/2006; 16:35:35

#ifndef _GFA_CHARSET_H_
#define _GFA_CHARSET_H_

#include "tigcclib.h"

/** @brief Enumration des caractres spciaux */
enum {
	CHAR_NULL    = 0x00,
  CHAR_ENDLINE = 0x0D,
  CHAR_E       = 0x95,
  CHAR_NEGATIF = 0xAD,
  
  CHAR_aGRAVE  = 0xE0,
  CHAR_iUML    = 0xEF,
  CHAR_nTILDE  = 0xF1,
  CHAR_oUML    = 0xF6,
  CHAR_oSlash  = 0xF8,
  CHAR_thorn   = 0xFE,
  
  CHAR_AGRAVE  = 0xC0,
  CHAR_IUML    = 0xCF,
  CHAR_NTILDE  = 0xD1,
  CHAR_OUML    = 0xD6,
  CHAR_OSlash  = 0xD8,
  CHAR_THORN   = 0xDE 
};

extern inline bool GFA_Charset_EofLine(char c);
extern inline bool GFA_Charset_Number(char c);
extern inline bool GFA_Charset_Exponential(char c);
extern inline bool GFA_Charset_Operator(char c);

extern inline bool GFA_Charset_Letter(char c);
extern char GFA_Charset_LetterUpper(char c);
extern char GFA_Charset_LetterLower(char c);

#endif