// C Source File
// Created 22/06/2006; 14:12:05

#include "tigcclib.h"
#include "gfabasic.h"
#include "errors.h"
#include "memory.h"
#include "files.h"

static const char *GFA_Error_Table[] = {
  "No error",
  "No enougth memory",
  "File no found",
  "File already open",
  "Impossible to open the file",                 // Tokenisor
  "Impossible to create the file",
  "Incorrect file name",												 // Files
  "Incorrect file type",												 // Files                
  "Incorrect file signature",                    // GFA-Lib
  "Incorrect file version",                      // GFA-Lib
  "Stack library overflow",                      // GFA-Lib
  "Stack tag overflow",                          // Scanner
  "Stack expressions find overflow",             // GFA_ExprFind
  "Line too long",                               // Scanner
  "Number overflow",                             // Scanner
  "Invalid number conversion",                   // Scanner
  "Syntax error, bracket '(' missing",           // Scanner
  "Syntax error, bracket ')' missing",           // Scanner
  "Syntax error, unknown suffixed data name",    // Scanner
  "Syntax error",                                // Scanner
  "Internal error, unknown structure",           // Scanner
  "Internal error, unknown tag",								 // Parser
  "Internal error, unknwon subtag",				       // Tokenisor
  "Syntax error, incompatible types",            // Parser
  "Syntax error, few arguments",                 // Parser
  "Syntax error, too many arguments",            // Parser
  "Syntax error, you must use an explicit suffix",
  
  "Trop de labels, max 255",						//13
	"Label dj dfini",									//14
	"Un label n'a pas t dfini",				//15
	"Erreur interne, MoveTags",					//16
	"Mauvais nombre d'indices",					//17
	"Indice incorrect",									//18
	"Tableau indfini",									//19
	"Tableau dj dfini",								//20
	"Types incompatibles",								//21
	"Opration impossible",							//22
	"Trop peu d'arguments",							//23
  "Trop d'arguments",									//24
  "Division par zro",									//25
  "Argument incorrect",								//26
  "Dimension  zro incorrecte",				//27
  "Rsultat non rel",									//28
  "Trop de goto avant labels",					//29
  "Trop de conditons If imbriques",		//30
  "Else sans if",											//31
  "Endif sans if",											//32
  "If sans Endif",											//33
  "ElseIf sans if",										//34
  "Trop de conditons ElseIf imbriques",	//35
  "Trop de structures Do...Loop",				//36
  "Trop de structures imbriques",			//37
  "Loop sans Do",											//38
  "Do sans Loop",											//39
  "Trop de structures Exit [If]",			//40
  "Exit [If] incorrect",								//41
  "Trop de structures Repeat...Until",	//42
  "Until sans Repeat",									//43
  "Repeat sans Until",									//44
  "Trop de structures While...Wend",		//45
  "Wend sans While",										//46
  "While sans Wend",										//47
  "Trop de structures For...Next",			//48
  "Next sans For",											//49
  "For sans Next",											//50
  "Trop de Restore avant labels",			//51
  "Trop de structures Continue",				//52
  "Continue incorrect",								//53
  "Goto into/out of a For Next loop or a procedure",	//54
  "Trop de procedures, max 256",				//55
  "Procedure dj dfinie",						//56
  "Une procedure n'a pas t dfinie",	//57
  "Procedure in a loop",								//58
  "Local only allowed in Procedure",		//59
  "Local not allowed in a loop",				//60
  "Return without Procedure",					//61
  "Procedure without Return",					//62
  "Trop de Gosub avant Procedures"		//63
};

struct s_Error_Stack GFA_Error_Stack;

static struct {
  char *file_data;
	short line;
	const char *eptr;
} GFA_ErrorMark;


void GFA_Error_EndProgram() {
  for (short i = (GFA_Error_Stack.n - 1); i>=0; --i)
    GFA_Error_Stack.tab[i]();
  GFA_Memory_FreeAll(); // Libre l'ensemble des allocations mmoire restantes
  GFA_File_CloseAll();  // Ferme les fichiers ouverts  
}


inline void GFA_Error_Push(void (*func)(void)) {
  Assert(GFA_Error_Stack.n < GFA_ERROR_STACK_SIZE);
  GFA_Error_Stack.tab[GFA_Error_Stack.n++] = func;
}


inline const char *GFA_Error_GetString(GFA_ERROR_NUMBER n) {
  return GFA_Error_Table[n];
}


void GFA_Error_SetMark(char *file_data, short line, const char *eptr) {
	Assert(file_data && (line > 0) && eptr);
	
	GFA_ErrorMark.file_data = file_data;
	GFA_ErrorMark.line = line;
	GFA_ErrorMark.eptr = eptr;
}


void GFA_Error_Call(const GFA_Error *error) {
  Assert(error);
  
  static char buffer[64];
  GFA_Error_EndProgram();
  
  if (!GFA_ErrorMark.line)
    sprintf(buffer, "Error %d : %s", error->n, GFA_Error_GetString(error->n));   
  else {
    sprintf(buffer, "Error %d line %d : %s", error->n, GFA_ErrorMark.line, GFA_Error_GetString(error->n));

    //if (GFA_ErrorMark.file_data && GFA_BASIC_PARAMETERS.ASSIGN_CURSOR_ERROR)
    //  *(unsigned short *)(GFA_ErrorMark.file_data - 3) = ((error->eptr?error->eptr:GFA_ErrorMark.eptr) - GFA_ErrorMark.file_data) + 1;
  }
  
  ST_helpMsg(buffer);
  
  // Informations supplmentaires
  if (error->content) {
    ngetchx();
    strcpy(buffer, "Information : ");
    strcat(buffer, error->content);
    ST_helpMsg(buffer);
  }

  //#ifdef _DEBUG
    ngetchx();
  //#endif

  exit(0);
}
