// Header File
// Created 22/06/2006; 14:12:22

#ifndef _GFA_ERRORS_H_
#define _GFA_ERRORS_H_

#include "strings.h"

/** @brief Nombre de fonctions  appeler lors d'une exception */
#define GFA_ERROR_STACK_SIZE            8

#define GFA_GET_ERR(n, content, expr)         ((GFA_Error){n, content, expr})
#define GFA_GET_ERR_N(n, content)             ((GFA_Error){n, content, NULL})
#define GFA_GET_ERR_OK							          ((GFA_Error){GFA_ERR_OK, NULL, NULL})

#define GFA_Error_Call2(n, content)           GFA_Error_Call(&(GFA_Error){n, content, NULL})

/**
 * @brief Enumration des erreurs disponibles
 */
typedef enum {
  GFA_ERR_OK = 0,
  GFA_ERR_MEMORY,
  GFA_ERR_FILE_NO_FOUND,
  GFA_ERR_FILE_ALREADY_OPEN,
  GFA_ERR_IMPOSSIBLE_TO_OPEN_FILE,
  GFA_ERR_IMPOSSIBLE_TO_CREATE_FILE,
  GFA_ERR_INCORRECT_FILE_NAME,
  GFA_ERR_INCORRECT_FILE_TYPE,
  GFA_ERR_INCORRECT_FILE_SIGNATURE,
  GFA_ERR_INCORRECT_FILE_VERSION,
  GFA_ERR_STACK_LIB_OVERFLOW,
  GFA_ERR_STACK_TAG_OVERFLOW,
  GFA_ERR_STACK_EXPRFIND_OVERFLOW,
  GFA_ERR_LINE_TOO_LONG,
  GFA_ERR_NUMBER_OVERFLOW,
  GFA_ERR_INVALID_NUMBER_CONVERSION,
  GFA_ERR_SYNTAX_BRACKET_OPEN_MISSING,
  GFA_ERR_SYNTAX_BRACKET_CLOSE_MISSING,
  GFA_ERR_SYNTAX_UNKNOWN_FUNCTION_OR_CONSTANT_NAME,
  GFA_ERR_SYNTAX_GENERAL,
  GFA_ERR_INTERNAL_UNKNOWN_STRUCTURE,
  GFA_ERR_INTERNAL_UNKNOWN_TAG,
  GFA_ERR_INTERNAL_UNKNOWN_SUBTAG,
  GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES,
  GFA_ERR_SYNTAX_FEW_ARGUMENTS,
  GFA_ERR_SYNTAX_LOT_ARGUMENTS,
  GFA_ERR_EXPLICIT_TYPE_FOR_VARIABLE,
  
  ERROR_LABEL_OVERFLOW,
  ERROR_LABEL_DEFINED,
  ERROR_LABEL_UNDEFINED,
  ERROR_INTERNE_MOVETAGS,
  ERROR_TBL_INDICES,
  ERROR_TBL_INCORRECT_INDICE,
  ERROR_TBL_UNDEF,
  ERROR_TBL_DEF,
  ERROR_TYPE_INCOMPATIBLE,
  ERROR_OPERATION,
  ERROR_FEW_ARGUMENT,
  ERROR_LOT_ARGUMENT,
  ERROR_DIVIDE_BY_ZERO,
  ERROR_INCORRECT_ARG,
  ERROR_TBL_ZERODIM,
  ERROR_NON_REAL_RESULT,
  ERROR_GOTO_OVERFLOW,
  ERROR_IF_OVERFLOW,
  ERROR_ELSE,
  ERROR_ENDIF,
  ERROR_IF,
  ERROR_ELSEIF,
  ERROR_ELSEIF_OVERFLOW,
  ERROR_DO_OVERFLOW,
  ERROR_STRUCT_OVERFLOW,
  ERROR_LOOP,
  ERROR_DO,
  ERROR_EXITIF_OVERFLOW,
  ERROR_EXITIF,
  ERROR_REPEAT_OVERFLOW,
  ERROR_UNTIL,
  ERROR_REPEAT,
  ERROR_WHILE_OVERFLOW,
  ERROR_WEND,
  ERROR_WHILE,
  ERROR_FOR_OVERFLOW,
  ERROR_NEXT,
  ERROR_FOR,
  ERROR_RESTORE_OVERFLOW,
  ERROR_CONTINUE_OVERFLOW,
  ERROR_CONTINUE,
  ERROR_INCORRECT_GOTO,
  ERROR_PROCEDURE_OVERFLOW,
  ERROR_PROCEDURE_DEFINED,
  ERROR_PROCEDURE_UNDEFINED,
  ERROR_PROCEDURE_IN_LOOP,
  ERROR_LOCAL_OUT_PROCEDURE,
  ERROR_LOCAL_IN_LOOP,
  ERROR_RETURN,
  ERROR_PROCEDURE,
  ERROR_GOSUB_OVERFLOW
} GFA_ERROR_NUMBER;


/**
 * @brief Pile d'execution de fonctions (fin de programme)
 */
extern struct s_Error_Stack {
  void (*tab[GFA_ERROR_STACK_SIZE])(void);
  unsigned short n;
} GFA_Error_Stack;


/** @brief Structure d'information d'erreur */
typedef struct {
	GFA_ERROR_NUMBER n;
	const char *content;
	const char *eptr;
} GFA_Error;


/**
 * @brief Ajoute une fonction dans la pile
 *
 * @param[in] func : Fonction  ajouter
 */
extern inline void GFA_Error_Push(void (*func)(void));


/**
 * @brief Execute les fonctions se trouvant dans la pile et libre la mmoire
 */
extern void GFA_Error_EndProgram();


/**
 * @brief Retourne une chane de caractres reprsentant l'erreur n
 *
 * @param[in] n : Code de l'erreur
 * @return une chane de caractres reprsentant l'erreur
 */
extern inline const char *GFA_Error_GetString(GFA_ERROR_NUMBER n);


/**
 * @brief Crer une marqueur d'erreur
 * Cette fonction est utile pour pointer la bonne ligne dans un fichier source qui a comise une erreur
 *
 * @param[in] file_data : Pointeur dbut de donnes du fichier source
 * @param[in] line : Ligne en cours de traitement
 * @param[in] eptr : Pointeur sur la donne dans le fichier en cours de traitement
 */
extern void GFA_Error_SetMark(char *file_data, short line, const char *eptr);


/**
 * @brief Affiche le message d'erreur et termine l'excution du programme
 * La pile des fonctions est appele avant la fin d'excution du programme
 *
 * @param[in] n : Code de l'erreur
 */
extern void GFA_Error_Call(const GFA_Error *error) __attribute__ ((noreturn));

#endif