// C Source File
// Created 10/07/2006; 15:38:44

#include "tigcclib.h"
#include "expr_find.h"
#include "errors.h"
#include "memory.h"
#include "strings.h"

GFA_StackExprFind GFA_ExprFind_CreateStack() {
  GFA_StackExprFind stack;
  
  for (short i = GFA_EXPR_NUMBER_OF_TYPE - 1; i>=0; --i) {
    stack.type[i].item = GFA_Memory_Alloc(GFA_EXPR_FIND_STACK_SIZE * sizeof(GFA_String));
    stack.type[i].n = 0;
  }
  
  return stack;  
}


void GFA_ExprFind_DeleteStack(GFA_StackExprFind *stack) {
  Assert(stack);
  
  for (short i = GFA_EXPR_NUMBER_OF_TYPE - 1; i>=0; --i) {
    GFA_Memory_Free(stack->type[i].item);
    stack->type[i].n = 0;
  }
}


bool GFA_ExprFind_PushString(GFA_StackExprFind *stack, GFA_enumTypeExpr type, const GFA_String *str) {
  Assert(stack && str);
  
  if (stack->type[type].n>=GFA_EXPR_FIND_STACK_SIZE)
    return false;
    
  stack->type[type].item[stack->type[type].n++] = *str;
  return true;
}


short GFA_ExprFind_FindString(const GFA_StackExprFind *stack, GFA_enumTypeExpr type, const GFA_String *str) {
  Assert(stack && str);
  
  for (short i = stack->type[type].n - 1; i>=0; --i) {
    if (!GFA_String_strcmpNoCase(&stack->type[type].item[i], str))
      return i;
  }  
  
  return -1;
}


inline unsigned short GFA_ExprFind_GetStackSize(const GFA_StackExprFind *stack, GFA_enumTypeExpr type) {
  Assert(stack);
  
  return stack->type[type].n;
}


unsigned short GFA_ExprFind_StringInStack(GFA_StackExprFind *stack, GFA_enumTypeExpr type, const GFA_String *str) {
  Assert(stack && str);
  
  short idx = GFA_ExprFind_FindString(stack, type, str);
  if (idx==-1) {
    idx = GFA_ExprFind_GetStackSize(stack, type);
    if (!GFA_ExprFind_PushString(stack, type, str))
      GFA_Error_Call2(GFA_ERR_STACK_EXPRFIND_OVERFLOW, NULL);
  }
  
  return idx;
}


inline const GFA_String *GFA_ExprFind_GetStringsFromType(const GFA_StackExprFind *stack, GFA_enumTypeExpr type) {
  Assert(stack);
  
  return stack->type[type].item;
}
