// Header File
// Created 10/07/2006; 15:39:12

#ifndef _GFA_EXPR_FIND_H_
#define _GFA_EXPR_FIND_H_

#include "strings.h"

/** @brief Nombre maximum de symboles pour chaque type de donnes */
#define GFA_EXPR_FIND_STACK_SIZE   128

/** @brief Enumration des diffrents types de donnes */
typedef enum {
  GFA_EXPR_U8,
  GFA_EXPR_S16,
  GFA_EXPR_S32,
  GFA_EXPR_FLOAT,
  GFA_EXPR_BOOL,
  GFA_EXPR_STRING,
  
  GFA_EXPR_TAB_U8,
  GFA_EXPR_TAB_S16,
  GFA_EXPR_TAB_S32,
  GFA_EXPR_TAB_FLOAT,
  GFA_EXPR_TAB_BOOL,
  GFA_EXPR_TAB_STRING,
  
  GFA_EXPR_LABEL,
  GFA_EXPR_PROCEDURE,
  
  GFA_EXPR_NUMBER_OF_TYPE = 14
} GFA_enumTypeExpr;


/** @brief Structure de stockage des symboles de chaque type de donnes */
typedef struct {
  struct {
    GFA_String *item;
    unsigned short n;
  } type[GFA_EXPR_NUMBER_OF_TYPE];    
} GFA_StackExprFind;


extern GFA_StackExprFind GFA_ExprFind_CreateStack();
extern void GFA_ExprFind_DeleteStack(GFA_StackExprFind *stack);
extern bool GFA_ExprFind_PushString(GFA_StackExprFind *stack, GFA_enumTypeExpr type, const GFA_String *str);
extern short GFA_ExprFind_FindString(const GFA_StackExprFind *stack, GFA_enumTypeExpr type, const GFA_String *str);
extern inline unsigned short GFA_ExprFind_GetStackSize(const GFA_StackExprFind *stack, GFA_enumTypeExpr type);
extern unsigned short GFA_ExprFind_StringInStack(GFA_StackExprFind *stack, GFA_enumTypeExpr type, const GFA_String *str);
extern inline const GFA_String *GFA_ExprFind_GetStringsFromType(const GFA_StackExprFind *stack, GFA_enumTypeExpr type);

#endif