// C Source File
// Created 24/06/2006; 17:02:14

#include "tigcclib.h"
#include "exprs.h"
#include "charset.h"

const char *GFA_Expr_String(const char *ptr) {
  Assert(ptr);
  
  if (*(ptr++)!='\"')
    return NULL;
  
  while (!GFA_Charset_EofLine(*ptr)) {
    if (*(ptr++)=='\"')
      return ptr;
  }
  
  return NULL;
}


const char *GFA_Expr_Number(const char *ptr) {
  Assert(ptr);
  
  const char *begin_ptr = ptr;
  for (; GFA_Charset_Number(*ptr); ++ptr);
  return (begin_ptr==ptr)?NULL:ptr;
}


const char *GFA_Expr_Number_Float_(const char *ptr) {
  Assert(ptr);
  bool l_number = false;
  
  const char *new_ptr = GFA_Expr_Number(ptr);
  if (new_ptr) {
    ptr = new_ptr;
    l_number = true;
  }
  if (*(ptr++)!='.')
    return NULL;
  
  new_ptr = GFA_Expr_Number(ptr);
  if (new_ptr)
    ptr = new_ptr;
  else if (!l_number)
    return NULL;
    
  return ptr;
}


const char *GFA_Expr_Number_Float(const char *ptr) {
  Assert(ptr);
  
  const char *base_ptr;
  const char *new_ptr;
  bool l_integer = false;
  if (!(new_ptr = GFA_Expr_Number_Float_(ptr))) {
    if ((new_ptr = GFA_Expr_Number(ptr)))
      l_integer = true;
    else
      return NULL;
  }
   
  if (!GFA_Charset_Exponential(*(base_ptr = new_ptr)))
    return l_integer?NULL:new_ptr;
  if (GFA_Charset_Operator(*(++new_ptr)))
    ++new_ptr;
  
  if (!(ptr = GFA_Expr_Number(new_ptr)))
    return base_ptr;
  return ptr;
}


const char *GFA_Expr_Number_Base(const char *ptr, long *number, bool *overflow) {
  Assert(ptr && number && overflow);
  short count = 0;
  
  if (*(ptr++)!='&')
    return NULL;
  
  *number = 0;
  *overflow = false;
  
  // Conversion Binaire  
  if ((*ptr=='X')  || (*ptr=='x') || (*ptr=='B')  || (*ptr=='b')) {
    for (++ptr; ; ++ptr) {
      if ((*ptr!='0') && (*ptr!='1'))
        return count?ptr:NULL;
      
      *number <<= 1;
      if (*ptr=='1')
        *number |= 0x01;
        
      if (++count>(short)(sizeof(long) * 8)) {
        *overflow = true;
        return NULL;
      }
    }
  }
  // Conversion Hexadcimale
  else if ((*ptr=='H') || (*ptr=='h')) {
    unsigned char cbyte;
    
    for (++ptr; ; ++ptr) {
      if ((*ptr>='0') && (*ptr<='9'))      cbyte = *ptr - '0';
      else if ((*ptr>='a') && (*ptr<='f')) cbyte = (*ptr - 'a') + 10;
      else if ((*ptr>='A') && (*ptr<='F')) cbyte = (*ptr - 'A') + 10;
      else 
        return count?ptr:NULL;
        
      *number <<= 4;
      *number |= cbyte;
      
      if (++count>(short)(sizeof(long) * 2)) {
        *overflow = true;
        return NULL;
      }
    }
  }
  // Conversion Octale
  else if ((*ptr=='O') || (*ptr=='o')) {
    unsigned char cbyte, cfirst = 0;
    
    for (++ptr; ; ++ptr) {
      if ((*ptr<'0') || (*ptr>'7'))
        return count?ptr:NULL;
      
      cbyte = *ptr - '0';
      *number <<= 3;
      *number |= cbyte;
      
      if (!count)
        cfirst = cbyte;
      
      if ((++count > 11) || ((count==11) && (cfirst>0b011))) { // 11 = round(32 / 3)
        *overflow = true;
        return NULL;
      }
    }
  }
  
  return NULL;
}


const char *GFA_Expr_Symbol(const char *ptr) {
  Assert(ptr);
  bool a_letter = false;
  
  for (; !GFA_Charset_EofLine(*ptr); ++ptr) {
    if (GFA_Charset_Letter(*ptr))
      a_letter = true;
    else if (!((*ptr=='_') || (*ptr=='.') || GFA_Charset_Number(*ptr)))
      break;
  }
  
  return a_letter?ptr:NULL;
}
