// Header File
// Created 22/06/2006; 14:57:50

#ifndef _GFA_FILES_H_
#define _GFA_FILES_H_

#include "tigcclib.h"
#include "errors.h"
#include "memory.h"
#include "strings.h"

#define GFA_FILE_MAX_OPEN      					 16

/** @brief Structure reprsentant un fichier */
typedef struct {
  SYM_ENTRY *sym_entry;
  HANDLE handle;
  const char *data;
  unsigned short size;
  char *ptr;
  char *ptr_end;
} GFA_File;


/**
 * @brief Ouvre un fichier
 * @param[out] file : Structure accueillant les informations du fichier  ouvrir
 * @param[in] name : Nom du fichier
 * @return un code d'erreur
 *
 * @note Si name ne contient pas de nom de dossier, une recherche est faite  travers
 * tous les dossiers.
 * N'oubliez pas de fermer le fichier car cette fonction le marque comme tant ouvert et en lecture.
 */
extern GFA_ERROR_NUMBER GFA_File_Open(GFA_File *file, const char *name);


/**
 * @brief Ferme un fichier
 *
 * @param[in] file : Fichier
 */
extern void GFA_File_Close(GFA_File *file);


extern void GFA_File_CloseAll();


/**
 * @brief Dtermine si la fin du fichier a t atteinte
 *
 * @param[in] file : Fichier
 * @return true si la fin du fichier a t atteinte, sinon false
 */
extern inline bool GFA_File_Eof(const GFA_File *file);

//extern inline char *GFA_File_GetData(const GFA_File *file);


/**
 * @brief Retourne la taille relle d'un fichier
 *
 * @param[in] file : Fichier
 * @return la taille relle du fichier
 *
 * @note La taille relle reprsente la taille totale des donnes utiles du fichier.
 */
extern inline unsigned short GFA_File_GetSize(const GFA_File *file);


/**
 * @brief Retourne un pointeur marqueur de fin d'un fichier
 *
 * @param[in] file : Fichier
 * @return pointeur (marqueur) de fin du fichier
 */
extern inline const char *GFA_File_GetEndPos(const GFA_File *file); 


/**
 * @brief Retourne le type d'un fichier
 *
 * @param[in] file : Fichier
 * @return le type du fichier
 *
 * @note Un fichier peut tre de type texte ou de type donnes
 * voir TEXT_TAG, OTH_TAG...
 */
extern inline unsigned short GFA_File_GetType(const GFA_File *file);


/**
 * @brief Gnre  partir d'un buffer un fichier
 *
 * @param[in, out] buffer : Buffer
 * @param[in] name : Nom du fichier  gnrer
 * @param[in] ext : Extension du fichier gnr
 * @return un code d'erreur
 *
 * @note Si aucune erreur s'est produire, le buff est automatiquement libr par la fonction
 */
extern GFA_ERROR_NUMBER GFA_File_GenerateFileFromMemoryBuffer(GFA_MemoryBuffer *buffer, const char *name, const char *ext);

#endif
