// Header File
// Created 22/06/2006; 18:14:46

#ifndef _GFA_BASIC_H_
#define _GFA_BASIC_H_

#include "tbl_tags.h"
#include "files.h"
#include "gfalib.h"
#include "expr_find.h"
#include "scanner.h"
#include "tokenisor.h"
#include "parser.h"

#define GFA_BASIC_VERSION               "2.01.40"
#ifdef _DEBUG
  #define GFA_BASIC_COMPILE_MODE        "debug"
#else
  #define GFA_BASIC_COMPILE_MODE        "release"
#endif


/** @brief Paramtres de l'interprteur */
extern struct s_Params {
	bool       ASSIGN_CURSOR_ERROR;
	GFA_SUBTAG DEFAULT_NOT_SUFFIXED_VARIABLE_TYPE;
	GFA_SUBTAG DEFAULT_NOT_SUFFIXED_VALUE_TYPE;
} GFA_BASIC_PARAMETERS;


/** @brief Jeu de piles */
typedef struct {
  GFA_StackTag stack_tag;
  GFA_StackLib stack_lib;
  
  GFA_StackExprFind stack_expr_find;
} GFA_StackSet;


/** @brief Jeu de piles par dfaut */
extern GFA_StackSet GFA_Default_StackSet;


/**
 * @brief Fonction allouant un jeu de piles
 *
 * @param[out] set : Jeu de piles
 */
extern void GFA_StackSet_Create(GFA_StackSet *set);


/**
 * @brief Efface un jeu de piles
 *
 * @param[in] set : Jeu de piles
 */
extern void GFA_StackSet_Delete(GFA_StackSet *set);


extern void GFA_Init();
extern void GFA_Uninit();


extern GFA_Error GFA_ParseSourceFile(GFA_File *source_file, const char *dst, GFA_StackSet *set);

#endif
