// C Source File
// Created 28/08/2006; 12:44:54

#include "tbl_tags.h"
#include "tbl_parser.h"
#include "tbl_structs.h"
#include "tbl_tokens.h"
#include "config.h"
#include "tigcclib.h"
#include "errors.h"
#include "files.h"
#include "expr_find.h"
#include "tags.h"
#include "tokenisor.h"
#include "parser.h"

static void GFA_Parser_SetTags(GFA_StackTag *stack_tag);
static GFA_Error GFA_Parser_AddBrackets(GFA_StackTag *stack_tag);
static GFA_Error GFA_Parser_PreparePostfixNotation(GFA_StackTag *stack_tag);
static void GFA_Parser_AddPriority(const GFA_StackLib *stack_lib, GFA_StackTag *stack_tag);
static GFA_Error GFA_Parser_PostfixNotation(GFA_StackTag *stack_tag);
static void GFA_Parser_SetNotationRules(GFA_StackTag *stack_tag);
//static GFA_ERROR_NUMBER GFA_Parser_CheckSyntax(const GFA_StackLib *stack_lib, GFA_StackTag *stack_tag);
static GFA_Error GFA_Parser_CheckStackTag(GFA_StackTag *stack_tag);

GFA_Error GFA_Parser_Process(GFA_StackLib *stack_lib, GFA_StackExprFind *stack_expr_find, GFA_StackTag *stack_tag) {
	// Nous sommes dans la zone des commandes du parseur, ne pas parser
  if (!GFA_Tag_GetParserAreaDefined(stack_tag))
    return GFA_GET_ERR_OK;
	
	GFA_Error err = GFA_GET_ERR_OK;	
	GFA_Parser_SetTags(stack_tag);
	if (!(err = GFA_Parser_AddBrackets(stack_tag)).n) {
	  if (!(err = GFA_Parser_PreparePostfixNotation(stack_tag)).n) {
	  	GFA_Parser_AddPriority(stack_lib, stack_tag);
	  	if (!(err = GFA_Parser_PostfixNotation(stack_tag)).n) {
	  		GFA_Parser_SetNotationRules(stack_tag);
	  		err = GFA_Parser_CheckStackTag(stack_tag);
	  	}
	  }
	}

	return err;
}


void GFA_Parser_SetTags(GFA_StackTag *stack_tag) {
	for (short i = 0; i < (short)GFA_Tag_GetStackSize(stack_tag) - 1; ++i) {
		GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
		if (tag->symbol==GFA_SYMBOL_COMMENT) {
		  GFA_Tag_DeleteFromStack(stack_tag, i--);
		  continue;
		}
		
		if (tag->tag==GFA_TAG_BASE) {
			tag->tag = GFA_TAG_VALUE;
			continue;
		}
		
		if (tag->struct_idx==GFA_STRUCT_GOTO) {
			tag->info.index = GFA_Tag_GetFromStack(stack_tag, i + 1)->info.index;
			GFA_Tag_DeleteFromStack(stack_tag, i + 1);
			continue;
		}
	}
}


GFA_Error GFA_Parser_AddBrackets(GFA_StackTag *stack_tag) {
	Assert(stack_tag);
	
	GFA_Tag bracket_tag = GFA_Tag_Create(NULL, GFA_TAG_SIGN, GFA_SUBTAG_BRACKET_OPEN, GFA_PRIORITY_NONE);
	bool end_bracket = false;
	unsigned short start_code = 0;

	// Parcours la pile et ajoute les parenthses 
	for (unsigned short i = 0; i < GFA_Tag_GetStackSize(stack_tag); ++i) {
    const GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
    
    // Fin de ligne de code
    if (tag->symbol==GFA_SYMBOL_EOFLINE) {
    	bracket_tag.subtag = GFA_SUBTAG_BRACKET_CLOSE;
    	if (end_bracket) {
    		if (!GFA_Tag_PushFromStack(stack_tag, &bracket_tag, i++))
          return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
        end_bracket = false;
    	}
      
      start_code = (i + 1);
      continue;    	
    }
    
    // Parenthse pour les structures style Print, For...
    if ((tag->symbol==GFA_SYMBOL_STRUCT) && (tag->struct_idx!=GFA_STRUCT_AT)) {
    	// Parenthse fermante
    	if (end_bracket) {
    		bracket_tag.subtag = GFA_SUBTAG_BRACKET_CLOSE;
    		if (!GFA_Tag_PushFromStack(stack_tag, &bracket_tag, i++))
          return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
    	}
    	
    	// Parenthse ouvrante
    	bracket_tag.subtag = GFA_SUBTAG_BRACKET_OPEN;
    	if (!GFA_Tag_PushFromStack(stack_tag, &bracket_tag, ++i))
        return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
      end_bracket = true;
      
      // Ligne de code suivante aprs un Then
      if (tag->struct_idx==GFA_STRUCT_THEN)
        start_code = (i + 1);
      
      continue;
    }
        
    // Ajoute ( fonction sans retour
    //!GFA_LIB_FUNC_RETURN_VALUE(GFA_Lib_Object_GetFunctionType(&tag->info.library.object))) { 
    if ((tag->symbol==GFA_SYMBOL_FUNCTION) && (i==start_code)) {	  	
     	bracket_tag.subtag = GFA_SUBTAG_BRACKET_OPEN;
      if (!GFA_Tag_PushFromStack(stack_tag, &bracket_tag, ++i))
        return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
    	end_bracket = true;
    	
      continue;
    }
    	  
    // Ajoute () fonction avant signe
    if (tag->symbol==GFA_SYMBOL_FUNCTION) {
    	const GFA_Tag *next_tag = GFA_Tag_GetFromStack(stack_tag, i + 1);
    	  	
    	if (((next_tag->tag==GFA_TAG_MATH) && (next_tag->subtag!=GFA_SUBTAG_NEGATIF)) ||
    	    ((next_tag->tag==GFA_TAG_LOGIC) && (next_tag->subtag!=GFA_SUBTAG_NOT)) ||
    	    (next_tag->tag==GFA_TAG_COMPARE) ||
    	    (next_tag->symbol==GFA_SYMBOL_POINT_COMMA) || (next_tag->symbol==GFA_SYMBOL_APOST))
    	{
    		bracket_tag.subtag = GFA_SUBTAG_BRACKET_OPEN;
    	  if (!GFA_Tag_PushFromStack(stack_tag, &bracket_tag, ++i))
    	    return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
    	  		
    		bracket_tag.subtag = GFA_SUBTAG_BRACKET_CLOSE;
    	  if (!GFA_Tag_PushFromStack(stack_tag, &bracket_tag, ++i))
    	     return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
    	}
    	  	
    	continue;
    }
  }
  
  return GFA_GET_ERR_OK;
}


GFA_Error GFA_Parser_PreparePostfixNotation(GFA_StackTag *stack_tag) {
  unsigned short start_code = 0;
  unsigned short then_pos = 0;
  short count_bracket = 0;
  const GFA_Tag *last_bracket = NULL;
  for (unsigned short i = 0; i < GFA_Tag_GetStackSize(stack_tag); ++i) {
  	GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
  	
  	// Il reste des parenthses ouvertes
  	if (((tag->symbol==GFA_SYMBOL_EOFLINE) || (tag->symbol==GFA_SYMBOL_STRUCT)) && count_bracket)
  		return GFA_GET_ERR(GFA_ERR_SYNTAX_BRACKET_CLOSE_MISSING, NULL, GFA_String_GetStr(&last_bracket->expr));
  	
  	// Fin du code
  	if (tag->symbol==GFA_SYMBOL_EOFLINE) {  
  		start_code = (i + 1);
  		continue;
  	}
  		
  	// Gestion des parenthses
  	if (tag->symbol==GFA_SYMBOL_BRACKET_OPEN) {
  		#ifdef GFA_PARSER_USE_BRACKETS_DEPTH
  		  tag->depth = count_bracket;
  		#endif
  		++count_bracket;
  		last_bracket = tag;
  		continue;
    }
    
    if (tag->symbol==GFA_SYMBOL_BRACKET_CLOSE) {
    	if (!count_bracket)
    	  return GFA_GET_ERR(GFA_ERR_SYNTAX_BRACKET_OPEN_MISSING, NULL, GFA_String_GetStr(&tag->expr));
      --count_bracket;
      #ifdef GFA_PARSER_USE_BRACKETS_DEPTH
        tag->depth = count_bracket;
    	#endif
    	continue;
    }
  	
  	// Then
  	if (tag->struct_idx==GFA_STRUCT_THEN) {
  	  then_pos = i;
  	  continue;
  	}
  	
  	// End tag pour fonctions et tableaux
  	if ((i!=start_code) && (i!=(then_pos + 1)) &&
  	    ((tag->tag==GFA_TAG_SYMBOL) || (tag->tag==GFA_TAG_VARTABLE)))
  	{
  		GFA_Tag etag = GFA_Tag_Create(NULL, GFA_TAG_ENDTAG, GFA_SUBTAG_NONE, GFA_PRIORITY_NONE);
  		if (!GFA_Tag_PushFromStack(stack_tag, &etag, i++))
  		  return GFA_GET_ERR_N(GFA_ERR_STACK_TAG_OVERFLOW, NULL);
  	}
  }
  
  return GFA_GET_ERR_OK;
}


void GFA_Parser_AddPriority(const GFA_StackLib *stack_lib, GFA_StackTag *stack_tag) {
  // Sous fonction d'attribution priorit oprateur chane de caractres
  bool StringPriority(GFA_Tag *operator, const GFA_Tag *operand) {
  	if ((((operand->tag==GFA_TAG_VALUE) || (operand->tag==GFA_TAG_VAR) || (operand->tag==GFA_TAG_VARTABLE)) &&
  		   (operand->subtag==GFA_SUBTAG_STRING)) ||
  		  ((operand->symbol==GFA_SYMBOL_FUNCTION) && (GFA_Lib_Object_GetFunctionType(&operand->info.library.object).bit_field & RETURN_STRING)))
    {
  	  operator->treetag = GFA_TREETAG_STRING_OPERATION;
  		operator->priority = (operator->symbol==GFA_SYMBOL_MATH_ADD)?
  		                     GFA_PRIORITY_STRING_ADDITION:
  		                     GFA_PRIORITY_STRING_COMPARE;
  		return true;
  	}
  	
  	return false;
  }
  
  Assert(stack_tag);
  
  // Priorit de string, parcourir pile  l'envers regarder profondeur fonction
  for (short i = (short)GFA_Tag_GetStackSize(stack_tag) - 1; i > 0; --i) {
  	GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
  	
  	// Gestion priorit oprateurs entre chanes
  	if ((tag->symbol==GFA_SYMBOL_MATH_ADD) || (tag->tag==GFA_TAG_COMPARE)) {
  		// Tag suivant, chane de caractres
  		const GFA_Tag *tmp_tag = GFA_Tag_GetFromStack(stack_tag, i + 1);
  		if (StringPriority(tag, tmp_tag))
  		  continue;
  		
  		#ifdef GFA_PARSER_USE_BRACKETS_DEPTH
  		  // Tag prcdent, chane de caractres
  		  tmp_tag = GFA_Tag_GetFromStack(stack_tag, i - 1);
  		
  		  // Si parenthse fermante, trouver tableau ou fonction
  		  if (tmp_tag->symbol==GFA_SYMBOL_BRACKET_CLOSE) {
  		  	unsigned short depth = tmp_tag->depth;
  			  for (short j = (i - 2); (j > 0); --j) {
  				  tmp_tag = GFA_Tag_GetFromStack(stack_tag, j);
  				  if (tmp_tag->depth==depth) {
  				    tmp_tag = GFA_Tag_GetFromStack(stack_tag, j - 1);
  				    break;
  				  }
  			  }
  		  }
  		
  		  // Attribution priorit si tag prcdent chane de caractres
  		  if (StringPriority(tag, tmp_tag))
  		    continue;
  		#endif
  	}
  	
  	// Attribution, autres priorits
  	if (tag->tag==GFA_TAG_MATH)
			tag->priority = GFA_Math_PriorityTable[tag->subtag - 1];
		else if (tag->tag==GFA_TAG_LOGIC)
			tag->priority = (tag->subtag==GFA_SUBTAG_NOT)?
			                GFA_PRIORITY_LOGIC_NOT:
			                GFA_PRIORITY_LOGIC;  
		else if (tag->tag==GFA_TAG_COMPARE)
			tag->priority = GFA_PRIORITY_COMPARE;
  }
}


// Algorithme de l'aiguillage (shunting algorithm) Dijkstra
GFA_Error GFA_Parser_PostfixNotation(GFA_StackTag *stack_tag) {		
	struct {
		const GFA_Tag *item[GFA_TAG_STACK_SIZE];
		#ifdef GFA_PARSER_CHECK_OPERATORS_LEVEL
		  short level[GFA_TAG_STACK_SIZE];
		#endif
		short size;
	} OperatorStack;
		
	// Gestion level dans pile d'oprateurs
	#ifdef GFA_PARSER_CHECK_OPERATORS_LEVEL
	  #define GFA_OperatorStack_Push(t, x) {\
	          OperatorStack.item[OperatorStack.size] = t;\
	          OperatorStack.level[OperatorStack.size++] = x;}
	  
	  #define GFA_OperatorStack_PopLevel()    OperatorStack.level[OperatorStack.size - 1]
	  #define GFA_OperatorStack_GetLevel(x)   OperatorStack.level[x]
	  
	  // Vrifie le niveau de l'oprateur (ejecte 5 2 + par exemple)
	  #define GFA_OperatorStack_CheckLevel(s, t,l) ((t->tag > GFA_TAG_COMPARE) || (l < (short)GFA_Tag_GetStackSize(s)))
	#else
	  #define GFA_OperatorStack_Push(t, x)    OperatorStack.item[OperatorStack.size++] = t;
	#endif
	        
	#define GFA_OperatorStack_PopTag()        OperatorStack.item[OperatorStack.size - 1]
	#define GFA_OperatorStack_GetTag(x)       OperatorStack.item[x]
	#define GFA_OperatorStack_Size            OperatorStack.size 
	
	// Dbut du code de la fonction	
	GFA_OperatorStack_Size = 0;
	GFA_StackTag tmpStack = GFA_Tag_CreateStack();
	GFA_Tag_SetParserAreaDefined(&tmpStack);
	GFA_Error err = GFA_GET_ERR_OK;
	
	const GFA_Tag *otag = NULL;
	for (unsigned short i = 0; i < GFA_Tag_GetStackSize(stack_tag); ++i) {
		const GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
		
		// Ajoute directement dans la pile finale
		if ((tag->tag==GFA_TAG_ENDTAG) ||
		    (tag->tag==GFA_TAG_VALUE) || 
		    (tag->tag==GFA_TAG_VAR) ||
		    ((tag->tag==GFA_TAG_SIGN) && 
		     ((tag->subtag==GFA_SUBTAG_POINT_COMMA) || (tag->subtag==GFA_SUBTAG_APOST))))
		{
			GFA_Tag_PushFromStack(&tmpStack, tag, -1);
			continue;
		}
		
		// Parenthse ouverte, ajoute dans la pile d'oprateurs
		if (tag->symbol==GFA_SYMBOL_BRACKET_OPEN) {
			GFA_OperatorStack_Push(tag, -1);
			continue;
		}
		
		// Parenthse ferme, ajouter dernier signe dans pile d'expressions finale puis tester si parenthse ouverte
		// Fin de ligne
		if ((tag->symbol==GFA_SYMBOL_BRACKET_CLOSE) ||
		    (tag->symbol==GFA_SYMBOL_EOFLINE))
		{
			bool bracket_open = false;
			  
			// Vide la pile d'oprateurs
			while (GFA_OperatorStack_Size) {
				otag = GFA_OperatorStack_GetTag(--GFA_OperatorStack_Size);
				
				// Parenthse ouverte trouve
				if (otag->symbol==GFA_SYMBOL_BRACKET_OPEN) {
					if (tag->symbol==GFA_SYMBOL_EOFLINE) {
						err = GFA_GET_ERR(GFA_ERR_SYNTAX_BRACKET_CLOSE_MISSING, NULL, GFA_String_GetStr(&otag->expr));
		        goto end_function;
					}
					
					bracket_open = true;
					break;
				}
				
				// Vrification du niveau de l'oprateur
        #ifdef GFA_PARSER_CHECK_OPERATORS_LEVEL
				  if (!GFA_OperatorStack_CheckLevel(&tmpStack, otag, GFA_OperatorStack_GetLevel(GFA_OperatorStack_Size))) {
        	  err = GFA_GET_ERR(GFA_ERR_SYNTAX_GENERAL, NULL, GFA_String_GetStr(&otag->expr));
        	  goto end_function;
        	}
        #endif
				
				// Oprateur dans la pile finale
			  GFA_Tag_PushFromStack(&tmpStack, otag, -1);
			}
			
			// Parenthse ouvrante manquante
			if ((tag->symbol==GFA_SYMBOL_BRACKET_CLOSE) && !bracket_open) {
				err = GFA_GET_ERR(GFA_ERR_SYNTAX_BRACKET_OPEN_MISSING, NULL, GFA_String_GetStr(&tag->expr));
		    goto end_function;
			}
			
			// Tag de fin de ligne
			if (tag->symbol==GFA_SYMBOL_EOFLINE)
			  GFA_Tag_PushFromStack(&tmpStack, tag, -1);
			//Tableau, fonction
			else if (GFA_OperatorStack_Size) {
			  otag = GFA_OperatorStack_PopTag();
			  if ((otag->symbol==GFA_SYMBOL_FUNCTION) || 
			      (otag->tag==GFA_TAG_VARTABLE) || 
			      (otag->tag==GFA_TAG_STRUCT)) 
			  {
			  	GFA_Tag_PushFromStack(&tmpStack, otag, -1);
			  	--GFA_OperatorStack_Size;
			  }
			}

			continue;
		}
		
		// Virgule
		if (tag->tag==GFA_TAG_SIGN) {
			// Ajoute signe oprateur dans la pile d'expressions
			while (GFA_OperatorStack_Size) {
				otag = GFA_OperatorStack_PopTag();
				if ((otag->symbol==GFA_SYMBOL_BRACKET_OPEN) || 
				    (otag->symbol==GFA_SYMBOL_FUNCTION) ||
				    (otag->tag==GFA_TAG_VARTABLE) || 
			      (otag->tag==GFA_TAG_STRUCT))
				  break;
				
				GFA_Tag_PushFromStack(&tmpStack, otag, -1);
			  --GFA_OperatorStack_Size;
			}
			
			// Ajoute point virgule ou apostrophe
			if ((tag->subtag==GFA_SUBTAG_POINT_COMMA) || (tag->subtag==GFA_SUBTAG_APOST))
			  GFA_Tag_PushFromStack(&tmpStack, tag, -1);
			continue;
		}
		
		// Autre
		if (GFA_OperatorStack_Size) {
			otag = GFA_OperatorStack_PopTag();
			// Une fonction est directement ajoute dans la pile d'oprateurs
			if ((otag->symbol!=GFA_SYMBOL_BRACKET_OPEN) &&
			    (otag->symbol!=GFA_SYMBOL_FUNCTION) && 
			    (otag->tag!=GFA_TAG_VARTABLE) &&
			    (otag->tag!=GFA_TAG_STRUCT) &&
			    
			    (tag->symbol!=GFA_SYMBOL_FUNCTION) &&
			    (tag->tag!=GFA_TAG_VARTABLE) &&
			    (tag->tag!=GFA_TAG_STRUCT))
			{
        do {
        	otag = GFA_OperatorStack_PopTag();
        	if ((otag->symbol==GFA_SYMBOL_BRACKET_OPEN) || (tag->priority > otag->priority))
        	  break;
        	
        	// Vrification du niveau de l'oprateur
        	#ifdef GFA_PARSER_CHECK_OPERATORS_LEVEL
        	  if (!GFA_OperatorStack_CheckLevel(&tmpStack, otag, GFA_OperatorStack_PopLevel())) {
        	  	err = GFA_GET_ERR(GFA_ERR_SYNTAX_GENERAL, NULL, GFA_String_GetStr(&otag->expr));
        	  	goto end_function;
        	  }
        	#endif
        	
        	GFA_Tag_PushFromStack(&tmpStack, otag, -1);
        } while (--GFA_OperatorStack_Size); 
		  }
		}
		
		GFA_OperatorStack_Push(tag, GFA_Tag_GetStackSize(&tmpStack));
	}
		
	// Fin de la fonction
	end_function:
	  GFA_Tag_DeleteStack(stack_tag);
	  *stack_tag = tmpStack;
	  
	  return err;
	
	#undef GFA_OperatorStack_Push
	#undef GFA_OperatorStack_PopTag
	#undef GFA_OperatorStack_GetTag
	#undef GFA_OperatorStack_Size 
	
	#ifdef GFA_PARSER_CHECK_OPERATORS_LEVEL
	  #undef GFA_OperatorStack_PopLevel
	  #undef GFA_OperatorStack_GetLevel
	#endif
}


void GFA_Parser_SetNotationRules(GFA_StackTag *stack_tag) {
	short end_line = (short)GFA_Tag_GetStackSize(stack_tag) - 1;
	for (short i = (end_line - 1); i>=0; --i) {
		GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
		
		// Fin d'une ligne de code
		if (tag->symbol==GFA_SYMBOL_EOFLINE) {
			end_line = i;
			continue;
		}
		
		// Force affectation d'un For  conserver son rsultat
		if (tag->struct_idx==GFA_STRUCT_FOR) {
			tag = GFA_Tag_GetFromStack(stack_tag, i - 1);
			if (tag->symbol==GFA_SYMBOL_MATH_AFFEC_LEFT) {
			  tag->treetag = GFA_TREETAG_DONT_CLEAR_STACK;
			  --i;
			}
			
			continue;
		}
		
		// Affectation -> avec rsultat dans la pile
		if ((tag->symbol==GFA_SYMBOL_MATH_AFFEC_RIGHT) && (i!=(end_line - 1))) {
			const GFA_Tag *next_tag = GFA_Tag_GetFromStack(stack_tag, i + 1);
			if ((next_tag->struct_idx!=GFA_STRUCT_ELSE) && (next_tag->struct_idx!=GFA_STRUCT_THEN))
			  tag->treetag = GFA_TREETAG_DONT_CLEAR_STACK;
		}	
	}
}


/*
GFA_ERROR_NUMBER GFA_Parser_CheckSyntax(const GFA_StackLib *stack_lib, GFA_StackTag *stack_tag) {
	GFA_StackTag tmpStack_tag = GFA_Tag_CreateStack();
	
	GFA_ERROR_NUMBER err = GFA_ERR_OK;
	GFA_Tag *ltag = NULL, *rtag = NULL;
	
	for (unsigned short i = 0; i < GFA_Tag_GetStackSize(stack_tag); ++i) {
	  GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
	   
	  switch (tag->tag) {
	    // Fin de ligne de code
	    case GFA_TAG_EOFLINE:
	    {
	    	// Pile encore pleine ?
	      if (GFA_Tag_GetStackSize(&tmpStack_tag))
	        err = GFA_ERR_SYNTAX_GENERAL;
	    	  goto end_function;
	    	}
	    	
	    	continue;
	    }	
	  	
	  	// -------------
	  	// Tags  sauter
	  	// -------------
	  	case GFA_TAG_LABEL:
	  	  continue;
	  	
	  	// --------------------------------
	    // Ajouter directement dans la pile
	    // --------------------------------
	    case GFA_TAG_VALUE:
      case GFA_TAG_VAR:
      case GFA_TAG_SIGN:
      case GFA_TAG_ENDTAG:
      {
      	GFA_Tag_PushFromStack(&tmpStack_tag, tag, -1);
       	continue;
      }
	  	
	  	// --------------------------
      // Gestion paramtres tableau
      // --------------------------
      case GFA_TAG_VARTABLE:
      {
    	  short count = 0;
    	  for (; GFA_Tag_PopTagFromStack(&tmpStack_tag, &rtag, true); ++count) {
    	  	// Marqueur fin de tableau
    	  	if (rtag->tag==GFA_TAG_ENDTAG)
    	  	  break;
    		
    	  	// Signe (erreur de syntax)
    	  	if (rtag->tag==GFA_TAG_SIGN) {
    	  		err = GFA_ERR_SYNTAX_GENERAL;
    	  		goto end_function;
    	  	}
    		
    	  	// Forcment un nombre
    	  	if (((rtag->tag==GFA_TAG_VALUE) || (rtag->tag==GFA_TAG_VAR)) && (rtag->subtag<=GFA_SUBTAG_INT_S32))
    	  	  continue;
    		
    	  	err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
    	  	goto end_function;
    	  }
    	
    	  // Tableau renvoyant une donne
    	  if (count) {
    	  	tag->tag = GFA_TAG_VAR;
    	  	tag->treetag = GFA_TREETAG_VARTABLE;
    	  }
    	  
        GFA_Tag_PushFromStack(&tmpStack_tag, tag, -1);
        continue;
      }
	  	
	  	// ----------------------
      // Opration mathmatique
      // ----------------------
      case GFA_TAG_MATH:
      case GFA_TAG_LOGIC:
      case GFA_TAG_COMPARE:
      {
    	  // Opration unaire
    	  if ((tag->symbol==GFA_SYMBOL_MATH_NEGATIF) || (tag->symbol==GFA_SYMBOL_LOGIC_NOT)) 
    	  {
    	  	// Rcupre rvalue
          if (!GFA_Tag_PopTagFromStack(&tmpStack_tag, &rtag, false) ||
             (rtag->tag==GFA_TAG_SIGN)) 
          {
          	err = GFA_ERR_SYNTAX_GENERAL;
          	goto end_function;
          }
    		  
    		  // Opration avec types incompatibles
    		  if ((tag->tag==GFA_TAG_VARTABLE) || (rtag->subtag==GFA_SUBTAG_STRING)) {
    			  err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
    			  goto end_function;
    	  	}
    	  	
    	  	// Not avec un flottant donne un entier S32
    	  	if ((tag->symbol==GFA_SYMBOL_LOGIC_NOT) && (rtag->subtag==GFA_SUBTAG_FLOAT))
    	  	  rtag->symbol = GFA_SUBTAG_INT_S32;
    	  	
    	  	continue;
    	  }
    	     	  
    	  // Opration binaire
    	  if (// Extraction lvalue et rvalue
    	      !GFA_Tag_PopTagFromStack(&tmpStack_tag, &rtag, true) ||
    	      !GFA_Tag_PopTagFromStack(&tmpStack_tag, &ltag, (((tag->symbol==GFA_SYMBOL_MATH_AFFEC_LEFT) || (tag->symbol==GFA_SYMBOL_MATH_AFFEC_RIGHT)) && 
    	                                                       (tag->treetag!=GFA_TREETAG_DONT_CLEAR_STACK))) ||
    	      
    	      // Signe
    	      ((ltag->tag==GFA_TAG_SIGN) || (rtag->tag==GFA_TAG_SIGN)) ||
    	      
    	      // Tableau
    	      ((ltag->tag==GFA_TAG_VARTABLE) || (rtag->tag==GFA_TAG_VARTABLE)) ||
    	      
    	      // Vrification variable si affectation
    	      ((tag->symbol==GFA_SYMBOL_MATH_AFFEC_LEFT)  && (ltag->tag!=GFA_TAG_VAR)) ||
    		    ((tag->symbol==GFA_SYMBOL_MATH_AFFEC_RIGHT) && (rtag->tag!=GFA_TAG_VAR))) 
      	{
          err = GFA_ERR_SYNTAX_GENERAL;
          goto end_function;
        }
    		
    		// Vrification affectation (Bug  amliorer) (a=Timer*6->b)
    		if ((tag->symbol==GFA_SYMBOL_MATH_AFFEC_LEFT) || (tag->symbol==GFA_SYMBOL_MATH_AFFEC_RIGHT)) {
    			// Affectation correcte
    			if (((ltag->subtag<=GFA_SUBTAG_BOOL) && (rtag->subtag<=GFA_SUBTAG_BOOL)) ||
    			    ((ltag->subtag==GFA_SUBTAG_STRING) && (tag->subtag==GFA_SUBTAG_STRING)))
    			{
    			  // Si affectation -> avec reste dans la pile
    			  if (tag->symbol==GFA_SYMBOL_MATH_AFFEC_RIGHT)
    				  *ltag = *rtag;
    				continue;
    	    }
    	    
    	    err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
    	    goto end_function;
    		}
    			
    	  // Si forcment des nombres alors valides
    	  if ((ltag->subtag<=GFA_SUBTAG_BOOL) && (rtag->subtag<=GFA_SUBTAG_BOOL)) {
    	  	// Rsultat type nombre
    	  	ltag->tag = GFA_TAG_VALUE;
    	  	
    	  	// Rsultat boolen pour une comparaison ( amliorer)
    	  	if (tag->tag==GFA_TAG_COMPARE)
    	  	  ltag->subtag = GFA_SUBTAG_BOOL;
    	  	else if (tag->tag==GFA_TAG_LOGIC)
    	  		ltag->subtag = GFA_SUBTAG_INT_S32;
    	  	else if ((ltag->subtag==GFA_SUBTAG_FLOAT) || (rtag->subtag==GFA_SUBTAG_FLOAT))
    	  	  ltag->subtag = GFA_SUBTAG_FLOAT;
    	  	else
    	  	  ltag->subtag = GFA_SUBTAG_INT_S32;
    	  	  
    	  	continue;
    	  }
    	    
    	  // Oprations sur des chanes de caractres
    	  if (((tag->symbol==GFA_SYMBOL_MATH_ADD) || (tag->tag==GFA_TAG_COMPARE)) &&
    	      ((ltag->subtag==GFA_SUBTAG_STRING) && (rtag->subtag==GFA_SUBTAG_STRING))) 
    	  {
    	  	
    	  	// Rsultat du bon type
    	  	ltag->tag = GFA_TAG_VALUE;
    	  	ltag->subtag = (tag->tag==GFA_TAG_COMPARE)?
    	  	               GFA_SUBTAG_BOOL:
    	  	               GFA_SUBTAG_STRING;    	  	
    	  	continue;
    	  }
    	    
    	  err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
    	  goto end_function;
      }
	  	
	  	// --------
	  	// Fonction
	  	// --------
	  	case GFA_TAG_SYMBOL:
	  	{
	  		const GFA_Lib *lib = GFA_Lib_GetLib(stack_lib, tag->info.library.index);
	  		GFA_Lib_ParamsInfo pinfo = GFA_Lib_GetParamsInfoOfFunction(lib, &tag->info.library.object);
	  	
	  		short stack_end = GFA_Tag_GetStackSize(&tmpStack_tag);
	  		short stack_begin = stack_end;
	  		
	  		// Recherche dbut de la liste d'argument
	  		while ((--stack_begin)>=0) {
	  			rtag = GFA_Tag_GetFromStack(&tmpStack_tag, stack_begin);
	  			if (rtag->tag==GFA_TAG_ENDTAG)
	  				break;
	  			
	  			// Dtection d'un signe
	  			if (rtag->tag==GFA_TAG_SIGN) {
	  				err = GFA_ERR_SYNTAX_GENERAL;
	  				goto end_function;
	  			}
	  		}
	  		++stack_begin;
	  		
	  		// Trop d'arguments, aucun paramtre
	  		if ((pinfo.nlist==0) && (stack_begin!=stack_end)) {
	  			err = GFA_ERR_SYNTAX_LOT_ARGUMENTS;
	  			goto end_function;
	  		}
	  		  			  		
	  		// Teste l'ensemble des listes
	  		short best_nparam = -1;
	  		for (short list_n = (pinfo.nlist - 1); list_n>=0; --list_n) {
	  			short nparam = GFA_Lib_GetNumberParamsOfFunction(lib, &tag->info.library.object, list_n);
	  			const GFA_Lib_Param *params = GFA_Lib_GetParamsOfFunction(lib, &tag->info.library.object, list_n);
	  			
	  			short param_n = 0; 			
	  			short stack_n = stack_begin;
	  			
	  			// Parcours la liste des arguments
	  			for (; stack_n < stack_end; ++stack_n, ++param_n) {
	  				// Dpassement de la liste des paramtres
	  				if (param_n>=nparam) {
	  					// Rpter la liste
	  					if (pinfo.is_repeated)
	  					  param_n = 0;
	  					// La liste de paramtres est valide mais la pile possde trop d'arguments
	  					else {
	  						err = GFA_ERR_SYNTAX_LOT_ARGUMENTS;
	  						goto end_function;
	  					}
	  				}
	  				
	  				// Extrait argument
	  				rtag = GFA_Tag_GetFromStack(&tmpStack_tag, stack_n);
	  				
	  				// Extrait argument prcdent
	  				if (stack_n!=stack_begin) ltag = GFA_Tag_GetFromStack(&tmpStack_tag, stack_n - 1);
	  				
	  				    // Container valide ?
	  				if (((GFA_LIB_PARAM_PREVIEW_CONTAINER(params[param_n].container) && (ltag->tag==rtag->tag)) ||
	  				     ((params[param_n].container.bit_field & CONTAINER_VARTABLE) && (rtag->tag==GFA_TAG_VARTABLE)) ||
	  				     ((params[param_n].container.bit_field & CONTAINER_VAR)      && (rtag->tag==GFA_TAG_VAR)) ||
	  				     ((params[param_n].container.bit_field & CONTAINER_VALUE)    && (rtag->tag==GFA_TAG_VALUE))) &&
	  				    // Type valide ?
  					    ((GFA_LIB_PARAM_PREVIEW_TYPE(params[param_n].type) && (ltag->subtag==rtag->subtag)) ||
	  					   ((params[param_n].type.bit_field & TYPE_STRING)   && (rtag->subtag==GFA_SUBTAG_STRING)) ||
	  					   ((params[param_n].type.bit_field & TYPE_BOOLEAN)  && (rtag->subtag==GFA_SUBTAG_BOOL)) ||
	  					   ((params[param_n].type.bit_field & TYPE_FLOAT)    && (rtag->subtag==GFA_SUBTAG_FLOAT)) ||
	  					   ((params[param_n].type.bit_field & TYPE_S32)      && (rtag->subtag==GFA_SUBTAG_INT_S32)) ||
	  					   ((params[param_n].type.bit_field & TYPE_S16)      && (rtag->subtag==GFA_SUBTAG_INT_S16)) ||
	  					   ((params[param_n].type.bit_field & TYPE_U8)       && (rtag->subtag==GFA_SUBTAG_INT_U8))))
	  			  {
	  			  	continue;
	  			  }
	  				
	  				// Retient la meilleure erreur possible
	  				if (best_nparam < nparam) {
	  				  err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
	  				  best_nparam = nparam;
	  				}
	  				break;
	  			}
	  			
	  			// Liste d'argments valide
	  			if (stack_n==stack_end) {  				
	  				// Paramtre restant n'est pas facultatif
	  				if ((param_n < nparam) && !GFA_LIB_PARAM_FACULT(params[param_n])) {
	  					if (best_nparam<=param_n) {
	  				    err = GFA_ERR_SYNTAX_FEW_ARGUMENTS;
	  				    best_nparam = (param_n + 1);
	  				  }
	  				  continue;
	  				}
	  				
	  				// Liste entirement valide
	  				err = GFA_ERR_OK;
	  				break;
	  			}
	  		}	
	  		
	  		// Une erreur s'est produire ?
	  		if (err)
	  		  goto end_function;
	  				
	  		// Rsultat d'une fonction
	  		GFA_Tag sav_tag = GFA_Tag_Create(NULL, GFA_TAG_VALUE, GFA_SUBTAG_NONE, GFA_PRIORITY_NONE);
	  		GFA_enumTypeFunction function_type = GFA_Lib_Object_GetFunctionType(&tag->info.library.object);
	  		
	  		// Rsultat correspond au premier paramtre
	  		if (GFA_LIB_FUNC_RETURN_FIRST_PARAM_TYPE(function_type)) {
	  			rtag = GFA_Tag_GetFromStack(&tmpStack_tag, stack_begin);
	  			sav_tag.subtag = rtag->subtag;
	  		}
	  		// Rsultat simple de la fonction
	  		else {	
	  			if (function_type.bit_field & RETURN_U8)
	  			  sav_tag.subtag = GFA_SUBTAG_INT_U8;
	  			else if (function_type.bit_field & RETURN_S16)
	  			  sav_tag.subtag = GFA_SUBTAG_INT_S16;
	  			else if (function_type.bit_field & RETURN_S32)
	  				sav_tag.subtag = GFA_SUBTAG_INT_S32;  
	  		  else if (function_type.bit_field & RETURN_FLOAT)
	  		    sav_tag.subtag = GFA_SUBTAG_FLOAT;
	  			else if (function_type.bit_field & RETURN_BOOLEAN)
	  				sav_tag.subtag = GFA_SUBTAG_BOOL;
	  		  else if (function_type.bit_field & RETURN_STRING)
	  				sav_tag.subtag = GFA_SUBTAG_STRING;
	  		}
	  		
	  		// Restaure tmpStack_tag et ajoute si ncessaire la valeur de retour
	  		GFA_Tag_DeleteNItemsFromStack(&tmpStack_tag, (stack_end - stack_begin) + (stack_begin?1:0));
	  		if (GFA_LIB_FUNC_RETURN_VALUE(function_type))
	  		  GFA_Tag_PushFromStack(&tmpStack_tag, &sav_tag, -1);
	  		
	  		continue;
	  	}
	  	
	  	// ---------
	  	// Structure
	  	// ---------
	  	default:
	  	{
	  	  switch (tag->struct_idx) {
	  	  	// Tag inconnu
	  	  	case -1:
	  	  	{
	  	  		err = GFA_ERR_INTERNAL_UNKNOWN_TAG;
	  	  		goto end_function;
	  	  	}
	  	  	
	  	  	// Une valeur doit pouvoir tre utilise dans tmpStack_tag
	  	  	case GFA_STRUCT_WHILE:
	  	  	case GFA_STRUCT_UNTIL:
	  	  	case GFA_STRUCT_FOR:    case GFA_STRUCT_TO:     case GFA_STRUCT_DOWNTO: case GFA_STRUCT_STEP:
	  	  	case GFA_STRUCT_IF:     case GFA_STRUCT_ELSEIF:
	  	  	case GFA_STRUCT_EXITIF:
	  	  	{
	  	  		if (GFA_Tag_GetStackSize(&tmpStack_tag)==1) {
	  	  		  rtag = GFA_Tag_GetFromStack(&tmpStack_tag, 0);
	  	  		  GFA_Tag_ClearStack(&tmpStack_tag);
	  	  		  
	  	  		  // Gestion erreur de syntaxe (Grer bool pour To Downto?)
	  	  		  if (!((rtag->tag==GFA_TAG_VARTABLE) ||
	  	  		        (rtag->subtag==GFA_SUBTAG_STRING) || 
	  	  		        ((tag->struct_idx==GFA_STRUCT_FOR) && (rtag->tag!=GFA_TAG_VAR))))
	  	  		  {
	  	  		    continue;
	  	  		  }
	  	  		}
	  	  		
	  	  		err = GFA_ERR_SYNTAX_GENERAL;
	  	    	goto end_function;
	  	  	}
	  	  	
	  	  	// Gestion de AT avec 2 paramtres, pas plus ni moins
	  	  	case GFA_STRUCT_AT:
	  	  	{
	  	  		short count = 0;
    	      for (; GFA_Tag_PopTagFromStack(&tmpStack_tag, &rtag, true); ++count) {
    	  	    // Marqueur fin de tableau
    	  	    if (rtag->tag==GFA_TAG_ENDTAG)
    	  	      break;
	  	  		  
	  	  		  // Signe (erreur de syntax)
    	  	    if (rtag->tag==GFA_TAG_SIGN) {
    	  		    err = GFA_ERR_SYNTAX_GENERAL;
    	  		    goto end_function;
    	  	    }
    		
    	  	    // Forcment un nombre
    	  	    if (((rtag->tag==GFA_TAG_VALUE) || (rtag->tag==GFA_TAG_VAR)) && (rtag->subtag<=GFA_SUBTAG_INT_S32))
    	  	      continue;
    		
    	  	    err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
    	  	    goto end_function;
	  	  	  }
	  	  	  
	  	  	  // Vrification nombre d'arguments
	  	  	  if (count < 2)
	  	  	    err = GFA_ERR_SYNTAX_FEW_ARGUMENTS;
	  	  	  else if (count > 2)
	  	  	    err = GFA_ERR_SYNTAX_LOT_ARGUMENTS;
	  	  	  else
	  	  	    continue;
	  	  	  
	  	  	  goto end_function;
	  	  	}
	  	  	
	  	  	// Gestion de PRINT
	  	  	case GFA_STRUCT_PRINT:
	  	  	{
	  	  		short count = 0;
	  	  		bool preview_point_comma = false;
    	      for (; GFA_Tag_PopTagFromStack(&tmpStack_tag, &rtag, true); ++count) {
    	      	// Tableau
    	      	if (rtag->tag==GFA_TAG_VARTABLE) {
    	      		err = GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES;
    	      		goto end_function;
    	      	}
    	      	
    	      	// Point virgule
    	      	if ((rtag->tag==GFA_TAG_SIGN) && (rtag->subtag==GFA_SUBTAG_POINT_COMMA)) {
    	      		if (preview_point_comma) {
    	      			err = GFA_ERR_SYNTAX_GENERAL;
    	      			goto end_function;
    	      		}
    	      		
    	      		preview_point_comma = true;
    	      	}
    	      	else
    	      	  preview_point_comma = false;
    	      }
    	      
    	      continue;
	  	  	}
	  	  	
	  	  	default:;
	  	  }
	  	}
	  }
	}
	
	end_function:
	  GFA_Tag_DeleteStack(&tmpStack_tag);
	
	  return err;
}
*/


GFA_Error GFA_Parser_CheckStackTag(GFA_StackTag *stack_tag) {
	for (short i = (short)GFA_Tag_GetStackSize(stack_tag) - 2; i>=0; --i) {
		const GFA_Tag *tag = GFA_Tag_GetFromStack(stack_tag, i);
		
		// Vrification structure DATA
		if (tag->struct_idx==GFA_STRUCT_DATA) {
			do {
				tag = GFA_Tag_GetFromStack(stack_tag, --i);
				if (tag->symbol==GFA_SYMBOL_EOFLINE)
				  break;
				
				if (tag->tag!=GFA_TAG_VALUE)
				  return GFA_GET_ERR(GFA_ERR_SYNTAX_INCOMPATIBLE_TYPES, NULL, GFA_String_GetStr(&tag->expr));
			} while (i > 0);
			
			continue;
		}
		
		// READ  vrifier dans CheckSyntax
	}
	
	return GFA_GET_ERR_OK;
}