// C Source File
// Created 22/06/2006; 14:44:17

#include "tigcclib.h"
#include "gfabasic.h"
#include "strings.h"
#include "charset.h"

inline GFA_String GFA_String_Create(const char *str, unsigned short size) {
  return (GFA_String){str, size};  
}

inline GFA_String GFA_String_Create2(const char *str) {
  return (GFA_String){str, strlen(str)};
}


inline const char *GFA_String_GetStr(const GFA_String *str) {
  Assert(str);
  
  return str->data;
}


inline unsigned short GFA_String_GetSize(const GFA_String *str) {
  Assert(str);
  
  return str->size;
}


short GFA_String_StrcmpUpper(const char *strUpper, const GFA_String *str) {
  Assert(strUpper && str);
  
  const char *pstr = GFA_String_GetStr(str);
  unsigned short size = GFA_String_GetSize(str);
  short res;
  
  while (size--) {
    if ((res = (*strUpper++ - GFA_Charset_LetterUpper(*(pstr++)))))
      return res;
  }
  
  return *strUpper;
}


short GFA_String_strcmpNoCase(const GFA_String *str1, const GFA_String *str2) {
  Assert(str1 && str2);
  
  short res;
  unsigned short size = GFA_String_GetSize(str1);
  if ((res = (size - GFA_String_GetSize(str2))))
    return res;
  
  const char *pstr1 = GFA_String_GetStr(str1);
  const char *pstr2 = GFA_String_GetStr(str2);

  while (size--) {
    if ((res = (GFA_Charset_LetterUpper(*(pstr1++)) - GFA_Charset_LetterUpper(*(pstr2++)))))
      return res;
  }
  
  return 0;
}


short GFA_String_strcmpUpperWithX(const GFA_String *strU, const GFA_String *strX) {
	Assert(strU && strX);
	
	short res;
	unsigned short sizeU = GFA_String_GetSize(strU);
	unsigned short sizeX = GFA_String_GetSize(strX);
	unsigned short max_size = (sizeU < sizeX)?sizeU:sizeX;
  
  const char *pstrU = GFA_String_GetStr(strU);
  const char *pstrX = GFA_String_GetStr(strX);
  
  while (max_size--) {
    if ((res = (*(pstrU++) - GFA_Charset_LetterUpper(*(pstrX++)))))
      return res;
  }
  
  return (sizeU - sizeX);
}


float GFA_String_StrToFloat(const GFA_String *str) {
  Assert(str && (GFA_String_GetSize(str) < GFA_BASIC_MAX_LINE_SIZE));
  
  char buffer[GFA_BASIC_MAX_LINE_SIZE + 1];
  const char *pstr = GFA_String_GetStr(str);
  char *pbuffer = buffer;
  for (unsigned short i = 0; i < GFA_String_GetSize(str); ++i) {
    if ((*pstr=='E') || (*pstr=='e')) *(pbuffer++) = CHAR_E; 
    else if (*pstr=='-')              *(pbuffer++) = CHAR_NEGATIF;
    else if (*pstr!='+')              *(pbuffer++) = *pstr;
    ++pstr; 
  }
  *pbuffer = CHAR_NULL;
 
  return atof(buffer);
}


const char *GFA_String_GetCString(const GFA_String *str) {
	Assert(str && (str->size<=GFA_BASIC_MAX_LINE_SIZE));
	
	static char buffer[GFA_BASIC_MAX_LINE_SIZE + 1];
	memcpy(buffer, str->data, str->size);
	buffer[str->size] = CHAR_NULL;
	return buffer;
}
