// Header File
// Created 22/06/2006; 14:44:27

#ifndef _GFA_STRINGS_H_
#define _GFA_STRINGS_H_

#include "tigcclib.h"

#define GFA_STRING_NULL		      (const GFA_String){NULL, 0}

/** @brief Structure d'une chane de caractres */
typedef struct {
  const char *data;
  unsigned short size;
} GFA_String;


/**
 * @brief Crer un pointeur vers une chane de caractres
 *
 * @param[in] str : Chane de caractres
 * @param[in] size : Taille de la chane de caractres en octets
 * @return le pointeur de la chane de caractres
 */
extern inline GFA_String GFA_String_Create(const char *str, unsigned short size);


/**
 * @brief Crer un pointeur vers une chane de caractres
 *
 * @param[in] str : Chane de caractres
 * @return le pointeur de la chane de caractres
 */
extern inline GFA_String GFA_String_Create2(const char *str);


/**
 * @brief Retourne un pointeur vers le contenu de la chane de caractres
 *
 * @param[in] str : Chane de caractres
 * @return un pointeur vers le contenu de la chane de caractres
 */
extern inline const char *GFA_String_GetStr(const GFA_String *str);


/**
 * @brief Retourne la taille d'une chane de caractres
 *
 * @param[in] str : Chane de caractres
 * @return la taille de la chane de caractres
 */
extern inline unsigned short GFA_String_GetSize(const GFA_String *str);


/**
 * @brief Comparaison d'une chane en majuscules avec une chane de caractres
 *
 * @param[in] strUpper : Chane de caractres en majuscules
 * @param[in] str : Chane de caractre quelconque
 * @return true si les deux chanes sont identiques, sinon false
 *
 * @note str n'est pas forcment en majuscules
 */
extern short GFA_String_StrcmpUpper(const char *strUpper, const GFA_String *str);


/**
 * @brief Comparaison de chane de caractres insensible  la case
 *
 * @param[in] str1 : 1re chane de caractre
 * @param[in] str2 : 2me chane de caractre
 * @return true si les deux chanes sont identiques, sinon false
 */
extern short GFA_String_strcmpNoCase(const GFA_String *str1, const GFA_String *str2);

extern short GFA_String_strcmpUpperWithX(const GFA_String *strU, const GFA_String *strX);


/**
 * @brief Conversion d'une chanes de caractres en un flottant
 *
 * @param[in] str : Chane de caractres reprsentant un flottant
 * @return un flottant
 *
 * @note Les nombres utilisant les signes + - e E sont valides
 * @note Utiliser is_nan pour dterminer si le flottant renvoye est valide (pas overflow...)
 */
extern float GFA_String_StrToFloat(const GFA_String *str);

extern const char *GFA_String_GetCString(const GFA_String *str);

#endif