// Header File
// Created 23/06/2006; 12:31:49

#ifndef _GFA_TAGS_H_
#define _GFA_TAGS_H_

#include "tbl_tags.h"

#define GFA_TAG_STACK_SIZE          64

/**
 * @brief Structure d'une pile de tags
 */
typedef struct {
  GFA_Tag *item;
  unsigned short size;
  bool parser_area_defined;
} GFA_StackTag;


/**
 * @brief Structure d'une pile d'oprateurs
 */
typedef struct {
	const GFA_Tag **item;
	unsigned short size;
} GFA_OperatorStack;


/**
 * @brief Cration d'une pile de tags
 * 
 * @return une pile de tags vide
 */
extern GFA_StackTag GFA_Tag_CreateStack();


/**
 * @brief Efface une pile de tags
 *
 * @param[in,out] stack : Pointeur vers une pile de tags
 */
extern inline void GFA_Tag_DeleteStack(GFA_StackTag *stack);


extern inline bool GFA_Tag_GetParserAreaDefined(const GFA_StackTag *stack);
extern inline void GFA_Tag_SetParserAreaDefined(GFA_StackTag *stack);

/**
 * @brief Renvoie un tag  partir des informations fournies  la fonction
 *
 * @param[in] expr : Chane de caractres reprsentant une expression
 * @param[in] tag : Tag de l'expression
 * @param[in] subtag : Sous tag de l'expression
 * @param[in] priority : Priorit de calcul pour l'expression
 *
 * @return une structure reprsentant le tag
 */
extern GFA_Tag GFA_Tag_Create(const GFA_String *expr, GFA_TAG tag, GFA_SUBTAG subtag, GFA_PRIORITY priority);


/**
 * @brief Ajoute un tag dans une pile
 *
 * @param[in, out] stack : Pile de tags
 * @param[in] tag : Tag
 *
 * @return true si le tag a t correctement ajout, sinon false
 */
extern bool GFA_Tag_PushFromStack(GFA_StackTag *stack, const GFA_Tag *tag, short pos);


/**
 * @brief Efface un tag dans une pile
 *
 * @param[in, out] stack : Pile de tags
 * @param[in] n : Indice du tag  supprimer
 */
extern void GFA_Tag_DeleteFromStack(GFA_StackTag *stack, unsigned short n);

extern inline GFA_Tag *GFA_Tag_GetFromStack(const GFA_StackTag *stack, unsigned short n);

extern inline unsigned short GFA_Tag_GetStackSize(const GFA_StackTag *stack);

extern inline void GFA_Tag_ClearStack(GFA_StackTag *stack);

extern bool GFA_Tag_PopTagFromStack(GFA_StackTag *stack, GFA_Tag **tag, bool decrease);

extern inline void GFA_Tag_DeleteNItemsFromStack(GFA_StackTag *stack, unsigned short n);


#ifdef _DEBUG
  extern void GFA_Tag_PrintStack(const GFA_StackLib *stack_lib, const GFA_StackTag *stack_tag);
#endif

#endif