// Header File
// Created 23/09/2006; 14:11:30

#ifndef _GFA_TBL_PARSER_H_
#define _GFA_TBL_PARSER_H_

#include "strings.h"

/** @brief Table des commandes du parseur disponibles */
extern const char *GFA_TBL_PARSER[];


/** 
 * @brief Enumration des commandes disponibles,
 * Elle suit les indices du tableau de structures
 */
typedef enum {
  GFA_PARSER_INCLUDE,
  GFA_PARSER_VARIABLE_NOT_SUFFIXED
  /*GFA_PARSER_OPTION,
  GFA_PARSER_EXPLICIT,*/
} GFA_PARSER;


/**
 * @brief Retourne l'indice d'une commande  partir de son nom
 *
 * @param[in] str : Chane de caractres reprsentant le nom de la commande
 * @return l'indice de la commande dans le tableau sinon -1
 *
 * @note Cette fonction est insensible  la case
 */
extern short GFA_Tbl_Parser_Find(const GFA_String *str);

#endif
