// C Source File
// Created 19/07/2006; 14:23:26

#include "tbl_structs.h"

const struct s_Structs {
	const char *name;
	bool first;
} GFA_TBL_STRUCTS[] = {
	// Structures conditionnelles
	{"IF",     true},
	{"THEN",   false},
	{"ELSEIF", true},
	{"ELSE",   true},
	{"ENDIF",  true},
	
	// Boucle For
	{"FOR",    true},
	{"TO",     false},
	{"DOWNTO", false},
	{"STEP",   false},
	{"NEXT",   true},
	
	// Boucle Do...Loop
	{"DO",   true},
	{"LOOP", true},
	
	// Boucle Repeat...Until
	{"REPEAT", true},
	{"UNTIL",  true},
	
	// Boucle While...Wend
	{"WHILE", true},
	{"WEND",  true},
	
	// Gestion boucle
	{"EXIT",     true},
	{"EXITIF",   true},
	{"CONTINUE", true},
	
	// Goto
	{"GOTO", true},
	
	// Structures donnes
	{"DATA",    true},
	{"READ",    true},
	{"RESTORE", true},
	
	// Structures d'affichage
	{"PRINT", true},
	{"AT",    false},
	
	// Autre
	{"AS", false},
	
	// Types de donnes
	{"BYTE",    false},
	{"SHORT",   false},
	{"INTEGER", false},
	{"FLOAT",   false},
	{"BOOLEAN", false},
	{"STRING",  false},
	{"NOTHING", false}
};


short GFA_Structs_GetIndex(const GFA_String *str) {
  for (short i = (sizeof(GFA_TBL_STRUCTS) / sizeof(struct s_Structs)) - 1; i>=0; --i) {
    if (!GFA_String_StrcmpUpper(GFA_TBL_STRUCTS[i].name, str))
      return i;
  }
  
  return -1;
}


inline bool GFA_Structs_First(GFA_STRUCT idx) {
	return GFA_TBL_STRUCTS[idx].first;
}


inline const char *GFA_Structs_GetName(GFA_STRUCT idx) {
	return GFA_TBL_STRUCTS[idx].name;
}