// Header File
// Created 19/07/2006; 14:22:41

#ifndef _GFA_TBL_STRUCTS_H_
#define _GFA_TBL_STRUCTS_H_

#include "strings.h"


/** 
 * @brief Enumration des structures disponibles,
 * Elle suit les indices du tableau de structures
 */
typedef enum {
  GFA_STRUCT_IF,     GFA_STRUCT_THEN,   GFA_STRUCT_ELSEIF, GFA_STRUCT_ELSE, GFA_STRUCT_ENDIF,
  GFA_STRUCT_FOR,    GFA_STRUCT_TO,     GFA_STRUCT_DOWNTO, GFA_STRUCT_STEP, GFA_STRUCT_NEXT,
  GFA_STRUCT_DO,     GFA_STRUCT_LOOP,   
  GFA_STRUCT_REPEAT, GFA_STRUCT_UNTIL,
  GFA_STRUCT_WHILE,  GFA_STRUCT_WEND,
  GFA_STRUCT_EXIT,   GFA_STRUCT_EXITIF, GFA_STRUCT_CONTINUE,
  GFA_STRUCT_GOTO,
  GFA_STRUCT_DATA,   GFA_STRUCT_READ,   GFA_STRUCT_RESTORE,
  GFA_STRUCT_PRINT,  GFA_STRUCT_AT,
  
  GFA_STRUCT_AS,
  GFA_STRUCT_BYTE,   GFA_STRUCT_SHORT,  GFA_STRUCT_INTEGER, GFA_STRUCT_FLOAT, GFA_STRUCT_BOOLEAN, GFA_STRUCT_STRING, GFA_STRUCT_NOTHING,

  GFA_NO_STRUCT = -1
} GFA_STRUCT;


/**
 * @brief Retourne l'indice d'une structure  partir de son nom
 *
 * @param[in] str : Chane de caractres reprsentant le nom de la structure
 * @return l'indice de la structure dans le tableau sinon -1
 *
 * @note Cette fonction est insensible  la case
 */
extern short GFA_Structs_GetIndex(const GFA_String *str);
extern inline bool GFA_Structs_First(GFA_STRUCT idx);
extern inline const char *GFA_Structs_GetName(GFA_STRUCT idx);

#endif
