// C Source File
// Created 23/06/2006; 12:50:59

#include "tbl_tags.h"

const struct s_Number_Suffix_Table GFA_Number_Suffix_Table[4] = {
  {'|', GFA_SUBTAG_INT_U8},
  {'&', GFA_SUBTAG_INT_S16},
  {'%', GFA_SUBTAG_INT_S32},
  {'#', GFA_SUBTAG_FLOAT}
};


const struct s_Symbol_Suffix_Table GFA_Symbol_Suffix_Table[7] = {
	// Variables
  {'|', GFA_TAG_VAR, GFA_SUBTAG_INT_U8},
  {'&', GFA_TAG_VAR, GFA_SUBTAG_INT_S16},
  {'%', GFA_TAG_VAR, GFA_SUBTAG_INT_S32},
  {'#', GFA_TAG_VAR, GFA_SUBTAG_FLOAT},
  {'!', GFA_TAG_VAR, GFA_SUBTAG_BOOL},
  {'$', GFA_TAG_VAR, GFA_SUBTAG_STRING},
   
  // Fonctions
  {'?', GFA_TAG_SYMBOL, GFA_SUBTAG_FUNCTION}
};


const struct s_Sign_Table GFA_Sign_Table[25] = {
  // Signes mathmatiques d'affectations
  {"\x16", 1, GFA_TAG_MATH,    GFA_SUBTAG_AFFEC_RIGHT},
  {"->",   2, GFA_TAG_MATH,    GFA_SUBTAG_AFFEC_RIGHT},
     
  // Signes de comparaisons
  {"\x9C", 1, GFA_TAG_COMPARE, GFA_SUBTAG_INFEGAL},
  {"<=",   2, GFA_TAG_COMPARE, GFA_SUBTAG_INFEGAL},
  {"\x9E", 1, GFA_TAG_COMPARE, GFA_SUBTAG_SUPEGAL},
  {">=",   2, GFA_TAG_COMPARE, GFA_SUBTAG_SUPEGAL},
  {"\x9D", 1, GFA_TAG_COMPARE, GFA_SUBTAG_DIFF},
  {"<>",   2, GFA_TAG_COMPARE, GFA_SUBTAG_DIFF},
  {"=",    1, GFA_TAG_COMPARE, GFA_SUBTAG_EGAL},
  {"<",    1, GFA_TAG_COMPARE, GFA_SUBTAG_INFERIOR},
  {">",    1, GFA_TAG_COMPARE, GFA_SUBTAG_SUPERIOR},
    
  // Signes mathmatiques
  {"+",    1, GFA_TAG_MATH,    GFA_SUBTAG_ADD},
  {"-",    1, GFA_TAG_MATH,    GFA_SUBTAG_SUB},
  {"*",    1, GFA_TAG_MATH,    GFA_SUBTAG_MUL},
  {"/",    1, GFA_TAG_MATH,    GFA_SUBTAG_DIV},
  {"\\",   1, GFA_TAG_MATH,    GFA_SUBTAG_DIV_INT},
  {"^",    1, GFA_TAG_MATH,    GFA_SUBTAG_EXP},
  {"\xAD", 1, GFA_TAG_MATH,    GFA_SUBTAG_NEGATIF},
    
  // Autres signes
  {"(",    1, GFA_TAG_SIGN,    GFA_SUBTAG_BRACKET_OPEN},
  {")",    1, GFA_TAG_SIGN,    GFA_SUBTAG_BRACKET_CLOSE},
  {",",    1, GFA_TAG_SIGN,    GFA_SUBTAG_COMMA},
  {";",    1, GFA_TAG_SIGN,    GFA_SUBTAG_POINT_COMMA},
  {"'",    1, GFA_TAG_SIGN,    GFA_SUBTAG_APOST},
  {":",    1, GFA_TAG_SIGN,    GFA_SUBTAG_TWO_POINT},
  {"!",    1, GFA_TAG_SIGN,    GFA_SUBTAG_EXCLAMATION},	
};


const struct s_Symbol_Table GFA_Symbol_Table[8] = {
  {"DIV", GFA_TAG_MATH, GFA_SUBTAG_DIV_INT},
  {"MOD", GFA_TAG_MATH, GFA_SUBTAG_MOD},
  {"NOT", GFA_TAG_LOGIC, GFA_SUBTAG_NOT},
  {"AND", GFA_TAG_LOGIC, GFA_SUBTAG_AND},
  {"OR",  GFA_TAG_LOGIC, GFA_SUBTAG_OR},
  {"XOR", GFA_TAG_LOGIC, GFA_SUBTAG_XOR},
  {"IMP", GFA_TAG_LOGIC, GFA_SUBTAG_IMP},
  {"EQV", GFA_TAG_LOGIC, GFA_SUBTAG_EQV}
};


const GFA_PRIORITY GFA_Math_PriorityTable[] = {
  GFA_PRIORITY_AFFEC_LEFT, GFA_PRIORITY_AFFEC_RIGHT,
  GFA_PRIORITY_ADD_SUB, GFA_PRIORITY_ADD_SUB, 
  GFA_PRIORITY_MUL_DIV, GFA_PRIORITY_MUL_DIV, 
  GFA_PRIORITY_DIV_MOD, GFA_PRIORITY_DIV_MOD,
  GFA_PRIORITY_EXP,
  GFA_PRIORITY_SIGN
};
