// Header File
// Created 23/06/2006; 12:51:14

#ifndef _GFA_TBL_TAGS_H_
#define _GFA_TBL_TAGS_H_

#include "config.h"
#include "gfalib.h"
#include "strings.h"

#define GFA_TAG_CREATE_SYMBOL(a, b)             (unsigned short)((a << 8) | (b & 0xFF))
#define GFA_SYMBOL_COMMENT                      GFA_TAG_CREATE_SYMBOL(GFA_TAG_COMMENT, GFA_SUBTAG_NONE)
#define GFA_SYMBOL_PARSER                       GFA_TAG_CREATE_SYMBOL(GFA_TAG_PARSER,  GFA_SUBTAG_NONE)
#define GFA_SYMBOL_STRUCT                       GFA_TAG_CREATE_SYMBOL(GFA_TAG_STRUCT,  GFA_SUBTAG_NONE)
#define GFA_SYMBOL_LABEL                        GFA_TAG_CREATE_SYMBOL(GFA_TAG_LABEL,   GFA_SUBTAG_NONE)
#define GFA_SYMBOL_FUNCTION                     GFA_TAG_CREATE_SYMBOL(GFA_TAG_SYMBOL,  GFA_SUBTAG_FUNCTION)
#define GFA_SYMBOL_CONSTANT                     GFA_TAG_CREATE_SYMBOL(GFA_TAG_SYMBOL,  GFA_SUBTAG_CONSTANT)
#define GFA_SYMBOL_ENDTAG                       GFA_TAG_CREATE_SYMBOL(GFA_TAG_ENDTAG,  GFA_SUBTAG_NONE)
#define GFA_SYMBOL_EOFLINE                      GFA_TAG_CREATE_SYMBOL(GFA_TAG_EOFLINE, GFA_SUBTAG_NONE)

#define GFA_SYMBOL_VALUE_INT_U8                 GFA_TAG_CREATE_SYMBOL(GFA_TAG_VALUE,   GFA_SUBTAG_INT_U8)
#define GFA_SYMBOL_VALUE_INT_S16                GFA_TAG_CREATE_SYMBOL(GFA_TAG_VALUE,   GFA_SUBTAG_INT_S16)
#define GFA_SYMBOL_VALUE_INT_S32                GFA_TAG_CREATE_SYMBOL(GFA_TAG_VALUE,   GFA_SUBTAG_INT_S32)
#define GFA_SYMBOL_VALUE_FLOAT                  GFA_TAG_CREATE_SYMBOL(GFA_TAG_VALUE,   GFA_SUBTAG_FLOAT)
#define GFA_SYMBOL_VALUE_STRING                 GFA_TAG_CREATE_SYMBOL(GFA_TAG_VALUE,   GFA_SUBTAG_STRING)

#define GFA_SYMBOL_BRACKET_OPEN                 GFA_TAG_CREATE_SYMBOL(GFA_TAG_SIGN,    GFA_SUBTAG_BRACKET_OPEN)
#define GFA_SYMBOL_BRACKET_CLOSE                GFA_TAG_CREATE_SYMBOL(GFA_TAG_SIGN,    GFA_SUBTAG_BRACKET_CLOSE)
#define GFA_SYMBOL_COMMA                        GFA_TAG_CREATE_SYMBOL(GFA_TAG_SIGN,    GFA_SUBTAG_COMMA)
#define GFA_SYMBOL_POINT_COMMA                  GFA_TAG_CREATE_SYMBOL(GFA_TAG_SIGN,    GFA_SUBTAG_POINT_COMMA)
#define GFA_SYMBOL_APOST                        GFA_TAG_CREATE_SYMBOL(GFA_TAG_SIGN,    GFA_SUBTAG_APOST)
#define GFA_SYMBOL_TWO_POINT                    GFA_TAG_CREATE_SYMBOL(GFA_TAG_SIGN,    GFA_SUBTAG_TWO_POINT)

#define GFA_SYMBOL_MATH_AFFEC_LEFT              GFA_TAG_CREATE_SYMBOL(GFA_TAG_MATH,    GFA_SUBTAG_AFFEC_LEFT)
#define GFA_SYMBOL_MATH_AFFEC_RIGHT             GFA_TAG_CREATE_SYMBOL(GFA_TAG_MATH,    GFA_SUBTAG_AFFEC_RIGHT)
#define GFA_SYMBOL_MATH_ADD                     GFA_TAG_CREATE_SYMBOL(GFA_TAG_MATH,    GFA_SUBTAG_ADD)
#define GFA_SYMBOL_MATH_SUB                     GFA_TAG_CREATE_SYMBOL(GFA_TAG_MATH,    GFA_SUBTAG_SUB)
#define GFA_SYMBOL_MATH_NEGATIF                 GFA_TAG_CREATE_SYMBOL(GFA_TAG_MATH,    GFA_SUBTAG_NEGATIF)
#define GFA_SYMBOL_LOGIC_NOT                    GFA_TAG_CREATE_SYMBOL(GFA_TAG_LOGIC,   GFA_SUBTAG_NOT)

#define GFA_SYMBOL_COMPARE_EGAL                 GFA_TAG_CREATE_SYMBOL(GFA_TAG_COMPARE, GFA_SUBTAG_EGAL)

// Sur 4 bits, ne pas dpasser 16
typedef enum {
  GFA_TAG_UNKNOWN,              // 0
  GFA_TAG_COMMENT,              // 1
  GFA_TAG_VALUE,                // 2
  GFA_TAG_BASE,									// 3
  GFA_TAG_MATH,                 // 4
  GFA_TAG_LOGIC,								// 5
  GFA_TAG_COMPARE,              // 6
  GFA_TAG_SIGN,                 // 7
  GFA_TAG_VAR,                  // 8
  GFA_TAG_VARTABLE,             // 9
  GFA_TAG_LABEL,                // 10
  GFA_TAG_PARSER,								// 11
  GFA_TAG_STRUCT,						    // 12
  GFA_TAG_SYMBOL,               // 13
  
  GFA_TAG_EOFLINE = 0x10,       // 16
  GFA_TAG_ENDTAG = 0xFF					// 255
} GFA_TAG;


// Sur 4 bits, ne pas dpasser 16
typedef enum {
  GFA_SUBTAG_NONE,              // 0
  
  // Nombres ou variables
  GFA_SUBTAG_INT_U8 = 1,        // 1
  GFA_SUBTAG_INT_S16,           // 2
  GFA_SUBTAG_INT_S32,           // 3
  GFA_SUBTAG_FLOAT,             // 4
  GFA_SUBTAG_BOOL,              // 5
  GFA_SUBTAG_STRING,            // 6
  GFA_SUBTAG_NOTHING,						// 7
  
  // Signes mathmatiques
  GFA_SUBTAG_AFFEC_LEFT = 1,    // 1
  GFA_SUBTAG_AFFEC_RIGHT,       // 2
  GFA_SUBTAG_ADD,               // 3
  GFA_SUBTAG_SUB,               // 4
  GFA_SUBTAG_MUL,               // 5
  GFA_SUBTAG_DIV,               // 6
  GFA_SUBTAG_DIV_INT,           // 7
  GFA_SUBTAG_MOD,               // 8
  GFA_SUBTAG_EXP,               // 9
  GFA_SUBTAG_NEGATIF,           // 10
  
  // Oprateurs logiques
  GFA_SUBTAG_NOT = 1,           // 1
  GFA_SUBTAG_AND,               // 2
  GFA_SUBTAG_OR,                // 3
  GFA_SUBTAG_XOR,               // 4
  GFA_SUBTAG_IMP,               // 5
  GFA_SUBTAG_EQV,               // 6
  
  // Signes de comparaison
  GFA_SUBTAG_EGAL = 1,          // 1
  GFA_SUBTAG_INFERIOR,          // 2
  GFA_SUBTAG_SUPERIOR,          // 3
  GFA_SUBTAG_INFEGAL,           // 4
  GFA_SUBTAG_SUPEGAL,           // 5
  GFA_SUBTAG_DIFF,              // 6
  
  // Autres signes
  GFA_SUBTAG_BRACKET_OPEN = 1,  // 1
  GFA_SUBTAG_BRACKET_CLOSE,     // 2
  GFA_SUBTAG_COMMA,             // 3
  GFA_SUBTAG_POINT_COMMA,       // 4
  GFA_SUBTAG_APOST,             // 5
  GFA_SUBTAG_TWO_POINT,         // 6
  GFA_SUBTAG_EXCLAMATION,       // 7
  
  // Symboles
  GFA_SUBTAG_FUNCTION = 1,      // 1
  GFA_SUBTAG_CONSTANT,          // 2
  
} GFA_SUBTAG;


// Informations complmentaires
typedef enum {
	GFA_TREETAG_NONE,							// 0
	GFA_TREETAG_VARTABLE,					// 1
	GFA_TREETAG_DONT_CLEAR_STACK, // 2  (Force une affectation  conserver la variable dans la pile)
	GFA_TREETAG_STRING_OPERATION  // 3  (Le tag correspond  une opration entre strings)
} GFA_TREETAG;


/** Enumration des priorits de calcul */
typedef enum {
  GFA_PRIORITY_NONE,
  GFA_PRIORITY_AFFEC_LEFT,      // =
  GFA_PRIORITY_AFFEC_RIGHT,     // ->
  GFA_PRIORITY_LOGIC_NOT,       // NOT
  GFA_PRIORITY_LOGIC,           // AND, OR, XOR, IMP, EQV
  GFA_PRIORITY_COMPARE,         // =, <>, <, >, <=, >=
  GFA_PRIORITY_ADD_SUB,         // +, -
  GFA_PRIORITY_DIV_MOD,         // DIV MOD
  GFA_PRIORITY_MUL_DIV,         // * /
  GFA_PRIORITY_EXP,             // ^
  GFA_PRIORITY_SIGN,            // Negatif (-)
  GFA_PRIORITY_STRING_COMPARE,  // =, <>, <, >, <=, >=
  GFA_PRIORITY_STRING_ADDITION  // +
} GFA_PRIORITY;


extern const struct s_Number_Suffix_Table {
  const char suffix;
  GFA_SUBTAG subtag;
} GFA_Number_Suffix_Table[4];


extern const struct s_Symbol_Suffix_Table {
  const char suffix;
  GFA_TAG tag;
  GFA_SUBTAG subtag;
} GFA_Symbol_Suffix_Table[7];


extern const struct s_Sign_Table {
	const char *sign;
  unsigned short size;
  GFA_TAG tag;
  GFA_SUBTAG subtag;
} GFA_Sign_Table[25];


extern const struct s_Symbol_Table {
  const char *expr;
  GFA_TAG tag;
  GFA_SUBTAG subtag;
} GFA_Symbol_Table[8]; 


extern const GFA_PRIORITY GFA_Math_PriorityTable[];


typedef struct {
  // Expression sous forme de chane de caractres
  GFA_String expr;
  
  // Expression dcompose en tag
  union {
    struct {
      unsigned char /*GFA_TAG*/ tag;
      unsigned char /*GFA_SUBTAG*/ subtag;
      unsigned char /*GFA_TREETAG*/ treetag;
    };
    unsigned short symbol;
  };
  
  union {
    GFA_PRIORITY priority;
    #ifdef GFA_PARSER_USE_BRACKETS_DEPTH
      unsigned short depth;
    #endif
  };
  
  // Index de structure
  short struct_idx;

  // Informations complmentaires
  union {
    struct {
      float value_float;
      union {
        long value_S32;
        short value_S16;
        unsigned char value_U8;
      };
    } number;
    
    struct {
    	short index;
    	GFA_Lib_Object object;
    } library;
    
    short index;
  } info;
} GFA_Tag;

#endif
