// Header File
// Created 26/07/2006; 18:08:05

#ifndef _GFA_TOKENISOR_H_
#define _GFA_TOKENISOR_H_

#include "expr_find.h"
#include "tags.h"
#include "errors.h"
#include "memory.h"

/** @brief Structure d'un fichier tokenis (BAS) */
typedef struct {
  unsigned char signature[6];
  unsigned char version[2];
  unsigned short jump_offset;
} GFA_Tokenisor_Header;

typedef struct {
  unsigned char n_U8;
  unsigned char n_S16;
  unsigned char n_S32;
  unsigned char n_float;
  unsigned char n_bool;
  unsigned char n_string;
  
  unsigned char n_tU8;
  unsigned char n_tS16;
  unsigned char n_tS32;
  unsigned char n_tfloat;
  unsigned char n_tbool;
  unsigned char n_tstring;
  
  unsigned char n_label;
  unsigned char n_procedure;
} GFA_Tokenisor_TableSymbolsInfo;


typedef GFA_MemoryBuffer GFA_TokensBuffer;

/** @brief Signature d'un fichier tokenis */
extern const char GFA_TOKENISOR_HEADER_SIGNATURE[6];

/** @brief Version supporte pour les fichier toenis */
extern const unsigned char GFA_TOKENISOR_HEADER_VERSION[2];

extern GFA_TokensBuffer GFA_Tokenisor_CreateBuffer();
extern inline void GFA_Tokenisor_DeleteBuffer(GFA_TokensBuffer *tks_buff);

extern void GFA_Tokenisor_WriteSymbols(GFA_TokensBuffer *tks_buff, const GFA_StackExprFind *stack_expr_find);
extern void GFA_Tokenisor_WriteStackTag(GFA_TokensBuffer *tks_buff, const GFA_StackTag *stack_tag);

GFA_ERROR_NUMBER GFA_Tokenisor_CreateFile(GFA_TokensBuffer *tks_buff, const char *file, const GFA_StackExprFind *stack_expr_find);

extern bool GFA_Tokenisor_EofFile(const GFA_File *file);
extern GFA_ERROR_NUMBER GFA_Tokenisor_ExtractHeader(GFA_File *file, GFA_StackExprFind *stack_expr_find);
extern GFA_ERROR_NUMBER GFA_Tokenisor_ExtractData(GFA_File *file, unsigned short *line, const GFA_StackLib *stack_lib, GFA_StackTag *stack_tag);

#endif
