// C Source File
// Created 22/06/2006; 14:41:39

#include "tigcclib.h"
#include "utilities.h"
#include "charset.h"

char *get_file_name(const char *name) {
  Assert(name);
  
  for (char *ptr = (char *)name; *ptr;) {
    if (*(ptr++)=='\\')
      return ptr;
  }
  
  return (char *)name;
}


char *StrUpper(char *dest, const char *src, unsigned short size) {
  Assert(dest && src);
  
  char *d = dest;
  do {
    *(d++) = GFA_Charset_LetterUpper(*(src++));
  } while (--size);
  *d = CHAR_NULL;
  
  return dest;
}


inline unsigned char MakeByte(unsigned char lsb, unsigned char msb) {
  Assert((lsb<=0x0F) && (msb<=0x0F));
  return (lsb + (msb << 4));
}


SYM_STR MakeSymStr(const char *name, char *buffer, bool is_folder) {
  Assert(name && buffer);
  
  if (name) {
    *(buffer++) = CHAR_NULL;
    while (*name && (!is_folder || (*name!='\\')))
      *(buffer++) = GFA_Charset_LetterLower(*(name++)); 
  }
  *buffer = CHAR_NULL;
  return buffer;
}


bool CheckFileName(const char *name) {
	Assert(name);
	
	unsigned short count_data = 0;
	bool have_folder = false;
	bool have_letter = false;
	
	for (; *name; ++name) {
		if (*name=='\\') {
		  if (have_folder)
		    return false;
		  have_folder = true;
		  have_letter = false;
		  if (count_data > 8)
		    return false;
		  count_data = 0;
		  continue;
		}
		
		++count_data;
		if (GFA_Charset_Letter(*name)) {
		  have_letter = true;
		  continue;
		}
		
		if (!GFA_Charset_Number(*name) || !have_letter)
		  return false;  
	}
	
	return (have_letter && (count_data<=8));
}


inline bool CheckVersion(unsigned short require, unsigned short ver) {
	return ((require >> 8)==(ver >> 8) &&
	        (ver & 0x00FF)>=(require & 0x00FF));
}


const char *GetVersion(unsigned short ver) {
	static char buffer[3 + 1 + 3 + 1];
	sprintf(buffer, "%d,%d", ver >> 8, ver & 0x00FF);
	return buffer;
}