| GFA Basic Tokens Execution Manager
|==============================================================================================
| Creation: Samedi 23 Octobre 2004
| Modifications: 
| 23/10/04, 24/10/04, 25/10/04, 27/10/04, 29/10/04, 30/10/04, 31/10/04, 01/11/04, 02/11/04
| 03/11/04, 05/11/04, 06/11/04, 07/11/04, 08/11/04, 12/11/04, 13/10/04, 14/10/04, 15/11/04
| 16/11/04, 17/11/04, 20/11/04, 21/11/04, 22/11/04, 23/11/04, 24/11/04, 25/11/04, 26/11/04
| 01/12/04, 02/12/04, 03/12/04, 04/12/04, 05/12/04, 06/12/04, 11/12/04, 12/12/04, 18/01/05
| 20/01/05, 05/02/05, 06/02/05, 07/02/05, 09/02/05, 10/02/05, 11/02/05, 14/02/05, 15/02/05
| 16/02/05, 17/02/05, 18/02/05, 19/02/05, 20/02/05, 21/02/05, 03/03/05, 05/03/05, 24/03/05
| 25/03/05, 26/03/05, 27/03/05, 28/03/05, 09/04/05, 10/04/05, 12/04/05, 13/04/05, 14/04/05
| 15/04/05, 16/04/05, 17/04/05, 18/04/05, 19/04/05, 29/04/05, 30/04/05, 01/05/05, 04/05/05
| 05/05/05, 07/05/05, 21/06/05, 22/06/05, 24/06/05, 26/06/05, 05/08/05, 12/08/05
|==============================================================================================
|----------------------------------------------------------------------------------------------
| Ce programme permet d'excuter un programme crit en GFA Basic contenant des tokens
| d'excution.
| Ligne de commande ;
| Ex: GFATEM ("file")
|
| Auteur: Geoffrey ANNEHEIM
| Dernire modification: Dimanche 26 Juin 2005 
|
| - Vrifier la pile SP lors de stockage de donnes.
| - Finir fonction Put.
| - Autoriser de grandes chanes de caractres.
|-----------------------------------------------------------------------------------------------
	
		.include  "os.h"
		.include  "GFA_FontLib.h"
		
		.include  "Defines.h"
		.include  "Tbl_Errors.h"
		.include  "GFATEM.h"
		
		.xdef     _v200
		.xdef 	  _ti92plus
		.xdef	  _ti89
		.xdef 	  _tigcc_native
		.xdef     __ref_all___startup_code
		.xdef     __ref_all___nostub
		.xdef     __main
		
		.xdef     exit_program
		.xdef     _illegal
		
|Dboguage
_illegal:	illegal
		
|*************************************************************************
|Gestion des erreurs
|*************************************************************************
_ERROR_noargument:
		move.w    #ERROR_NOARGUMENT,%d7
		jbra	  exit_program
		
_ERROR_incorrect_file:
		move.w    #ERROR_INCORRECT_FILE,%d7
		jbra	  exit_program
				
_ERROR_file_no_found:
		move.w    #ERROR_FILE_NO_FOUND,%d7
		jbra	  exit_program
		
_ERROR_incorrect_file_version:
		move.w    #ERROR_INCORRECT_FILE_VERSION,%d7
		jbra	  exit_program
		
_ERROR_tokens_section_no_found:
		move.w    #ERROR_TOKENS_SECTION_NO_FOUND,%d7
		jbra      exit_program
		
_ERROR_no_enough_memory:
		move.w    #ERROR_NO_ENOUGH_MEMORY,%d7
		jbra	  exit_program
		
_ERROR_incorrect_AMS_version:
		move.w    #ERROR_AMS_VERSION,%d7
		jbra	  exit_program
		
_ERROR_file_font_no_found:
		move.w    #ERROR_FILE_FONT_NO_FOUND,%d7
		jbra	  exit_program
		
_ERROR_file_font_incorrect:
		move.w    #ERROR_FILE_FONT_INCORRECT,%d7
		jbra	  exit_program
		
_ERROR_file_font_version:
		move.w    #ERROR_FILE_FONT_VERSION,%d7
		jbra	  exit_program
		
		
|=========================================================================
|TEM_SaveScreen
|-------------------------------------------------------------------------
|Sauvegarde cran
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: a0
|=========================================================================
TEM_SaveScreen:
		move.l    (%SP)+,%a2
		
		|Allocation mmoire
		lea.l     -LCD_SIZE(%SP),%SP
		lea.l     SaveScreen,%a0
		move.l    %SP,(%a0)
		
		|Copie cran
		move.l    #LCD_SIZE,-(%SP)
		move.l    #LCD_MEM,-(%SP)
		move.l    (%a0),-(%SP)
		ROM_CALL  memcpy
		lea.l     12(%SP),%SP
		
		pea.l     (%a2)		
		rts


|=========================================================================
|TEM_RestoreScreen
|-------------------------------------------------------------------------
|Restore cran
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: d0, a0
|=========================================================================
TEM_RestoreScreen:
		move.l    (%SP)+,%a2
		
		move.l    SaveScreen,%d0
		jbeq      _RestoreScreen_exit
		move.l    #LCD_SIZE,-(%SP)
		move.l    %d0,-(%SP)
		move.l    #LCD_MEM,-(%SP)
		ROM_CALL  memcpy
		lea.l     12+LCD_SIZE(%SP),%SP
_RestoreScreen_exit:
		pea.l     (%a2)
		rts


/*|=========================================================================
|TEM_Initialize_Variables
|-------------------------------------------------------------------------
|Met  zro toutes les variables
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: d0, a0
|=========================================================================
TEM_Initialize_Variables:
		move.l	  #(End_Variables-Start_Variables),%d0
		lsr.w     #1,%d0
		subq.w    #1,%d0
	        lea.l	  Start_Variables,%a0
_Initialize_Variables_loop_erase:
		clr.w	  (%a0)+
		dbf	  %d0,_Initialize_Variables_loop_erase
		rts*/
	

|=========================================================================
|TEM_GetArg_ReadNameFile
|-------------------------------------------------------------------------
|Lecture du nom du fichier  partir de estack
|-------------------------------------------------------------------------
|input:
|
|output:
|  dc.b   TokensFile_NameSize = Taille du nom du fichier.
|  dc.l   TokensFile_Name     = Nom du fichier.
|
|destroy: d0, a2
|=========================================================================				
TEM_GetArg_ReadNameFile:
		|Rcupre le nom du fichier  partir de la pile estack
 		ROM_CALL2 top_estack
 		
 		|Pas d'argument
 		movea.l   %a4,%a2
 		cmpi.b    #0x2D,(%a2)				|Recherche une chaine de caractres STR_TAG
 		jbne      _ERROR_noargument			|Aucun argument spcifi
 		subq.l	  #2,%a2				|Saute caractre NULL on se retrouve  la fin de la chane
 		
 		|Remonte au dbut de la chane 
_GetArg_ReadNameFile_string_loop: 		
 		move.b    (%a2),%d0
 		subq.l    #1,%a2
 		jbne      _GetArg_ReadNameFile_string_loop
 		
 		|Vrification de la taille de la chane entre
 		pea.l     2(%a2)
 		ROM_CALL  strlen
 		addq.l    #4,%SP
 		cmpi.b    #17,%d0				|folder+'\'+file = 17 octets max
 		jbhi      _ERROR_incorrect_file
 		
 		|Copie la chane de caractres
 		lea.l     TokensFile_NameSize,%a0
 		move.b    %d0,(%a0)
 		|subq.l    #4,%SP
 		pea.l     2(%a2)
 		pea.l     TokensFile_Name
 		ROM_CALL  strcpy
 		addq.l    #8,%SP
 		rts 						|Return	
		
		
|=========================================================================
|TEM_GetArg_OpenFile
|-------------------------------------------------------------------------
|Ouvre le fichier et vrifie son header
|-------------------------------------------------------------------------
|input:
|  dc.l   TokensFile_Name
|output:
|
|destroy: d0, d1, a0
|=========================================================================
TEM_GetArg_OpenFile:
		|Pointeur SymEntry
		lea.l     TokensFile_Name,%a0
		jbsr      FILE_GetSymByName
		lea.l     TokensFile_SymEntry,%a1
		move.l    %a0,(%a1)
		|tst.l     TokensFile_SymEntry
		jbeq      _ERROR_file_no_found

		|Lock handle
		move.w    12(%a0),-(%SP)
		ROM_CALL  HeapLock
		lea.l     TokensFile_Handle,%a0
		move.w    %d0,(%a0)
		
		|Rcupre pointeur et taille du fichier
		move.w    %d0,-(%SP)
		ROM_CALL  HeapDeref
		movea.l   %a0,%a2					|%a2 = Pointeur fichier
		move.w    (%a2)+,%d7					|%d7 = Taille du fichier
		
		|--------------------------------|		
		|Lecture Header                  |
		|--------------------------------|
		|xxxx  Signature (GFA_GTK)       |     
		|dc.b  Version (1.00)            |
		|				 |
		|dc.w  Tokens_size		 |
		|dc.w  data_number		 |
		|dc.w  data_offset		 |
		                                 |
		|dc.b  nVar_Float                |
		|dc.b  nVar_Int                  |
		|dc.b  nVar_Bool                 |
		|dc.b  nVar_String               |
		|                                |
		|dc.b  nVar_TFloat               |
		|dc.b  nVar_TInt                 |
		|dc.b  nVar_TBool                |
		|dc.b  nVar_TString              |
		|                                |
		|dc.w  TK 'Start Execution Tokens|
		|--------------------------------|
		
		|Vrification fichier GTK signature
		move.l    #GTK_Signature_Size,-(%SP)
		pea.l     GTK_Signature
		pea.l     (%a2)
		ROM_CALL  memcmp
		lea.l     4+4+4+2+2(%SP),%SP
		tst.w     %d0
		jbne      _ERROR_incorrect_file
		
		|Vrification numro de version
		addq.l    #GTK_Signature_Size,%a2		|Prpare test numro de version
		move.b    (%a2)+,%d0
		cmp.b     GTK_Version,%d0
		jbne      _ERROR_incorrect_file_version
		
		|Taille des tokens
		move.w    (%a2)+,%d5				|%d5 = Taille des tokens
		lea.l     TokensFile_Size,%a0
		move.w    %d5,(%a0)
		
		|Informations structure DATA
		clr.w     sDATA_number
		lea.l     sDATA_total_number,%a0		|Nombre de donnes
		move.w    (%a2)+,(%a0)
		move.w    (%a2)+,%d6				|%d6 = DATA_offset
		
		|Section nombre de variables
		lea.l     nVar_Float,%a0
		move.l    (%a2)+,(%a0)				|Variables simples
		lea.l     nVar_TFloat,%a0
		move.l    (%a2)+,(%a0)				|Tableaux
		
		|Vrification section TK
		move.l    #GTK_Tokens_Section_Size,-(%SP)
		pea.l     GTK_Tokens_Section
		pea.l     (%a2)
		ROM_CALL  memcmp
		lea.l     12(%SP),%SP
		tst.w     %d0					|Vrification memcmp section TK 
		jbne      _ERROR_tokens_section_no_found
		
		|Gestion adresses tokens
		addq.l    #GTK_Tokens_Section_Size,%a2		|Saute tmoin dbut section
		lea.l     TokensFile_Data,%a0
		move.l    %a2,(%a0)
		lea.l     TokensFile_DataPtr,%a0
		move.l    %a2,(%a0)				|Adresse avancement de lecture des donnes
		lea.l     (%d5.w,%a2),%a1			|Adresse fin tokens
		lea.l     TokensFile_DataMaxAdr,%a0
		move.l    %a1,(%a0)
		
		|Gestion adresses structure DATA
		lea.l     sDATA_type_ptr,%a0			|Adresse typage donnes
		move.l    %a1,(%a0)
		lea.l     (%a2,%d6.w),%a1			|Adresse dbut donnes DATA
		lea.l     sDATA_start_ptr,%a0
		move.l    %a1,(%a0)
		lea.l     sDATA_ptr,%a0
		move.l    %a1,(%a0)
		rts
		
		
|=========================================================================
|TEM_GetArg_CloseFile
|-------------------------------------------------------------------------
|Unlock handle
|-------------------------------------------------------------------------
|input:
|  dc.w   TokensFile_Handle
|output:
|
|destroy: d0
|=========================================================================
TEM_GetArg_CloseFile:
		move.w    TokensFile_Handle,%d0    
		jbeq      _GetArg_CloseFile_no_unlock_handle
		move.w    %d0,-(%SP)
                ROM_CALL  HeapUnlock
                addq.l    #2,%SP
_GetArg_CloseFile_no_unlock_handle:                      
		rts		
		

|=========================================================================
|TEM_Allocate_VarMemory
|-------------------------------------------------------------------------
|Allocation mmoire pour les variables et les tableaux
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: d0, d1, a0
|=========================================================================	
TEM_Allocate_VarMemory:
		moveq.l   #0,%d1					|Compte l'espace mmoire  allouer
		
		|---------|
		|VARIABLES|
		|---------|
		|VARS Flottants
		move.b    nVar_Float,%d1
		mulu.w    #SIZE_FLOAT,%d1
		
		|VARS Integer
		move.w    %d1,-(%SP)
		clr.w     %d0
		move.b    nVar_Int,%d0
		mulu.w    #SIZE_INTEGER,%d0
		add.w     %d0,%d1
		
		|VARS Bool
		move.w    %d1,-(%SP)
		clr.w     %d0
		move.b    nVar_Bool,%d0
		
		|Octet d'alignement si ncessaire
		move.b    %d0,%d2
		btst.b    #0,%d2
		jbeq      _Allocate_VarMemory_nVarBool_is_pair
		addq.w    #1,%d0
_Allocate_VarMemory_nVarBool_is_pair:
		add.w     %d0,%d1
		
		|VARS String
		move.w    %d1,-(%SP) 
		clr.w     %d0
		move.b    nVar_String,%d0
		mulu.w    #SIZE_DESCRIPTOR,%d0
		add.w     %d0,%d1
		 
		 
		|--------|
		|TABLEAUX|
		|--------|
		|TABS Flottants
		move.w    %d1,-(%SP)
		clr.w	  %d0
		move.b    nVar_TFloat,%d0
		mulu.w    #SIZE_DESCRIPTOR,%d0
		add.w     %d0,%d1
		
		|TABS Integer
		move.w    %d1,-(%SP)
		clr.w     %d0
		move.b    nVar_TInt,%d0
		mulu.w    #SIZE_DESCRIPTOR,%d0
		add.w     %d0,%d1
		
		|TABS Bool
		move.w    %d1,-(%SP)
		clr.w     %d0
		move.b    nVar_TBool,%d0
		mulu.w    #SIZE_DESCRIPTOR,%d0
		add.w     %d0,%d1
		
		|TABS String
		move.w    %d1,-(%SP)
		clr.w     %d0
		move.b    nVar_TString,%d0
		mulu.w    #SIZE_DESCRIPTOR,%d0
		add.w     %d0,%d1
		
		|Allocation de l'espace mmoire
		move.l    %d1,%d3					|Sauvegarde d1
		move.l    %d1,-(%SP)
		ROM_CALL  malloc
		
		|Attribution des espaces
		lea.l     MEM_VARS,%a1
		move.l    %a0,(%a1)
		lea.l     VAR_FLOAT,%a1
		move.l    %a0,(%a1)
		move.l    %a0,%d0
		add.w     16(%SP),%d0
		lea.l     VAR_INTEGER,%a1
		move.l    %d0,(%a1)
		move.l    %a0,%d0
		add.w     14(%SP),%d0
		lea.l     VAR_BOOL,%a1
		move.l    %d0,(%a1)
		move.l    %a0,%d0
		add.w     12(%SP),%d0
		lea.l     VAR_STRING,%a1
		move.l    %d0,(%a1)
		
		move.l    %a0,%d0
		add.w     10(%SP),%d0
		lea.l     MEM_TABS,%a1
		move.l    %d0,(%a1)
		lea.l     TAB_FLOAT,%a1
		move.l    %d0,(%a1)
		move.l    %a0,%d0
		add.w     8(%SP),%d0
		lea.l     TAB_INTEGER,%a1
		move.l    %d0,(%a1)
		move.l    %a0,%d0
		add.w     6(%SP),%d0
		lea.l     TAB_BOOL,%a1
		move.l    %d0,(%a1)
		move.l    %a0,%d0
		add.w     4(%SP),%d0
		lea.l     TAB_STRING,%a1
		move.l    %d0,(%a1)
		
		|Vide pile SP
		lea.l     7*2+4(%SP),%SP
		
		|Vrification allocation
		move.l    %a0,%d0
		jbeq	  _ERROR_no_enough_memory
		
		|Initialise zone avec des octets NULL
		move.l    %d3,-(%SP)					|Nombres d'octets
		clr.w     -(%SP)					|Caractre NULL
		move.l    %d0,-(%SP)					|Adresse
		ROM_CALL  memset
		lea.l     10(%SP),%SP
		
		|Initialise les chanes de caractres
		moveq.l   #0,%d0
		move.b    nVar_String,%d0
		move.l    VAR_STRING,%a0
		jbra      TokensExec_InitEmptyString


|=========================================================================
|TEM_Unallocate_VarMemory
|-------------------------------------------------------------------------
|Efface allocation mmoire pour les variables et les tableaux
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy:
|=========================================================================
_Unallocate_VarMemory_table:
		move.l    (%a2),-(%SP)
		ROM_CALL  free
		addq.l    #4,%SP
		rts

_Unallocate_VarMemory_TFloat_free:
		jbsr      _Unallocate_VarMemory_table
		jbra      _Unallocate_VarMemory_TFloat_continue
		
_Unallocate_VarMemory_TInt_free:
		jbsr      _Unallocate_VarMemory_table
		jbra      _Unallocate_VarMemory_TInt_continue
		
_Unallocate_VarMemory_TBool_free:
		jbsr      _Unallocate_VarMemory_table
		jbra      _Unallocate_VarMemory_TBool_continue
		
_Unallocate_VarMemory_TString_free:
		move.l    %d3,-(%SP)					|Sauvegarde %d3 					
		move.w    4(%a2),%d0					|Nombre de dimensions
		move.l    (%a2),%a3					|Zone descripteurs
		jbsr      TokensExec_DeleteTabString
		move.l    (%SP)+,%d3					|Restaure %d3	
		jbsr      _Unallocate_VarMemory_table
		jbra      _Unallocate_VarMemory_TString_continue
		
TEM_Unallocate_VarMemory:
		tst.l	  MEM_VARS
		jbeq      _Unallocate_VarMemory_noblock
		
		|Efface les chanes de caractres
		moveq.l   #0,%d3
		move.b    nVar_String,%d3
		move.l    VAR_STRING,%a3
		jbsr      TokensExec_DeleteString
		
		|Efface les tableaux
		|T_FLOAT
		moveq.l   #0,%d3
		move.b    nVar_TFloat,%d3
		movea.l   TAB_FLOAT,%a2
		dbf       %d3,_Unallocate_VarMemory_TFloat_loop
		jbra      _Unallocate_VarMemory_TFloat_end
_Unallocate_VarMemory_TFloat_loop:
		tst.l     (%a2)
		jbne      _Unallocate_VarMemory_TFloat_free
_Unallocate_VarMemory_TFloat_continue:
		addq.l    #SIZE_DESCRIPTOR,%a2
		dbf       %d3,_Unallocate_VarMemory_TFloat_loop
		
		|T_INTEGER
_Unallocate_VarMemory_TFloat_end:
		moveq.l   #0,%d3
		move.b    nVar_TInt,%d3
		movea.l   TAB_INTEGER,%a2
		dbf       %d3,_Unallocate_VarMemory_TInt_loop
		jbra      _Unallocate_VarMemory_TInt_end
_Unallocate_VarMemory_TInt_loop:
		tst.l     (%a2)
		jbne      _Unallocate_VarMemory_TInt_free
_Unallocate_VarMemory_TInt_continue:
		addq.l    #SIZE_DESCRIPTOR,%a2
		dbf       %d3,_Unallocate_VarMemory_TInt_loop
		
		|T_BOOL
_Unallocate_VarMemory_TInt_end:
		moveq.l   #0,%d3
		move.b    nVar_TBool,%d3
		movea.l   TAB_BOOL,%a2
		dbf       %d3,_Unallocate_VarMemory_TBool_loop
		jbra      _Unallocate_VarMemory_TBool_end
_Unallocate_VarMemory_TBool_loop:
		tst.l     (%a2)
		jbne      _Unallocate_VarMemory_TBool_free
_Unallocate_VarMemory_TBool_continue:
		addq.l    #SIZE_DESCRIPTOR,%a2
		dbf       %d3,_Unallocate_VarMemory_TBool_loop
		
		|T_STRING
_Unallocate_VarMemory_TBool_end:
		moveq.l   #0,%d3
		move.b    nVar_TString,%d3
		movea.l   TAB_STRING,%a2
		dbf       %d3,_Unallocate_VarMemory_TString_loop
		jbra      _Unallocate_VarMemory_TString_end
_Unallocate_VarMemory_TString_loop:
		tst.l     (%a2)
		jbne      _Unallocate_VarMemory_TString_free
_Unallocate_VarMemory_TString_continue:
		addq.l    #SIZE_DESCRIPTOR,%a2
		dbf       %d3,_Unallocate_VarMemory_TString_loop
_Unallocate_VarMemory_TString_end:
		
		|Efface buffer des variables
		move.l	  MEM_VARS,-(%SP)
		ROM_CALL  free
		addq.l    #4,%SP
_Unallocate_VarMemory_noblock:
		rts		


|==========================================================================
|TEM_Allocate_ES_DT_and_FOR
|--------------------------------------------------------------------------
|Allocation mmoire pour la pile ES, le tampon de donnes DT et la pile FOR
|--------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: a0
|==========================================================================
TEM_Allocate_ES_DT_and_FOR:
		move.l    (%SP)+,%a1

		|Allocation pile ES  
		lea.l     -ES_SIZE(%SP),%SP
		move.l    %SP,%d0
		lea.l     ptrStart_ES,%a0
		move.l    %d0,(%a0)
		addi.l    #ES_SIZE,%d0
		lea.l     ptrEnd_ES,%a0
		move.l    %d0,(%a0)
		
		|Allocation tampon DT
		lea.l     -DT_SIZE(%SP),%SP
		lea.l     ptrData_DT,%a0
		move.l    %SP,(%a0)
		lea.l     DTO,%a0
		move.l    %SP,(%a0)
		
		|Allocation pile FOR
		lea.l     -FOR_SIZE(%SP),%SP
		lea.l     ptrData_FOR,%a0
		move.l    %SP,(%a0)
		lea.l     ptrFOR,%a0
		move.l    %SP,(%a0)
			
		pea.l     (%a1)
		rts
		
		
|=================================================================================
|TEM_Unallocate_ES_DT_and_FOR
|---------------------------------------------------------------------------------
|Efface allocation mmoire pour la pile ES, le tampon de donnes DT et la pile FOR
|---------------------------------------------------------------------------------
|input:
|
|output:
|
|destroy:
|=================================================================================
TEM_Unallocate_ES_DT_and_FOR:
		move.l    (%SP)+,%a1
		
		|Unallocation pile ES
		tst.l     ptrStart_ES
		jbeq      _TEM_Unallocate_ES_DT_and_FOR_exit
		lea.l     ES_SIZE(%SP),%SP
		
		|Unallocation pile DT
		tst.l     ptrData_DT
		jbeq      _TEM_Unallocate_ES_DT_and_FOR_exit
		lea.l     DT_SIZE(%SP),%SP
		
		|Unallocation pile FOR
		tst.l     ptrData_FOR
		jbeq      _TEM_Unallocate_ES_DT_and_FOR_exit
		lea.l     FOR_SIZE(%SP),%SP
		
_TEM_Unallocate_ES_DT_and_FOR_exit:
		pea.l     (%a1)
		rts


|==========================================================================
|TEM_Allocate_Local_Vars
|--------------------------------------------------------------------------
|Allocation mmoire pour la pile de variables locales
|--------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: %a0
|==========================================================================
TEM_Allocate_Local_Vars:
		move.l    (%SP)+,%a1
		
		lea.l     ptrStart_LocalVarString,%a0
		move.l    %SP,(%a0)
		lea.l     ptrLocalVarString,%a0
		move.l    %SP,(%a0)
		
		|Allocation pile de variables locales type chanes de caractres
		lea.l     -LOCAL_VAR_STRING_SIZE(%SP),%SP
		lea.l     ptrStart_LocalVar,%a0
		move.l    %SP,(%a0)
		lea.l     ptrLocalVar,%a0    
		move.l    %SP,(%a0)
		
		|Allocation pile de variables locales  
		lea.l     -LOCAL_VAR_SIZE(%SP),%SP
		lea.l     ptrEnd_LocalVar,%a0
		move.l    %SP,(%a0)
			
		pea.l     (%a1)
		rts
		
		
|==========================================================================
|TEM_Unallocate_Local_Vars
|--------------------------------------------------------------------------
|Efface allocation mmoire pour la pile de variables locales
|--------------------------------------------------------------------------
|input:
|
|output:
|
|destroy:
|==========================================================================
TEM_Unallocate_Local_Vars:
		move.l    (%SP)+,%a1
		
		tst.l     ptrEnd_LocalVar
		jbeq      _TEM_Unallocate_Local_Vars_exit
		
		|Efface les chanes de caractres
		move.l    ptrLocalVarString,%a3
		move.l    %a3,%d0
                move.l    ptrStart_LocalVarString,%d3
		sub.l     %d0,%d3
		divu.w    #6,%d3
		jbsr      TokensExec_DeleteString
		
		|Restaure pile SP
		lea.l     (LOCAL_VAR_SIZE+LOCAL_VAR_STRING_SIZE)(%SP),%SP
		
_TEM_Unallocate_Local_Vars_exit:		
		pea.l     (%a1)
		rts
		
				
|==========================================================================
|TEM_Allocate_Others
|--------------------------------------------------------------------------
|Autres allocations mmoire
|--------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: %a0
|==========================================================================
TEM_Allocate_Others:
		move.l    (%SP)+,%a2
		lea.l     -STRING_BUFFER_SIZE(%SP),%SP
		lea.l     string_buffer,%a0
		move.l    %SP,(%a0)
		pea.l     (%a2) 
		rts


|==========================================================================
|TEM_Unallocate_Others
|--------------------------------------------------------------------------
|Efface les autres allocations mmoire
|--------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: %a0
|==========================================================================		
TEM_Unallocate_Others:
		move.l    (%SP)+,%a2
		move.l    string_buffer,%d0
		jbeq      _TEM_Unallocate_Others_exit
		lea.l     STRING_BUFFER_SIZE(%SP),%SP
_TEM_Unallocate_Others_exit:
		pea.l     (%a2)
		rts


|=========================================================================
|TEM_Init_Interrupts
|-------------------------------------------------------------------------
|Rglages des interruptions
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy:
|=========================================================================
TEM_Init_Interrupts:
		|Sauvegarde des exceptions
		lea.l     OldExcept0,%a0
		move.l    VECTOR_BUS_ERROR,(%a0)
		lea.l     OldExcept1,%a0
		move.l    VECTOR_ADDRESS_ERROR,(%a0)
		lea.l     OldExcept2,%a0
		move.l    VECTOR_ILLEGAL_INSTRUCTION,(%a0)
		lea.l     OldExcept3,%a0
		move.l    VECTOR_DIVIDE_BY_ZERO,(%a0)
		lea.l     OldExcept4,%a0
		move.l    VECTOR_PRIVILEGE_VIOLATION,(%a0)
		lea.l     OldExcept5,%a0
		move.l    VECTOR_AUTO_INT_7,(%a0)
		
		|Sauvegardes les interruptions
		lea.l     OldInt1,%a0
		move.l    VECTOR_AUTO_INT_1,(%a0)
		lea.l     OldInt2,%a0
		move.l    VECTOR_AUTO_INT_2,(%a0)
		lea.l     OldInt5,%a0
		move.l    VECTOR_AUTO_INT_5,(%a0)
		lea.l     OldInt6,%a0
		move.l    VECTOR_AUTO_INT_6,(%a0)
				
		|Modification de la table des vecteurs (exceptions et interruptions)
		bclr.b    #2,ASIC_PROTECT_VECTORS		|Dsactive protection en criture
		move.l    #Except_Bus_Error,		VECTOR_BUS_ERROR
		move.l    #Except_Address_Error,	VECTOR_ADDRESS_ERROR
		move.l    #Except_Illegal_Instruction,	VECTOR_ILLEGAL_INSTRUCTION
		move.l    #Except_Divide_By_Zero,	VECTOR_DIVIDE_BY_ZERO
		move.l    #Except_Privilege_Violation,	VECTOR_PRIVILEGE_VIOLATION
		move.l    #Except_Memory_Violation,	VECTOR_AUTO_INT_7
		
		move.l    #Interrupt1,			VECTOR_AUTO_INT_1
		move.l    #Interrupt2,			VECTOR_AUTO_INT_2
		move.l    #__dummy_handler__,		VECTOR_AUTO_INT_5
		move.l    #Interrupt6,			VECTOR_AUTO_INT_6
	
		bset.b    #2,ASIC_PROTECT_VECTORS		|Active protection en criture
		
		lea.l     __SAVE_SR__,%a0			|Sauvegarde registre SR
 		move.w    %SR,(%a0)
		
		lea.l     SetInts,%a0
		move.w    #-1,(%a0)
		rts
		
		
|=========================================================================
|TEM_Uninit_Interrupts
|-------------------------------------------------------------------------
|Restaure interruptions
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: %d0
|=========================================================================
TEM_Uninit_Interrupts:
		|Les interruptions ont t modifies?
		tst.w     SetInts
		jbeq      _Uninit_Interrupts_end
		
		bclr.b    #2,ASIC_PROTECT_VECTORS		|Dsactive protection en criture
		move.l    OldExcept0,VECTOR_BUS_ERROR
		move.l    OldExcept1,VECTOR_ADDRESS_ERROR
		move.l    OldExcept2,VECTOR_ILLEGAL_INSTRUCTION
		move.l    OldExcept3,VECTOR_DIVIDE_BY_ZERO
		move.l    OldExcept4,VECTOR_PRIVILEGE_VIOLATION
		move.l    OldExcept5,VECTOR_AUTO_INT_7
		
		
		move.l    OldInt1,VECTOR_AUTO_INT_1
		move.l    OldInt2,VECTOR_AUTO_INT_2
		move.l    OldInt5,VECTOR_AUTO_INT_5
		move.l    OldInt6,VECTOR_AUTO_INT_6
		bset.b    #2,ASIC_PROTECT_VECTORS		|Active protection en criture
		
		|move.w    __SAVE_SR__,%SR			|Restaure registre SR
_Uninit_Interrupts_end:
		rts


|=========================================================================
|TEM_Calculator_Init
|-------------------------------------------------------------------------
|Variables spcifiques  la calculatrice
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy:
|=========================================================================
_Calculator_Init_TI89:
		lea.l     LCD_WIDTH,%a0
		move.w    #159,(%a0)
		lea.l     LCD_HEIGHT,%a0
		move.w    #99,(%a0)
		lea.l     LCD_LINE_BYTES,%a0
		move.w    #20,(%a0)
		rts
		
TEM_Calculator_Init:
		|AMS 1xx
		clr.b     %d0
		move.l    200.w,%a0
		cmpi.l    #999,-4(%a0)
		sls       %d0
		lea.l     AMS_1xx,%a0
		move.b    %d0,(%a0)
		jbne      _ERROR_incorrect_AMS_version
		
		|Hardware version
		jbsr      __get_hw_version
		lea.l     HARDWARE_VERSION,%a0
		move.w    %d0,(%a0)
		
		|ROM_BASE
		move.l    200.w,%d0
		andi.l    #14680064,%d0
		lea.l     ROM_BASE,%a0
		move.l    %d0,(%a0)
				
		|Modle de calculatrice
		move.w    __calculator,%d0
		lea.l     CALCULATOR,%a0
		move.w    %d0,(%a0)
		jbeq      _Calculator_Init_TI89
		lea.l     LCD_WIDTH,%a0
		move.w    #239,(%a0)
		lea.l     LCD_HEIGHT,%a0
		move.w    #127,(%a0)
		lea.l     LCD_LINE_BYTES,%a0
		move.w    #30,(%a0)
		rts
		
			
|=========================================================================
|TEM_Parameters_init
|-------------------------------------------------------------------------
|Initialisation de parameters
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy: %d0, %a0
|=========================================================================
TEM_Parameters_Init:
		lea.l     PARAM_PRINT_DIGITS,%a0
		move.w    #PRINT_DIGITS,(%a0)
		lea.l     PARAM_SHOW_ENDTEXT,%a0
		move.w    #SHOW_ENDTEXT,(%a0)
		lea.l     PARAM_PRINT_AT,%a0
		move.w    #FALSE,(%a0)
		
		lea.l     PARAM_FONTLIB,%a0
		move.w    #DEFAULT_FONTLIB,(%a0)
		lea.l     PARAM_FONTLIB_MODE,%a0
		move.w    #DEFAULT_FONTLIB_MODE,(%a0)
		lea.l     PARAM_FONTLIB_GRAPHMODE,%a0
		move.w    #DEFAULT_FONTLIB_GRAPHMODE,(%a0)
		
		lea.l     PARAM_FONT,%a0
		move.w    #FONT,(%a0)
		lea.l     PARAM_FONT_DIVx,%a0
		move.w    #FONT_DIVx,(%a0)
		lea.l     PARAM_FONT_DIVy,%a0
		move.w    #FONT_DIVy,(%a0)
		move.w    #FONT,-(%SP)
		ROM_CALL  FontSetSys
		
		lea.l     PARAM_PRINT_ATx,%a0
		move.w    #PRINT_ATx,(%a0)
		lea.l     PARAM_PRINT_ATy,%a0
		move.w    #PRINT_ATy,(%a0)
		lea.l     PARAM_PRINT_REAL_ATx,%a0
		move.w    #PRINT_REAL_ATx,(%a0)
		lea.l     PARAM_PRINT_REAL_ATy,%a0
		move.w    #PRINT_REAL_ATy,(%a0)
		move.w    #PRINT_REAL_ATy,-(%SP)
		move.w    #PRINT_REAL_ATx,-(%SP)
		ROM_CALL  MoveTo

		lea.l     PARAM_REPEAT_KEYDELAY,%a0
		move.w    #DEFAULT_REPEAT_KEYDELAY,(%a0)
		lea.l     PARAM_BETWEEN_KEYDELAY,%a0
		move.w    #DEFAULT_BETWEEN_KEYDELAY,(%a0)
		
		lea.l     PARAM_SPRITE_LCD_MEM,%a0
		move.l    #DEFAULT_SPRITE_LCD_MEM,(%a0)
		
		|Randomize
		move.b    0x600017,%d0
	        clr.l     __randseed
	        move.b    %d0,__randseed+3
	        
	        |SetCurClip (&(SCR_RECT){{0, 0, LCD_WIDTH-1, LCD_HEIGHT-1}});
	        lea.l     SCR_RECT,%a0
	        move.l    %a0,-(%SP)
	        clr.w     (%a0)+
	        move.b    LCD_WIDTH+1,(%a0)+
	        move.b    LCD_HEIGHT+1,(%a0)
	        ROM_CALL  SetCurClip
	        
	        |Attribut par dfaut
	        lea.l     PARAM_CURATTR,%a0
	        move.w    #DEFAULT_CURATTR,(%a0)
	        move.w    (%a0),-(%SP)
	        ROM_CALL  SetCurAttr
	        lea.l     12(%SP),%SP
	        
	        |Input Length
	        lea.l     PARAM_INPUT_LENGTH,%a0
	        move.w    #INPUT_LENGTH,(%a0)
		rts


|=========================================================================
|TEM_Init_Font
|-------------------------------------------------------------------------
|Initialisation de GFA-Basic standard font
|-------------------------------------------------------------------------
|input:
|
|output:
|
|destroy:
|=========================================================================
TEM_Init_Font:
		move.l    #FontLib_FileName,%a0
		jbsr      FONT_OpenFile
		subq.w    #1,%d0
		jbeq      _ERROR_file_font_no_found
		subq.w    #1,%d0
		jbeq      _ERROR_file_font_incorrect
		subq.w    #1,%d0
		jbeq      _ERROR_file_font_version
		rts
				
		
|=========================================================================
|Programme principal
|=========================================================================		
__main:
  		movem.l   %d3-%d7/%a2-%a6,-(%SP) 		|Sauvegarde les registres
 		link.w 	  %a6,#0
 			
 		|jbsr      TEM_Initialize_Variables		|Initialise variables  zro
 		jbsr      TEM_Calculator_Init			|Initialise variables dpendant de la calculatrice
 		jbsr      TEM_Parameters_Init			|Initialise parameters
 		
 		jbsr      TEM_SaveScreen			|Sauvegarde cran
 		
 		jbsr      TEM_GetArg_ReadNameFile		|Lecture de l'argument
 		jbsr	  TEM_GetArg_OpenFile			|Ouvre fichier avec vrification du format
 		
 		jbsr      TEM_Allocate_VarMemory		|Allocation mmoire pour les variables
 		jbsr      TEM_Allocate_ES_DT_and_FOR		|Allocation pile ES, tampon DT et pile FOR
 		jbsr      TEM_Allocate_Local_Vars		|Allocation pile de variables locales
 		jbsr      TEM_Allocate_Others			|Effectue les autres allocations (gestion de TEM)
 		jbsr      TEM_Init_Font				|Initialisation GFA_FontLib
 		jbsr      TEM_Init_Interrupts			|Prpare interruptions
 		
 		lea.l     counter_time,%a0			|Compteur de temps initialis
 		clr.l     (%a0)
 		
 		lea.l     __SAVE_LINK__,%a0			|Sauvegarde %a6
 		move.l    %a6,(%a0)
 		
 		lea.l     __SAVE_USP__,%a1			|Sauvegarde pile %USP
 		move.l    %SP,%a0
 		move.l    %a0,(%a1)
 		
 		jbsr      TokensExec_Run			|Boucle d'execution des tokens
		
exit_program:       
 		jbsr      TEM_Uninit_Interrupts			|Restaure interruptions
 		jbsr      FONT_CloseFile			|Ferme GFA_Basic FontLib
 		jbsr      TEM_Unallocate_Others			|Efface les autres allocations (gestion de TEM)
 		jbsr      TEM_Unallocate_Local_Vars		|Efface allocation pile variables locales
 		jbsr	  TEM_Unallocate_ES_DT_and_FOR		|Efface allocation pile ES, tampon DT, pile FOR	
 		jbsr      TEM_Unallocate_VarMemory		|Efface espace mmoires pour les variables
 		
 		jbsr      TEM_GetArg_CloseFile			|Ferme le fichier de tokens
 		
 		ROM_CALL  HeapCompress				|Garbage Collect de la RAM
 		ROM_CALL  GKeyFlush				|Key Flush
 		
 		jbsr      TEM_RestoreScreen			|Restaure cran
 		
 		|Affichage erreur
 		tst.w     %d7
 		jbeq      _main_no_error
 		lea.l     Tbl_Error,%a0
   		move.w    (%d7.w,%a0),%d7
   		lea.l     .error_0x00,%a0
   		adda.w    %d7,%a0
   		pea.l     (%a0)
   		ROM_CALL  ST_helpMsg
   		addq.l    #4,%SP

_main_no_error: 	
 		unlk      %a6
 		movem.l   (%SP)+,%d3-%d7/%a2-%a6 		|Restaure les registres
  		rts
  		
|-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
|FIN DU PROGRAMME
|-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
		.end
		