# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

import sys
from pathlib import Path

sys.path.insert(0, str(Path('..', 'python').resolve()))
sys.path.insert(0, str(Path('..').resolve()))

# -- Project information -----------------------------------------------------

project = 'bbowda-python'
copyright = '2006-2024 Kevin Kofler, ' \
            '2024-2025 DAGOPT Optimization Technologies GmbH'
author = 'Kevin Kofler <kofler@dagopt.com>'

# The short X.Y version
version = '@BBOWDA_RELEASE@'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'alabaster'

# Set some options to make the theme look decent.
html_theme_options = {
  "body_min_width": 0,
  "body_max_width": "none",
  "page_width": "100%",
  "font_size": "1em",
  "code_font_size": "1em",
  "caption_font_size": "1.5em",
  "base_bg": "#dee3e9",
  "body_bg": "#ffffff",
  "extra_nav_links": {
    "Index": "genindex.html",
  }
}

# Select the sidebar sections.
html_sidebars = {
    '**': [
        'about.html',
        'localtoc.html',
        'navigation.html',
        'searchbox.html',
    ]
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']
