#!/bin/bash
GITHASH=`git rev-parse master`
NVERSION=2.10.0
LVERSION=5.5.2.11

case `uname -m` in
  x86_64)
    BITS=64
    ;;
  *)
    BITS=32
    ;;
esac

BUILDSCRIPTSDIR=`pwd`
DIRNAME=bbowda-$GITHASH
FILENAME=$DIRNAME.tar.gz
if [ ! -f "$FILENAME" ] ; then
  echo "--- generating $FILENAME ---"
  cd ..
  git archive -o "$BUILDSCRIPTSDIR/$FILENAME" --prefix="$DIRNAME/" "$GITHASH" || exit $?
  cd "$BUILDSCRIPTSDIR"
fi

NDIRNAME=nlopt-$NVERSION
NFILENAME=$NDIRNAME.tar.gz
if [ ! -f "$NFILENAME" ] ; then
  echo "downloading $NFILENAME"
  wget https://github.com/stevengj/nlopt/archive/v$NVERSION/$NFILENAME || exit $?
fi

LDIRNAME=lp_solve_5.5
LFILENAME=lp_solve_${LVERSION}_source.tar.gz
if [ ! -f "$LFILENAME" ] ; then
  echo "downloading $LFILENAME"
  wget "https://downloads.sourceforge.net/project/lpsolve/lpsolve/$LVERSION/$LFILENAME" || exit $?
fi

echo "unpacking lp_solve $LVERSION"
rm -rf "$LDIRNAME" || exit $?
tar xzf "$LFILENAME" || exit $?
cd "$LDIRNAME"
if [ ! -f configure.ac ] || (grep -q '^AC_INIT(\[lpsolve\],' configure.ac ; [ $? == 1 ]) ; then
  echo "error: "`pwd`" is not a valid lp_solve release"
  exit 1
fi
echo "patching lp_solve $LVERSION"
patch -p1 <../lpsolve-5.5.2.11-misc.patch || exit $?
sed -i -e '/so=y/d;s/\$c -s/$c $CFLAGS $LDFLAGS/g;s/-fpic/-fPIC/g;s#bin/\$PLATFORM/##g;/mkdir /d' lpsolve55/ccc || exit $?
rm -f bfp/bfp_LUSOL/LUSOL/myblas.h
ln -s ../../../shared/myblas.h bfp/bfp_LUSOL/LUSOL/myblas.h
echo "compiling lp_solve"
cd lpsolve55
LPSOLVE_LIBRARY_DIR=`pwd`
CC=gcc CFLAGS="-fPIC -fvisibility=hidden -DLoadInverseLib=0 -DLoadLanguageLib=0 -DLoadableBlasLib=0" LDFLAGS="-s" bash -x ccc || exit $?
cd ..
echo "copying lp_solve headers"
mkdir -p include/lpsolve || exit $?
cp -a lp*.h yacc_read.h include/lpsolve/ || exit $?
LPSOLVE_INCLUDE_DIR=`pwd`/include
cd ..

echo "unpacking NLopt $NVERSION"
rm -rf "$NDIRNAME" || exit $?
tar xzf "$NFILENAME" || exit $?
cd "$NDIRNAME"
if [ ! -f CMakeLists.txt ] || (grep -q '^project (nlopt)$' CMakeLists.txt ; [ $? == 1 ]) ; then
  echo "error: "`pwd`" is not a valid NLopt release"
  exit 1
fi
echo "compiling NLopt"
mkdir build
cd build
cmake .. -DNLOPT_CXX:BOOL=OFF -DNLOPT_FORTRAN:BOOL=OFF -DBUILD_SHARED_LIBS:BOOL=OFF -DNLOPT_PYTHON:BOOL=OFF -DNLOPT_OCTAVE:BOOL=OFF -DNLOPT_MATLAB:BOOL=OFF -DNLOPT_GUILE:BOOL=OFF -DNLOPT_JAVA:BOOL=OFF -DNLOPT_SWIG:BOOL=OFF -DNLOPT_LUKSAN:BOOL=OFF -DNLOPT_TESTS:BOOL=OFF -DCMAKE_BUILD_TYPE:STRING=Release -DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON -DCMAKE_CXX_VISIBILITY_PRESET:STRING=hidden -DCMAKE_C_VISIBILITY_PRESET:STRING=hidden -DCMAKE_VISIBILITY_INLINES_HIDDEN:BOOL=ON || exit $?
make -j4 || exit $?
NLOPT_DIR=`pwd`
cd ..
cd ..

echo "unpacking BBOWDA revision $GITHASH"
rm -rf "$DIRNAME" || exit $?
tar xzf "$FILENAME" || exit $?
cd "$DIRNAME"
if [ ! -f CMakeLists.txt ] || (grep -q '^project(bbowda ' CMakeLists.txt ; [ $? == 1 ]) ; then
  echo "error: "`pwd`" is not a valid BBOWDA snapshot"
  exit 1
fi
echo "compiling BBOWDA"
mkdir build
cd build
cmake .. -DBBOWDA_SHARED:BOOL=OFF -DBBOWDAPP_SHARED:BOOL=OFF -DNLP_SOLVER:STRING=NLopt -DWITH_DOXYGEN:BOOL=OFF -DWITH_CXX:BOOL=ON -DWITH_JAVA:BOOL=ON -DWITH_JAVA_JAVADOC:BOOL=OFF -DWITH_PYTHON:BOOL=OFF -DWITH_PYTHON_SPHINX:BOOL=OFF -DCMAKE_LIBRARY_PATH="$LPSOLVE_LIBRARY_DIR" -DCMAKE_INCLUDE_PATH="$LPSOLVE_INCLUDE_DIR" -DNLopt_DIR="$NLOPT_DIR" -DCMAKE_BUILD_TYPE:STRING=Release || exit $?
make -j4 || exit $?
cd ..

echo "copying results out"
cp -a build/bbowdapp/swig/libbbowdajni.so ../libbbowdajnix$BITS.so || exit $?
cp -a build/bbowdapp/swig/bbowda.jar ../ || exit $?
cd ..

echo "stripping libbbowdajnix$BITS.so"
strip libbbowdajnix$BITS.so || exit $?
exit 0
