#!/bin/bash
GITHASH=`git rev-parse master`
NVERSION=2.10.0
LVERSION=5.5.2.11

if [ -z "$1" ] ; then
  echo "error: missing target"
  exit 1
fi
echo "--- compiling for $1 ---"
case "$1" in
  *x86_64*)
    BITS=64
    ;;
  *)
    BITS=32
    ;;
esac
case "$1" in
  *-w64-mingw32)
    CMAKE=mingw$BITS-cmake
    ;;
  *)
    CMAKE=$1-cmake
    ;;
esac

BUILDSCRIPTSDIR=`pwd`
DIRNAME=bbowda-$GITHASH
FILENAME=$DIRNAME.tar.gz
if [ ! -f "$FILENAME" ] ; then
  echo "--- generating $FILENAME ---"
  cd ..
  git archive -o "$BUILDSCRIPTSDIR/$FILENAME" --prefix="$DIRNAME/" "$GITHASH" || exit $?
  cd "$BUILDSCRIPTSDIR"
fi

NDIRNAME=nlopt-$NVERSION
NFILENAME=$NDIRNAME.tar.gz
if [ ! -f "$NFILENAME" ] ; then
  echo "downloading $NFILENAME"
  wget https://github.com/stevengj/nlopt/archive/v$NVERSION/$NFILENAME || exit $?
fi

LDIRNAME=lp_solve_5.5
LFILENAME=lp_solve_${LVERSION}_source.tar.gz
if [ ! -f "$LFILENAME" ] ; then
  echo "downloading $LFILENAME"
  wget "https://downloads.sourceforge.net/project/lpsolve/lpsolve/$LVERSION/$LFILENAME" || exit $?
fi

if [ ! -d jni_include/win32 ] ; then
  echo 'fetching jni_include/win32'
  mkdir -p jni_include/win32 || exit $?
  cd jni_include/win32
  wget --user-agent=Mozilla https://hg.openjdk.java.net/jdk6/jdk6/jdk/raw-file/ac1d168048bd/src/windows/javavm/export/jni_md.h || exit $?
  wget --user-agent=Mozilla https://hg.openjdk.java.net/jdk6/jdk6/jdk/raw-file/ac1d168048bd/src/windows/javavm/export/jawt_md.h || exit $?
  cd ../..
fi
JNI_ARCH_DIR=`pwd`/jni_include/win32

echo "unpacking lp_solve $LVERSION"
rm -rf "$LDIRNAME" || exit $?
tar xzf "$LFILENAME" || exit $?
cd "$LDIRNAME"
if [ ! -f configure.ac ] || (grep -q '^AC_INIT(\[lpsolve\],' configure.ac ; [ $? == 1 ]) ; then
  echo "error: "`pwd`" is not a valid lp_solve release"
  exit 1
fi
echo "patching lp_solve $LVERSION"
patch -p1 <../lpsolve-5.5.2.11-misc.patch || exit $?
sed -i -e '/so=y/d;s/\$c -s/$c $CFLAGS $LDFLAGS/g;s/-fpic/-fPIC/g;s#bin/\$PLATFORM/##g;/mkdir /d' lpsolve55/ccc || exit $?
rm -f bfp/bfp_LUSOL/LUSOL/myblas.h
ln -s ../../../shared/myblas.h bfp/bfp_LUSOL/LUSOL/myblas.h
echo "compiling lp_solve"
cd lpsolve55
LPSOLVE_LIBRARY_DIR=`pwd`
CC=$1-gcc CFLAGS="-DLoadInverseLib=0 -DLoadLanguageLib=0 -DLoadableBlasLib=0" LDFLAGS="-s" bash -x ccc || exit $?
cd ..
echo "copying lp_solve headers"
mkdir -p include/lpsolve || exit $?
cp -a lp*.h yacc_read.h include/lpsolve/ || exit $?
LPSOLVE_INCLUDE_DIR=`pwd`/include
cd ..

echo "unpacking NLopt $NVERSION"
rm -rf "$NDIRNAME" || exit $?
tar xzf "$NFILENAME" || exit $?
cd "$NDIRNAME"
if [ ! -f CMakeLists.txt ] || (grep -q '^project (nlopt)$' CMakeLists.txt ; [ $? == 1 ]) ; then
  echo "error: "`pwd`" is not a valid NLopt release"
  exit 1
fi
echo "compiling NLopt"
mkdir build
cd build
$CMAKE .. -DNLOPT_CXX:BOOL=OFF -DNLOPT_FORTRAN:BOOL=OFF -DBUILD_SHARED_LIBS:BOOL=OFF -DNLOPT_PYTHON:BOOL=OFF -DNLOPT_OCTAVE:BOOL=OFF -DNLOPT_MATLAB:BOOL=OFF -DNLOPT_GUILE:BOOL=OFF -DNLOPT_JAVA:BOOL=OFF -DNLOPT_SWIG:BOOL=OFF -DNLOPT_LUKSAN:BOOL=OFF -DNLOPT_TESTS:BOOL=OFF -DCMAKE_BUILD_TYPE:STRING=Release -DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON -DCMAKE_CXX_VISIBILITY_PRESET:STRING=hidden -DCMAKE_C_VISIBILITY_PRESET:STRING=hidden -DCMAKE_VISIBILITY_INLINES_HIDDEN:BOOL=ON || exit $?
make -j4 || exit $?
NLOPT_DIR=`pwd`
cd ..
cd ..

echo "unpacking BBOWDA revision $GITHASH"
rm -rf "$DIRNAME" || exit $?
tar xzf "$FILENAME" || exit $?
cd "$DIRNAME"
if [ ! -f CMakeLists.txt ] || (grep -q '^project(bbowda ' CMakeLists.txt ; [ $? == 1 ]) ; then
  echo "error: "`pwd`" is not a valid BBOWDA snapshot"
  exit 1
fi
echo "compiling BBOWDA"
mkdir build
cd build
case "$1" in
  *x86_64*)
    KILL_AT=
    ;;
  *)
    KILL_AT="-Wl,--kill-at"
    ;;
esac
$CMAKE .. -DBBOWDA_SHARED:BOOL=OFF -DBBOWDAPP_SHARED:BOOL=OFF -DNLP_SOLVER:STRING=NLopt -DWITH_DOXYGEN:BOOL=OFF -DWITH_CXX:BOOL=ON -DWITH_JAVA:BOOL=ON -DWITH_JAVA_JAVADOC:BOOL=OFF -DWITH_PYTHON:BOOL=OFF -DWITH_PYTHON_SPHINX:BOOL=OFF -DLPSOLVE_LIBRARY="$LPSOLVE_LIBRARY_DIR/liblpsolve55.a" -DLPSOLVE_INCLUDE_DIR="$LPSOLVE_INCLUDE_DIR/lpsolve" -DNLopt_DIR="$NLOPT_DIR" -DCMAKE_BUILD_TYPE:STRING=Release -DCMAKE_MODULE_LINKER_FLAGS="-static -static-libgcc -static-libstdc++ -Wl,--static $KILL_AT" -DJAVA_INCLUDE_PATH:PATH=/usr/lib/jvm/java/include -DJAVA_INCLUDE_PATH2:PATH="$JNI_ARCH_DIR" -DJNI_INCLUDE_PATH2_OPTIONAL:BOOL=OFF -DJAVA_JVM_LIBRARY:FILEPATH=/usr/lib/jvm/java/lib/server/libjvm.so || exit $?
make -j4 || exit $?
cd ..

echo "copying results out"
cp -a build/bbowdapp/swig/bbowdajni.dll ../bbowdajnix$BITS.dll || exit $?
cd ..

echo "stripping bbowdajnix$BITS.dll"
$1-strip bbowdajnix$BITS.dll || exit $?
exit 0
