/* bbowda - Black Box Optimization With Data Analysis
   Copyright (C) 2025 DAGOPT Optimization Technologies GmbH (www.dagopt.com)
                      written by Kevin Kofler <kofler@dagopt.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version. A copy of the GNU General Public
   License version 3 can be found in the file gpl-3.0.txt.

   Linking bbowda statically or dynamically (directly or indirectly) with
   other modules is making a combined work based on bbowda. Thus, the terms
   and conditions of the GNU General Public License cover the whole
   combination.

   In addition, as a special exception, the copyright holder of bbowda gives
   you permission to combine the bbowda program:
   * with free software programs or libraries that are released under the
     GNU Library or Lesser General Public License (LGPL), either version 2
     of the License, or (at your option) any later version,
   * with free software programs or libraries that are released under the
     IBM Common Public License (CPL), either version 1.0 of the License, or
     (at your option) any later version,
   * with free software programs or libraries that are released under the
     eclipse.org Eclipse Public License (EPL), either version 1.0 of the
     License, or (at your option) any later version,
   * with free software programs or libraries that are released under the
     CeCILL-C Free Software License Agreement, either version 1 of the License,
     or (at your option) any later version,
   * with code included in the standard release of MUMPS under the old MUMPS
     Conditions of Use as reproduced in licenses.txt (or modified versions
     of such code, with unchanged license; variants of the license where only
     the list of contributors and/or the list of suggested citations changed
     shall be considered the same license) and
   * if you qualify for a free of charge license of DONLP2, with code
     included in the standard release of DONLP2 under the DONLP2 Conditions
     of Use as reproduced in licenses.txt (or modified versions of such code,
     with unchanged license).
   (For avoidance of doubt, this implies that it is permitted, e.g., to combine
   the bbowda program with current versions of Ipopt released under the EPL
   version 2.0, because 2.0 is >= 1.0. Its dependency MUMPS is released under
   the CeCILL-C version 1, which is also listed above.)

   You may copy and distribute such a system following the terms of the GNU
   GPL for bbowda and the licenses of the other code concerned, provided that
   you include the source code of that other code when and as the GNU GPL
   requires distribution of source code.

   Note that people who make modified versions of bbowda are not obligated
   to grant this special exception for their modified versions; it is their
   choice whether to do so. The GNU General Public License gives permission
   to release a modified version without this exception; this exception also
   makes it possible to release a modified version which carries forward
   this exception.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#pragma once

#include <stdio.h>
#include "o8para.h"

struct donlp3_problem;

#ifdef __cplusplus
extern "C" {
#endif

/* pointers to the variables from o8fuco.h */
struct donlp3_fuco {
  LOGICAL   **val, **llow, **lup;

  INTEGER   *n, *nr, *nres, *nlin, *nonlin;

  DOUBLE    *epsmac, *tolmac, *deldif;

  char      (*name)[41];

  DOUBLE    *epsdif;

  LOGICAL   *intakt, *te0, *te1, *te2, *te3, *singul;
  LOGICAL   *ident, *eqres, *silent, *analyt, *cold;

  INTEGER   *icf, *icgf, *cfincr, **cres, **cgres;

  LOGICAL   *ffuerr, **confuerr;

/*  special variables for the interface to old fashioned function */
/*  specification                                                 */
/*  can be removed is only problems in the new formulation are to be used */
  INTEGER *nh, *ng;

  INTEGER **nonlinlist;

  INTEGER ***gunit; 

  LOGICAL **gconst; 

  LOGICAL **cfuerr; 
/* this is necessary because of the different index positions used */
/*  in the old and new versions   */
};

/* pointers to the variables from o8comm.h */
struct donlp3_comm {
  struct donlp3_fuco fuco;

  REAL      *runtim;
  REAL      *optite;
  DOUBLE    ***accinf;
  INTEGER   *itstep, *phase;

  DOUBLE    *upsi, *upsi0, *upsi1, *upsist, *psi, *psi0,
            *psi1, *psist, *psimin,
            *phi, *phi0, *phi1, *phimin, *fx, *fx0, *fx1,
            *fxst, *f_min, *b2n, *b2n0, *xnorm, *x0norm, *sig0, *dscal, *dnorm,
            *d0norm;
  DOUBLE    *sig, *sigmin, *dirder, *cosphi, *upsim;
  DOUBLE    **x, **x0, **x1, **xmin, **d, **d0, **dd, **difx, **resmin;

  DOUBLE    **gradf, *gfn, **qgf, **gphi0, **gphi1, ***gres, **gresn;

  INTEGER   **perm, **perm1, **colno, *rank;
  DOUBLE    ***qr, **betaq, **diag, **cscal, **colle;

/* colno also used o8qpso with double length ! */

  DOUBLE    ***a, *scalm, *scalm2, **diag0, *matsc;

  INTEGER   **violis, **alist, **bind, **bind0, **aalist, **clist;
                        
  DOUBLE    **u, **u0, **w, **w1, **res, **res0, **res1, **resst, *scf, *scf0,
            **yu, **slack, *infeas, **work;

  INTEGER   *iterma;
  DOUBLE    *del, *del0, *del01, *delmin, *tau0, *tau, *ny;
  DOUBLE    *smalld, *smallw, *rho, *rho1, *eta, *epsx, *c1d,
            *scfmax, *updmy0, *tauqp, *taufac, *taumax;

  DOUBLE    *alpha, *beta, *theta, *sigsm, *sigla, *delta, *stptrm;
  DOUBLE    *delta1, *stmaxl;

  DOUBLE    *level;
  INTEGER   *clow, *lastdw, *lastup, *lastch;

  DOUBLE    **ug, **og;

  DOUBLE    **low, **up, *big;

  INTEGER   *nreset;

  DOUBLE    **xst;

  FILE      **prou, **meu;

  char      (*line)[65];
};

typedef void (*donlp3_user_init_callback_t)(const struct donlp3_comm *comm,
                                            void *user_data);
typedef void (*donlp3_setup_callback_t)(const struct donlp3_comm *comm,
                                        void *user_data);
typedef void (*donlp3_solchk_callback_t)(const struct donlp3_comm *comm,
                                         void *user_data);
typedef void (*donlp3_ef_callback_t)(DOUBLE *x, DOUBLE *fx,
                                     const struct donlp3_fuco *fuco,
                                     void *user_data);
typedef void (*donlp3_egradf_callback_t)(DOUBLE *x, DOUBLE *gradf,
                                         const struct donlp3_fuco *fuco,
                                         void *user_data);
typedef void (*donlp3_econ_callback_t)(INTEGER type, INTEGER *liste, DOUBLE *x,
                                       DOUBLE *con, LOGICAL *err,
                                       const struct donlp3_fuco *fuco,
                                       void *user_data);
typedef void (*donlp3_econgrad_callback_t)(INTEGER *liste, INTEGER shift,
                                           DOUBLE *x, DOUBLE **grad,
                                           const struct donlp3_fuco *fuco,
                                           void *user_data);
typedef void (*donlp3_eval_extern_callback_t)(INTEGER mode,
                                              const struct donlp3_comm *comm,
                                              void *user_data);

struct donlp3_problem *
donlp3_problem_create(int nx, int nlincons, int nnonlincons, int maxit,
                      int nstep, donlp3_user_init_callback_t user_init_callback,
                      donlp3_setup_callback_t setup_callback,
                      donlp3_solchk_callback_t solchk_callback,
                      donlp3_ef_callback_t ef_callback,
                      donlp3_egradf_callback_t egradf_callback,
                      donlp3_econ_callback_t econ_callback,
                      donlp3_econgrad_callback_t econgrad_callback,
                      donlp3_eval_extern_callback_t eval_extern_callback,
                      void *user_data);
void donlp3_problem_update(struct donlp3_problem *donlp3, int nx, int nlincons,
                           int nnonlincons, int maxit, int nstep,
                           donlp3_user_init_callback_t user_init_callback,
                           donlp3_setup_callback_t setup_callback,
                           donlp3_solchk_callback_t solchk_callback,
                           donlp3_ef_callback_t ef_callback,
                           donlp3_egradf_callback_t egradf_callback,
                           donlp3_econ_callback_t econ_callback,
                           donlp3_econgrad_callback_t econgrad_callback,
                           donlp3_eval_extern_callback_t eval_extern_callback,
                           void *user_data);
const struct donlp3_comm * donlp3_problem_get_comm(const struct donlp3_problem
                                                   *donlp3);
void * donlp3_problem_get_user_data(const struct donlp3_problem *donlp3);
void donlp3_problem_set_user_data(struct donlp3_problem *donlp3,
                                  void *new_user_data);
void donlp3_problem_solve(struct donlp3_problem *donlp3);
void donlp3_problem_free(struct donlp3_problem *donlp3);

#ifdef __cplusplus
}
#endif
