// Archive/Tar/InEngine.h

#pragma once

#ifndef __ARCHIVE_TAR_INENGINE_H
#define __ARCHIVE_TAR_INENGINE_H

#include "Archive/Tar/ItemInfoEx.h"
#include "Interface/IInOutStreams.h"

namespace NArchive {
namespace NTar {
  
class CInArchive
{
  CComPtr<IInStream> m_Stream;
  UINT64 m_Position;
  
  HRESULT ReadBytes(void *data, UINT32 size, UINT32 &processedSize);
public:
  HRESULT Open(IInStream *inStream);
  HRESULT GetNextItemReal(bool &filled, CItemInfoEx &itemInfo);
  HRESULT GetNextItem(bool &filled, CItemInfoEx &itemInfo);
  HRESULT Skeep(UINT64 numBytes);
  HRESULT SkeepDataRecords(UINT64 dataSize);
};
  
}}
  
#endif
