;AutoClBr (auto close brackets) v.2.22
;Copyright (C) Kevin Kofler, 2000-2004
;please read the readme file before using this file
;Please DO NOT distribute modified versions without my
;permission!

 include "OS.h" ;You need the version included with TIGCC.
_tigcc_native: xdef _tigcc_native ;no kernel required, but startup sections
 xdef _ti89 ;This is for the TI-89.
 xdef _ti92plus ;This is also for the TI-92+.
_v200: xdef _v200 ;and the Voyage 200.

 section "_st1"

 xdef _nostub_data__0000 ;comment
 xdef _nostub_data__0006 ;incompatibility flags

 include "h220xtsr.h" ;include my Hardware 2.00 AMS 2 TSR support
 movem.l a0-a6/d0-d7,-(a7) ;save all registers
 moveq.l #-5,d1
 moveq.l #16,d3 ;compute offset
 cmp.l d0,d1
 beq hw3
 bset.l #18,d3
hw3:
 move.l #$4000410c,event_key ;initialize the Y= key code
 move.w #16397,calcmodelpatch+2 ;initialize the DIAMOND+ENTER keycode
 move.l $c8,a0
 move.l ScrRect*4(a0),a0
 cmp.b #200,2(a0) ;check if TI-92+/V200
 bcs ti89
 move.l #$20002057,event_key ;if yes, change the Y= key code
 move.w #8205,calcmodelpatch+2 ;initialize the DIAMOND+ENTER keycode
ti89:
 pea.l event1(PC)
 move.w #-2,-(a7)
 ROM_CALL EV_sendEvent ;send the Y= keypress
 ROM_CALL2 FirstWindow
 move.l (a4),a4
 addq.l #1,a4
 move.l a4,ywindow ;get the address of the Y= window
 move.l #$10001108,event_key ;change the keycode to Quit
 ROM_CALL EV_sendEvent ;send the Quit keypress
 addq.l #6,a7
 move.l $c8,a0
 cmp.l #cmd_disphome,-4(a0) ;check if cmd_disphome is available
 bls nodisphome ;If it isn't, we are on a TI-92+ AMS 1.00. That means that there
                ;is no icon desktop anyway, so we already are on the home screen.
 move.l cmd_disphome*4(a0),a0
 jsr (a0) ;switch to the HOME screen
nodisphome:
 ROM_CALL2 FirstWindow
 move.l (a4),a4
 addq.l #1,a4
 move.l a4,window ;get the address of the home screen window

;Detect the address of the home screen entry line parameters.
;Thanks to Samuel Stearley for this one!
 move.l $c8,a0
 move.l TE_select*4(a0),d0 ;get the address of TE_select
 move.l HomeExecute*4(a0),a0 ;get the address of HomeExecute
;The code for HomeExecute contains a jsr to TE_select preceded by a pea of the
;required address.
search_loop:
 addq.l	#2,a0 ;code is word-aligned, so no need to check every byte
 cmp.l (a0),d0 ;compare with the address of TE_select
 bne search_loop
 moveq.l #0,d0
 move.w -4(a0),d0 ;get address of the home screen entry line
 add.l #16,d0 ;add 16 to the address to point it to the length of the text
 move.l d0,params
;End of the home screen entry line parameters detection

;Detect the address of the Y= entry line parameters.
 move.l $c8,a4 ;get the address of the jump table
 cmp.l #1000,-4(a4) ;check if less than 1000 entries
 bcs ams1 ;if yes, it is AMS 1
 pea.l tiequed(PC) ;otherwise it is AMS 2 (or higher)
 move.l $454*4(a4),a0 ;EV_getAppId
 jsr (a0) ;get the handle of the ACB of the Y= editor
 move.w d0,(a7)
 move.l HeapDeref*4(a4),a0
 jsr (a0) ;dereference the handle
 addq.l #4,a7
 move.l 12(a0),a0 ;get the address of the application header
 move.l 96(a0),a0 ;get the address of the routine the address we are looking for
                  ;is in
 bra ams2 ;continue with common code
ams1: ;routine for AMS 1:
 ;On AMS 1, there is an array of pointers to routines which immediately precedes
 ;EV_captureEvents. The second entry from the beginning is the routine we are
 ;looking for.
 move.l EV_captureEvents*4(a4),a0 ;get the address of EV_captureEvents
ams1_search_loop:
 cmp.l #$600000,-(a0) ;advance until the 4 bytes we are checking are no longer
 bcs ams1_search_loop ;a ROM address
 move.l 8(a0),a0 ;a0 points to array[-1], we need array[1], so we get a0[2]
ams2: ;common routine:
;The code for the routine we just found contains a jsr to TE_close preceded by a
;move.l #immediate,(a7) of the required address.
 move.l TE_close*4(a4),d0 ;get the address of TE_close
yeq_search_loop:
 addq.l	#2,a0 ;code is word-aligned, so no need to check every byte
 cmp.l (a0),d0 ;compare with the address of TE_close
 bne yeq_search_loop
 move.l -6(a0),d0 ;get address of the Y= screen entry line
 add.l #16,d0 ;add 16 to the address to point it to the length of the text
 move.l d0,yparams
;End of the Y= screen entry line parameters detection

 ROM_CALL2 EV_hook ;get the location of the event hook
 move.l (a4),oldevent ;save the old event hook and call
                        ;it from the event routine
 move.l #(endevent-newevent),-(a7)
 ROM_CALL HeapAllocHigh ;allocate a handle for the new
                        ;event routine
 addq.l #2,a7
 tst.w d0 ;check if NULL handle
 beq nomem ;if yes, display "no mem" error message
 move.w d0,(a7)
 ROM_CALL HeapDeref ;get ("dereference") the address
 move.l a0,a3 ;save the address to a3 for further use
 subq.l #2,a7
 move.l #(endevent-newevent),(a7)
 pea.l newevent(PC)
 move.l a0,-(a7)
 ROM_CALL memcpy ;copy the event routine to the handle
 lea.l 12(a7),a7 ;shorter as add(a).l #12,a7
 ROM_CALL2 EV_hook ;get the location of the event hook
 adda.l d3,a3 ;add offset to skip the uninstall information (need the start of
              ;the executable code here)
 move.l a3,(a4) ;install the event hook
 pea.l installedST(PC) ;show "installed" message
showmsg:
 ROM_CALL ST_helpMsg
 addq.l #4,a7
 movem.l (a7)+,a0-a6/d0-d7 ;restore all registers
 rts ;return
nomem:
 addq.l #2,a7 ;adjust the stack
 pea.l nomemST(PC) ;show "no mem" message
 bra showmsg

newevent: ;event hook
 dc.b 'evHkAutoClBr' ;signature "evHk" + program name
                     ;(for event hook uninstaller)
oldevent: dc.l 0 ;placeholder for old event hook
                   ;0 if none
                   ;placed here for easier and
                   ;program- and version-independent
                   ;uninstalling
 movem.l a0-a6/d0-d7,-(a7) ;save all registers
 move.l window(PC),a2 ;a2 = window for a moment
 btst.b #7,(a2) ;check "active" flag of the home screen
 beq nothome ;skip if the home screen is inactive
 move.l params(PC),a2 ;a2 = params from now on
 moveq.l #1,d0 ;remember the current application
 bra ishome ;skip Y= if the home screen is active
nothome:
 move.l ywindow(PC),a2 ;a2 = ywindow for a moment
 btst.b #7,(a2) ;check "active" flag of the Y= editor
 beq notmissing ;do nothing if Y= is inactive too
 move.l yparams(PC),a2 ;a2 = params from now on
 clr.b d0 ;remember the current application
ishome:
 btst.b #1,16(a2) ;check if cursor is in entry line
 beq notmissing
 move.l 64(a7),a0 ;get event structure (passed as an
                   ;argument on the stack to the event
                   ;hooking routine)
 cmp.w #$710,(a0) ;check if CM_KEYPRESS
 bne notmissing ;do nothing if event is not CM_KEYPRESS
 move.w 10(a0),a0 ;get the key number
 cmp.w #13,a0 ;check if ENTER
 beq isenter ;start event routine if ENTER
 tst.b d0 ;check if we are in the Y= editor
 beq notmissing ;ignore DIAMOND+ENTER if in the Y= editor
calcmodelpatch: ;the keycode is 16397 on a TI-89, 8205 on a TI-92+/V200
 cmp.w #8205,a0 ;check if DIAMOND-ENTER
 bne notmissing ;start event routine if DIAMOND-ENTER
                ;do nothing if any other key
isenter:
 move.w 18(a2),d7 ;d7 = entry line handle from now on
 move.w d7,-(a7)
 ROM_CALL HeapDeref ;dereference the handle to the address
 addq.l #2,a7
 move.l a0,a3 ;copy a0 to a3 for manipulation
 move.l a0,a5 ;save a0 to a5 for further use
continue:
 moveq.l #0,d3 ;initialize d3 = number of opening brackets - 
          ;                number of closing brackets
 clr.b d4 ;initialize d4 = $ff if in a string
          ;                1 or $fe if in a comment
          ;                0 if in executable expressions
 clr.b d0 ;d0 = dms n active (01) / inactive (00)
;d1 = variable name (1) / number (2) / expression (4) used
;as part of DMS number
;d2 = n of brackets in DMS expression
test:
 tst.b (a3) ;a3 = pointer to the currently treated
            ;character of the entry line
            ;check if 0 character
 beq endentryline ;if yes, the end of the entry line has
                  ;been reached
 cmp.b #'"',(a3) ;check if quote
 beq ias  ;entering/exiting a string
          ;"" will lead to exiting + entering, so the
          ;string will continue as expected
          ;only problem: DMS numbers (workaround required)
 tst.b d4 ;check if in a string or comment
 bne next ;if yes, skip treatment of "(", ")" and "(C)"
 cmp.b #'(',(a3) ;check if "("
 beq add1
 cmp.b #')',(a3) ;check if ")"
 beq sub1
 cmp.b #22,(a3) ;check if store arrow
 beq endentryline ;if yes, add the parentheses before it
 cmp.b #':',(a3) ;check if : sign
 beq endentryline ;if yes, add the parentheses before it
 cmp.b #169,(a3) ;check if "(C)"
 beq iac
 cmp.b #'',(a3) ;check if degree sign (necessary to avoid
 beq deg         ;bugs with DMS numbers)
 tst.b d0 ;check if in a DMS number
 beq next ;if no, skip treatment of DMS components
 tst.w d2 ;if brackets open in DMS number, skip
 bne next 
 cmp.b #'''',(a3) ;check if minute sign (necessary to
 beq min          ;avoid bugs with DMS numbers)
 cmp.b #'0',(a3) ;check if number
 bcs notnum
 cmp.b #'9',(a3)
 bhi notnum
 bra num
notnum:
 cmp.b #'.',(a3) ;check if .
 beq dot
 cmp.b #'a',(a3)
 bcs var1
 cmp.b #'z',(a3)
 bhi var1
 bra var ;if a to z, it is a variable name
var1:
 cmp.b #'A',(a3)
 bcs var2
 cmp.b #'Z',(a3)
 bhi var2
 bra var ;if A to Z, it is a variable name
var2:
 cmp.b #128,(a3)
 bcs var3
 cmp.b #139,(a3)
 bhi var3
 bra var ;if 128 to 139, it is a variable name
var3:
 cmp.b #141,(a3)
 bcs var4
 cmp.b #148,(a3)
 bhi var4
 bra var ;if 141 to 148, it is a variable name
var4:
 cmp.b #'',(a3)
 bcs var5
 cmp.b #'',(a3)
 bhi var5
 bra var ;if  to , it is a variable name
var5:
 cmp.b #'',(a3)
 bcs var6
 cmp.b #'',(a3)
 bhi var6
 bra var ;if  to , it is a variable name
var6:
 cmp.b #'',(a3)
 bcs var7
 cmp.b #'',(a3)
 bhi var7
 bra var ;if  to , it is a variable name
var7:
 cmp.b #'_',(a3)
 beq var
 cmp.b #154,(a3)
 beq var
 cmp.b #155,(a3)
 beq var
 cmp.b #178,(a3)
 beq var
;if any other character, the DMS number is over
numex:
 clr.b d0 ;end of DMS number
next:
 addq.l #1,a3 ;treat next character
 bra test
add1:
 addq.l #1,d3 ;add 1 to the number of open brackets
 tst.b d0 ;check if in a DMS number
 beq next ;if no, finish
 btst.b #0,d1 ;check if number
 bne numex ;if yes, the DMS number is over
 btst.b #2,d1 ;check if expression
 bne numex ;if yes, the DMS number is over
 addq.w #1,d2 ;add 1 to number of open brackets in DMS
 bra next
sub1:
 subq.l #1,d3 ;subtract 1 from the number of open brackets
 tst.b d0 ;check if in a DMS number
 beq next ;if no, finish
 subq.w #1,d2 ;subtract 1 from number of brackets in DMS
 moveq.l #4,d1 ;type is: expression with brackets
 bra next
deg:
 move.l a3,a0 ;copy a3 to a0 for calculations
 cmp.b #'_',-(a0) ;check if previous character is "_"
 bne degisdms ;if not "_" then it starts a DMS number
 moveq.l #6,d5 ;d5 = DBRA counter
 cmp.l a5,a0 ;check if beginning of the entry line
 beq next ;if yes, it is _C, _F or _K
degloop:
 cmp.b #'a',-(a0)
 bcs deg1
 cmp.b #'z',(a0)
 bhi deg1
 bra degisdms ;if a to z, it is a DMS number
deg1:
 cmp.b #'A',(a0)
 bcs deg2
 cmp.b #'Z',(a0)
 bhi deg2
 bra degisdms ;if A to Z, it is a DMS number
deg2:
 cmp.b #128,(a0)
 bcs deg3
 cmp.b #139,(a0)
 bhi deg3
 bra degisdms ;if 128 to 139, it is a DMS number
deg3:
 cmp.b #141,(a0)
 bcs deg4
 cmp.b #148,(a0)
 bhi deg4
 bra degisdms ;if 141 to 148, it is a DMS number
deg4:
 cmp.b #'',(a0)
 bcs deg5
 cmp.b #'',(a0)
 bhi deg5
 bra degisdms ;if  to , it is a DMS number
deg5:
 cmp.b #'',(a0)
 bcs deg6
 cmp.b #'',(a0)
 bhi deg6
 bra degisdms ;if  to , it is a DMS number
deg6:
 cmp.b #'',(a0)
 bcs deg7
 cmp.b #'',(a0)
 bhi deg7
 bra degisdms ;if  to , it is a DMS number
deg7:
 cmp.b #'_',(a0)
 beq degisdms
 cmp.b #154,(a0)
 beq degisdms
 cmp.b #155,(a0)
 beq degisdms
 cmp.b #178,(a0)
 beq degisdms
 cmp.b #'0',(a0)
 bcs deg8
 cmp.b #'9',(a0)
 bhi deg8
 bra next ;if 0 to 9, it is _C, _F or _K
deg8:
 cmp.l a5,a0 ;check if beginning of the entry line reached
 dbne d5,degloop ;continue if beginning not reached
 bra next ;if 7 numbers before _, then it is _C,F,K
degisdms:
 moveq.l #1,d0 ;DMS number active
 clr.b d1 ;type of expression unknown
 clr.w d2 ;0 brackets open in DMS number
 bra next
min:
 clr.b d1 ;type of expression unknown
 bra next
num:
 btst.b #2,d1 ;check if expression
 bne numex ;if yes, the DMS number is over
 btst.b #1,d1 ;check if variable name
 bne next
 bset.b #0,d1 ;if no, it is a number
 bra next
dot:
 btst.b #2,d1 ;check if expression
 bne numex ;if yes, the DMS number is over
 btst.b #1,d1 ;check if variable name
 bne numex ;if yes, the DMS number is over
 btst.b #3,d1 ;check if 2nd dot
 bne numex ;if yes, the DMS number is over
 moveq.l #9,d1 ;if no, it is a number
 bra next
var:
 btst.b #2,d1 ;check if expression
 bne numex ;if yes, the DMS number is over
 btst.b #0,d1 ;check if number
 bne numex ;if yes, the DMS number is over
 moveq.l #2,d1 ;if no, it is a variable name
 bra next
ias:
 tst.b d0 ;if not DMS number, it is a string delimiter
 beq iasisstr
 tst.b d2 ;same if brackets open in DMS number
 bne iasisstr
 clr.b d0 ;end of DMS number
 bra next
iasisstr:
 eor.b #$ff,d4 ;exchange 0 <-> $ff (entering / exiting
               ;a string) or 1 <-> $fe (if in a comment,
               ;no effects)
 bra next
iac:
 moveq.l #1,d4 ;set d4 to 1 so it will always remain 1
               ;or $fe until the end of the routine
 bra next
endentryline: ;the end of the entry line has been reached
 tst.b d4 ;check if still in a string or comment
 bne notmissing ;if yes, no use for adding ")" (it won't
                ;work, just mess up the comment)
 tst.l d3 ;check the number of brackets left open
 ble checkifend ;if 0 or if there are more closing than
                ;opening brackets, do nothing
 moveq.l #0,d0
 move.w (a2),d0
 add.l d3,d0 ;compute the new number of characters
 cmp.l #$ffe4,d0 ;compare with the maximum number of characters
 bhi notmissing ;if exceeded, there is an overflow, so do nothing
 move.l d3,-(a7)
 addq.l #1,(a7)
 ROM_CALL HeapAllocPtr ;allocate (number of brackets)+1 bytes
 cmp.l #0,a0 ;check if enough memory
 bne charnum_ok ;if no, do not add anything
 addq.l #4,a7 ;restore stack
 bra notmissing ;do nothing
charnum_ok: ;if enough memory, proceed
 subq.l #1,(a7)
 move.w #')',-(a7)
 pea.l (a0)
 ROM_CALL memset ;set all bytes except the last one to ")"
 move.l (a7),a0
 clr.b 0(a0,d3.l) ;clear the last byte (set it to 0)
 move.l a3,d0 ;compute the number of characters to consider
 sub.l a5,d0  ;required because of the store arrow support
 move.w d0,-(a7)
 move.w d0,-(a7)
 pea.l -16(a2)
 ROM_CALL TE_select ;move the cursor behind the last byte
 addq.l #8,a7 
 lea.l event_string(PC),a0 ;insert the address of the string into the
 move.l (a7),(a0)          ;placeholder in the event structure
 pea.l event(PC)
 move.w #-2,-(a7)
 ROM_CALL EV_sendEvent ;send the CM_STRING event to the current application
 addq.l #6,a7
 ROM_CALL HeapFreePtr ;free the memory
 lea.l 10(a7),a7
 add.l d3,a3 ;skip the added parentheses
checkifend:
 moveq.l #0,d0
 move.w (a2),d0
 add.l a5,d0 ;check if we are at the end of the entry line or before a store
 cmp.l a3,d0 ;arrow character
 beq notmissing ;if not before a store arrow, finish
 addq.l #1,a3 ;skip the store arrow
 move.w d7,-(a7)
 ROM_CALL HeapDeref ;dereference the handle again
                    ;(The address might have changed!)
 addq.l #2,a7
 sub.l a5,a3 ;subtract the old starting address from a3
 move.l a0,a5 ;change the starting address to the new one
 add.l a5,a3 ;add it to get the new current position
 bra continue ;continue
notmissing:
 move.l oldevent(PC),a0 ;a0 = old event hook
 cmp.l #0,a0 ;check if 0 (tst refuses this addressing mode)
 beq nooldevent ;if 0 do nothing
 move.l 64(a7),a2 ;pass event structure in a2 (for TeOS)
 move.l a2,-(a7) ;pass event structure as an argument
 jsr (a0) ;run the old event hook
 addq.l #4,a7
nooldevent:
 movem.l (a7)+,a0-a6/d0-d7 ;restore all registers
 rts ;return
 EVEN ;avoid silly alignment problems
      ;("Address Error" etc.)
params: dc.l $6016 ;position of the home screen entry line
                   ;parameters (TEXT_EDIT structure + 16)
window: dc.l $6071 ;position of the 2nd byte of the home
                   ;screen window flags (containing the
                   ;"active" flag)
yparams: dc.l $6256 ;position of Y= editor entry line
                    ;parameters (TEXT_EDIT structure + 16)
ywindow: dc.l 0 ;position of the 2nd byte of the Y=
                ;editor window flags (containing the
                ;"active" flag)
;These 4 values may be adjusted for different AMS versions.
event: ;event structure for EV_sendEvent
 dc.w $723 ;type = CM_STRING
 ds.b 6 ;RunningApp (2), Side (2), StatusFlags (2)
event_string:
 ds.b 6 ;pasteText (4), StartType (2)
endevent:

 EVEN ;avoid silly alignment problems
      ;("Address Error" etc.)

_nostub_data__0006: ;incompatibility flags
 dc.l 11 ;incompatible with handle freeing, EV_hook and trap restoring

event1: ;event structure for EV_sendEvent
 dc.w $710 ;type = CM_STRING
 ds.b 6 ;RunningApp (2), Side (2), StatusFlags (2)
event_key:
 dc.w $4000,$410c,0 ;Mod, Code, StartType (2)
tiequed: dc.b 'TIEQUED',0 ;"TIEQUED" string for EV_getAppID
installedST: dc.b 'AutoClBr 2.22 by Kevin Kofler installed',0
nomemST: dc.b 'ERROR: not enough memory',0

_nostub_data__0000: ;comment
 dc.b 'AutoClBr 2.22 by Kevin Kofler',0

 END
