;TI-89/92+ Hardware 2.00 AMS 2.0x TSR support v.1.03/1.04/1.05 UNINSTALLER
;Copyright (C) Kevin Kofler, 2001-2002
;please read the readme file before using this file
;Please DO NOT distribute modified versions without my
;permission!

 include "OS.h" ;You need the version included with TeOS
                ;or the one given with TIGCC 0.91 or
                ;higher (because of the ROM_CALL2 macro).
  xdef _nostub ;no kernel required
  xdef _ti89 ;This is for both the TI-89 and the TI-92+.
  xdef _ti92plus
  xdef _main ;This is a program, not a library.

_main:
 movem.l a0-a6/d0-d7,-(a7) ;save all registers
 move.l $ac,a2
 cmp.l #$200000,a2 ;check if trap #$b points to the ROM
 bcs found ;if no, it is installed
 pea.l notfoundST(PC) ;if none, display a "not found"
 bra return           ;error message
found:
 cmp.l #$40000,a2 ;if <$40000, it is not h220xTSR (because that would not work
 bcs incompatible ;reliably on HW2)
 sub.l #$40008,a2  ;remove: * $40000 for HW2 AMS 2.0x without HW2Patch
                   ;        * $8 to get the beginning of the handle (if
                   ;          compatible)
 cmp.l #'2Tsr',(a2) ;check for new signature
 beq compatible
 cmp.l #'2TSR',(a2) ;check for old signature
 beq compatible
incompatible:
 pea.l incompatibleST(PC) ;if incompatible, display an
 bra return               ;"incompatible" error message
compatible:
 ROM_CALL2 EV_hook ;check if an event hook is installed
 tst.l (a4)
 bne security ;if yes, refuse uninstallation
 cmp.l #$200000,$8 ;check if bus error points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$c ;check if address error points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$10 ;check if illegal instruction points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$14 ;check if divide by 0 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$18 ;check if CHK vector points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$1c ;check if TRAPV vector points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$20 ;check if privilege violation points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$24 ;check if trace points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$28 ;check if line 1010 emulator points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$2c ;check if line 1111 emulator points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$64 ;check if auto-int 1 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$68 ;check if auto-int 2 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$6c ;check if auto-int 3 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$70 ;check if auto-int 4 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$74 ;check if auto-int 5 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$78 ;check if auto-int 6 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$7c ;check if auto-int 7 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$80 ;check if trap #0 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$84 ;check if trap #1 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$88 ;check if trap #2 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$8c ;check if trap #3 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$90 ;check if trap #4 points to the ROM
 bcc trap4inrom ;if yes, skip next check
 move.l $90,a0 ;get old trap #4
 cmp.l #$40000,a0 ;if <$40000, it is not h220xTSR (because that would not work
 bcs security     ;reliably on HW2), so we refuse the uninstallation
 cmp.l #'2Tsr',-8(a0) ;check signature for h220xTSR
 bne security ;if not h220xTSR, refuse uninstallation
trap4inrom:
 cmp.l #$200000,$94 ;check if trap #5 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$98 ;check if trap #6 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$9c ;check if trap #7 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$a0 ;check if trap #8 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$a4 ;check if trap #9 points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$a8 ;check if trap #$a points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$b0 ;check if trap #$c points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$b4 ;check if trap #$d points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$b8 ;check if trap #$e points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$bc ;check if trap #$f points to the ROM
 bcs security ;if no, refuse uninstallation
 cmp.l #$200000,$90 ;check if trap #4 points to the ROM
 bcc trap4inrom2 ;if yes, skip removal of trap #4
 move.l $90,a0 ;get old trap #4
 move.l -4(a0),$40090 ;restore old trap #4
trap4inrom2:
 move.l 4(a2),$400ac ;restore old trap #$b
 move.l a2,-(a7)
 ROM_CALL HeapPtrToHandle ;get the handle number
 addq.l #2,a7
 move.w d0,(a7)
 ROM_CALL HeapFree ;free (unallocate) the handle
 addq.l #2,a7
 pea.l uninstalledST(PC) ;display "uninstalled" message
return:
 ROM_CALL ST_helpMsg ;display the message
 addq.l #4,a7
 movem.l (a7)+,a0-a6/d0-d7 ;restore all registers
 rts ;return
security:
 pea.l securityST(PC) ;display "cannot uninstall" message
 bra return

uninstalledST: dc.b 'h220xTSR by Kevin Kofler uninstalled',0
notfoundST: dc.b 'ERROR: h220xTSR not installed',0
incompatibleST: dc.b 'ERROR: Incompatible trap B hook',0
securityST: dc.b 'ERROR: TSRs still active, cannot uninstall',0

  END
