;UNINEVHK v.4.00
;Program- and version-independent event hook uninstaller
;Copyright (C) Kevin Kofler, 2000-2004
;please read the readme file before using this file
;This file can be freely distributed as long as:
;* the source and both executables (TI-89 and TI-92+) are
;  kept together.
;* it is LEFT UNMODIFIED.
;* applicable credit is given in the program's documentation.
;* it is NOT distributed together with ILLEGAL programs.
;Ask me for permission if you are not sure about on of these
;license requirements.
;Please DO NOT distribute modified versions of this file or
;the assembled ("compiled") program without my permission.

;TIGCC 0.95 Beta 1 or higher is needed to assemble this source code.
 include "OS.h" ;You need the version included with TIGCC.
_tigcc_native: xdef _tigcc_native ;no kernel required, but startup sections
 xdef _ti89 ;This is for the TI-89,
 xdef _ti92plus ;the TI-92+
_v200: xdef _v200 ;and the Voyage 200.

 xdef _nostub_data__0000 ;comment
 xdef _nostub_data__0006 ;incompatibility flags

 movem.l d3-d7/a2-a6,-(a7) ;save registers
 clr.w d3 ;initialize d3 = number of event hooks
 clr.w -(a7)
 pea.l popuptitle(PC)
 ROM_CALL PopupNew ;create a new popup menu
 addq.l #6,a7
 tst.w d0    ;check if NULL handle
 beq toomany2 ;if yes, use memory saving uninstall (last
              ;event hook)
 move.w d0,d4 ;d4 = handle of the popup menu
 ROM_CALL2 EV_hook ;get the location of the event hook
next:
 tst.l (a4) ;check if there is an event hook registered
 beq uninstall ;if no, display the uninstall dialog
 move.l (a4),d0 ;get the address of the event hook
                ;(move to data register so we can mask)
 cmp.l #$200000,d0 ;if not in RAM, it doesn't respect the
 bcc incompatible  ;evHk convention
 andi.l #$3ffff,d0 ;mask out any ghost space bits
 movea.l d0,a5 ;move to address register
 lea.l -16(a5),a5 ;remove 16 to get the begin of the handle
                  ;(if compatible)
 cmp.l #'evHk',(a5) ;check for signature
 beq compatible
incompatible:
 tst.w d3 ;check if there are other event hooks
 beq incompatible2 ;if no, display an error message
 move.w #4095,-(a7) ;4095 = return value for "incompatible"
 pea.l popupincompatible(PC)
 move.w #-1,-(a7)
 move.w d4,-(a7)
 ROM_CALL PopupAddText ;add the "incompatible" entry
 lea.l 10(a7),a7
 bra uninstall ;Display the uninstall dialog
compatible:
 cmp.w #4094,d3 ;check if maximum number reached
 beq toomany ;if yes, use memory saving uninstall (last
             ;event hook)
 addq.w #1,d3 ;add 1 to the number of event hooks
 move.l 4(a5),popuptext  ;replace the placeholder
 move.l 8(a5),popuptext2 ;with the program name
 move.w d3,-(a7)
 pea.l popuptext(PC)
 move.w #-1,-(a7)
 move.w d4,-(a7)
 ROM_CALL PopupAddText ;add an uninstall entry
 lea.l 10(a7),a7
 tst.w d0    ;check if NULL handle
 beq toomany ;if yes, use memory saving uninstall (last
             ;event hook)
 lea.l 12(a5),a4 ;get next event hook
 bra next ;go ahead
uninstall:
 tst.w d3 ;check if there are event hooks to uninstall
 bne found
 move.w d4,-(a7)
 ROM_CALL HeapFree ;delete the popup menu
 subq.l #2,a7
 move.l #$10000,(a7)
 pea.l notfoundDL(PC) ;if none, display a "not found"
 bra return           ;error message
found:
 clr.w -(a7)
 move.l #$ffffffff,-(a7)
 move.w d4,-(a7)
 ROM_CALL PopupDo ;show the popup menu
 move.w d0,d5 ;save the return value to d5
 ROM_CALL HeapFree ;delete the popup menu
 addq.l #8,a7
 tst.w d5 ;check if ESC presses
 beq displayappname ;if yes, display the app name
 cmp.w #4095,d5 ;check if "incompatible" selected
 beq incompatible3 ;display "incompatible" error message
 ROM_CALL2 EV_hook
skip:
 move.l a4,a3 ;save the address of EV_hook to change to a3
 move.l (a4),d0 ;get the address of the event hook
                ;(move to data register so we can mask)
 andi.l #$3ffff,d0 ;mask out any ghost space bits
 movea.l d0,a5 ;move to address register
 lea.l -16(a5),a5 ;remove 16 to get the begin of the handle
                  ;(if compatible)
 lea.l 12(a5),a4 ;move the "old event hook" placeholder to
                 ;a4 (this is the EV_hook replacement)
 subq.w #1,d5 ;remove 1 from the number of the event hook
 bne skip ;continue until the correct event hook is reached
 move.l (a4),(a3) ;restore the old event hook
uninstall_now:
 move.l 4(a5),uninstalledDL ;replace the placeholder
 move.l 8(a5),uninstalled2  ;with the program name
 move.l a5,-(a7)
 ROM_CALL HeapPtrToHandle ;get the handle number
 addq.l #4,a7
 move.w d0,-(a7)
 ROM_CALL HeapFree ;free (unallocate) the handle
 addq.l #2,a7
 move.l #$10000,-(a7)
 pea.l uninstalledDL(PC) ;display "uninstalled" message
return:
 pea.l uninevhk(PC)
 ROM_CALL DlgMessage ;display the message
 lea.l 12(a7),a7
return_now:
 movem.l (a7)+,d3-d7/a2-a6 ;restore registers
 rts ;return
toomany:
 move.w d4,-(a7)
 ROM_CALL HeapFree ;delete the popup menu
 addq.l #2,a7
toomany2:
 ROM_CALL2 EV_hook ;get the location of the event hook
 tst.l (a4) ;check if there is an event hook registered
 bne toomany_found
 move.l #$10000,-(a7)
 pea.l notfoundDL(PC) ;if none, display a "not found"
 bra return           ;error message
toomany_found:
 move.l (a4),d0 ;get the address of the event hook
                ;(move to data register so we can mask)
 cmp.l #$200000,d0 ;if not in RAM, it doesn't respect the
 bcc incompatible3 ;evHk convention
 andi.l #$3ffff,d0 ;mask out any ghost space bits
 movea.l d0,a5 ;move to address register
 lea.l -16(a5),a5 ;remove 16 to get the begin of the handle
                  ;(if compatible)
 cmp.l #'evHk',(a5) ;check for signature
 bne incompatible3
 move.l 12(a5),(a4) ;restore the old event hook
 bra uninstall_now ;continue uninstallation like in the
                   ;new method
incompatible2:
 move.w d4,-(a7)
 ROM_CALL HeapFree ;delete the popup menu
 addq.l #2,a7
incompatible3:
 move.l #$10000,-(a7)
 pea.l incompatibleDL(PC) ;if incompatible, display an
 bra return               ;"incompatible" error message
displayappname:
 pea.l uninevhk(PC)
 ROM_CALL ST_helpMsg ;display the message
 addq.l #4,a7
 bra return_now

 EVEN ;Avoid silly alignment problems (Address Error etc.)

_nostub_data__0006: dc.l 8 ;incompatible with EV_hook restoring
uninstalledDL: dc.b '****'
uninstalled2: dc.b '**** TSR event hook uninstalled',0
notfoundDL: dc.b 'No TSR event hook resident',0
incompatibleDL: dc.b 'Incompatible TSR event hook',0
popuptitle: dc.b 'TSR event hooks',0
popupincompatible: dc.b '(Incompatible TSR)',0
_nostub_data__0000: ;comment
uninevhk: dc.b 'UnInEvHk v.4.00 by Kevin Kofler',0

 EVEN ;Avoid silly alignment problems (Address Error etc.)

popuptext: dc.b '****'
popuptext2: dc.b '****',0

 END
