VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   5025
   ClientLeft      =   165
   ClientTop       =   795
   ClientWidth     =   10500
   LinkTopic       =   "Form1"
   ScaleHeight     =   5025
   ScaleWidth      =   10500
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox SpectreEchX 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   615
      Left            =   1185
      ScaleHeight     =   41
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   513
      TabIndex        =   8
      Top             =   3960
      Width           =   7695
   End
   Begin VB.PictureBox SpectreEchY 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   4455
      Left            =   120
      ScaleHeight     =   297
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   73
      TabIndex        =   7
      Top             =   120
      Width           =   1095
   End
   Begin MSComctlLib.ProgressBar ProgressBar 
      Height          =   330
      Left            =   600
      TabIndex        =   6
      Top             =   4680
      Visible         =   0   'False
      Width           =   8295
      _ExtentX        =   14631
      _ExtentY        =   582
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CommandButton cmd_FilterMinus 
      Caption         =   "-"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   9960
      TabIndex        =   5
      Top             =   1230
      Width           =   255
   End
   Begin VB.CommandButton cmd_FilterPlus 
      Caption         =   "+"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   9960
      TabIndex        =   4
      Top             =   960
      Width           =   255
   End
   Begin VB.TextBox TxtFilter 
      Alignment       =   2  'Center
      Height          =   285
      Left            =   9120
      MaxLength       =   4
      TabIndex        =   2
      Text            =   "7"
      Top             =   1080
      Width           =   615
   End
   Begin VB.CommandButton cmd_DrawSpectre 
      Caption         =   "Spectrogramme"
      Height          =   375
      Left            =   9120
      TabIndex        =   1
      Top             =   120
      Width           =   1335
   End
   Begin VB.PictureBox Spectre 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      ForeColor       =   &H00FFFFFF&
      Height          =   3840
      Left            =   1200
      ScaleHeight     =   256
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   512
      TabIndex        =   0
      Top             =   120
      Width           =   7680
   End
   Begin MSComDlg.CommonDialog dialog 
      Left            =   9240
      Top             =   1680
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      Caption         =   "Filtre"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   345
      Left            =   9120
      TabIndex        =   3
      Top             =   720
      Width           =   660
   End
   Begin VB.Menu MnuFile 
      Caption         =   "&Fichier"
      Begin VB.Menu MnuFile_Open 
         Caption         =   "&Ouvrir"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public SpcFile As String                'Fichier de donnes

Public NB_PTS As Long                   'Nombre de points
Dim LstPTS() As Single                  'Tableau de points

Dim PalColor() As Long                  'Palette de couleurs
Public nPalColor As Long                'Nombre de couleurs

'Axes Temps et frquences
Public TimeMin As Single, TimeMax As Single
Public FreqMin As Single, FreqMax As Single

Public PtsSize As Byte                  'Taille d'un point suivant X
Public WindowSize As Long               'Taille d'une fentre d'chantillons
Public MaxFrequency As Long             'Frquence d'chantillonnage maximale

'Axes
Public X_Xmin As Long, X_Ymin As Long
Public X_Ymax As Long, X_Xmax As Long
Public Y_Xmin As Long, Y_Ymin As Long
Public Y_Ymax As Long, Y_Xmax As Long

Public nMqX As Long, nMqY As Long       'Nombre de marqueurs
Public MqSize As Byte                   'Taille d'une ligne de marqueur


Private Sub cmd_FilterPlus_Click()
TxtFilter.Text = Str(Val(TxtFilter.Text) + 1)
cmd_DrawSpectre_Click
End Sub

Private Sub cmd_FilterMinus_Click()
If Val(TxtFilter.Text) > 1 Then
  TxtFilter.Text = Str(Val(TxtFilter.Text) - 1)
End If
cmd_DrawSpectre_Click
End Sub


Private Sub Form_Load()
TxtFilter.Text = 7

ProgressBar.Min = 0: ProgressBar.Max = 100
ProgressBar.value = 0

MaxFrequency = 22050

AxesInit
PalColor_Create
End Sub

Private Sub MnuFile_Open_Click()
Dim TmpTxt As String
Dim i As Long

On Error GoTo Cancel
dialog.CancelError = True
dialog.DefaultExt = 1
dialog.DialogTitle = "Ouvrir un fichier de points"
dialog.Filter = "Fichiers type spectre (*.spc)|*.spc|Tous les fichiers (*.*)|*.*"
dialog.InitDir = App.Path
dialog.ShowOpen

SpcFile = dialog.FileName

'Bloc de donnes
WindowSize = 256

'====================
'Ouverture du fichier
'====================
NB_PTS = 0
Open SpcFile For Input As #1
  'Compte le nombre de points
  While Not EOF(1)
    Line Input #1, TmpTxt
    NB_PTS = NB_PTS + 1
  Wend
  
  'Dimension liste de points
  ReDim LstPTS(NB_PTS + WindowSize - 1) 'Liste de NB_PTS+1 points
  Seek #1, 1
  
  'Cration de la liste de points
  i = 0
  While Not EOF(1)
    Line Input #1, TmpTxt
    LstPTS(i) = Val(TmpTxt)
    i = i + 1
  Wend
Close #1


'========================
'Mise  l'chelle spectre
'========================
TimeMin = 0
TimeMax = (NB_PTS / WindowSize)
FreqMin = 0
FreqMax = 256 'WindowSize - 1

PtsSize = Round((Spectre.Width / 15) / (TimeMax * 2)) 'Dfinit la taille d'un point

Spectre.ScaleMode = 0 'User=0; Pixel=3
Spectre.ScaleLeft = 0: Spectre.ScaleWidth = (TimeMax * PtsSize * 2) - 1
Spectre.ScaleTop = 0: Spectre.ScaleHeight = FreqMax

'Augmente le nombres de points
For i = NB_PTS To (NB_PTS + WindowSize) - 1
  LstPTS(i) = LstPTS(NB_PTS - 1) 'Necessaire pour ajouter des points d'approximations
Next i

Form1.Refresh
cmd_DrawSpectre_Click

Exit Sub
Cancel:
End Sub


'*********************
'Dessine Spectrogramme
'*********************
Private Sub cmd_DrawSpectre_Click()
Dim nWindow As Long
Dim FreqY As Long
Dim xPTS As Long
Dim aPTS_x1 As Single, aPTS_x2 As Single 'Amplitude

Dim nPtsX As Long
Dim Filter As Single

If (NB_PTS = 0) Then
  MsgBox "Impossible de raliser le spectogramme. Veuillez ouvrir un fichier!", vbCritical + vbDefaultButton1 + vbOKOnly, "Liste de donnes vide"
  Exit Sub
End If

Spectre.Cls
AxesMake
Form1.Refresh

Filter = Val(TxtFilter.Text)
ProgressBar.Visible = True
ProgressBar.value = 0

Form1.MousePointer = 11
Spectre.MousePointer = 11

'Nombre de fentres
For nWindow = 0 To TimeMax - 1
  'Coordonnes dans le temps
  For FreqY = 0 To WindowSize - 1
    xPTS = (nWindow * WindowSize) + FreqY
    aPTS_x1 = LstPTS(xPTS)
    aPTS_x2 = (LstPTS(xPTS) + LstPTS(xPTS + WindowSize)) / 2
    
    'Ajustement au niveau de la palette de couleurs
    aPTS_x1 = (aPTS_x1 ^ (1 / Filter)) * Int(nPalColor / ((MaxFrequency / 2) ^ (1 / Filter)))
    aPTS_x2 = (aPTS_x2 ^ (1 / Filter)) * Int(nPalColor / ((MaxFrequency / 2) ^ (1 / Filter)))
    
    'aPTS_x1 = aPTS_x1 * (nPalColor - 1) * 2
    'aPTS_x2 = aPTS_x2 * (nPalColor - 1) * 2
        
    'aPTS_x1 = 20 * (Log(aPTS_x1) / Log(10))
    'aPTS_x2 = 20 * (Log(aPTS_x2) / Log(10))
        
    'aPTS_x1 = 1 - 0.97 / aPTS_x1
    'aPTS_x2 = 1 - 0.97 / aPTS_x2
    
    'aPTS_x1 = aPTS_x1 + 3
    'aPTS_x2 = aPTS_x2 + 3
    
    'aPTS_x1 = (aPTS_x1 ^ (1 / Filter)) * Int(nPalColor / (6 ^ (1 / Filter)))
    'aPTS_x2 = (aPTS_x2 ^ (1 / Filter)) * Int(nPalColor / (6 ^ (1 / Filter)))

       
    For nPtsX = 0 To PtsSize - 1
      Spectre_DrawPoint ((nWindow * 2) * PtsSize) + nPtsX, FreqY, Fix(aPTS_x1)
    Next nPtsX
    For nPtsX = 0 To PtsSize - 1
      Spectre_DrawPoint (((nWindow * 2) + 1) * PtsSize) + nPtsX, FreqY, Fix(aPTS_x2)
    Next nPtsX
    
    
    'DoEvents
  Next FreqY
  
  ProgressBar.value = ((nWindow + 1) * 100) / TimeMax
Next nWindow

ProgressBar.Visible = False
Form1.MousePointer = 0
Spectre.MousePointer = 0

End Sub


Private Sub Spectre_DrawPoint(x As Long, y As Long, color As Long)
Dim i As Byte, j As Byte
If (color = 0) Then Exit Sub

Spectre.PSet (x, Spectre.ScaleHeight - y), PalColor(color)

'For i = 0 To 20 - 1
'  Spectre.PSet (x, Spectre.ScaleHeight - (y * 20 + i)), PalColor(color)
'Next i
End Sub


'Cration de la palette de nuances d'amplitudes
Private Sub PalColor_Create()
Dim x As Long

nPalColor = 1791
ReDim PalColor(nPalColor)

For x = 1 To 256
  PalColor(x - 1) = RGB(0, x - 1, 0)                  'Noir -> Vert
  PalColor(x + 256 - 1) = RGB(0, 256 - x, x - 1)      'Vert -> Bleu
  PalColor(x + 256 * 2 - 1) = RGB(x - 1, 0, 256 - x)  'Bleu -> Violet
  PalColor(x + 256 * 3 - 1) = RGB(255, 0, 256 - x)    'Violet -> Rouge
  PalColor(x + 256 * 4 - 1) = RGB(255, x - 1, 0)      'Rouge -> Jaune
  PalColor(x + 256 * 5 - 1) = RGB(255, 255, x - 1)    'Jaune -> Blanc
  PalColor(x + 256 * 6 - 1) = RGB(255, 255, 255)      'Blanc
Next x

End Sub


'Initialise les variables necessaire  la gestion des Axes
Private Sub AxesInit()
'Coordonnes de bases
X_Xmin = 0
X_Xmax = SpectreEchX.ScaleWidth - 1
X_Ymin = 1
X_Ymax = SpectreEchX.ScaleHeight - 1

Y_Xmin = 0
Y_Xmax = SpectreEchY.ScaleWidth - 2
Y_Ymin = 0
Y_Ymax = (Spectre.Height / 15) + 1

'Marqueurs
nMqX = 10: nMqY = 10
MqSize = 15

'Lignes de sparations
SpectreEchX.Line (X_Xmin, X_Ymin)-(X_Xmax, X_Ymin)
SpectreEchY.Line (Y_Xmax, Y_Ymin)-(Y_Xmax, Y_Ymax)

'Axe X
SpectreEchX.FontSize = 7
SpectreEchX.CurrentX = X_Xmax - 22
SpectreEchX.CurrentY = X_Ymin + 4
SpectreEchX.Print "Sec"
SpectreEchX.FontSize = 6

'Axe Y
SpectreEchY.FontSize = 7
SpectreEchY.CurrentX = Y_Xmin + 22
SpectreEchY.CurrentY = Y_Ymin + 4
SpectreEchY.Print "Hz"
SpectreEchY.FontSize = 6
End Sub


'Cration des chelles
Private Sub AxesMake()
Dim i As Long
Dim xPos As Long, yPos As Long
Dim value As Single

SpectreEchX.Cls
SpectreEchY.Cls

'Lignes de sparations
SpectreEchX.Line (X_Xmin, X_Ymin)-(X_Xmax, X_Ymin)
SpectreEchY.Line (Y_Xmax, Y_Ymin)-(Y_Xmax, Y_Ymax)

'Axe X
SpectreEchX.FontSize = 7
SpectreEchX.CurrentX = X_Xmax - 22
SpectreEchX.CurrentY = X_Ymin + 4
SpectreEchX.Print "Sec"
SpectreEchX.FontSize = 6

'Axe Y
SpectreEchY.FontSize = 7
SpectreEchY.CurrentX = Y_Xmin + 22
SpectreEchY.CurrentY = Y_Ymin + 4
SpectreEchY.Print "Hz"
SpectreEchY.FontSize = 6

'Dessine marqueurs
'X
For i = 0 To nMqX - 1
  'Dessine ligne
  xPos = X_Xmin + (((Spectre.Width / 15) / nMqX) * i)
  SpectreEchX.Line (xPos, X_Ymin)-(xPos, X_Ymin + MqSize)
  
  'Attribution valeur
  value = (((NB_PTS * 2) / MaxFrequency) / (nMqX + 1)) * (i + 1)
  SpectreEchX.CurrentX = xPos
  SpectreEchX.CurrentY = X_Ymin + MqSize + 3
  SpectreEchX.Print Format(value, "##0.00")
Next i

'Y
For i = 0 To nMqY - 1
  'Dessine ligne
  yPos = Y_Ymax - (((Spectre.Height / 15) / nMqY) * i)
  SpectreEchY.Line (Y_Xmax, yPos)-(Y_Xmax - MqSize, yPos)
  
  'Attribution valeur (frquence Hz)
  value = Round(((MaxFrequency / 2) / nMqY) * i, 0)
  
  'Mels
  'value = 2595 * (Log(1 + value / 700) / Log(10))
  
  SpectreEchY.CurrentX = Y_Xmax - MqSize - 3 - ((Len(Str(value)) - 1) * 5)
  SpectreEchY.CurrentY = yPos - 4
  SpectreEchY.Print Str(value)
Next i

End Sub
