#ifndef FFT_H
#define FFT_H

#define AngleNumerator      6.283185 //2*PI = 2*3.14159265358979

//========
//Fentres
//========
/*
Rectangulaire: 1
Triangulaire: Phase1-> (x/NumSamples)/2; Phase 2:-> (x/-NumSamples)/2
Hamming: 0.54-0.46*cos(2*M_PI*x/NumSamples)
Hanning: 0.5-0.5*cos(2*M_PI*x/NumSamples)
Blackman-Harris: 0.355768-0.487396*cos(2*M_PI*x/NumSamples)+0.144232*cos(4*M_PI*x/NumSamples)-0.012604*cos(6*M_PI*x/NumSamples)
Gossa: Phase 1-> (1-0.25)*(0.5-0.5*cos(x*M_PI/((NumSamples/2)-1)))+0.25*x /((NumSamples/2)-1); Phase 2-> (1-0.25)*(0.5-0.5*cos(((NumSamples-1)-x)*M_PI/((NumSamples/2)-1)))+0.25*((NumSamples-1)-x)/((NumSamples/2)-1)
*/

//Prototypes
//==========
unsigned char NumberOfBitsNeeded (long PowerOfTwo);
bool IsPowerOfTwo (long x);
long ReverseBits (long Index, unsigned char NumBits);
bool FFTAudio (long NumSamples, float *RealIn, float *RealOut, float *ImagOut);
//bool FFTAudio (long NumSamples, short *RealIn, float *RealOut, float *ImagOut);
void iDCT (long size, float *data_in, float *data_out);

#endif
