#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <cstring>
#include "Functions.h"

//Frquence en Hz en Mel
float FrequencyToMel (float frequency)
{
  return 2595.037*log10(1.0+frequency/700.0);
}

//Mel en frquence en Hz
float MelToFrequency (float mel)
{
  return 700.0*(pow (10.0, mel/2595.037)-1.0);
}

//Application de la fentre (Hamming)
float WindowPonder (unsigned long i, unsigned long nSamples)
{
  float x = (float)i;
  float n = (float)nSamples;
  
  return (0.54-0.46*cos(2*M_PI*x/n));
}

//Rcupre nom d'un fichier
void GetFileName (char *buffer_src, char *buffer_dest)
{
  unsigned short size_src = strlen (buffer_src);
  long i;
  unsigned short pos_start_ext;
  unsigned short pos_start_cpy;
  
  pos_start_cpy = 0x00;
  for (i=(strlen (buffer_src)-1); i>=0; i--)
  {
    if (buffer_src [i]=='.') pos_start_ext = i;
    if (buffer_src [i]=='\\') {
      pos_start_cpy = i+1;
      break;}
  } 
  pos_start_cpy = pos_start_cpy?pos_start_cpy:0x00; 
  
  memcpy (buffer_dest, buffer_src+pos_start_cpy, pos_start_ext-pos_start_cpy);
  buffer_dest [pos_start_ext-pos_start_cpy] = 0x00;      
}
