#ifndef HEADER_H
#define HEADER_H

//Structure d'un fichier WAV
typedef struct RiffHeader {
 unsigned long FichType;         // contient RIFF
 unsigned long dwFileLength;     // longueur du fichier - 8 octets
 unsigned long InfoType;         // contient WAVE
 unsigned long Fmt;              // contient fmt  avec lespace
 unsigned long FmtLen;           // contient 16 (long. Infos prcd.)

 unsigned short wFormatTag;      // contient WAVE_FORMAT_PCM
 unsigned short wChannels;       // 1=mono, 2=stro
 unsigned long dwSamplesPerSec;  // frquence dchantillonnage
 unsigned long dwAvgBytesPerSec; // nbre doctets par seconde

 unsigned short wBlockAlign;     // nbre doctets / chantillon :
     // 1= 8 bits mono
     // 2= 8 bits stro ou 16 bits mono
     // 4= 16 bits stro

 unsigned short wBitsPerSample;  // 8 ou 16
 unsigned long dwIdentif;        // contient data

 unsigned long dwNberOfData;     // nbre dchantillons qui suivent (en octets)
};

//Fentre d'chantillons
typedef struct s_Window {
  float *data;
  float *FFT_Real;
  float *FFT_Imag;
};

//Structure d'un filtre de Mels
typedef struct s_MelFilter {
  float start_point;
  float end_point;
  float *data;
};

//Structure de donnes 
typedef struct s_data {
  float *data;
};

//Structure gnrale du fichier WAV
typedef struct s_wSamples {
  RiffHeader HeaderInfo;
  unsigned long NumSamples;
  unsigned long NumWindow;
  s_Window *Window;
  s_MelFilter *MelFilter;
  s_data *MelFrame;
  s_data *iDCT_Frame; 
};


//MFCC Header
typedef struct MFCCHeader {
  unsigned long FichType;
  unsigned long NumWindow;
  unsigned long NumFilter;
};

//Vecteurs pour DTW
typedef struct s_wVector {
  s_data *Vector;  
  unsigned long NumWindow;
  unsigned long NumFilter;
};  

//Accs direct  la structure
#define sHeaderInfo      wSamples->HeaderInfo
#define sNumWindow       wSamples->NumWindow
#define sNumSamples      wSamples->NumSamples
#define sWindow          wSamples->Window
#define sMelFilter       wSamples->MelFilter
#define sMelFrame        wSamples->MelFrame
#define siDCT_Frame      wSamples->iDCT_Frame


//Dfinition fichier PCM
#define SAMPLE_RATE               22050
#define MAX_CHANNELS              16

//Fentre de n chantillons
#define WINDOW_SAMPLES            512 //2^9

//Facteur de praccentuation
#define PREACCENT_FACTOR          0.970

//Nombre de filtres de Mels
#define MELS_FILTERS              12

#define DTW_INFINITY              100000
#define DTW_MIDDLE                0.5

#define OUTPUT_FILE               "output.txt"

int WavFile_CheckFormat (char *file, s_wSamples *wSamples);
bool WavFile_AllocateWindows (unsigned long nSamples, s_wSamples *wSamples);
void WavFile_MakeWindows (FILE *wav_file, unsigned long nSamples, s_wSamples *wSamples);
void WavFile_MFCC (unsigned long nSamples, s_wSamples *wSamples);
bool WavFile_Create_MFCC_File (s_wSamples *wSamples, const char *MFCC_File);
void WavFile_DeleteWindows (s_wSamples *wSamples);

bool DTW_CreateVector (FILE *input, s_wVector *sVector);
void DTW_DeleteVector (s_wVector *sVector);
float DTW_DistEuclidian (float *x, float *y, unsigned long nFilter1, unsigned long nFilter2);
float DTW_Compare (s_wVector *sVector11, s_wVector *sVector21);

#endif


