#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include "Convert.h" 

//Ficher de conversion des bases
//******************************

bool sCnError = false;

//Table de la base hexadcimale
const unsigned char HexaTable [16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B','C', 'D', 'E', 'F'};

//--------------------------------------------------
//Conversion Hexadcimal->Dcimal prefixe (0h ou 0x)
//--------------------------------------------------
unsigned long Str_HexToInt (const char *string, unsigned long size)
{
  unsigned long sValue, sResult = 0;
  sCnError = false;
  
  //Vrification du format de la chane
  if (size<=2 || string [0]!='0' && !(string [1]=='h' || string [1]=='H' || string [1]=='x' || string [1]=='X'))
    return (sCnError = true);
  
  //Parcours caractres
  for (unsigned long i=2; i<size; i++)
  {
    if (string [i]>='0' && string [i]<='9') sValue = string [i]-'0';
    else if (string [i]>='A' && string [i]<='F') sValue = (string [i]-'A')+10;
    else if (string [i]>='a' && string [i]<='f') sValue = (string [i]-'a')+10;
    else return (sCnError = true);
    
    sResult += (unsigned long)sValue<<((size-i-1)<<2); 
  }
  
  return sResult;
}


//--------------------------------------------------
//Conversion Hexadcimal->Dcimal prefixe (0h ou 0x)
//--------------------------------------------------
unsigned long Str_BinToInt (const char *string, unsigned long size)
{
  unsigned long sValue, sResult = 0;
  sCnError = false;
  
  //Vrification du format de la chane
  if (size<=2 || string [0]!='0' && !(string [1]=='b' || string [1]=='B'))
    return (sCnError = true);
  
  //Parcours caractres
  for (unsigned long i=2; i<size; i++)
  {
    if (!(string [i]=='0' || string [i]=='1'))
      return (sCnError = true);
    
    sResult += (unsigned long)(string [i]-'0')<<(size-i-1);
  }
  
  return sResult;
}

//******************************************************
//Retourne le nombre de bits d'un nombre
//******************************************************
unsigned char GetnBits (unsigned long integer)
{
  for (unsigned char nbit = 31; nbit>0; nbit--)
    if (integer&(1UL<<nbit)) return nbit+1;
  return 1;
}


//******************************************************
//Retourne le nombre de digits
//******************************************************
unsigned char GetnDigits (unsigned long integer, unsigned char div)
{
  unsigned char digit = 1;
  for (;integer>>=div; digit++); return digit;
}


//-------------------------------
//Conversion Dcimal->Hexadcimal
//-------------------------------
char *Str_IntToHex (unsigned long value, char *buffer)
{
  unsigned char ndigit = GetnDigits (value, 4);
  unsigned char pos = 0;
	
  for (int i=ndigit-1; i>=0; i--, pos++)
    buffer [pos] = HexaTable [(value>>(i<<2))&15UL];
  buffer [pos] = 0;
  
  return buffer;
}


//---------------------------
//Conversion Dcimal->Binaire
//---------------------------
char *Str_IntToBin (unsigned long value, char *buffer)
{
  unsigned char nbit = GetnBits (value);
  unsigned char pos = 0;
  unsigned char addzero = 0;
  
  //Parcours les bits   	
  for (int i=nbit-1; i>=0; i--, pos++)
    buffer [pos] = value&(1UL<<i)?'1':'0';
  buffer [pos] = 0;
  
  //Ajoute des zros si ncessaire
  addzero = 8-strlen (buffer);
  memmove (buffer+addzero, buffer, strlen (buffer));
  memset (buffer, '0', addzero);
  buffer [pos+addzero] = 0;
  
  return buffer;
}


