#include <windows.h>
#include <iostream>
#include <stdlib.h>
#include <stdio.h> 
#include <dos.h> 
#include <conio.h>
#include "WinIo.h"

#include "Header.h"
#include "Convert.h"

using namespace std;

unsigned long SET_LPT;          //Default: LPT1
void Program1 (void);
void Program2 (void);
void Program3 (void);
void Program4 (void);

int main(int argc, char *argv[])
{  
  char buffer [50] = {};
  bool bResult;
  unsigned long sValue = 0, sResult = 0;
  unsigned char RunProgram = 0;
  
  //===================
  //Options par dfauts
  //===================
  SET_LPT = LPT1;
  sValue = 0x00;
  
  //*****
  //Texte
  //*****
  system ("CLS");
  printf ("Write data in the LPT\n");
  printf ("This program run with the library WinI/O.\n");
  printf ("Copyright 2004 by ANNEHEIM Geoffrey\n\n");
  printf ("Command: \n");
  printf ("-a = Set port address (1 for LPT1, 2 for LPT2)\n");
  printf ("-v = Set port value\n");
  printf ("-1 = Program test 1\n");
  printf ("-2 = Program test 2\n");
  printf ("-3 = Program test 3\n");
  printf ("-4 = Program test 4\n\n");
  printf ("Usage: [-a port address] [-v write value]\n");
  printf ("Default: -a 0h378 -v 0x00\n\n");
  
  //Lecture des arguments
  for (int i=1; i<argc; i++)
  {
    //************
    //PORT ADDRESS
    //************
    if (!strcmp (argv [i], "-a"))
    { 
      //Dernier argument, va au numro de port!
      if (++i==argc || !strlen (argv [i])) {
        printf ("Error: No port address specified!\n");
        return 1;}
      
      //Choix du port
      if (strlen (argv [i])==1)
      {
        if (argv [i][0]=='1') sResult = LPT1;
        else if (argv [i][0]=='2') sResult = LPT2;
        else {
          printf ("Error: Incorrect value of port address!\n"); 
          return 2;}
      }
      //Valeur hexadcimale
      else 
      {
        sResult = Str_HexToInt (argv [i], strlen (argv [i]));
        if (sCnError) {
          printf ("Error: Incorrect value of port address!\n"); 
          return 2;}
      }
      
      //Adresse 0h379 ou 0H279, risque d'endommager le PC
      if (sResult==LPT1+1 || sResult==LPT2+1) {
        printf ("Error: Do no use this address because it is not possible to write data!\n");
        return 6;}   
            
      //Choix du port LPT
      SET_LPT = sResult;
      
      continue;
    } 
    
    
    //**********
    //READ VALUE
    //**********
    else if (!strcmp (argv [i], "-v"))
    {
      sValue = 0x00;
      
      //Dernier argument, va au numro de port!
      if (++i==argc || !strlen (argv [i])) {
        printf ("Error: No write value specified!\n");
        return 3;}
      
      //Binaire
      sValue = Str_BinToInt (argv [i], strlen (argv [i]));
      
      //Hexa
      if (sCnError) sValue = Str_HexToInt (argv [i], strlen (argv [i]));
      //Dcimal
      if (sCnError) sValue = atol (argv [i]);
      
      //Overflow >sizeof (BYTE);
      if (sValue>0xFF) {
        printf ("Error: Number overflow, the maximum size of the data is 0xFF.\n");
        return 4;}
      
      continue;
    }
    
    //***************
    //Program de test
    //***************
    else if (!strcmp (argv [i], "-1"))
      RunProgram = 1;
    else if (!strcmp (argv [i], "-2"))
      RunProgram = 2;
    else if (!strcmp (argv [i], "-3"))
      RunProgram = 3;
    else if (!strcmp (argv [i], "-4"))
      RunProgram = 4;
        
    //Argument incorrect
    else 
    {
      printf ("Error: Incorrect argument.\n");
      return 5;
    } 
  }
  
  //Registre
  printf ("Register set: ");
  if (SET_LPT==LPT1 || SET_LPT==LPT2) printf ("DATA REGISTER");
  else if (SET_LPT==LPT1+2 || SET_LPT==LPT2+2) printf ("CONTROL REGISTER");
  else printf ("UNKNWON REGISTER");
  
  printf (" ON THE ");
  
  //Port  
  if (SET_LPT>=LPT1 && SET_LPT<=LPT1+2) printf ("LPT1.\n");
  else if (SET_LPT>=LPT2 && SET_LPT<=LPT2+2) printf ("LPT2.\n");
  else printf ("UNKNOWN PORT.\n");
  
  //Infos
  printf ("Port Address: 0h%s\n", Str_IntToHex (SET_LPT, buffer));
  printf ("Port data: 0b%s\n", Str_IntToBin (sValue, buffer));
  
  
  //==============================
  //ECRITURE SUR LE PORT PARALLELE
  //==============================
  
  //Initialisation de la librairie WinI/O
  bResult = InitializeWinIo();
  if (!bResult) {
    printf ("Error during initialization of WinIo.\n");
    return 0;}            
  
  //Ecriture donnes
  if (RunProgram==1) Program1();
  else if (RunProgram==2) Program2();
  else if (RunProgram==3) Program3();
  else if (RunProgram==4) Program4();
  else
    PortWrite (SET_LPT, sValue); 
     
  //Fermeture de la librairie WinI/O                                               
  ShutdownWinIo();
    
  //system("PAUSE");	
  return 0;
}


//Programme n1
void Program1 (void)
{
  unsigned char value = 0;
  unsigned long tempo;
  
  printf ("Appuyez sur une touche pour quitter.\n");
 
  PortWrite (SET_LPT, 0x00);
  while (!kbhit ())
  {
    if (tempo++>0x5555)
    {
      PortWrite (SET_LPT, ++value);
      tempo = 0;
    }
  } 
}

//Programme n2
void Program2 (void)
{
  unsigned char value = 0;
  unsigned long tempo;
  char sens = 1;
  
  printf ("Appuyez sur une touche pour quitter.\n");
 
  PortWrite (SET_LPT, 0x00);
  while (!kbhit ())
  {
    if (tempo++>0x5555)
    {
      PortWrite (SET_LPT, 1<<(value += sens));
      
      if (value==0 || value==7) sens *= -1;
      tempo = 0;
    }
  } 
}

//Programme n3
void Program3 (void)
{
  unsigned char value = 0;
  unsigned long tempo;
  char sens = 1;
  
  printf ("Appuyez sur une touche pour quitter.\n");
 
  PortWrite (SET_LPT, 0x00);
  while (!kbhit ())
  {
    if (tempo++>0x5555)
    {
      value += sens;
      PortWrite (SET_LPT, (1<<value)|(1<<(7-value)));
      
      if (value==0 || value==3) sens *= -1;
      tempo = 0;
    }
  } 
}

//Programme n4
void Program4 (void)
{
  unsigned long tempo;
  unsigned char TriggerLEDs;
  
  printf ("Appuyez sur une touche pour quitter.\n");
 
  PortWrite (SET_LPT, 0x00);
  while (!kbhit ())
  {
    if (tempo++>0x5555)
    {
      PortWrite (SET_LPT, TriggerLEDs = ~TriggerLEDs);
      tempo = 0;
    }
  } 
}
