;/////////////////////////////////////////////////////////
;=========================================================
;       XETRION ASSEMBLY SOURCE CODE
;	LAUNCHER
;
;       (c) NeXO Sofware, Benoit SCHERRER
;       mail : benoitscherrer@gmail.com
;
;=========================================================
;/////////////////////////////////////////////////////////


	include "tios.h"
	include "RomCalls.h"


	xdef	_main
	xdef	_comment

	xdef	_ti92plus
	xdef	_ti89
	xdef	_v200
	xdef	_ti89ti
	


FEEDBACK_EXIT	equ	0
FEEDBACK_EXEC	equ	1

_main:
	lea	PctLauncherComm(PC),a0	
	clr.w	(a0)

\runpct
	;------------------------------------------------
	; Be sure to clear busy in status bar
	;------------------------------------------------
	clr.w	-(a7)
	jsr	tios::ST_busy
	addq.l	#2,a7

	;------------------------------------------------
	; Run PCTools
	;------------------------------------------------
	lea	PctLauncherComm(PC),a0	; Data where pct will write
	move.b	#1,-(a7)		; Requires version 1
	clr.w	-(a7)			; Function 0 = launch PCTools
	pea	pctprgm_str(Pc)		; name
	jsr	kernel::LibsExec	; Execute the library
	tst.l	(a7)			; Test if the kernel has called the library
	addq.l	#8,a7
	beq.s	\error

	;------------------------------------------------
	; Check PCTFeedBack to see what to do
	;------------------------------------------------
	lea	PctLauncherComm(PC),a0

	;------------------------------------------------
	; Exit PCTools
	;------------------------------------------------
	tst.w	(a0)
	beq.s	\exit

	;------------------------------------------------
	; Run a program and clean result
	;------------------------------------------------
	lea	8(a0),a0
	move.l	a0,-(a7)		;addr of command line in struct
	bsr	RunProgram
	addq.l	#4,a7
	move.w	d0,-(a7)		;HRESULT from RunProg
	beq.s	\nodel
	jsr	tios::HeapFree
\nodel	addq.l	#2,a7

	;------------------------------------------------
	; Reload PCTools
	;------------------------------------------------
	bra	\runpct



	;------------------------------------------------
	; Exit launcher:
	;------------------------------------------------
\exit
	rts

\error	bra.s	\exit



;------------------------------------------------------------------------
; Procedure : HRESULT RunProg ( char *ProgName )
;
; > run a program as if it were launch from the HOME
;
; (c) From APILib, Benoit SCHERRER, Ibrahim
;------------------------------------------------------------------------
SF_errNo	equ	-64
SF_errOffset	equ	-62
SF_hTokenized	equ	-66
SF_ErrFrame	equ	-60

RunProgram:
;#ifdef TIPLUS
	link.w 		a6,#-68
	movem.l		d2-d7/a0-a6,-(a7)


	move.l		tios::top_estack,d6		;save estack
	clr.w		d4				;HRESULT
	clr.w		d3				;errCode


	;-----------------------------------------
	; Get current folder in a stack frame
	; in order to set it as current folder
	;-----------------------------------------
	suba.w		#20,a7				;create stack frame
	move.l		a7,a3				;its address

	clr.b		(a3)+				;TIOS string
	move.l		a3,-(a7)
	jsr		tios::FolderGetCur
	addq.l		#4,a7

	;-----------------------------------------
	; Construct folder to set
	;-----------------------------------------
	lea		9(a3),a1
	clr.b		(a1)+				;TIOS string
	move.l		8(a6),a0
\folder	move.b		(a0)+,d0
	beq.s		\exfolder
	cmp.b		#'\',d0
	beq.s		\exfolder
	move.b		d0,(a1)+
	bra.s		\folder
\exfolder clr.b		(a1)

	;-----------------------------------------
	; Set current folder
	;-----------------------------------------
	clr.l		-(a7)
	move.l		a1,-(a7)			;point to end of string
	jsr		tios::FolderCur
	addq.l		#8,a7


	;-----------------------------------------
	; Create a hProgram
	;-----------------------------------------
	move.l		#80,-(a7)			;Alloc heap
	jsr		tios::HeapAlloc
	addq.l		#4,a7
	move.w		d0,d7				;save handle 
	beq		\end

	bsr		DEREFd0a0			;Copy file name
	move.l		8(a6),a1
\cpy	move.b		(a1)+,(a0)+
	bne.s		\cpy

	;-----------------------------------------
	; Install error catcher
	;-----------------------------------------
	pea 		SF_ErrFrame(a6)			;create stack frame
	jsr		tios::ER_catch
	addq.l 		#4,a7
	tst.w 		d0
	bne 		\catch_error

	;-----------------------------------------
	; Execute program
	;-----------------------------------------
	jsr		tios::OSDisableBreak

	pea		SF_errOffset(a6)		;errOffset
	pea		SF_errNo(a6)			;errNo
	move.w		d7,-(a7)			;Handle
	jsr		tios::NG_tokenize
	lea		10(a7),a7
	cmp.w		#1,d0
	bne		\ex2

	jsr		tios::HS_popEStack
	move.w		d0,SF_hTokenized(a6)		;save it
	clr.w		-(a7)				;NG_DONT_APPROXIMATE
	move.w 		d0,-(a7)			;Handle
	jsr		tios::NG_execute
	addq.l		#4,a7

	;-----------------------------------------
	; Get HRESULT if needed
	;-----------------------------------------
	move.l		tios::top_estack,d0
	cmp.l		d0,d6
	beq.s		\skip
	jsr		tios::HS_popEStack
	move.w		d0,d4				;HRESULT
\skip	jsr		tios::ER_success
	clr.w		d3				;errCode=no error
	bra.s		\exit

	;-----------------------------------------
	; Go here if an error occured
	;-----------------------------------------
\catch_error
	clr.w 		-(a7)
	move.w 		d0,-(a7)
	move.w		d0,d3
	jsr		tios::ERD_dialog
	addq.l 		#4,a7

	;-----------------------------------------
	; Exit function => free memory
	;-----------------------------------------
\exit	pea		SF_hTokenized(a6)
	jsr		tios::HeapFreeIndir
	addq.l		#4,a7
\ex2	move.w		d7,-(a7)
	jsr		tios::HeapUnlock
	jsr		tios::HeapFree
	addq.l		#2,a7
	jsr		tios::OSEnableBreak

	move.l 		d6,tios::top_estack		;restore estack

	jsr		tios::reset_control_flags
	jsr		tios::cmd_disphome
	clr.L		d0
	trap		#1
	jsr		tios::GKeyFlush

\end
	;-----------------------------------------
	; Set current folder
	;-----------------------------------------
	clr.l		-(a7)				;FALSE
\eos	tst.b		(a3)+				;Get end of string
	bne.s		\eos
	subq.l		#1,a3
	move.l		a3,-(a7)			;push it
	jsr		tios::FolderCur
	addq.l		#8,a7

	adda.w		#20,a7				;delete stack frame

	;-----------------------------------------
	; Free kb buffer if needed
	;-----------------------------------------
\wk	tst.w	KEY_PRESSED_FLAG	; has a key been pressed ?
	beq	\nokey			; no..
	jsr	tios::ngetchx		; yes : get the key code
	bra.s	\wk
\nokey

	;-----------------------------------------
	; Exit, returning HRESULT, errCode
	;-----------------------------------------
	move.w		d4,d0				;HRESULT
	move.w		d3,d1				;errCode
	movem.l		(a7)+,d2-d7/a0-a6
	unlk 		a6
;#endif
	rts


DEREFd0a0:
	lsl.w	#2,d0
        move.l	tios::Heap,a0
	move.l	0(a0,d0.w),a0
        lsr.w   #2,d0                   ;restore hdl
        rts




PctLauncherComm:
	dc.w	0		;ActionID
				; FEEDBACK_EXIT = Exit PCTools
				; FEEDBACK_EXEC = Run a program
	dc.w	0		;Handle of program to execute
	dc.w	0		;0 if not extracted, else hdl of real file
	dc.b	0		;Flags:
				;0000000x : Hide program after execution
				;000000x0 : Delete handle after execution
	dc.b	0		;Not used
	dcb.b	18,0		;name of program to execute if FEEDBACK_EXEC

pctprgm_str	dc.b "pctprgm",0

_comment:	dc.b "PCTools File Manager"

	END



