/*
Copyright (c) 2003-2004, Richard Dillingham
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include "shared.hpp"

int mode;

FILE *orig;
FILE *final;

char tempString[tempStringMaxLength];	//not used: unsigned char *u_tempString=(unsigned char *) tempString;
char tempString2[tempStringMaxLength];
char folderName[folderNameMaxLength];

#ifndef WINDOWS
	void MessageBox(char *a, char *str, char *title, int b) {
		printf("%s\n",str);
	}
#endif


int ReadLine(FILE *inFile, char *string, int max) {
	//Reads a line of text from a text file:
	int nextByte = fgetc(inFile);
	int pos = 0;
	while (nextByte=='\n' || nextByte=='\r') {
		nextByte = fgetc(inFile);
	}

	//Loop until we reach a new-line character:
	while (nextByte!='\n' && nextByte!='\r' && pos<max) {
		//Check for end of file:
		if (nextByte==EOF) {
			string[pos]='\0';
			return 0;
		}
		string[pos++]=(char)nextByte;
		nextByte = fgetc(inFile);
	}

	string[pos]='\0';
	return 1;
}

/*
Return values:
	-1 - Fatal error!
	0 - Everything worked
	1 - We ignored this file, because it has a matching .89p program file.
	2 - We ignored this file, and it was because of filename length.
*/

//This assumes that folderName is no more than 8 characters long. (That's checked by the code calling this)
//When this is called, we should be in the folder already. (HandleFile('people','bob.txt') would be called after we have gone into the people folder.)
int HandleTxtFile(char * folderName, char* fileName) {
	//First, see if there's a .89p file with the same name
	
	//Copy the filename to tempString and tempString2.
	sprintf(tempString, "%s",fileName);
	strcpy(tempString2, tempString);
	
	//Replace the .txt extension with .89p in tempString2.
	char *extension=strrchr(tempString2,'.');
	strcpy(extension,".89p");
	//Try to open the .89p filename to see if it exists.
	FILE* pfile=fopen(tempString2,"rt");
	if (pfile!=NULL) {
		fclose(pfile);
		return 1;			//we don't convert files back to .89p
	}
	
	/*
	Okay, if we got this far, there is no .89p with the same filename as our source .txt.
	tempString contains foldername/filename.txt still and is read from later.
	tempString2 is reuseable, its current value won't be used after this point.
	*/
	
	orig=fopen(tempString, "rt");
	if (orig==NULL) {
		sprintf(tempString2, "Unable to open '%s' for reading.",tempString);
		MessageBox(NULL, tempString2,"Error!",MB_OK);
		return -1;
	}
	//erase the extension on the filename, including the '.' (In preparation for writing the filename to the output .89t file)
	extension=strrchr(tempString,'.');
	*extension=0;
	
	//Check the length of the filename sans extension to make sure it's legal for the TI-89.
	if (strlen(tempString)>8) {	//skip files whose names are > 8 characters long, as those could not have been made by ToTxt, and I'd rather not truncate long filenames, for now. May change my mind later.
		sprintf(tempString2,"The file name '%s' (%s without the extension) in '%s' is > 8 letters long. Perhaps you want to shorten it for the TI-89? I'm ignoring it for now.",fileName, tempString, folderName);
		MessageBox(NULL, tempString2,"FromTxt is complaining!",MB_OK);
		fclose(orig);
		return 2;
	}
	
	//Write the output filename ("../people/bob.89t" to continue our previous example) to tempString2.
	sprintf(tempString2, "../%s.%s.89t", folderName, tempString);
	
	final=fopen(tempString2, "wb");
	if (final==NULL) {
		fclose(orig);
		sprintf(tempString, "You don't have write permissions to this folder, or something has locked %s, or something. I was unable to open that file for writing. Program ending.",(tempString2+3));	//don't show the ../ part of the filename
		MessageBox(NULL, tempString, "Error!", MB_OK);
		return -1;
	}
	
	//Write stuff out... See 89tformat.txt for file format info.
	fprintf(final,"%s","**TI89**");	//**TI92** is also valid, and is what the old TI-89 graph-link software writes.
	fputc(0x01,final);
	fputc(0x00,final);
	
	//Write the folder name, and follow it with however many nulls is needed to fill 8 characters, if any.
	int slen=strlen(folderName);
	for (int a=0; a<slen; a++) {
		fputc(folderName[a],final);
	}
	for (int a=slen; a<8; a++) {	//write nulls to fill it up to 8 characters, if needed
		fputc(0,final);
	}
	
	sprintf(tempString2,"Text file converted by FromTxt");	//We only have 40 characters to play with. :(
	slen=strlen(tempString2);
	
	if (slen>41) {	//Just in case...
		tempString2[41]=0;	//If we put the null at 41, only the first 40 characters will be written.
	}
	
	fprintf(final,"%s",tempString2);
	for (int a=slen; a<40; a++) {	//buffer it with nulls
		fputc(0,final);
	}
	
	//Stuff that never changes 'cause there's only one variable in this .89t file
	fputc(0x01, final); fputc(0x00, final);
	fputc(0x52, final); fputc(0x00, final); fputc(0x00, final); fputc(0x00, final);
	
	//tempString still holds the filename sans extension.	
	slen=strlen(tempString);
	//We did check the length earlier to make sure it wasn't > 8, so we don't need to check it again
	for (int a=0; a<slen; a++) {
		fputc(tempString[a],final);
	}
	for (int a=slen; a<8; a++) {	//write nulls to fill it up to 8 characters, if needed
		fputc(0,final);
	}
	
	fputc(0x0b, final);	//File type
	fputc(0x00, final);	//0x00 normal, 0x01 readonly?, 0x02 archived
	fputc(0x00, final); //0xFF on TI-92
	fputc(0x00, final);
	
	int blank=0;
	
	//This is where the total file size gets written. We'll return to this point in the file later to write it.
	fwrite(&blank, 4, 1, final);
	
	fputc(0xa5, final); fputc(0x5a, final);
	int checksum=0;
	fputc(0x00, final); fputc(0x00, final); fputc(0x00, final); fputc(0x00, final);
	fwrite(&blank, 2, 1, final); //We'll come back here later, after we know the total text size. (Here is 0x56 from the start of the file)
	
	fputc(0x00, final); fputc(0x01, final);	//I've seen all sorts of stuff where we have 00 01, but 00 01 is most common, and I didn't find any rational pattern, although it sometimes seems related to the file size. The 0x20 is always there, though. I've tried always writing 00 01 and haven't seen any problems so far, so we'll keep doing that for now.
	checksum+=0x01;
	
	//write text
	int lineStart=2;
	
	while (1) {
		int c=fgetc(orig);
		if (c==-1) {
			break;
		} else if (lineStart==2 && c==0x0c) {
			fputc(0xc, final);
			checksum+=0xc;
			lineStart=1;
		} else if (lineStart==2 && c==0x0e) {
			fputc(0x43, final);
			checksum+=0x43;
			lineStart=1;
		} else if (lineStart==2 && c==0x0f) {
			fputc(0x50, final);
			checksum+=0x50;
			lineStart=1;
		} else if (c==9) {	//tab - I wonder if the TI-89 can handle tab characters... In any event, ToTxt does make them from leading spaces, and so it's no problem if that's where they occur. If they were after some text or something, though, they'd get changed to a space here and not changed back by ToTxt later, which might be annoying to some people. I would hope they would complain, if that's the case, though. Or modify the code to their liking, if they knew how (Ain't open-source great?).
			if (lineStart==2) {
				fputc(0x20, final);	//Line type.
				checksum+=0x20;
				lineStart=1;
			}
			if (lineStart==1) {
				fputc(0x20, final);
				checksum+=0x20;
			} else {
				fputc(0x09, final);
				checksum+=0x09;
			}
		} else if (c=='\n') {
			if (lineStart==2) {
				fputc(0x20, final);	//Line type.
				checksum+=0x20;
			}
			fputc(0x0d, final); //You know, I really have no idea whether \n is 0x0a or 0x0d, but the TI-89 always wants 0x0d, so... :P
			
			checksum+=0x0d;
			lineStart=2;
		} else {
			if (lineStart==2) {
				fputc(0x20, final);	//Line type.
				checksum+=0x20;
			}
			//We aren't going to bother to change back all the things ToTxt does. The readme says what symbols ToTxt changes to what text, by the way.
			fputc(c, final);
			checksum+=c;
			lineStart=0;
		}
	}
	
	fputc(0x00, final); fputc(0xE0, final);
	checksum+=0xE0;
	
	//write blank where checksum goes
	int checksumPos=ftell(final);
	fwrite(&blank, 2, 1, final);
	
	int filesize=ftell(final);
	fseek(final, 0x4c, SEEK_SET);
	//fwrite(&filesize, 4, 1, final);
	fputc(filesize&0xff, final);
	fputc((filesize>>8)&0xff, final);
	fputc((filesize>>16)&0xff, final);
	fputc((filesize>>24)&0xff, final);
	
	
	int textsize=filesize-0x5a;		//this should give the correct result
	fseek(final, 0x56, SEEK_SET);
	fputc((textsize>>8)&0xff, final);
	fputc((textsize)&0xff, final);
	
	checksum+=(textsize&0xff)+((textsize>>8)&0xff);
	
	//write checksum
	fseek(final, checksumPos, SEEK_SET);
	fputc(checksum&0xff, final);
	fputc((checksum>>8)&0xff, final);
	
	//It seems that we can write the upper two bytes too, and the TI-89 doesn't complain. Heh. But it may not be healthy still, so we won't (I did try it, though, just to see).
	//fputc((checksum>>16)&0xff, final);
	//fputc((checksum>>24)&0xff, final);
	
	fclose(final);
	fclose(orig);
	return 0;
}

/*
Return values:
	-1 - Fatal error!
	0 - Everything worked
*/

int HandleSrcFile(char* filename) {
	orig=fopen(filename, "rb");
	if (orig==NULL) {
		sprintf(tempString2, "Unable to open '%s' for reading.",filename);
		MessageBox(NULL, tempString2,"Error!",MB_OK);
		return -1;
	}
	int pos=0;
	fseek(orig, 0xa, SEEK_SET);
	int c=0;
	int a=0;
	int cont=1;
	while (cont) {
		c=fgetc(orig);
		if (c>-1) {
			folderName[a]=c;
			a++;
			if (c==0) {
				cont=0;
			}
		} else {
			cont=0;
		}
		if (a==8) {
			//sprintf(tempString, "Folder name in %s is more than 8 characters in length.", filename);
			//MessageBox(NULL, tempString, "Error!", MB_OK);
			//cont=0;
			cont=0;
		}
	}
	#ifdef WINDOWS
		struct _finddata_t file;
		long hFile;
	#else
		struct dirent file;
	#endif


	#ifdef WINDOWS
		if( (hFile = _findfirst( folderName, &file )) == -1L ) {
	#else
		DIR *dirdata=opendir(folderName);
		if (dirdata!=NULL) {
			closedir(dirdata);
		} else {
	#endif
		strcpy(tempString,"mkdir ");
		strcpy(tempString+strlen(tempString),folderName);
		system(tempString);
	}
	strcpy(tempString, folderName);
	strcpy(tempString+strlen(tempString),PATHSTR);
	
	//Determine whether it was created by 'Ti Connect' and has the folder name in the filename
	char* firstdotpos=strchr(filename,'.');
	char* lastdotpos=strrchr(filename,'.');
	char filetype='0';
	if (firstdotpos==NULL || lastdotpos==NULL) {
		//missing .89t, this should not be possible
		MessageBox(NULL, "Fatal error: Filename missing extension.", "Error!", MB_OK);
		fclose(orig);
		return -1;
	} else if (firstdotpos==lastdotpos) {	//just the filename.89?
		strcpy(tempString+strlen(tempString),filename);
		filetype=filename[strlen(filename)-1];
	} else {	//folder.filename.89? - strip out the folder name
		strcpy(tempString+strlen(tempString),firstdotpos+1);
		filetype=filename[strlen(filename)-1];
	}

	strcpy(tempString+strlen(tempString)-3,"txt");
	final=fopen(tempString, "wt");
	if (final==NULL) {
		fclose(orig);
		sprintf(tempString, "You don't have write permissions to this folder, or something has locked %s, or something. I was unable to open that file for writing. Program ending.",(tempString));
		MessageBox(NULL, tempString, "Error!", MB_OK);
		return -1;
	}
	fseek(orig, 0x5a, SEEK_SET);
	int start=1;	//start would be 2 if we weren't jumping past the first 'start--' statement initially.
	int wasNL=2;
	int startOverride=1;
	while (1) {
		start--;
		int c=fgetc(orig);
		notspace:
		if (c==-1) {
			break;
		} else if (c==0x0d || startOverride) {
			if (startOverride) {	//we need to run this code on the character at 0x5a, but there's no preceding 0x0d.
				startOverride=0;
			} else {
				c=fgetc(orig); //line type
				fputc('\n',final);
			}
			if (c==0x20) {
				wasNL=1;
				continue;
			} else if (c==0x43) {
				fputc(0x0e,final);
				wasNL=1;
				continue;
			} else if (c==0x50) {
				fputc(0x0f,final);
				wasNL=1;
				continue;
			} else {
				wasNL=1;
				goto notspace;
			}
		} else if (c==0) {
			if (start) {
				//There's a 0 at 0x5b - Happens for blank programs (lacking Prgm and EndPrgm), and for tokenized ones.
				//get length
				fseek(orig, 0, SEEK_END);
				long filelen=ftell(orig);
				if (filetype=='p') {
					if (filelen<=103) {
						//empty 89p
						fprintf(final, "This program file appears to be empty!");
					} else {
						fprintf(final, "This program file is tokenized. We can't translate tokenized files. If you want this program file translated, please open it in the TI-89 program editor (to untokenize it), and copy it to the computer & try converting it again. (Programs are tokenized when they are run, and untokenized if they're opened in the program editor).\n");
					}
				}
			}
			//eof
			break;
		} else if (wasNL) {
			if (c==0x20) {
				fputc('\t',final);
				continue;
			} else {
				wasNL=0;
			}
		}
			
		if (c==0xad) {	//other -
			fputc(0x2d,final);
		} else if (c==0x8c) {	//PI
			fputc('P',final);
			fputc('I',final);
		} else if (c==0x9d) {	//"Not equals to" (Diamond-equals)
			fputc('!',final);
			fputc('=',final);
		} else if (c==0x16) {	//->
			fputc('-',final);
			fputc('>',final);
		} else if (c==0x9c) {	//<=
			fputc('<',final);
			fputc('=',final);
		} else if (c==0x9e) {	//>=
			fputc('>',final);
			fputc('=',final);
		} else if (c==0xa8) {	//square root
			fputc('s',final);
			fputc('q',final);
			fputc('r',final);
			fputc('t',final);
		} else {
			fputc(c,final);
		}
	}
	fclose(final);
	fclose(orig);
	return 0;
}
