# Copyright (c) 2003-2004, Richard Dillingham
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# 

from __future__ import division
import os, sys, os.path, string, re, os.path
import time

rootDir=os.getcwd()
		
class FilePair:
	def __init__(self):
		self.txtf=None	#"foo"
		self.txt=None	#"bar"
		self.src=None	#"foo.bar.89t"
	def found89t(self,filename):
		if (self.txtf!=None):
			if (filename==self.txtf+'.'+self.txt+'.89t'):
				self.src=filename
				return 1
		elif (self.src==None):
			self.src=filename
			return 2
		return 0
	def foundTxt(self,folder,fnse):
		if (self.src!=None):
			if (self.src==folder.lower()+'.'+fnse.lower()+'.89t'):
				self.txtf=folder.lower()
				self.txt=fnse.lower()
				return 1
		elif (self.txt==None):
			self.txtf=folder
			self.txt=fnse
			return 2
		return 0
	def handle(self, file, lastTime):
		#compare dates
		if (self.src!=None):
			if (self.txt==None):
				file.write('s'+self.src+'\n')
			else:
				txtStat=os.stat(os.path.join(self.txtf,self.txt+'.txt'))
				srcStat=os.stat(self.src)
				txtTime=txtStat.st_mtime
				srcTime=srcStat.st_mtime
				if (lastTime==None or txtTime>lastTime or srcTime>lastTime):
					if (txtTime>srcTime):
						file.write('t'+self.txtf+'/'+self.txt+'.txt\n')
					elif (srcTime>txtTime):
						file.write('s'+self.src+'\n')
				#else, time is the same
		else:
			if (self.txt==None):
				print "Error: handle() called on a FilePair with no files known."
			else:
				file.write('t'+self.txtf+'/'+self.txt+'.txt\n')
		
		
		
def main():
	uc=UpdateClass()
	
class UpdateClass:
	def __init__(self):
		self.known=[]
		self.checkAll()
		
	def checkAll(self):
		try:
			self.filesStat=os.stat('files.lst')
			self.filesTime=self.filesStat.st_mtime
		except OSError:
			self.filesTime=None
		self.file=open('files.lst','wb')
		self.check(".")
		for k in self.known:
			k.handle(self.file,self.filesTime)
		self.file.close()
		os.system('sync89t')
		
	def check(self,folder):
		files=os.listdir(".")
		#print "Checing folder "+folder
		for file in files:
			#print "Checking file "+file
			if os.path.isdir(file):
				os.chdir(file)
				self.check(file)
				os.chdir('..')
			elif file[-4:]=='.89t':
				self.note89t(os.getcwd(),file)
			elif file[-4:]=='.txt':
				self.noteTxt(os.getcwd(),file)
	
	def note89t(self,folder,file):
		#89t files should be in the base folder
		if (folder!=rootDir):
			print "Warning: Found 89t file '"+file+"' in '"+folder+"', which is not the folder this was run from ('"+rootDir+"'). Ignoring it."
		else:
			for k in self.known:
				if (k.found89t(file)==1):
					return
			fp = FilePair()
			if (fp.found89t(file)==2):
				self.known.append(fp)
			else:
				print "ERROR! fp.foundTxt failed!"
		
	
	def noteTxt(self,folder,file):
		#txt files should be in a subfolder
		subFolder=getSubfolder(folder)
		if (subFolder==None):
			print "Warning: Found txt file '"+file+"' in '"+folder+"', which is not a subfolder of ('"+rootDir+"'). Ignoring it."
		else:
			filenameSansExtension=getFilenameSansExtension(file)
			for k in self.known:
				if (k.foundTxt(subFolder,filenameSansExtension)==1):
					return
			fp = FilePair()
			if (fp.foundTxt(subFolder,filenameSansExtension)==2):
				self.known.append(fp)
			else:
				print "ERROR! fp.foundTxt failed!"
		
def getSubfolder(folder):
	if (folder.lower().find(rootDir.lower())==0):
		if (len(folder)==len(rootDir)):
			return None
		return folder[len(rootDir)+1:]
	return None

def getFilenameSansExtension(file):
	pos=file.lower().find('.')
	if (pos==-1):
		return None
	else:
		return file[:pos]

if __name__ == '__main__': main()
