// C Header File
// Created 06/06/02; 14:41:59




#ifndef _GLOBAL_DECLARATIONS_
#define _GLOBAL_DECLARATIONS_




#define VERSION                "4.0"
#define DATE_COMPIL            "11/11/07"
#define COPYRIGHT              "2001-2007"
#define REQ_DATAFILE_VERSION   4

#define IMBRICATION_MAX        1  // 1 niveau de profondeur au maximum... si un jour TI nous invente les sous-rpertoires on mettra plus :)




#define OPTIMIZE_ROM_CALLS    // Use ROM Call Optimization
#define EXECUTE_IN_GHOST_SPACE



#ifdef __GTC__
  #include "GTC_files\PLATEFORME_C.h"
  #include "common_files\data_table.h"
#else
  #include "PLATEFORME_C.h"
  #include "data_table.h"
#endif

#include <tigcclib.h>         // Include All Header Files




#define PASSER_SUR_LA_PILE  __attribute__((__stkparm__))




#define H_INCHANGE 0xFFFF


#define getch()\
          ngetchx()

#define GrayPutSprite16(X, Y, SPRITE)\
        {\
          MonPutSprite16_MX(GetPlane(DARK_PLANE), (SPRITE), X, Y);\
          MonPutSprite16_MX(GetPlane(LIGHT_PLANE), (char *)(SPRITE)+16*2, X, Y);\
        }

#define GrayPutSprite32(X, Y, SPRITE)\
        {\
          MonPutSprite32_ER(GetPlane(DARK_PLANE), (SPRITE), X, Y);\
          MonPutSprite32_ER(GetPlane(LIGHT_PLANE), (char *)(SPRITE)+32*4, X, Y);\
        }


#ifdef POUR_TI89
  #define ECHAPpresse\
            (f_rowread(~0b1000000) & 0b00000001)

  #define F1presse\
            (f_rowread(~0b0100000) & 0b10000000)

  #define F2presse\
            (f_rowread(~0b0010000) & 0b10000000)

  #define F3presse\
            (f_rowread(~0b0001000) & 0b10000000)

  #define ALPHApresse\
            (f_rowread(~0b0000001) & 0b10000000)

  #define DIAMONDpresse\
            (f_rowread(~0b0000001) & 0b01000000)

  #define SHIFTpresse\
            (f_rowread(~0b0000001) & 0b00100000)

  #define SECONDpresse\
            ((f_rowread(~0b0000001) & 0b00010000) || (f_rowread(~0b0000010) & 0b00000001))

  #define CLEARpresse\
            ((f_rowread(~0b0000010) | f_rowread(~0b0000100)) & 0b01000000)

  #define RIGHTpresse\
            (f_rowread(~0b0000001) & 0b00001000)

  #define DOWNpresse\
            (f_rowread(~0b0000001) & 0b00000100)

  #define LEFTpresse\
            (f_rowread(~0b0000001) & 0b00000010)

  #define UPpresse\
            (f_rowread(~0b0000001) & 0b00000001)

  #define PLUSpresse\
            (f_rowread(~0b0000010) & 0b00000010)

  #define MINUSpresse\
            (f_rowread(~0b0000010) & 0b00000100)
#else
  #define ECHAPpresse\
            (f_rowread(~0b0100000000) & 0b01000000)

  #define F1presse\
            (f_rowread(~0b0001000000) & 0b00010000)

  #define F2presse\
            (f_rowread(~0b0000010000) & 0b00010000)

  #define F3presse\
            (f_rowread(~0b0000000100) & 0b00010000)

  #define ALPHApresse /* [ON] */ \
            ((*(volatile char *)0x60001A & 0b00000010) ^ 0b00000010)

  #define DIAMONDpresse\
            (f_rowread(~0b0000000001) & 0b00000010)

  #define SHIFTpresse\
            (f_rowread(~0b0000000001) & 0b00000100)

  #define SECONDpresse\
            ((f_rowread(~0b0000000001) & 0b00000001) || (f_rowread(~0b0001000000) & 0b01000000) || (f_rowread(~0b1000000000) & 0b00000010))

  #define CLEARpresse\
            ((f_rowread(~0b0100000000) & 0b00000001) || (f_rowread(~0b0010000000) & 0b00100000))

  #define RIGHTpresse\
            (f_rowread(~0b0000000001) & 0b01000000)

  #define DOWNpresse\
            (f_rowread(~0b0000000001) & 0b10000000)

  #define LEFTpresse\
            (f_rowread(~0b0000000001) & 0b00010000)

  #define UPpresse\
            (f_rowread(~0b0000000001) & 0b00100000)

  #define PLUSpresse\
            (f_rowread(~0b0100000000) & 0b00010000)

  #define MINUSpresse\
            (f_rowread(~0b1000000000) & 0b00000001)
#endif

#define GuetterRelachement(TEST_TOUCHE)\
          ({while (TEST_TOUCHE);})

#define GuetterAppui(TEST_TOUCHE)\
          GuetterRelachement(!(TEST_TOUCHE))


#define GetFileTypePtr(FICHIER_HDL)\
        ({\
          void *Fich= HeapDeref(FICHIER_HDL);\
          &((unsigned char *)Fich)[*(unsigned short *)Fich+1];\
        })


#define Affichable(fichierSE)\
        (!(fichierSE).flags.bits.hidden && (fichierSE).name[0] != '0' && !(fichierSE).flags.bits.local)


#define ElementSEptr_2_Off(FatVatHdl, ElementSEptr)\
        ((unsigned long)((char *)(ElementSEptr) - (char *)HeapDeref(FatVatHdl)))

#define ElementSEptr_2_Ind(FatVatHdl, ElementSEptr)\
        ((short)((ElementSEptr) - ((tFatVat *)HeapDeref(FatVatHdl))->elements))

#define ElementInd_2_SEptr(FatVatPtr, ElementInd)\
        (&((FatVatPtr)->elements[ElementInd]))

#define ElementOff_2_SEptr(FatVatHdl, ElementOff)\
        ((SYM_ENTRY *)((unsigned long)(ElementOff) + HeapDeref(FatVatHdl)))

#define ElementCrd_2_SEptr(x, y)\
        ElementInd_2_SEptr((tFatVat *)HeapDeref(FatVatTriee->FatVatHdl), FatVatTriee->elements[y][x].index)

#define ElementHdl_2_Ind(FatVatHdl, ElementHdl)\
        ElementSEptr_2_Ind(FatVatHdl, ElementHdl_2_SEptr(FatVatHdl, ElementHdl))


#define L64_F1   ((10*4) << 6)
#define L64_F2   ((10*4) << 6)
#define L64_F3   ((9*4) << 6)
#define L64_HR   ((6*4) << 6)
#define ESPACE64 ((((X_MAX+1) << 6) - L64_HR - (L64_F1 + L64_F2 + L64_F3)) / 4)
#define X64_F1   (ESPACE64)
#define X64_F2   (X64_F1 + L64_F1 + ESPACE64)
#define X64_F3   (X64_F2 + L64_F2 + ESPACE64)
#define X_F1     (X64_F1 >> 6)
#define X_F2     (X64_F2 >> 6)
#define X_F3     (X64_F3 >> 6)
#define X_HR     (X_MAX+1 - (L64_HR >> 6))


typedef enum {OUI_NON, OK_ANNULER, OK, ANNULER, OUI_TOUS_NON, ENTER_ANNULER} TypeBoutons;
typedef enum {RIEN, COPIEES, COUPEES} tEtatSelection;

typedef enum {CRB, FLD, NA2, EXE, NA3, PPG, NA4, BAS, NA5, ACF, NA6, TXT, NA7, BMP, NA8, PIC, NA9, DLL, NAA, LIB, NAB, ZIP, NAC, OTH, NAD, EXP} tFileType;
#define NB_TYPES 26

typedef struct {
  tFileType virtual;
  tFileType real;
} tComplexType;


typedef struct {
  unsigned short datasize;
  unsigned short format_version;
  tFileType      original_virtualtype;
  unsigned short original_datasize;
} tACFheader;

typedef struct {
  tACFheader header;
  struct {
    unsigned short occurences[256];
    unsigned char  compressed[];
  } data;
} tACFformat1;

typedef struct {
  tACFheader header;
  struct {
    unsigned char nb_leaf_m1;    // nombre de feuilles que comporte l'arbre, moins 1 (pour pouvoir avoir 256 feuilles sans repasser  0)
    unsigned char compressed[];  // description binaire de l'arbre suivie des codes de Huffman
  } data;
} tACFformat2;


typedef struct
{
  HANDLE FatherHdl;
  HANDLE FatVatHdl;
  HANDLE ElementHdl;
  void  *PrevSelection;
  void  *NextSelection;
} tSelection;

typedef struct
{
  HANDLE FatVatHdl;
  HANDLE ElementHdl;
} tPrepRet;

typedef struct
{
  short     allocated;
  short     used;
  SYM_ENTRY elements[];
} tFatVat;

typedef struct
{
  HANDLE FatherHdl;
  short  index_premiere_ligne; // ordonne de la premire ligne visible
  short  X;                    // abscisse du "curseur"  l'cran et dans la FAT/VAT trie
  short  Yecr;                 // ordonne du "curseur"  l'cran
  short  Yabs;                 // ordonne du "curseur" dans la FAT/VAT trie
  short  x,                    // coordonnes graphiques du nom ...
         y;                    // ... du fichier en surbrillance
} tNiveau;

typedef struct
{
  HANDLE FatherHdl;
  HANDLE FatVatHdl;
  short  used;
  short  nb_lignes;
  short  indexMax_derniere_ligne;
  struct
  {
    short index;  // ATTENTION : modifier la taille de l'allocation dans la fonction GenererListeTriee si modification de la structure
  } elements[][ELEMS_PAR_LIGNE];
} tFatVatTriee;

extern void **volatile DataTable;
extern INT_HANDLER save_int_1, save_int_5, save_int_6, gray_function;


extern void clavier_natif_handler_1;

extern unsigned short PASSER_SUR_LA_PILE f_rowread(short masque);

extern void PASSER_SUR_LA_PILE MonDrawStr(void *plane, short x, short y, const char *string, short reverse);
#define MonDrawChar(plane, x, y, character, reverse) ({static char Buff[2]={0,0}; Buff[0]= (character); MonDrawStr(plane, x, y, Buff, reverse);})

extern void PASSER_SUR_LA_PILE EffacerInterieur(void *plane, short AscenseurEtCadre);
extern void PASSER_SUR_LA_PILE MonPutSprite16_MX(void *Plane, void *Sprt, short X, short Y);
extern void PASSER_SUR_LA_PILE MonPutSprite32_ER(void *Plane, void *Sprt, short X, short Y);

extern          HANDLE        FatVatTrieeHdl;
extern volatile tFatVatTriee *FatVatTriee;
extern          short         AfficherLesElementsCaches;

extern short        GenererListeTriee(HANDLE ToSortHdl, HANDLE FatherHdl);
extern void         DetruireListeTriee(void);
extern tComplexType GetFileType(SYM_ENTRY *fileSE);

extern tNiveau *niveaux;
extern short    profondeur;

extern HANDLE         FolderListHandle;
extern unsigned short AMS_Version;

extern short          NombreSelections;
extern tEtatSelection LesSelectionsSont;
extern tSelection    *FirstSelection;


extern tPrepRet    PreparerOperationSurSelections(void);
extern void        TerminerOperationSurSelections(tPrepRet PreparerOperationSurSelections_retour);
extern short       Selectionner(HANDLE FatherFatVatHdl, HANDLE FileFatVatHdl, HANDLE ElementHdl, short DeselectionnerSiDejaSelectionne);
extern short       Deselectionner(HANDLE FileFatVatHdl, HANDLE ElementHdl);
extern void        ToutDeselectionner(void);
extern tSelection *EstSelectionne(HANDLE FileFatVatHdl, HANDLE ElementHdl);

extern char EINSDATA_INTROUVABLE[];
extern char AUTEUR[], MAIL[], SITE[];

extern SYM_ENTRY *ElementHdl_2_SEptr(HANDLE FatVatHdl, HANDLE ElementHdl);
extern void       Temporiser(short repetitions);
extern void       CheckerCoherenceAffichage(HANDLE FatHdl);
extern void       SePositionnerSurPremierElement(void);
extern short      Descendre(void);
extern short      Monter(void);
extern short      AllerAdroite(void);
extern short      AllerAgauche(void);
extern HANDLE     ChargerAdressesData();
extern char      *UpperCase(char *dst, char *src, short max);

extern void ToutQuitter(const char *Message);
extern void LiberationCompleteAvantFermeture();
extern void RestaurerEtatStandard(void);
extern void RestaurerEcranParent(void);
extern void RevenirEtatEinstein(void);
extern void reactiver_clavier_natif(void);
extern void reactiver_rowread(void);

extern short SuppressionDemandee(void);
extern short SelectAllDemande(void);
extern short OuvertureDemandee(void);
extern short SelectionDemandee(void);
extern short FermetureDemandee(void);
extern short ArchivageDemande(void);
extern short DesarchivageDemande(void);
extern short CollageDemande(void);
extern short DeCompressionDemandee(void);
extern short RenommageDemande(short effacer_nom);
extern short CreationRepertoireDemandee(void);

extern void DessinerFond(void);
extern void AfficherElements(short RedrawAscenseurAndEraseFrame);

extern void PASSER_SUR_LA_PILE scroll4_left(void *plane);
extern void PASSER_SUR_LA_PILE scroll4_right(void *plane);
extern void PASSER_SUR_LA_PILE scroll7_up(void *plane);
extern void PASSER_SUR_LA_PILE scroll7_down(void *plane);
extern void PASSER_SUR_LA_PILE erase4_left(void *plane);
extern void PASSER_SUR_LA_PILE erase_right(void *plane, short howmanycols);
extern void PASSER_SUR_LA_PILE erase7_up(void *plane);
extern void PASSER_SUR_LA_PILE erase_down(void *plane, short howmanylines);

extern void PASSER_SUR_LA_PILE copy_textviewerbuffer_to_plane(void *dst, void *src, short nb_lignes);

extern void  DrawWindow(short largeur, short hauteur, short EspaceEntreLignes, const char *titre, const char *texte, TypeBoutons Boutons);
extern void  WriteInWindow(short largeur, short EspaceEntreLignes, const char *texte);
extern short DrawMenu(short x, const char *items);
extern void  SelectionnerItem(short x, short largeur, short index);

extern void ExecuterMenu_F1(void);
extern void ExecuterMenu_F2(void);
extern void ExecuterMenu_F3(void);

extern short AfficherTexte(HANDLE fichierHdl);
extern void  VisionnerPic(HANDLE handle);
extern short VisionnerBmp(HANDLE handle);

extern HANDLE compresser(HANDLE fichier, tFileType virtual_type);
extern HANDLE decompresser(HANDLE fichier);

extern void PASSER_SUR_LA_PILE WaitForMillis(unsigned short);




#endif

