;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		slctfile.xas
;	Utility>	A composant used to select
;			a file, using nested folders
;
;-----------------------------------------------------------


SLCTFILE_X		equ	0
SLCTFILE_Y		equ	2
SLCTFILE_NBITEMPP	equ	4
SLCTFILE_WIDTH		equ	6
SLCTFILE_HDL		equ	8
SLCTFILE_FLAG		equ	$0A
SLCTFILE_CBFILTER 	equ	$0C
SLCTFILE_CBKEYDOWN	equ	$10
SLCTFILE_CBKEY		equ	$14
SLCTFILE_CBSELECT	equ	$18
SLCTFILE_CBDRAWITEM	equ	$1C

;
;	xxxxxxx1 : If set don't draw the rect
;	xxxxxx1x : If set allow the user to jump from the
;			first item to the last with up
;	xxxx1xxx : if set, use internal images
;	xxx1xxxx : if set, allows pad to naviguate between folders
;out>	d0.w : 	0 if ESC
;		Else handle of selected file		
;	d1.w : Selected File Handle
;------------------------------------------------------------
apilib@0052:
_SelectFileComponent:
	movem.l	d2-d7/a0-a6,-(a7)

	move.l	a0,a6				;Save a0

	clr.l	d7				;HAndle of buffer
	move.w	SLCTFILE_HDL(a6),d0
	bne.s	\Loop
	API92_FOLDHDL d0

\Loop	move.l	SLCTFILE_CBFILTER(a6),a0	;CB function
	move.w	d7,d1				;previous hdl
	move.w	d0,d5				;Save current hdl
	clr.w	d2				;Mode
	bsr	_vat_CreateBuffer
	move.w	d0,d7
	tst.w	d1				;Check if error
	bne.s	\exit

	suba.w	#LV_STRUCTSIZE+4,a7
	move.l	a7,a2
	move.l	a6,(a2)+
	move.l	a2,a3

	move.w	d7,d0
	bsr	DEREFd0a0
	lea	2(a0),a1
	move.w	(a1)+,(a2)+			;NbItem
	move.w	SLCTFILE_NBITEMPP(a6),(a2)+	;NbItemPP
	move.l	(a6),(a2)+			;X,Y
	clr.l	(a2)+				;Reserved
	move.w	SLCTFILE_WIDTH(a6),(a2)+	;Width
	move.w	#VATENTRY_SIZE,(a2)+		;Constant Size
	clr.w	(a2)+				;Height
	move.w	SLCTFILE_FLAG(a6),(a2)+		;Flag
	move.l	SLCTFILE_CBKEYDOWN(a6),(a2)+	;KeyDown
	lea	SlctFile_Key(PC),a4
	move.l	a4,(a2)+			;Key
	move.l	SLCTFILE_CBSELECT(a6),(a2)+	;Select
	lea	SlctFile_DrawItem(PC),a4
	move.l	a4,(a2)+			;DrawItem
	clr.l	(a2)+				;Properties

	move.l	a3,a0
	bsr	_ListViewComponent
	adda.w	#LV_STRUCTSIZE+4,a7
	cmp.w	#4,d0			;if ESC exit
	beq.s	\esc
	cmp.w	#3,d0			;If Back
	bne.s	\noback
\gl	move.w	d1,d0
	bra.s	\Loop
\noback	cmp.w	#2,d0			;If folder
	beq.s	\gl

\exit	bsr	slct_FreeArray
	movem.l	(a7)+,d2-d7/a0-a6
	rts

\error	clr.w	d0
	bra.s	\exit

\esc	clr.w	d0
	bra.s	\exit

;----------------------------------------------------
; Callback function used to draw an item
;----------------------------------------------------
SlctFile_DrawItem:
	move.l	-4(a6),a6
	move.l	SLCTFILE_CBDRAWITEM(a6),a0
	move.l	a0,d7
	beq.s	\nodraw
	movem.l	d0-d6/a0-a6,-(a7)
	jsr	(a0)
	move.w	d0,d7
	movem.l	(a7)+,d0-d6/a0-a6
	tst.w	d7
	beq	\exit

\nodraw	tst.w	d6
	beq.s	\skip
	addq.w	#4,d0

\skip	btst.b	#3,SLCTFILE_FLAG(a6)
	beq	\noimg

	movem.l	d0-d3/a0,-(a7)		;Save a0
	move.w	d0,d3			;save d0=X

	bsr	_GetFont		;Get font
	tst.w	d0			;small ?
	bne.s	\nosmall
	move.w	VATENTRY_HDL(a1),d0
	API92_CMPFOLDHDL d0
	beq.s	\root
	tst.w	d6
	bne.s	\nof1
	lea	smallback_gfx(PC),a0
	API92_CMPFOLDHDL d5
	bne.s	\drawsgfx
\root	lea	smallti_gfx(PC),a0
	bra.s	\drawsgfx
\nof1	lea	smallfolder_gfx(PC),a0
	btst.b	#7,VATENTRY_FLG(a1)
	bne.s	\drawsgfx
	lea	smallfile_gfx(PC),a0
\drawsgfx move.w d3,d0			;restore X
	moveq.w	#4,d2			;5 lines
	bsr	_draw_GFX8xn
	bra.s	\exdraw

\nosmall move.w	VATENTRY_HDL(a1),d0	;Get file hdl
	tst.w	d6			;first item ?
	bne.s	\nof
	lea	backgfx(PC),a0
	API92_CMPFOLDHDL d5
	bne.s	\drawgfx
	lea	tigfx(PC),a0
	bra.s	\drawgfx
\nof	lea	dirgfx(PC),a0
	btst.b	#7,VATENTRY_FLG(a1)
	bne.s	\drawgfx
	bsr	DEREFd0a0
	bsr	_GetFileExt
	bsr	_ExtID_Picture
\drawgfx move.w	d3,d0
	bsr	_draw_GFX8x8
\exdraw	movem.l	(a7)+,d0-d3/a0
	add.w	#9,d0

\noimg	bsr	_draw_StringSpecial

\exit	clr.w	d0
	rts

;----------------------------------------------------
; Callback function used when a key is pressed
;----------------------------------------------------
SlctFile_Key:
	move.l	-4(a6),a6
	move.l	SLCTFILE_CBKEY(a6),a0	;CBKey support ?
	move.l	a0,d7			;
	beq.s	\nocb			;
	move.l	d0,-(a7)		;save d0
	jsr	(a0)			;call CBKey
	move.l	d0,d2			;save return value
	move.l	(a7)+,d0		;restore d0
	cmp.w	#$FFFF,d2
	bne.s	\s1
\s2	move.w	d2,d0
	bra.s	\exit
\s1	tst.w	d2
	bne.s	\s2

\nocb	btst.b	#4,SLCTFILE_FLAG(a6)
	beq.s	\skip

	cmp.w	#PAD_LEFT,d0
	beq.s	\back
	cmp.w	#PAD_RIGHT,d0		;pad right ?
	bne.s	\skip
	btst.b	#7,VATENTRY_FLG(a1)	;Check if folder
	beq.s	\skip
	move.w	VATENTRY_HDL(a1),d1	;Get item hdl
	moveq.w	#2,d0			;d0=2 : Folder d1
	bra.s	\exit

\skip	cmp.w	#13,d0			;Test if ENTER
	bne.s	\noenter
	move.w	d6,d0
	bne.s	\not_first

\back	API92_CMPFOLDHDL d5
	beq.s	\noesc
	move.w	d5,d1			;Check if current folder
	bsr	_nf_IsFolderNested ;is nested
	tst.w	d0			;
	bne.s	\nested
	API92_FOLDHDL d0
\nested	move.w	d0,d1
	moveq.w	#3,d0			;d0=3 : Back with d1
	bra.s	\exit

\not_first
	move.w	VATENTRY_HDL(a1),d1	;Get item hdl
	btst.b	#7,VATENTRY_FLG(a1)	;Check if folder
	beq.s	\file
	moveq.w	#2,d0			;d0=2 : Folder d1
	bra.s	\exit
\file	moveq.w	#1,d0			;d0=1 : File
	bra.s	\exit


\noenter cmp.w	#264,d0
	bne.s	\noesc
	moveq.w	#4,d0			;d0=4 : ESC
	bra.s	\exit

\noesc	clr.w	d0
\exit	rts

slct_FreeArray:
	tst.w	d7				;Delete previous buffer
	beq.s	\exit				;if needed
	movem.l	d0-d2/a0-a1,-(a7)
	move.w	d7,-(a7)
	TIOS_CALL HeapFree
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a1
\exit	rts

_HeapLock:
;#ifdef TIPLUS
	movem.l	d0-d2/a0-a2,-(a7)		;Lock it
	move.w	d0,-(a7)
	TIOS_CALL HeapLock
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a2
;#endif
	rts

_HeapUnlock
;#ifdef TIPLUS
	movem.l	d0-d2/a0-a2,-(a7)		;Lock it
	move.w	d0,-(a7)
	TIOS_CALL HeapUnlock
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a2
;#endif
	rts

;-----------------------------------------------------
;Input>	d0.w : hdl of VAT
;	d1.w : hdl of previous array
;	d2.w : Mode :   0=add first item
;			1=don't addr first item
;	a0.l : Address of api92CB_Filter function or NULL
;Out>	d0.w : Handle of created buffer if succesful
;	d1.w : Error Code
;-----------------------------------------------------
apilib@005E:
_vat_CreateBuffer:
	movem.l	d2-d7/a0-a6,-(a7)

	move.l	a0,a4				;save registers
	move.w	d1,d7				;..

	move.w	d0,d6				;Save src hdl
	bsr	slct_FreeArray			;first free previous hdl

	moveq.w	#VATENTRY_SIZE,d1		;Create a buffer
	bsr	_array_Create
	move.w	d0,d7
	beq	\memerror

	movem.l	d1-d2/a0-a2,-(a7)
	move.w	d6,d0
	bsr	DEREFd0a0			;addr of buffer
	move.w	2(a0),d1			;nb files
	bsr	_nf_GetNestedCount
	add.w	d2,d1
	addq.w	#1,d1				;for the first item
	move.w	d7,d0
	bsr	DEREFd0a0
	move.w	d1,(a0)
	mulu.w	#VATENTRY_SIZE,d1
	addq.l	#4,d1
	move.l	d1,-(a7)
	move.w	d7,-(a7)
	TIOS_CALL HeapRealloc
	addq.l	#6,a7
	movem.l	(a7)+,d1-d2/a0-a2
	move.w	d0,d7
	beq	\memerror

	tst.w	d2
	bne.s	\skipb2
	lea	_ti(PC),a0
	API92_CMPFOLDHDL d6
	beq.s	\skip2
	lea	_back(PC),a0
\skip2	moveq.w	#VATENTRY_SIZE,d1
	move.w	d7,d0
	bsr	_array_AddItem
	tst.w	d1
	bne	\error
\skipb2

;---- Search for nested folders
	bsr     _nf_GetBufferAddr		;return a1=addr of buffer
	tst.w   d0				;if error
	beq.s   \nonested			;exit
	addq.l  #2,a1
	move.w  (a1)+,d3			;Nb of items
	beq.s   \nonested
	subq.w  #1,d3				;for dbra

	;----------------------------------
	; Lock nested folder buffer
	;----------------------------------
	bsr	_HeapLock			;Lock d0
	move.w	d0,-(a7)

	;----------------------------------
	; Loop that looks for nested folders
	;----------------------------------
\loop   cmp.w   (a1),d6				;Check if in that folder
	bne.s   \next2
	move.l	a1,-(a7)
	API92_FOLDHDL d0
	move.w  2(a1),d1			;If yes, get hdl
	bsr     _vat_FindHdl			;And get its name
	move.l	a1,a0
	move.l	(a7)+,a1
	tst.w   d2				;if error, skip
	beq.s   \next2
	bsr	CallFilterFct
\next2	addq.l  #4,a1
	dbra.s  d3,\loop

	;----------------------------------
	; Unlock nested folder buffer
	;----------------------------------
	move.w	(a7)+,d0
	bsr	_HeapUnlock			;Lock d0

	;----------------------------------
	; New look for files and folders
	;----------------------------------
\nonested move.w d6,d0
	bsr	DEREFd0a0
	addq.l	#2,a0
	move.w	(a0)+,d3			;Nb entry
	beq.s	\noitem
	subq.w	#1,d3

	;----------------------------------
	; Lock VAT
	;----------------------------------
	bsr	_HeapLock			;Lock d0
	move.w	d0,-(a7)

	;----------------------------------
	; Loop that looks for normal folders
	;----------------------------------
	movem.l	d3/a0,-(a7)
\addfolder
	btst.b	#7,VATENTRY_FLG(a0)
	beq.s	\next
	move.w	VATENTRY_HDL(a0),d1
	bsr     _nf_IsFolderNested	;if nested
	tst.w   d0				;don't show it at root
	bne.s   \next
	bsr	CallFilterFct
\next	lea	VATENTRY_SIZE(a0),a0
	dbra.s	d3,\addfolder
	movem.l (a7)+,d3/a0

	;----------------------------------
	; Loop that looks for files
	;----------------------------------
\addfile btst.b	#7,VATENTRY_FLG(a0)
	bne.s	\next3
	bsr	CallFilterFct
\next3	lea	VATENTRY_SIZE(a0),a0
	dbra.s	d3,\addfile

	;----------------------------------
	; Unlock VAT
	;----------------------------------
	move.w	(a7)+,d0
	bsr	_HeapUnlock			;Lock d0


\noitem	clr.w	d1				;no error

\exit	move.w	d7,d0
	movem.l	(a7)+,d2-d7/a0-a6
	rts

\memerror moveq.w	#EC_OUTOFMEMORY,d1
\error	bsr	slct_FreeArray
	bra.s	\exit

;----------------------------------------------------
; Call the callback filter function
;Input>	a0.l : address of VAT
;	d7.w : Handle of buffer
;----------------------------------------------------
CallFilterFct:
	move.l	a1,-(a7)

	move.l	a4,d0
	beq.s	\no_fct
	movem.l	d1-d7/a0-a6,-(a7)
	jsr	(a4)
	movem.l	(a7)+,d1-d7/a0-a6
	tst.w	d0
	beq.s	\noadd

\no_fct	moveq.w	#VATENTRY_SIZE,d1
	move.w	d7,d0
	bsr	_array_AddItem

\noadd	move.l	(a7)+,a1
	rts

;---------------------------------------------------
; Some datas
;---------------------------------------------------

_ti:
;#ifdef TI89
	dc.b	"TI89"
;#else
	dc.b	"TI92"
;#endif

	dcb.b	VATENTRY_SIZE-4,0
_back	dc.b	"[...]"
	dcb.b	VATENTRY_SIZE-5,0


smallfolder_gfx:
	dc.b	%01100000
        dc.b    %10011000
        dc.b    %10000100
        dc.b    %10000100
	dc.b	%01111000

smallfile_gfx:
	dc.b	%01110000
        dc.b    %01001000
        dc.b    %01001000
        dc.b    %01001000
        dc.b    %01111000

smallback_gfx:
	dc.b	%00010000
        dc.b    %00110000
        dc.b    %01110000
        dc.b    %00110000
	dc.b	%00010000

smallti_gfx:
	dc.b	%01111000
        dc.b    %10110100
        dc.b    %10000100
        dc.b    %01111000
        dc.b    %00000000

	ds.w	0
