;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		exec.mdl
;	Utility>	Execution Functions
;
;-----------------------------------------------------------

DelTmpIfArchived:
;#ifdef TIPLUS
	movem.l	d0-d2/a0-a2,-(a7)

	move.w	d4,d1
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\error

	btst.b	#1,VAT_ENTRYFLAG-1(a1)
	beq.s	\noarch
	move.l	a1,a2			;save VAT entry

	move.l	a1,a0			;for vat_Find
	jsr	apilib::vat_Find		;d0 returned by FindHdlEve
	tst.w	d2
	beq.s	\error
	cmp.l	a1,a2
	beq.s	\noarch

	subq.w	#1,d2
	jsr	apilib::vat_DeleteVar

	
\noarch
\error	movem.l	(a7)+,d0-d2/a0-a2
;#endif
	rts


;--------------------------------------------------
;input>	d0.w : Handle of the program
;	a0.l : buffer
;	a1.l : 0 if not parameter
;	       else addr of parameter string
;	d0.w : 0 if error
;		else sucess
;--------------------------------------------------
BuildCommandLine:
;#ifdef TIPLUS
	movem.l	d1-d5/a0-a5,-(a7)

	move.l	a1,d5
	jsr	apilib::GetTIOSFileName
	tst.w	d0
	beq.s	\error

\findend tst.b	(a0)+
	bne.s	\findend
	subq.l	#1,a0

	move.b	#'(',(a0)+

	tst.l	d5			;parameter?
	beq.s	\skip	
	move.l	d5,a1
\cpy	tst.b	(a1)
	beq.s	\skip
	move.b	(a1)+,(a0)+
	bra.s	\cpy

\skip	move.b	#')',(a0)+
	clr.b	(a0)+

\skip2	moveq.w	#1,d0

\exit	movem.l	(a7)+,d1-d5/a0-a5
;#endif
	rts

;#ifdef TIPLUS
\error	clr.w	d0
	bra.s	\exit

;	a1->a2
cpy8str:
	moveq.w #7,d0           ;8 laps
\cpy	tst.b   (a1)
	beq.s   \out
	move.b  (a1)+,(a2)+
	dbra.s  d0,\cpy
\out	rts
;#endif

;#ifdef TIPLUS
ExecBasicText:
	dc.w	52+XO,68+YO	;X,Y
	dc.w	20		;Max
	dc.b	0,%00001000	;flag
	dc.l	execbasic_KD
	dc.l	0

ScrollingComponent:
	dc.w	52+XO,58+YO
	dc.w	22
	dc.w	0


execbasic_KD:
	lea	ScrollingComponent+6(PC),a0
	cmp.w	#KEY_DIAMOND+PAD_LEFT,d0
	bne.s	\noleft
	tst.w	(a0)
	beq.s	\nopad
	subq.w	#1,(a0)
	bra.s	\redraw
\noleft	cmp.w	#KEY_DIAMOND+PAD_RIGHT,d0
	bne.s	\exit
	addq.w	#1,(a0)
	bra.s	\redraw

\exit	clr.w	d1		;continue
	rts

\redraw	move.l	argstr_addr(PC),a1
	lea	ScrollingComponent(PC),a0
	jsr	apilib::ScrollingCaptionComponent	

\nopad	clr.w	d0
	bra.s	\exit

argstr_addr:	dc.l	0

;---------------------------------------------------
;       Run a basic program with parameters
;
;Input> d0.w    : handle of the program
;----------------------------------------------------
ExecBasic:
	movem.l	d0-d7/a0-a6,-(a7)
	move.w	d0,d4			;save handle
	suba.w	#22,a7
	move.l	a7,a1			;buffer for edition

	lea	winExecB(PC),a0
	bsr	InterfaceEngine

	suba.w	#66,a7
	move.l	a7,a0

	move.l	a1,-(a7)
	moveq.w	#64,d1
	jsr	apilib::vat_GetBasicArgString
	move.l	a0,argstr_addr
	move.l	a0,a1
	lea	ScrollingComponent(PC),a0
	clr.w	6(a0)
	jsr	apilib::ScrollingCaptionComponent	
	move.l	(a7)+,a1

	lea	ExecBasicText(PC),a0
	jsr	apilib::EditComponent

	adda.w	#66,a7


	suba.w	#22+8+8+6,a7		;create stack frame
	move.l	a7,a0			;buffer
	cmp.w	#264,d0			;if ESC
	beq.s	\exit			;exit

	move.w	d4,d0			;Handle
	bsr	BuildCommandLine	;a1 is already params
	tst.w	d0			;Error ?
	beq.s	\exit

	move.w	d4,d1			;Handle
	bsr	UnhideProgramIfNeeded	;set d5

	jsr	apilib::ClearScreen
	move.l	a0,-(a7)
	jsr	apilib::RunProg
	addq.l	#4,a7

	move.w	d0,-(a7)		;HRESULT from RunProg
	beq.s	\nodel
	bsr	_HeapFree
\nodel	addq.l	#2,a7

	bsr	HideProgramIfNeeded
	bsr	DelTmpIfArchived

\exit	adda.w	#22+22+8+8+6,a7		;delete stack frames
	movem.l	(a7)+,d0-d7/a0-a6
	rts
;#endif

;---------------------------------------------------
;Input>	d1.w : File Handle
;Out>	d5.w : 0 if not, else program unhidden
;---------------------------------------------------
UnhideProgramIfNeeded:
	movem.l	d0-d2/a0-a2,-(a7)
	clr.w	d5			;default=Not hidden
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\no_h
	btst.b  #HIDE_BIT,ENTRYFLG+1(a1)
	beq.s	\no_h
	moveq.w	#1,d5			;Hidden
	bclr.b  #HIDE_BIT,ENTRYFLG+1(a1)
\no_h	movem.l	(a7)+,d0-d2/a0-a2
	rts

;---------------------------------------------------
;Input>	d5.w : 0 if not, else program unhidden
;	d4.w : file handle
;Out>	/
;---------------------------------------------------
HideProgramIfNeeded:
	movem.l	d0-d2/a0-a2,-(a7)
	tst.w	d5			;not hidden
	beq.s	\no_h
	move.w	d4,d1
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\no_h
	bset.b  #HIDE_BIT,ENTRYFLG+1(a1)
\no_h	movem.l	(a7)+,d0-d2/a0-a2
	rts



;---------------------------------------------------
; Prepare data in PctLauncherComm structure to 
; exec a file
;Input> d0.w    : handle of the program to exec
;	d3.w	: 0 if no compression, else hdl of
;		  real compressed file
;out>	d0.w	: error value 0 if error, 1 if ok
;----------------------------------------------------
PrepareFileToExec:
	movem.l	d1-d5/a0-a4,-(a7)

	move.w	d0,d4				;save hdl
	move.l	PctLauncherComm,a4
	move.w	#1,(a4)+		;Exec command

	clr.w	d2				;flag

	;----------------------------------------
	; Put hdl of prgm to exec in structure
	;----------------------------------------
	move.w	d0,(a4)+

	;----------------------------------------
	; If file has just been extracted set
	; it in structure
	;----------------------------------------
	move.w	d3,(a4)+

	;----------------------------------------
	; Build Command line in the structure
	;----------------------------------------
	lea	2(a4),a0		;in the struct
	clr.l	d1			;
	move.l	d1,a1			;no parameter
	bsr	BuildCommandLine	;D0 is prgm hdl
	tst.w	d0
	beq.s	\exit

	;----------------------------------------
	; Prevent real handle to be removed
	; by the kernel
	;----------------------------------------
	move.w	d3,d0
	beq.s	\notmp
	jsr	kernel::HdKeep
\notmp

	;----------------------------------------
	; Unhide program if needed
	;----------------------------------------
	move.w	d4,d1
	bsr	UnhideProgramIfNeeded	;return d5
	tst.w	d5
	beq.s	\nothidden
	bset.l	#0,d2			;set flag
\nothidden	
	move.b	d2,(a4)+		;set flag
	clr.b	(a4)+			;not used

	moveq.w	#1,d0			;successful
\exit	movem.l	(a7)+,d1-d5/a0-a4
	rts

\error	clr.w	d0
	bra.s	\exit

;---------------------------------------------------
; Clean up after a file execution
; (called at pct startup)
;Input> d0.w    : handle of the program to exec
;	d3.w	: 0 if no compression, else hdl of
;		  real compressed file
;	A0.l	: Address of PctLaunchComm struct
;out>	d0.w	: error value 0 if error, 1 if ok
;----------------------------------------------------
CleanAfterFileExecution:
	movem.l	d0-d2/a0-a2,-(a7)

	move.l	a0,a2
	tst.w	(a2)+
	beq.s	\exit

	;----------------------------------------
	; Hide the file if needed
	;----------------------------------------
	btst.l	#0,4(a2)			;should we hide it?
	beq.s	\nohide
	move.w	(a2),d1				;hdl to look for
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\nohide
	bset.b  #HIDE_BIT,ENTRYFLG+1(a1)

\nohide

	;----------------------------------------
	; Check if file was temporaly extracted
	;----------------------------------------
	tst.w	2(a2)
	beq.s	\notmp

	move.w	(a2),d1				;look for tmp hdl in vat
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2				;if error
	beq.s	\notmp				;exit
	move.w  2(a2),VAT_ENTRYHDL(a1)		;restore real hdl in VAT
	move.w	(a2),-(a7)			;put tmp hdl on stack
	bsr	_HeapFree			;and free tmp buffer
	addq.l  #2,a7

\notmp
\exit	movem.l	(a7)+,d0-d2/a0-a2
	rts


;---------------------------------------------------
;       Run a program
;Input> d0.w    : handle of the program
;out>	d0.w	: error value
;----------------------------------------------------
ExecFile:
	movem.l d1-d7/a0-a6,-(a7)

	movem.l	d5-d7/a0-a6,-(a7)

	; better method on TIPLUS that allow
	; nostubs



;#ifdef TIPLUS
	move.w	d0,d4			;save it
	suba.w	#30,a7			;create stack frame

	;----------------------------------------
	; Find handle of current PC address
	; (pctools handle)
	;----------------------------------------
	move.l	30+4*10+14*4(a7),a0
	jsr	apilib::vat_IsAddressInVAT
	move.w	d0,d1			;copy
	move.w	d4,d0			;for BuildCommandLine
	cmp.w	d1,d4
	beq.s	\exit

	;----------------------------------------
	; Build Command line in stack frame
	;----------------------------------------
	move.l	a7,a0
	clr.l	d1
	move.l	d1,a1			;no parameter
	bsr	BuildCommandLine
	tst.w	d0
	beq.s	\exit

	;----------------------------------------
	; Unhide program if needed
	;----------------------------------------
	move.w	d4,d1
	bsr	UnhideProgramIfNeeded	;return d5

	;----------------------------------------
	; Run the program
	;----------------------------------------
	move.l	a0,-(a7)
	jsr	apilib::RunProg
	addq.l	#4,a7

	;----------------------------------------
	; clean
	;----------------------------------------
	move.w	d0,-(a7)		;HRESULT from RunProg
	beq.s	\nodel
	bsr	_HeapFree
\nodel	addq.l	#2,a7

	bsr	HideProgramIfNeeded	;according to d5
	bsr	DelTmpIfArchived
	
;#else
	;----------------------------------------
	; Old Fargo method
	;----------------------------------------
	move.w  d0,-(a7)
	jsr     kernel::exec
	addq.l  #2,a7
;#endif

\exit
;#ifdef TIPLUS
	adda.w	#30,a7
;#endif

	movem.l	(a7)+,d5-d7/a0-a6
	movem.l	d0-d2/a0-a1,-(a7)
	moveq.w #1,d1			;be sure to have medium font set
	bsr     FontSet



;#ifdef TIPLUS
	;----------------------------------------
	; Free kb buffer
	;----------------------------------------
\wk
;#ifdef NSTUB
	TIOS_CALL kbhit
	tst.w	d0
;#else
	tst.w	KEY_PRESSED_FLAG	; has a key been pressed ?
;#endif
	beq	\nokey			; no..
	TIOS_CALL ngetchx	; yes : get the key code
	bra.s	\wk
\nokey
;#endif
	movem.l	(a7)+,d0-d2/a0-a1


;#ifdef TIPLUS
;#else
	tst.w   d0
	beq.s   \noerr

	lea     msgs(PC),a2
	
	cmp.w   #EXEC_NO_MEM,d0
	beq.s   \afferr
	adda.w  #14,a2
	cmp.w   #EXEC_FARGO_TOO_OLD,d0
	beq.s   \afferr
	cmp.w   #EXEC_INCOMPATIBLE,d0
	beq.s   \afferr
	cmp.w   #EXEC_INCOMPAT_ROM,d0
	beq.s   \afferr
	adda.l  #19,a2
	cmp.w   #EXEC_LIB_NOT_FOUND,d0
	beq.s   \afferr
	cmp.w   #EXEC_LIB_RANGE_ERR,d0
	beq.s   \afferr
	addq.l  #8,a2           ;show just 'error'
\afferr bsr     ST_Message
;#endif

\noerr  movem.l (a7)+,d1-d7/a0-a6
	rts

msgs:
;#ifdef TIPLUS
;#else

;#ifdef FRENCH
memout  dc.b    "Err:Mmoire  ",0
frgerr  dc.b    "Fargo Incompatible",0
nolib   dc.b    "Err:Librarie ",0
;#else
memout  dc.b    "Out of memory",0
frgerr  dc.b    "Incompatible Fargo",0
nolib   dc.b    "Library Error",0
;prgerr dc.b    "Avoid a crash:STOP program",0
;#endif
;#endif
	ds.w    0



